// Disco AIBO 4.x for the ERS-7
// Regular RCODE (not RCodePlus)
// Requires special TDASDATA.BIN for disco start tunes

// only 'lead' part (not multiple parts)

 // startup

 GLOBAL calibrated 0
 GLOBAL play_intro 1

 GLOBAL doPrint 0
 // SET doPrint 1

 IF doPrint != 0 THEN
    PRINT "Disco AIBO 4.5 (%d)" AiboType
 ENDIF


 SET NoFallDown 1 // don't reset if it falls down
    // requires .2 version to work

:Main
  IF calibrated == 0 THEN
    IF doPrint != 0 THEN
	    PRINT "Calibrating"
	ENDIF
    PLAY ACTION SIT
    WAIT
    LET calibrated 1
    SET AU_AiboSound 0 // purge pending
    SET AU_AiboSound_ID 0 // purge pending
    SET BackFR_ON 0
  ENDIF

  IF play_intro != 0 THEN
    // PLAY ACTION+ INTRO // intro song (after calibrated)
    // WAIT
    LET play_intro 0
  ENDIF

  IF Batt_Rest < 20 THEN
    HALT
  ENDIF

  IF AU_AiboSound != 0 THEN
    IF doPrint != 0 THEN
        PRINT "AU_AiboSound_ID = %d" AU_AiboSound_ID
	ENDIF

    PUSH AU_AiboSound_ID
    CALL DanceToTune 1
    WAIT 1000 // wait a second
    PLAY ACTION LIE // safer
    WAIT
	// force recalibration after dance (will clear any pending inputs)
    LET calibrated 0
    GO Main
  ENDIF

 WAIT 2 // not too long
 GO Main

EXIT

///////////////////////////////////////////////

:DanceToTune
  ARG:tune

  IF tune == 2 THEN
    PLAY ACTION+ DANCE02
    CALL DanceDogDance
  ENDIF

  IF tune == 3 THEN
    PLAY ACTION+ DANCE03
    CALL DanceDogDance
  ENDIF

  IF tune == 4 THEN
    PLAY ACTION+ DANCE04
    CALL DanceDogDance
  ENDIF

  IF tune == 5 THEN
    PLAY ACTION+ DANCE05
    CALL DanceDogDance
  ENDIF

  IF tune == 6 THEN
    PLAY ACTION+ DANCE06
    CALL DanceDogDance
  ENDIF

  IF tune == 7 THEN
    PLAY ACTION+ DANCE07
    CALL DanceDogDance
  ENDIF

  IF tune == 8 THEN
    PLAY ACTION+ DANCE08
    CALL DanceDogDance
  ENDIF

  IF tune == 9 THEN
    PLAY ACTION+ DANCE09
    CALL DanceDogDance
  ENDIF

  IF tune == 10 THEN
    PLAY ACTION+ DANCE10
    CALL DanceDogDance
  ENDIF

  IF tune == 11 THEN
    PLAY ACTION+ DANCE11
    CALL DanceDogDance
  ENDIF

  IF tune == 12 THEN
    PLAY ACTION+ DANCE12
    CALL DanceDogDance
  ENDIF

  IF tune == 13 THEN
    PLAY ACTION+ DANCE13
    CALL DanceDogDance
  ENDIF

  IF tune == 14 THEN
    PLAY ACTION+ DANCE14
    CALL DanceDogDance
  ENDIF

  IF tune == 15 THEN
    PLAY ACTION+ DANCE15
    CALL DanceDogDance
  ENDIF

  IF tune == 16 THEN
    PLAY ACTION+ DANCE16
    CALL DanceDogDance
  ENDIF

  IF tune == 17 THEN
    PLAY ACTION+ DANCE17
    CALL DanceDogDance
  ENDIF

  IF tune == 18 THEN
    PLAY ACTION+ DANCE18
    CALL DanceDogDance
  ENDIF

  IF tune == 19 THEN
    PLAY ACTION+ DANCE19
    CALL DanceDogDance
  ENDIF

  IF tune == 20 THEN
    PLAY ACTION+ DANCE20
    CALL DanceDogDance
  ENDIF

  IF tune == 21 THEN
    PLAY ACTION+ DANCE21
    CALL DanceDogDance
  ENDIF

  IF tune == 22 THEN
    PLAY ACTION+ DANCE22
    CALL DanceDogDance
  ENDIF

  IF tune == 23 THEN
    PLAY ACTION+ DANCE23
    CALL DanceDogDance
  ENDIF


RETURN

///////////////////////////////////////////////
// hold front and rear back lights to abort

:DanceDogDance

  SET BackFR_LONG 0
  WHILE Wait > 0
    IF BackFR_LONG > 0 THEN
	    IF doPrint != 0 THEN
	        PRINT "ABORT"
		ENDIF
        QUIT // emergency stop
        SET Wait 0
        LET calibrated 0
		LET play_intro 1 // riff after abort
        RETURN
    ENDIF
    WAIT 20
  WEND

RETURN

///////////////////////////////////////////////

