
////////////////////////////////////////////////////////////////////
//                                                                //
//  DogsLife Behavior Probability Module                          //
//  Copyright (C) 2001-2003 by DogsBody & Ratchet Software        //
//  All Rights Reserved                                           //
//                                                                //
//  This is free software and MAY NOT be sold under any           //
//  circumstances, seperately or bundled.                         //
//                                                                //
////////////////////////////////////////////////////////////////////




////////////////////////////////////////////////////////////////////
//
//  Find any behavior different from last two random events...
//
:G_BEHAVIOR_DIFF
  rndend := behavior[rndbase+1]
  lastact1 := behavior[rndbase+2]
  lastact2 := behavior[rndbase+3]
  
  // If selection different from what was used before, then return now...
  if (rndnum != lastact1) && (rndnum != lastact2) then
    RET 1
  endif
  
  // Otherwise, look for something different...
  index := rndbase+4
  while (index<=rndnum)
    temp := behavior[index++]
    if (temp != lastact1) && (temp != lastact2) then
      rndnum := temp
      RET 1
    endif
  wend
  RET 1



////////////////////////////////////////////////////////////////////
//
//  Track last 8 random numbers generated (globally)...
//
:G_BEHAVIOR_LOG
  if (rndnum>=0) then
    index := (behavior[BEHAVIOR_LOGINDEX]+1)&7
    behavior[index] := rndbase
    behavior[BEHAVIOR_LOGINDEX] := index
  
    lastact1 := behavior[rndbase+2]
    lastact2 := behavior[rndbase+3]
    if (rndnum != lastact1) && (rndnum != lastact2) then
      behavior[rndbase+2] := rndnum
      behavior[rndbase+3] := lastact1
    endif
  endif
  RET 1



////////////////////////////////////////////////////////////////////
//
//  Add number to random list...
//
:G_BEHAVIOR_ADD
  rndend := behavior[rndbase+1]
  index := rndend-rndbase
  if (index<(BEHAVIOR_DEPTH-1)) then
    behavior[++rndend] := praise
    behavior[rndbase+1] := rndend
  endif
  RET 1



////////////////////////////////////////////////////////////////////
//
//  Remove number from random list...
//
:G_BEHAVIOR_SUB
  rndstart := rndbase+4
  rndend := behavior[rndbase+1]
  index := rndend

  while (index>=rndstart)
    if (behavior[index] == scold) then
      while index < rndend 
        behavior[index] := behavior[index+1]
        ++index
      wend
      behavior[rndbase+1] := --rndend
      RET 1
    endif
    --index
  wend
  RET 1



////////////////////////////////////////////////////////////////////
//
//  Initialize a behavior array entry on demand...
//
:G_BEHAVIOR_INIT
  if (behavior[rndbase]==rndcount) then // already initialized
    RET 1
  endif

  behavior[rndbase] := rndcount
  if (rndcount<0) then
    MUL rndcount -1
  endif

  rndend := rndbase+(2*rndcount)+3
  behavior[rndbase+1] := rndend
  index := rndbase+4
  temp := rndbase

  while index<rndend
    behavior[index++] := temp
    behavior[index++] := temp
    temp++
  wend
  RET 1



////////////////////////////////////////////////////////////////////
//
//  Increase probability on most recent action performed...
//
:G_BEHAVIOR_PRAISE
  index := behavior[BEHAVIOR_LOGINDEX] // Index into lastnum table
  rndbase := behavior[index]	       // Get rndbase of last list
  praise := behavior[rndbase+2]	       // Get last index

  // If a behavior has been used recently, update it...
  if (rndbase>=BEHAVIOR_FIRST) then
    behavior[BEHAVIOR_LEARN_COUNT]++
    behavior[BEHAVIOR_PRAISE_COUNT]++
    CALL G_BEHAVIOR_INIT
    CALL G_BEHAVIOR_ADD
  endif
  RET 1



////////////////////////////////////////////////////////////////////
//
//  Decrease probability on most recent action performed...
//
:G_BEHAVIOR_SCOLD
  index := behavior[BEHAVIOR_LOGINDEX] // Index into lastnum table
  rndbase := behavior[index]	       // Get rndbase of last list
  scold := behavior[rndbase+2]	       // Get last index

  // If a behavior has been used recently, update it...
  if (rndbase>=BEHAVIOR_FIRST) then
    behavior[BEHAVIOR_LEARN_COUNT]++
    behavior[BEHAVIOR_SCOLD_COUNT]++
    CALL G_BEHAVIOR_INIT
    CALL G_BEHAVIOR_SUB
  endif
  RET 1



////////////////////////////////////////////////////////////////////
//
//  Adjust random probabilities if bored.  Interest in bad things 
//  goes up.  Good goes down.
//
:G_BEHAVIOR_BORED
  if Fav_Color>0 then
    CALL G_DEC_SAD_MOOD
  else
    if Unfav_Color>0 then
      CALL G_INC_SAD_MOOD
    endif
    CALL G_DEC_HAPPY_MOOD
  endif

#ifdef RCODE250
  // If elephant mode, then never forget anything...
  if (behavior[BEHAVIOR_ELEPHANT_MODE]>0) then
    RET 1
  endif

  // 1% of the time, if bored adjust learned behaviors.
  // Decrease likelyhood of fun things.  Increase likelyhood 
  // of naughty things.
  if (F_RND100()<2) then
    // Pick skit to adjust randomly.  Try 10 times to find something to forget...
    for temp 1 10
      RND rndnum (BEHAVIOR_FIRST/BEHAVIOR_DEPTH) (BEHAVIOR_LAST/BEHAVIOR_DEPTH)
      rndbase := rndnum*BEHAVIOR_DEPTH
      rndcount := behavior[rndbase]

      // If behavior initialized...
      if (rndcount>0) then
        RND target rndbase (rndbase+rndcount-1)
        AP_SCANCOUNT count behavior rndbase rndcount target

        if (count < 2) then
          behavior[BEHAVIOR_FORGET_COUNT]++
    	  praise := target
          CALL G_BEHAVIOR_ADD
          RET 1
        endif

        if (count > 2) then
          behavior[BEHAVIOR_FORGET_COUNT]++
          scold := target
          CALL G_BEHAVIOR_SUB
          RET 1
        endif
      endif
    next
  endif
#endif
  RET 1



////////////////////////////////////////////////////////////////////
//
//  Pick a random number different from the last two selected.
//  Return TRUE if valid random number generated in 'rndnum'.
//
:F_BEHAVIOR_RNDN
  if (!F_BEHAVIOR_RND()) then // invalid random list
    return FALSE
  endif
  CALL G_BEHAVIOR_DIFF
  CALL G_BEHAVIOR_LOG
  return TRUE



////////////////////////////////////////////////////////////////////
//
//  Pick a random number.  If same as either of last two attempts,
//  then only 2/3rd of time force a unique number.
//
:G_BEHAVIOR_RNDNM
  if (!F_BEHAVIOR_RND()) then // invalid random list
    RET 3 // invalid
  endif

  rndend := behavior[rndbase+1]
  lastact1 := behavior[rndbase+2]
  lastact2 := behavior[rndbase+3]

  if (rndnum == lastact1) || (rndnum != lastact2) then
    if F_RND100()<33 then
      RET 1
    endif
    CALL G_BEHAVIOR_DIFF
  endif

  CALL G_BEHAVIOR_LOG
  RET 2	// valid



////////////////////////////////////////////////////////////////////
//
//  Generate random number, referencing learned behavior probabilities.
//  Does not check if random selection matches previous one.
//  Return TRUE if valid random number generated in 'rndnum'.
//
:F_BEHAVIOR_RND
  CALL G_BEHAVIOR_INIT
  rndstart := rndbase+4
  rndend := behavior[rndbase+1]
  SET rndnum 0	// default
  if (rndend>=rndstart) then
    RND index rndstart rndend
    rndnum := behavior[index]
    return TRUE
  endif
  return FALSE


