
//
// If you would like to customize DogsLife, you can place your tweaks here.
// DogsLife calls these routines prior to its own voice command processing,
// and other useful events.   If a voice call, the command is in variable 
// 'VoiceCmd'.
//
// You can do virtually anything you like here.  However, you should
// avoid using the same variable names DogsLife uses.  Prefix your
// variables with something like "my_".  For example:
//   my_loopcount
//   my_count
//   etc...
//
// Warning: 
// --------
// DogsLife could leave ball tracking or tail wagging enabled before
// making a call.  The 'Wait' variable might be non-zero, and using the
// 'WAIT' command might hang up DogsLife.   Either execute a 'STOP'
// command prior, or use the function 'G_WAIT' instead as shown:
//
// Example 1:
//   STOP
//   WAIT
//   <<command or action we need to wait for>>
//   WAIT
//
// Example 2:
//   WAIT 1
//   SET init_wait Wait
//   <<command or action we need to wait for>>
//   CALL G_WAIT
//
// -----------------------------------------------------------------
//
// Return values.  DogsLife responds to these various return codes:
//
//   GO_AHEAD      Continue with normal processing.
//
//   GO_IGNORE     Ignore voice command.  
//                   If not a voice call, same as GO_AHEAD.
//                   Use this if you respond to a voice command, and want 
//                   DogsLife to ignore it (and stay in the same behavior 
//                   processing).
//
//   GO_DOWNPOS    Go to sleep position loop.
//                   If already in sleep position, same as GO_AHEAD.
//                   Stop what is happening, and enter sleep position.
//                   Use this if you change the position of DogsLife
//                   (ie: DogsLife was standing, and you make him lie down)
//
//   GO_SITPOS     Go to sit position loop.
//                   If already in sit position, same as GO_AHEAD.
//                   Stop what is happening, and enter sit position.
//                   Use this if you change the position of DogsLife
//                   (ie: DogsLife was standing, and you make him sit)
//
//   GO_STANDPOS   Go to stand position loop.
//                   If already in stand position, same as GO_AHEAD.
//                   Stop what is happening, and enter stand position.
//                   Use this if you change the position of DogsLife
//                   (ie: DogsLife was sitting, and you make him stand)
//
//   GO_WALK       Go walking.
//                   If already walking, same as GO_AHEAD.
//                   Stop what is happening, and enter walk code.
//
//   GO_SEEBALL    Go play soccer (ball should be visible).
//                   If already playing soccer, same as GO_AHEAD.
//                   Stop what is happening, and chase ball.
//


//
// Called prior to evaluating voice command in sleep position.
//
:G_CUSTOM_SLEEP_VOICECMD
RET:GO_AHEAD


//
// Called prior to evaluating voice command in sit position.
//
:G_CUSTOM_SIT_VOICECMD
RET:GO_AHEAD


//
// Called prior to evaluating voice command in stationary stand position.
//
:G_CUSTOM_STAND_VOICECMD
RET:GO_AHEAD


//
// Called prior to evaluating voice command while walking or playing soccer.
//
:G_CUSTOM_WALK_VOICECMD
RET:GO_AHEAD


//
// Called if obstacle detected while walking (DogsLife stops walking before the call).
//
:G_CUSTOM_WALK_OBSTACLE
RET:GO_AHEAD


//
// Called prior to attempting a soccer kick.
//
:G_CUSTOM_SOCCER_KICK
RET:GO_AHEAD



