//|////////////////////////////////////////////////////////////////|//
//|                                                                |//
//| DogsLife - Version 2.52                                        |//
//| Copyright (C) 2001-2003 by DogsBody & Ratchet Software         |//
//| All Rights Reserved                                            |//
//|                                                                |//
//| The DogsLife behavior software is provided AS IS without       |//
//| any warranty, expressed or implied.   This includes without    |//
//| limitation the fitfulness for a particular purpose or          |//
//| application.   People using the software bear all risk as to   |//
//| its quality and performance.   The user of the software is     |//
//| responsible for any damages whether direct, indirect, special, |//
//| incidental or consequential arising from a failure of this     |//
//| program to operate in any manner desired.                      |//
//|                                                                |//
//| DogsLife is free software and MAY NOT be sold under any        |//
//| circumstances, seperately or bundled.                          |//
//|                                                                |//
//|////////////////////////////////////////////////////////////////|//
//|                                                                |//
//| Please do not edit YART blocks manually (in a text editor).    |//
//| Only use YART for customizing DogsLife.  There are special     |//
//| code blocks which must be managed carefully.                   |//
//|                                                                |//
//|////////////////////////////////////////////////////////////////|//

#undef DEBUG
#undef DEBUG_NOVOICE

#define RCODE250
#include "DogsLife.RH"


////////////////////////////////////////////////////////////////////
// Main
:G_Main

CALL G_STARTUP

:MAINLOOP
if (Context<GO_RESTPOS) || (Context>GO_SEEBALL) then
  SET Context GO_DOWNPOS
endif
CASE:GO_RESTPOS  CALL G_RESTMODE
CASE:GO_DOWNPOS  CALL G_SLEEPPOS
CASE:GO_SITPOS   CALL G_SITPOS
CASE:GO_STANDPOS CALL G_STANDPOS
CASE:GO_WALK     CALL G_WALK_ABOUT
CASE:GO_SEEBALL  CALL G_SOCCER
GO MAINLOOP



////////////////////////////////////////////////////////////////////
// ATTENTION_HANDLER  (Process user praise or scolding...)
:G_ATTENTION_HANDLER
SET pet 0
SET praise 0
SET scold 0
WAIT 1

// Process YART sensor overrides...
CALL G_YART_Sensors
if (Context != GO_AHEAD) then
  RET:Context
endif

// Process YART vision overrides...
CALL G_YART_Vision
if (Context != GO_AHEAD) then
  RET:Context
endif

/*** 220 specific ***/
#ifdef ERS220
  if CTail_ON>0 then 			// Turn on headlight for 10 seconds...
    CTail_ON := 0
    TIMER_CLEARLEDS := 10
    Spot := TRUE
  endif

  if RTail_ON>0 then			// Show mood for 5 seconds...
    RTail_ON := 0
    TIMER_CLEARLEDS := 5
    Eye_L1 := Eye_R1 := (mood_sad>=2)					// Sad
    Eye_L2 := Eye_R2 := (mood_mad<2) && (mood_sad<2) && (mood_happy>2)  // Happy
    Eye_L3 := Eye_R3 := (mood_mad>=2)					// Mad
  endif

  if LTail_ON>0 then			// Show battery level on tail fan (for 5 seconds)...
    LTail_ON := 0
    CALL G_SHOW_BATTERY_LEVEL
  endif
#endif

/*** 210/220 specific ***/
#if ERS210 | ERS220
  IF Back_LONG > 0 THEN			// 210/220 - Enter sit-only mode
    SET Back_LONG 0
    SET Head_LONG 0
    SET sitonly 1
    CALL G_UPDATE_PAUSEBAR
  ENDIF
  IF Head_LONG > 0 THEN			// 210/220 - Exit sit-only mode
    SET Back_LONG 0
    SET Head_LONG 0
    SET sitonly 0
    CALL G_UPDATE_PAUSEBAR
  ENDIF
  IF Back_ON > 0 THEN			// 210/220 - Petted
    ADD pet 2
    SET Back_ON 0
    ADD back_count 1
    RET GO_PETTED
  ENDIF
  IF Jaw_ON > 0 THEN			// 210/220 - Petted
    ADD pet 4
    SET Jaw_ON 0
    SET back_count 0
    RET GO_PETTED
  ENDIF
#endif
/*** END 210/220 specific ***/

/*** 310 specific ***/
#if ERS310
  IF Tail_R_LONG > 0 THEN		// 310 - Enter sit-only mode
    SET Tail_R_LONG 0
    SET sitonly 1
    CALL G_UPDATE_PAUSEBAR
  ENDIF
  IF Tail_U_LONG > 0 THEN		// 310 - Exit sit-only mode
    SET Tail_U_LONG 0
    SET sitonly 0
    CALL G_UPDATE_PAUSEBAR
  ENDIF
  IF Tail_RollR || Tail_RollL THEN	// 310 - Praise
    ADD pet 2
    SET TIMER_310ROLL MAXINT		// reset delay scold timer
    SET Tail_RollR 0
    SET Tail_RollL 0
    SET Tail_U_ON 0
    SET Tail_D_ON 0
    SET Tail_R_ON 0
    SET Tail_L_ON 0
    SET back_count 0
    RET GO_PETTED
  ENDIF

  // Gotta be careful with these, since a roll might trigger one of these...
  // Therefore, a delayed scold using a timer is implemented here.  If a roll
  // doesn't happen within the 1second timeout, the scolding occurs...
  IF Tail_U_ON || Tail_D_ON || Tail_R_ON || Tail_L_ON THEN	// 310 - Scold
    SET TIMER_310ROLL 1
    SET Tail_U_ON 0
    SET Tail_D_ON 0
    SET Tail_R_ON 0
    SET Tail_L_ON 0
    SET back_count 0
  ENDIF

  IF TIMER_310ROLL < 0 THEN		// 310 - Delayed scold
    SET TIMER_310ROLL MAXINT
    SET Tail_U_ON 0
    SET Tail_D_ON 0
    SET Tail_R_ON 0
    SET Tail_L_ON 0
    SET back_count 0
    ADD scold 2
    RET GO_SCOLD
  ENDIF
#endif
/*** End 310 specific ***/

IF Head_Hit > 0 THEN
  ADD scold 1
  SET Head_Hit 0
  SET back_count 0
  RET GO_SCOLD
ENDIF

IF Head_ON > 0 THEN
  ADD praise 1
  SET Head_ON 0
  SET back_count 0
  RET GO_PRAISE
ENDIF

CALL G_VOICECMD
  CASE:GO_VOICE GO AH_VOICECMD

// Process YART sound/noise/rhythm overrides...
CALL G_YART_HearSound
if (Context != GO_AHEAD) then
  RET:Context
endif

IF AP_Rhythm > 0 THEN
  SET VoiceCmd HEARD_RHYTHM
  SET VoiceLevel 3
  SET VoicePitch 3
  SET VoiceHorz 0
  SET VoiceDictID VoiceCmd
  SET AP_Rhythm 0
  GO AH_VOICECMD
ENDIF

IF AP_Tone > 0 THEN
  CALL G_TONECMD
    CASE:1 GO AH_VOICECMD
ENDIF
RET GO_IDLE


// Process YART voice command overrides...
:AH_VOICECMD
CALL G_YART_VoiceCmd_Attention
if (Context != GO_AHEAD) then
  RET:Context
endif

SET back_count 0
IF (VoiceCmd==VOICE_GOODBOT) || (VoiceCmd==VOICE2_GOODAIBO) THEN
  IF (VoiceDictID>=149) && (VoiceDictID<=150) CALL G_INC_BOYGIRL // Good Boy
  IF (VoiceDictID>=151) && (VoiceDictID<=154) CALL G_DEC_BOYGIRL // Good Girl
  RET GO_PRAISE
ENDIF

IF VoiceCmd == VOICE2_GOODBOY THEN		// Good Boy (voice2)
  CALL G_INC_BOYGIRL
  RET GO_PRAISE
ENDIF

IF VoiceCmd == VOICE2_GOODGIRL THEN		// Good Girl (voice2)
  CALL G_DEC_BOYGIRL
  RET GO_PRAISE
ENDIF

IF VoiceCmd == VOICE_GOFORIT THEN		// Go For It
  SET TIMER_GOFORIT 60
  RET GO_PRAISE
ENDIF

IF VoiceCmd == VOICE_BADBOT THEN
  IF (VoiceDictID>=160) && (VoiceDictID<=161) CALL G_INC_BOYGIRL // Bad Boy
  IF (VoiceDictID>=162) && (VoiceDictID<=165) CALL G_DEC_BOYGIRL // Bad Girl
  RET GO_SCOLD
ENDIF

IF VoiceCmd == VOICE2_BADBOY THEN		// Bad Boy (voice2)
  CALL G_INC_BOYGIRL
  RET GO_SCOLD
ENDIF

IF VoiceCmd == VOICE2_BADGIRL THEN		// Bad Girl (voice2)
  CALL G_DEC_BOYGIRL
  RET GO_SCOLD
ENDIF

SWITCH VoiceCmd 
  CASE:VOICE_AIBO CALL G_DEC_SAD_MOOD		// Aibo or registered name
  CASE:VOICE_ILIKEYOU CALL G_DEC_SAD_MOOD	// I like you
  CASE:VOICE_IAMHERE CALL G_DEC_SAD_MOOD	// I'm here (come here)
  CASE:VOICE_DONTDOTHAT RET 4 // scold		// Don't do that
  CASE:VOICE2_THATSRIGHT RET 2 // praise	// Good Bot (voice2)

IF VoiceCmd == VOICE_TAKEAPICTURE THEN		// Take a picture?
  IF Posture1 != POSTURE_WALK THEN
    CALL G_TAKE_A_PICTURE
  ENDIF
  RET GO_IDLE
ENDIF

RET GO_VOICE


////////////////////////////////////////////////////////////////////
//
// CLEAR_SENSORS
//
:G_CLEAR_SENSORS
SET Head_Pat 0
SET Head_Hit 0
SET Head_ON 0
SET Back_ON 0
SET Jaw_ON 0
SET Jaw_LONG 0
SET RFLeg_ON 0
SET LFLeg_ON 0
SET RRLeg_ON 0
SET LRLeg_ON 0
RET 1


////////////////////////////////////////////////////////////////////
//
// DEC_HAPPY_MOOD - Decrease happiness
//
//++CALL G_DEC_HAPPY_MOOD // Decrease Happiness
:G_DEC_HAPPY_MOOD
SUB mood_happy 1
IF mood_happy > MOOD_MAX THEN
  SET mood_happy MOOD_MAX
ENDIF
IF mood_happy < 0 THEN
  SET mood_happy 0
ENDIF
RET 1


////////////////////////////////////////////////////////////////////
//
// DEC_MAD_MOOD - Decrease anger
//
//++CALL G_DEC_MAD_MOOD // Decrease Anger
:G_DEC_MAD_MOOD
SUB mood_mad 1
CALL G_INIT_MOOD_TIMER
IF mood_mad > MOOD_MAX THEN
  SET mood_mad MOOD_MAX
ENDIF
IF mood_mad < 0 THEN
  SET mood_mad 0
ENDIF
RET 1


////////////////////////////////////////////////////////////////////
//
// DEC_SAD_MOOD - Decrease sadness
//
//++CALL G_DEC_SAD_MOOD // Decrease Sadness
:G_DEC_SAD_MOOD
SUB mood_sad 1
CALL G_INIT_MOOD_TIMER
IF mood_sad > MOOD_MAX THEN
  SET mood_sad MOOD_MAX
ENDIF
IF mood_sad < 0 THEN
  SET mood_sad 0
ENDIF
RET 1


////////////////////////////////////////////////////////////////////
//
// DEC_TIRED_MOOD
//
:G_DEC_TIRED_MOOD
IF mood_tired < 1 THEN
  SET mood_tired 0
  RET 1
ENDIF

SUB mood_tired 1
IF mood_tired < 1 THEN
  CALL G_DEC_ENDURE
ENDIF
RET 1


////////////////////////////////////////////////////////////////////
//
// GO_BACK
//
:G_GO_BACK
CALL G_VOICE_HIT
IF mood_mad > 5 THEN
  PLAY ACTION MOVE.MOVE.SLOW 180 100
  WAIT
  RET 1
ENDIF

IF mood_happy > 5 THEN
  PLAY ACTION MOVE.MOVE.FAST 180 300
  WAIT
  RET 1
ENDIF

CALL G_RANDOM3
  CASE:1 PLAY ACTION MOVE.MOVE.SLOW 180 200
  CASE:2 PLAY ACTION MOVE.MOVE.NORMAL 180 200
  CASE:3 PLAY ACTION MOVE.MOVE.FAST 180 200
CALL G_WAITZERO
RET 1


////////////////////////////////////////////////////////////////////
//
// GO_FORWARD  (Move forward in response to command.)
//
:G_GO_FORWARD
LOCAL gf_temp 0

CALL G_VOICE_HIT
WAIT 1
SET init_wait Wait

// Stand up if not doing so already...
if !POSE_STANDING() then
  PLAY ACTION STAND
ENDIF

// Look down at ground...
PLAY ACTION MOVE.HEAD.FAST 0 WALKHEADTILT
CALL G_WAIT

// Decide how far to walk, and how fast, based on mood...
IF mood_mad>5 THEN
  PLAY ACTION MOVE.MOVE.SLOW 0 250
ELSE
  IF mood_happy>5 THEN
    PLAY ACTION WALK 0 500
  ELSE
    CALL G_RANDOM2
      CASE:1 PLAY ACTION MOVE.MOVE.SLOW 0 400
      CASE:2 PLAY ACTION MOVE.MOVE.NORMAL 0 400
  ENDIF
ENDIF

:GF_WAITLOOP	// WAIT_FOR_WALK
if (gf_temp>120) || (Distance<TOOCLOSEDIST) || (Distance>CLIFFDIST) GF_STOPWALK
if (F_SEE_BALL()==GO_SEEBALL) GF_STOPWALK

IF Wait>0 THEN
  ADD gf_temp 1
  WAIT 100
  GO GF_WAITLOOP
ENDIF
RET 1

:GF_STOPWALK
SET init_wait Wait
PLAY ACTION WALK 0 0
CALL G_WAIT
RET 1


////////////////////////////////////////////////////////////////////
//
// GO_LEFT
//
:G_GO_LEFT
CALL G_VOICE_HIT
RND pan 30 60
IF_1ST mood_tired > 8 1184
IF_1ST mood_mad > 5 1184
IF_1ST mood_happy <= 5 1180
RND temp 0 100
IF_1ST temp < 90 1178
RND pan 90 180

:1178	// LEFT_FAST_MORE
ADD pan 45
PLAY ACTION MOVE.TURN.FAST pan
WAIT
RET 1

:1180	// RANDOM3
CALL G_RANDOM3
  CASE:1 PLAY ACTION MOVE.TURN.SLOW pan
  CASE:2 PLAY ACTION MOVE.TURN.NORMAL pan
  CASE:3 PLAY ACTION MOVE.TURN.FAST pan
WAIT
RET 1

:1184	// LEFT_SLOW_LESS
SUB pan 20
PLAY ACTION MOVE.TURN.SLOW pan
WAIT
RET 1


////////////////////////////////////////////////////////////////////
//
// GO_RIGHT
//
:G_GO_RIGHT
CALL G_VOICE_HIT
RND pan -30 -60
IF_1ST mood_tired > 8 1200
IF_1ST mood_mad > 5 1200
IF_1ST mood_happy <= 5 1196
RND temp 0 100
IF_1ST temp < 90 1194
RND pan -90 -180

:1194	// RT_FAST_MORE
ADD pan -45
PLAY ACTION MOVE.TURN.FAST pan
WAIT
RET 1

:1196	// RANDOM3
CALL G_RANDOM3
  CASE:1 PLAY ACTION MOVE.TURN.SLOW pan
  CASE:2 PLAY ACTION MOVE.TURN.NORMAL pan
  CASE:3 PLAY ACTION MOVE.TURN.FAST pan
WAIT
RET 1

:1200	// RT_SLOW_LESS
SUB pan -20
PLAY ACTION MOVE.TURN.SLOW pan
WAIT
RET 1


////////////////////////////////////////////////////////////////////
//
// HAPPYDANCE  (Do a happy dance)
//
:G_HAPPYDANCE
:1203	// PICK_ACT
RND temp 0 9
IF_1ST temp = last_happydance 1203
IF_1ST temp = last_happydance2 1203
WAIT 1
SET init_wait Wait
SWITCH temp
  CASE:0 PLAY ACTION CUTE_SMILE1
  CASE:1 PLAY ACTION CUTE_SWING1
  CASE:2 PLAY ACTION CUTE_SWING2
  CASE:3 PLAY ACTION DANCE_STAND1
  CASE:4 PLAY ACTION DANCE_STAND2
  CASE:5 PLAY ACTION LETSPLAY1
  CASE:6 PLAY ACTION LETSPLAY2
  CASE:7 PLAY ACTION DANCE_STAND6
  CASE:8 PLAY ACTION DANCE_STAND3
  CASE:9 PLAY ACTION DANCE_STAND5
SET last_happydance2 last_happydance
SET last_happydance temp
CALL G_WAIT_AWARE
RET 1


////////////////////////////////////////////////////////////////////
//
//  INC_HAPPY_MOOD - Increase happiness
//
//++CALL G_INC_HAPPY_MOOD // Increase Happiness
:G_INC_HAPPY_MOOD
IF mood_happy > 2 THEN
  CALL G_DEC_SAD_MOOD
ENDIF
ADD mood_happy 1
IF mood_happy > MOOD_MAX THEN
  SET mood_happy MOOD_MAX
ENDIF
IF mood_happy < 0 THEN
  SET mood_happy 0
ENDIF
RET 1


////////////////////////////////////////////////////////////////////
//
//  INC_MAD_MOOD - Increase anger
//
//++CALL G_INC_MAD_MOOD // Increase Anger
:G_INC_MAD_MOOD
IF mood_mad > 5 THEN
  CALL G_INC_SAD_MOOD
ENDIF
ADD mood_mad 1
CALL G_INIT_MOOD_TIMER
IF mood_mad > MOOD_MAX THEN
  SET mood_mad MOOD_MAX
ENDIF
IF mood_mad < 0 THEN
  SET mood_mad 0
ENDIF
RET 1


////////////////////////////////////////////////////////////////////
//
//  INC_SAD_MOOD - Increase sadness
//
//++CALL G_INC_SAD_MOOD // Increase Sadness
:G_INC_SAD_MOOD
ADD mood_sad 1
CALL G_INIT_MOOD_TIMER
IF mood_sad > MOOD_MAX THEN
  SET mood_sad MOOD_MAX
ENDIF
IF mood_sad < 0 THEN
  SET mood_sad 0
ENDIF
RET 1


////////////////////////////////////////////////////////////////////
//
// KARATE_CHOP
//
:G_KARATE_CHOP
CALL G_VOICE_HIT
SET rndbase 950
SET rndcount 3
SET lastact1 last_karateact
SET lastact2 last_karateact

if (F_BEHAVIOR_RNDN()) then
  SWITCH rndnum
    CASE:950 PLAY ACTION KARATE1
    CASE:951 PLAY ACTION KARATE2
    CASE:952 PLAY ACTION KARATE3
  SET last_karateact rndnum
  CALL G_WAITZERO
endif
RET 1


////////////////////////////////////////////////////////////////////
//
// LAZY_GOLEFT
//
:G_LAZY_GOLEFT

IF sitonly == 0 THEN
  IF mood_happy > 3 1275
  CALL G_RANDOM1/3
    CASE:1 GO 1275
ENDIF

// Look left instead of turning left if Aibo being lazy...
CALL G_VOICE_HIT
CALL G_RANDOM3
  CASE:1 PLAY ACTION MOVE.HEAD.SLOW 90 0
  CASE:2 PLAY ACTION MOVE.HEAD.NORMAL 90 0
  CASE:3 PLAY ACTION MOVE.HEAD.FAST 90 0
WAIT
RET 1	// done

:1275	// GO_LEFT
CALL G_GO_LEFT
RET 2	// stand


////////////////////////////////////////////////////////////////////
//
// LAZY_GORIGHT
//
:G_LAZY_GORIGHT

IF sitonly == 0 THEN
  IF mood_happy > 3 1287
  CALL G_RANDOM1/3
    CASE:1 GO 1287
ENDIF

// Look right instead of turning right if Aibo being lazy...
CALL G_VOICE_HIT
CALL G_RANDOM3
  CASE:1 PLAY ACTION MOVE.HEAD.SLOW -90 0
  CASE:2 PLAY ACTION MOVE.HEAD.NORMAL -90 0
  CASE:3 PLAY ACTION MOVE.HEAD.FAST -90 0
WAIT
RET 1	// done

:1287	// GO_RIGHT
CALL G_GO_RIGHT
RET 2	// stand


////////////////////////////////////////////////////////////////////
//
// NEED2REST  (See if we need to rest (heat or battery))
//
:G_NEED2REST
  if (F_NEED2REST()) then
    RET:1 // rest
  endif
  RET:2 // play
 
:F_NEED2REST
RETURN (Batt_Rest<BATTLEVEL_SHUTDOWN) || (BODYTEMP()>45) || (Batt_Temp>45) || POSE_CHARGE() || POSE_PICKUP()



////////////////////////////////////////////////////////////////////
//
// PRAISE
//
:G_PRAISE
LOCAL maxloop 10
CALL G_DEC_SAD_MOOD

IF (mood_happy<2) || (F_RND100()<50) THEN
  REPEAT
    RND rndnum 0 5
    maxloop-- 
  UNTIL (((rndnum!=last_praiseact) && (rndnum!=last_praiseact2)) || (maxloop<0))
ELSE
  REPEAT
    RND rndnum 100 102
    maxloop-- 
  UNTIL (((rndnum!=last_praiseact) && (rndnum!=last_praiseact2)) || (maxloop<0))
ENDIF

WAIT 1
SET init_wait Wait

SWITCH rndnum
  CASE:0 PLAY ACTION PRAISED1
  CASE:1 PLAY ACTION PRAISED2
  CASE:2 PLAY ACTION PRAISED3
  CASE:3 PLAY ACTION PRAISED4
  CASE:4 PLAY ACTION PRAISED5
  CASE:5 PLAY ACTION PRAISED6
  CASE:100 PLAY ACTION PRAISED7
  CASE:101 PLAY ACTION PRAISED8
  CASE:102 PLAY ACTION PRAISED9

SET last_praiseact2 last_praiseact
SET last_praiseact rndnum
CALL G_WAIT
CALL G_INC_HAPPY_MOOD
CALL G_DEC_MAD_MOOD
CALL G_BEHAVIOR_PRAISE
RET 1


////////////////////////////////////////////////////////////////////
//
// PRAISE_REST  (Been praised while not moving.   Get happier.)
//
:G_PRAISE_REST
CALL G_DEC_SAD_MOOD

IF_1ST mood_happy < 2 1361
IF_1ST mood_happy < 5 1371
IF_1ST mood_happy < 8 1370
CALL G_RANDOM4
  CASE:1 GO 1361
  CASE:2 GO 1355
  CASE:3 GO 1346

:1332	// RNDNUM(4)
RND rndnum 300 305
WAIT 1
SET init_wait Wait
IF_1ST rndnum = last_praiseact 1332
IF_1ST rndnum = last_praiseact2 1332
SWITCH rndnum
  CASE:300 PLAY ACTION HAPPY_ANY7
  CASE:301 PLAY ACTION HAPPY_ANY8
  CASE:302 PLAY ACTION HAPPY_ANY9
  CASE:303 PLAY ACTION HAPPY_ANY10
  CASE:304 PLAY ACTION HAPPY_ANY11
  CASE:305 PLAY ACTION HAPPY_ANY12

:1336	// TRACK_ACT
SET last_praiseact2 last_praiseact
SET last_praiseact rndnum
VSAVE boygirl
CALL G_WAIT
CALL G_INC_HAPPY_MOOD
CALL G_DEC_MAD_MOOD
CALL G_BEHAVIOR_PRAISE
RET 1

:1346	// RNDNUM(3)
RND rndnum 200 205
WAIT 1
SET init_wait Wait
IF_1ST rndnum = last_praiseact 1346
IF_1ST rndnum = last_praiseact2 1346
SWITCH rndnum
  CASE:200 PLAY ACTION HAPPY_ANY1
  CASE:201 PLAY ACTION HAPPY_ANY2
  CASE:202 PLAY ACTION HAPPY_ANY3
  CASE:203 PLAY ACTION HAPPY_ANY4
  CASE:204 PLAY ACTION HAPPY_ANY5
  CASE:205 PLAY ACTION HAPPY_ANY6
GO 1336

:1355	// RNDNUM(2)
RND rndnum 100 102
WAIT 1
SET init_wait Wait
IF_1ST rndnum = last_praiseact 1355
IF_1ST rndnum = last_praiseact2 1355
SWITCH rndnum
  CASE:100 PLAY ACTION PRAISED7
  CASE:101 PLAY ACTION PRAISED8
  CASE:102 PLAY ACTION PRAISED9
GO 1336

:1361	// RNDNUM
RND rndnum 0 5
WAIT 1
SET init_wait Wait
IF_1ST rndnum = last_praiseact 1361
IF_1ST rndnum = last_praiseact2 1361
SWITCH rndnum
  CASE:0 PLAY ACTION PRAISED1
  CASE:1 PLAY ACTION PRAISED2
  CASE:2 PLAY ACTION PRAISED3
  CASE:3 PLAY ACTION PRAISED4
  CASE:4 PLAY ACTION PRAISED5
  CASE:5 PLAY ACTION PRAISED6
GO 1336

:1370	// RANDOM3
CALL G_RANDOM3
  CASE:1 GO 1361
  CASE:2 GO 1355
GO 1346

:1371	// RANDOM2
CALL G_RANDOM2
  CASE:1 GO 1361
GO 1355


////////////////////////////////////////////////////////////////////
//
// QUERY_HUNGRY  (Respond to query about tummy status)
//
:G_QUERY_HUNGRY
#ifdef ERS220
  CALL G_SHOW_BATTERY_LEVEL
#endif

  WAIT 1
  SET init_wait Wait

  if (Batt_Rest>=50) then // not hungry
    CALL G_RANDOM2
      CASE:1 PLAY ACTION NO1
      CASE:2 PLAY ACTION NO2
    CALL G_WAIT_AWARE
    RET 1 // done
  endif

  CALL G_RANDOM2
    CASE:1 PLAY ACTION YES_OK1
    CASE:2 PLAY ACTION YES_OK2
  CALL G_WAIT_AWARE

  CALL G_RANDOM2
    CASE:2 RET 1	// done

  if (Batt_Rest<35) then
    PLAY ACTION HUNGRY_LOT
  else
    PLAY ACTION HUNGRY_LITTLE
  endif

  CALL G_WAIT_AWARE
  RET 2	// sit


#ifdef ERS220
:G_SHOW_BATTERY_LEVEL
  TIMER_CLEARLEDS := 5
  Back_3 := TRUE
  Back_2 := (Batt_Rest>40)
  Back_1 := (Batt_Rest>50)
  Back_4 := (Batt_Rest>60)
  Back_5 := (Batt_Rest>70)
  Back_6 := (Batt_Rest>80) 
  RET:1
#endif



////////////////////////////////////////////////////////////////////
//
// QUERY_MOOD  (Respond if asked "Are you ok?")
//
:G_QUERY_MOOD
WAIT 1
SET init_wait Wait

// If battery & mood ok, then say YES...
IF (Batt_Rest >= 35) && (mood_mad < 1) && (mood_sad < 1) THEN
  CALL G_RANDOM2
    CASE:1 PLAY ACTION YES_OK1
    CASE:2 PLAY ACTION YES_OK2
  CALL G_WAIT_AWARE
  RET:1
ENDIF

// Say NO...
CALL G_RANDOM2
  CASE:1 PLAY ACTION NO1
  CASE:2 PLAY ACTION NO2
CALL G_WAIT_AWARE

// If hungry, occastionally indicate if hungry...
RND rndnum 0 100
IF rndnum<50 THEN
  RET:1
ENDIF

IF Batt_Rest<35 THEN
  PLAY ACTION HUNGRY_LOT
  CALL G_WAIT
  RET:1
ENDIF

IF mood_mad>4 THEN
  CALL G_TANTRUM
  RET:1
ENDIF

IF mood_sad>4 THEN
  CALL G_SAD
  RET:1
ELSE
  RND TIMER_CLEAREYES 2 5	// Set timer to turn off eyes (2 to 5 seconds)...
  SET Eye_L1 1			// Set sad eyes...
  SET Eye_R1 1
ENDIF
RET:1


////////////////////////////////////////////////////////////////////
//
// QUERY_TIRED
//
:G_QUERY_TIRED
WAIT 1
SET init_wait Wait

IF mood_tired>5 THEN
  CALL G_RANDOM2
    CASE:1 PLAY ACTION YES_OK1
    CASE:2 PLAY ACTION YES_OK2
  CALL G_WAIT_AWARE
  RET 1	// done
ENDIF

CALL G_RANDOM2
  CASE:1 PLAY ACTION NO1
  CASE:2 PLAY ACTION NO2
CALL G_WAIT_AWARE
RET 1	// done



////////////////////////////////////////////////////////////////////
//
//  Random 33% chance...
//
:G_RANDOM1/3
RND rndnum 0 100
CSET:rndnum:<:33:1	// Yup
CSET:rndnum:>=:33:2	// Nope
RET:Context


////////////////////////////////////////////////////////////////////
// RANDOM2  (Random 50% chance)
:G_RANDOM2
RND rndnum 0 100
CSET:rndnum:<:50:1	// Yup
CSET:rndnum:>=:50:2	// Nope
RET:Context

:F_RND2
  RND rndnum 0 100
  return (rndnum>50)


////////////////////////////////////////////////////////////////////
// RANDOM3  (Random 1 in 3)
:G_RANDOM3
RND rndnum 0 100
CSET:rndnum:<:33:1
CSET:rndnum:<:66:2
CSET:rndnum:>=:66:3
RET:Context


////////////////////////////////////////////////////////////////////
// RANDOM4  (Random 1 in 4)
:G_RANDOM4
RND rndnum 0 100
CSET:rndnum:<:25:1
CSET:rndnum:<:50:2
CSET:rndnum:<:75:3
CSET:rndnum:>=:75:4
RET:Context


////////////////////////////////////////////////////////////////////
// RANDOM6  (Random 1 in 6)
:G_RANDOM6
RND rndnum 0 60
CSET:rndnum:<:10:1
CSET:rndnum:<:20:2
CSET:rndnum:<:30:3
CSET:rndnum:<:40:4
CSET:rndnum:<:50:5
CSET:rndnum:>=:50:6
RET:Context


////////////////////////////////////////////////////////////////////
// SAD
:G_SAD
RND rndnum 0 13
SWITCH rndnum
  CASE:0 PLAY ACTION SAD_ANY1
  CASE:1 PLAY ACTION SAD_ANY2
  CASE:2 PLAY ACTION SAD_ANY3
  CASE:3 PLAY ACTION SAD_ANY4
  CASE:4 PLAY ACTION SAD_ANY5
  CASE:5 PLAY ACTION SAD_ANY6
  CASE:6 PLAY ACTION SAD_ANY7
  CASE:7 PLAY ACTION SAD_ANY8
  CASE:8 PLAY ACTION SAD_ANY9
  CASE:9 PLAY ACTION SAD_ANY10
  CASE:10 PLAY ACTION SAD_ANY11
  CASE:11 PLAY ACTION SAD_ANY12
  CASE:12 PLAY ACTION SAD_ANY13
  CASE:13 PLAY ACTION SAD_ANY14
CALL G_WAIT
RET 1


////////////////////////////////////////////////////////////////////
// SCOLD
:G_SCOLD

:1496	// MOOD?
IF_1ST mood_mad <= 5 1514
RND rndnum 0 23

:4109	// MAD_RNDNUM
WAIT 1
SET init_wait Wait
IF_1ST rndnum = last_scoldact 1496
IF_1ST rndnum = last_scoldact2 1496
SWITCH rndnum
  CASE:0 PLAY ACTION SCOLDED1
  CASE:1 PLAY ACTION SCOLDED2
  CASE:2 PLAY ACTION SCOLDED3
  CASE:3 PLAY ACTION SCOLDED4
  CASE:4 PLAY ACTION SCOLDED5
  CASE:5 PLAY ACTION SCOLDED6
  CASE:6 PLAY ACTION SCOLDED7
  CASE:7 PLAY ACTION SCOLDED8
  CASE:8 PLAY ACTION SCOLDED9
SET last_scoldact2 last_scoldact
SET last_scoldact rndnum
CALL G_WAIT

CALL G_INC_MAD_MOOD
CALL G_DEC_HAPPY_MOOD
CALL G_BEHAVIOR_SCOLD
RET 1

:1514	// CALM_RNDNUM
RND rndnum 0 8
GO 4109


////////////////////////////////////////////////////////////////////
// SCOLD_REST  (Been scolded.  Get madder.)
:G_SCOLD_REST

:1517	// MOOD?
IF_1ST mood_mad <= 5 1555
CALL G_RANDOM1/3
  CASE:1 GO 1551

:1519	// MAD_RNDNUM
RND rndnum 0 23

:4110	// MAD_RNDNUM
WAIT 1
SET init_wait Wait
IF_1ST rndnum = last_scoldact 1517
IF_1ST rndnum = last_scoldact2 1517
IF_1ST rndnum < 10 1541
SWITCH rndnum
  CASE:9 PLAY ACTION MAD_ANY1
  CASE:10 PLAY ACTION MAD_ANY2
  CASE:11 PLAY ACTION MAD_ANY3
  CASE:12 PLAY ACTION MAD_ANY4
  CASE:13 PLAY ACTION MAD_ANY5
  CASE:14 PLAY ACTION MAD_ANY6
  CASE:15 PLAY ACTION MAD_ANY7
  CASE:16 PLAY ACTION MAD_ANY8
  CASE:17 PLAY ACTION MAD_ANY9
  CASE:18 PLAY ACTION MAD_ANY10
  CASE:19 PLAY ACTION MAD_ANY11
  CASE:20 PLAY ACTION MAD_ANY12
  CASE:21 PLAY ACTION MAD_ANY13
  CASE:22 PLAY ACTION MAD_ANY14

:1523	// TRACK_SCOLD
SET last_scoldact2 last_scoldact
SET last_scoldact rndnum
VSAVE boygirl
CALL G_WAIT
CALL G_INC_MAD_MOOD
CALL G_DEC_HAPPY_MOOD
CALL G_BEHAVIOR_SCOLD
RET 1

:1541	// SELECT_SCOLD
SWITCH rndnum
  CASE:0 PLAY ACTION SCOLDED1
  CASE:1 PLAY ACTION SCOLDED2
  CASE:2 PLAY ACTION SCOLDED3
  CASE:3 PLAY ACTION SCOLDED4
  CASE:4 PLAY ACTION SCOLDED5
  CASE:5 PLAY ACTION SCOLDED6
  CASE:6 PLAY ACTION SCOLDED7
  CASE:7 PLAY ACTION SCOLDED8
  CASE:8 PLAY ACTION SCOLDED9
GO 1523

:1551	// STANDING?
IF_1ST Posture1 <> POSTURE_STAND 1519
CALL G_RANDOM2
  CASE:1 PLAY ACTION BEENHIT1
  CASE:2 PLAY ACTION BEENHIT2
SET rndnum 999
GO 1523

:1555	// CALM_RNDNUM
RND rndnum 0 8
GO 4110



////////////////////////////////////////////////////////////////////
// STAND4BALL  (Standup while looking at ball)
:G_STAND4BALL
  if (sitonly>0) || (mood_tired>=9) then // don't stand if sitonly mode, or too tired...
    RET GO_IGNORE
  endif

  CALL G_STOP_HEADTAIL

  if (POSE_SIT()) then
    PLAY ACTION TRACK_HEAD PINK_BALL
    WAIT 1000
    SET init_wait Wait
    PLAY ACTION stand_straight   // standup while maintaining lock on ball...
    CALL G_WAIT
    CALL G_STOP_HEAD
  else
    SET pan Head_Pan
    SET tilt Head_Tilt
    SUB tilt 15
    WAIT 1
    SET init_wait Wait
    PLAY ACTION STAND
    CALL G_WAIT
    PLAY ACTION MOVE.HEAD.FAST pan tilt
    CALL G_WAIT
  endif

  if (Pink_Ball>0) then
    RET GO_SEEBALL
  endif

  CALL G_SOCCER_SEARCH4BALL
    CASE:1 RET GO_RESTPOS
    CASE:2 RET GO_SEEBALL
  RET GO_IDLE



////////////////////////////////////////////////////////////////////
// START_TAILWAG  (Stop tail from wagging)
:G_START_TAILWAG_SLOW
#ifdef ERS210
  if (tailwag==0) then
    PLAY ACTION O2_TAILWAG_VERT1 // slow
  endif
  tailwag := 1
#endif
  RET 1

:G_START_TAILWAG_NORMAL
#ifdef ERS210
  if (tailwag==0) then
    PLAY ACTION O2_TAILWAG_VERT2 // normal
  endif
  tailwag := 1
#endif
  RET 1

:G_START_TAILWAG_FAST
#ifdef ERS210
  if (tailwag==0) then
    PLAY ACTION O2_TAILWAG_VERT3 // fast
  endif
  tailwag := 1
#endif
  RET 1



////////////////////////////////////////////////////////////////////
// STOP_TAILWAG  (Stop tail from wagging)
:G_STOP_TAILWAG
#ifdef ERS210
WAIT 1
if (tailwag>0) && (Wait>0) then
  PLAY ACTION PALONE.AUTO.TAILSTOP
  CALL G_WAITZERO
endif
#endif
tailwag := 0
RET 1


////////////////////////////////////////////////////////////////////
// SURPRISE
:G_SURPRISE
RND rndnum 0 12
WAIT 1
SET init_wait Wait
SWITCH rndnum
  CASE:0 PLAY ACTION SURPRISE_ANY1
  CASE:1 PLAY ACTION SURPRISE_ANY2
  CASE:2 PLAY ACTION SURPRISE_ANY3
  CASE:3 PLAY ACTION SURPRISE_ANY4
  CASE:4 PLAY ACTION SURPRISE_ANY5
  CASE:5 PLAY ACTION SURPRISE_ANY6
  CASE:6 PLAY ACTION SURPRISE_ANY7
  CASE:7 PLAY ACTION SURPRISE_ANY8
  CASE:8 PLAY ACTION SURPRISE_ANY9
  CASE:9 PLAY ACTION SURPRISE_ANY10
  CASE:10 PLAY ACTION SURPRISE_ANY11
  CASE:11 PLAY ACTION SURPRISE_ANY12
  CASE:12 PLAY ACTION SURPRISE_ANY13
CALL G_WAIT
RET 1


////////////////////////////////////////////////////////////////////
// TAKE_A_PICTURE
:G_TAKE_A_PICTURE
WAIT 1
SET init_wait Wait
PLAY ACTION MOVE.HEAD.FAST Head_Pan 0
CALL G_WAIT_AWARE

PLAY ACTION PHOTOSNAP
AP_SNAPSHOT
CALL G_WAIT_AWARE

:3067	// WAIT4SNAP
WHILE AP_Snap_Ready <= 0 
  WAIT 1
WEND

VLOAD snapNum
AP_SAVEIMAGE snapNum

ADD snapNum 1
LAND snapNum 7	// Range 0 to 7, to avoid filling memstick
VSAVE snapNum

PLAY ACTION+ happy_eyes
CALL G_WAIT_AWARE
RET 1



////////////////////////////////////////////////////////////////////
//
//  Function to sample dogs or owners name.  Based on code from 
//  AiboPet's RCRLIB.R, but with more window dressing.
//
//  Return TRUE if successful.  FALSE otherwise.
//
:F_RECORD_NAME
  ARG:vcmd_id
  LOCAL count 
  LOCAL timeout

#if ERS210
 #define TAILBLUE Tail_B
 #define TAILRED Tail_O
#elif ERS220
 #define TAILBLUE Back_9 := Back_8
 #define TAILRED Back_7
#elif ERS310
 #define TAILBLUE Horn_B
 #define TAILRED Horn_O
#endif

  // Wait 10 seconds for backpress...
  timeout := 100			// 10 second timeout
  Head_ON := Back_ON := 0
  while (!Head_ON && !Back_ON)
    WAIT:100
    if (--timeout == 0) then
      TAILBLUE := 0
      RETURN:TRUE
    endif
    if (timeout&0x3)==0 then 
      TAILBLUE := (timeout&0x4) 	// Flash tail blue...
    endif
  wend

  Warn := 1 				// Turn on PAUSE light, so user knows AIBO is recording.
  TAILBLUE := 0				// Turn off LED's from above.
  timeout := 100			// Reset 10 second timeout
  count := 0

  repeat
    SET AP_VoiceRec_Result -1
    WAIT:100
    AP_VOICEREC vcmd_id 

    repeat
      WAIT:100
      if (timeout&0x3) then // alternate blue/red...
        TAILRED := !(TAILBLUE := (timeout&0x4))
      endif
    until (AP_VoiceRec_Result>-1) || (--timeout<=0)

    // Success or fault?
    if (AP_VoiceRec_Result==1) || (AP_VoiceRec_Result==100) then
      // Wait out the 10 second sample interval...
      repeat
        WAIT:100
        if (timeout&0x3) then // alternate blue/red...
          TAILRED := !(TAILBLUE := (timeout&0x4))
        endif
      until (--timeout<=0)
      Warn := TAILBLUE := TAILRED := 0	 // Turn off LED's...

      // Something bad happen to voice recording routines?
      if (AP_VoiceRec_Result==100) then
        PRINT "Voice Recognition Error - Unable to record."
        RETURN:FALSE
      endif

      PRINT "Voice Command 0x%x Recorded",vcmd_id
      RETURN:TRUE
    endif
  until (++count>=10) || (timeout<=0)

  // Turn off LED's...
  Warn := TAILBLUE := TAILRED := 0	
  PRINT "Unable to get good voice capture.  Try again."
  RETURN:FALSE



////////////////////////////////////////////////////////////////////
//
//  Function to playback dogs or owners name.  Based on code from 
//  AiboPet's RCRLIB.R.
//
:F_PLAYBACK_NAME
  ARG:vcmd_id
  LOCAL syn_size

  AP_GETSYNVOICE syn_voice syn_size vcmd_id
  if (syn_size<=0) then
    RETURN:FALSE
  endif

  SET AP_Replay_Result_Mode 0	// disable hook?!  what does this do?

  INIT MTN
  CALL G_WAITZERO

 #ifdef ERS210
  SET AP_SynBite_Mode 3 // sound and mouth (animate mouth)
 #else
  SET AP_SynBite_Mode 1 // sound only
 #endif
  AP_SETARRAYASRAM syn_voice 0 syn_size

  LOAD SND ram
  CALL G_WAITZERO
  PLAY MTN
  CALL G_WAITZERO

  SET AP_Use_Ram 0 		// no longer used?!  what does this do?  Clears 'ram' maybe?
  SET AP_SynBite_Mode 0
  RETURN:TRUE



////////////////////////////////////////////////////////////////////
//
//  AIBO name registration...
//
:G_NAME_REGISTRATION
  if (!behavior[BEHAVIOR_DISABLE_NAMEREG]) then
    PLAY ACTION BEG_PET1	// Beg for AIBO's name
    CALL G_WAITZERO
    if (F_RECORD_NAME(VOICE_AIBO)) G_PLAYBACK_AIBONAME
  endif
  PLAY ACTION NOTHANKS
  GO G_WAITZERO



////////////////////////////////////////////////////////////////////
//
//  Owner name registration...
//
:G_OWNER_REGISTRATION
  if (!behavior[BEHAVIOR_DISABLE_NAMEREG]) then
    PLAY ACTION BEG_PET3	// Beg for owners name
    CALL G_WAITZERO
    PLAY ACTION LIE	// Laydown when learning owner name
    CALL G_WAITZERO
    if (F_RECORD_NAME(VOICE_OWNERNAME)) G_PLAYBACK_OWNERNAME
  endif
  PLAY ACTION NOTHANKS
  GO G_WAITZERO



////////////////////////////////////////////////////////////////////
//
//  Routines for playing back dogs & owners name...
//
:G_PLAYBACK_AIBONAME
  F_PLAYBACK_NAME(VOICE_AIBO)
  RET:1

:G_PLAYBACK_OWNERNAME
  F_PLAYBACK_NAME(VOICE_OWNERNAME)
  RET:1



////////////////////////////////////////////////////////////////////
//
//  Throw a temper tantrum...
//
:G_TANTRUM
WAIT 1
SET init_wait Wait
RND rndnum 0 100
CSET:rndnum:<:10:1
CSET:rndnum:<:20:2
CSET:rndnum:<:30:3
CSET:rndnum:<:40:4
CSET:rndnum:<:50:5
CSET:rndnum:<:60:6
CSET:rndnum:<:70:7
CSET:rndnum:<:80:8
CSET:rndnum:<:90:9
CSET:rndnum:>=:90:10
CASE:1:PLAY ACTION TEMPER_TANTRUM1
CASE:2:PLAY ACTION TEMPER_TANTRUM2
CASE:3:PLAY ACTION TEMPER_TANTRUM3
CASE:4:PLAY ACTION TEMPER_TANTRUM4
CASE:5:PLAY ACTION TEMPER_TANTRUM5
CASE:6:PLAY ACTION TEMPER_TANTRUM6
CASE:7:PLAY ACTION TEMPER_TANTRUM7
CASE:8:PLAY ACTION CUTE_EXERCISE5
CASE:9:PLAY ACTION CUTE_EXERCISE6
CASE:10:PLAY ACTION AIBOZYA
CALL G_WAIT
RET 1


////////////////////////////////////////////////////////////////////
//
//  Translate tone commands into Voice commands...
//
:G_TONECMD
WAIT 1
IF_1ST rcodeplus > 0
IF_AND AP_Tone > 0 3110
RET 2	// none

:3110	// GET_TONE
WAIT 1
SET ToneCmd AP_Tone
SET AP_Tone 0
WAIT 1
SWITCH ToneCmd
  CASE:11 SET VoiceCmd VOICE_STANDUP	// Stand Up
  CASE:12 SET VoiceCmd VOICE_SITDOWN	// Sit Down
  CASE:13 SET VoiceCmd VOICE_LAYDOWN	// Lie Down
  CASE:23 SET VoiceCmd VOICE_GOFORWARD  // Go Forward
  CASE:24 SET VoiceCmd VOICE_STOP	// Stop
  CASE:25 SET VoiceCmd VOICE_GOBACK	// Go Back
  CASE:28 SET VoiceCmd VOICE_TURNLEFT	// Left
  CASE:29 SET VoiceCmd VOICE_TURNRIGHT	// Right
  CASE:ELSE RET 2			// none - 
RET 1


////////////////////////////////////////////////////////////////////
//
//  Acknowledge a voice command.  Occasionally be directional...
//
:G_TWITCH_EARS
WAIT 1
SET init_wait Wait

IF AiboType==210 THEN
  RND rndnum 0 100
  IF rndnum < 33 THEN
    SWITCH:VoiceHorz
      CASE:2 PLAY ACTION RIGHT_EAR_TWITCH3
      CASE:4 PLAY ACTION RIGHT_EAR_TWITCH3
      CASE:8 PLAY ACTION RIGHT_EAR_TWITCH3
      CASE:32 PLAY ACTION LEFT_EAR_TWITCH3
      CASE:64 PLAY ACTION LEFT_EAR_TWITCH3
      CASE:128 PLAY ACTION LEFT_EAR_TWITCH3
      CASE:ELSE PLAY ACTION BOTH_EAR_TWITCH3
  ELSE
    PLAY ACTION BOTH_EAR_TWITCH3
  ENDIF
ELSE // 220 & 310
  PLAY MWCID VOICEACK
ENDIF

CALL G_WAIT_AWARE
RET:1



////////////////////////////////////////////////////////////////////
//
//  Acknowledge a voice command (so user knows AIBO is responding)...
//
:G_VOICE_HIT
CALL G_TWITCH_EARS
CALL G_STOP_TAILWAG
RET:1



////////////////////////////////////////////////////////////////////
//
//  See if there is a pending voice command...
//
:G_VOICECMD
LOCAL hhit 0

#ifdef DEBUG_NOVOICE
  AP_Voice_Cmd := 0
  RET:GO_IDLE
#endif

WAIT 1
IF AP_Voice_Cmd == 0 THEN
  RET:GO_IDLE
ENDIF

SET VoiceCmd (AP_Voice_Cmd+base_voice_cmd)
SET VoiceLevel AP_Voice_Level
SET VoicePitch AP_Voice_Pitch
SET VoiceHorz AP_Voice_Horz
SET VoiceDictID AP_Voice_DicID
SET AP_Voice_Cmd 0

PRINT -----
PRINT VoiceCmd=%d VoiceCmd
PRINT VoiceLevel=%d VoiceLevel
PRINT VoicePitch=%d VoicePitch
PRINT VoiceHorz=%d VoiceHorz
PRINT VoiceDictID=%d VoiceDictID

// Ignor anything with quiet voice level.  Too often tends to
//  be disruptive background noise.
IF VoiceLevel < MIN_VOICE_LEVEL THEN
  PRINT "Filtered - Low voice level"
  SET VoiceCmd 0
  SET VoiceLevel 0
  RET:GO_IDLE
ENDIF

/*
// Spurious voice commands (seem to get triggered from background noise frequently),
// when using RCode 1.2 voice recognition (versas that from AiboLife 1).
IF base_voice_cmd > 0 THEN
  SWITCH VoiceDictID
    CASE:14 SET VoiceCmd 0
    CASE:26 SET VoiceCmd 0
  IF VoiceCmd == 0 THEN
    PRINT "Filtered - Spurious"
    SET VoiceLevel 0
    RET:GO_IDLE
  ENDIF
ENDIF
*/

#ifdef DEBUG
SWITCH VoiceCmd
  CASE:VOICE_GOODMORNING    PRINT "Good Morning"
  CASE:VOICE_GOODNIGHT 	    PRINT "Good Night"
  CASE:VOICE_GOODBYE 	    PRINT "Goodbye"
  CASE:VOICE_AIBO 	    PRINT "AIBO"
  CASE:VOICE_HELLO 	    PRINT "Hello"
  CASE:VOICE_SAYHELLO 	    PRINT "SayHello"
  CASE:VOICE_FINDBALL 	    PRINT "Find Ball"
  CASE:VOICE_KICKBALL 	    PRINT "Kick Ball"
  CASE:VOICE_LETSDANCE 	    PRINT "Let's Dance"
  CASE:VOICE_GETUP 	    PRINT "Get Up"
  CASE:VOICE_STANDUP 	    PRINT "Stand Up"
  CASE:VOICE_AREYOUOK 	    PRINT "Are You ok?"
  CASE:VOICE_GOFORWARD 	    PRINT "Go Forward"
  CASE:VOICE_GOBACK 	    PRINT "Go Back"
  CASE:VOICE_TURNLEFT 	    PRINT "Turn Left"
  CASE:VOICE_TURNRIGHT 	    PRINT "Turn Right"
  CASE:VOICE_POSE 	    PRINT "Pose"
  CASE:VOICE_ROAR 	    PRINT "Roar"
  CASE:VOICE_MEOW 	    PRINT "Meow"
  CASE:VOICE_AREYOUTIRED    PRINT "Are You Tired?"
  CASE:VOICE_AREYOUHUNGRY   PRINT "Are You Hungry?"
  CASE:VOICE_STOP 	    PRINT "Stop"
  CASE:VOICE_SITDOWN 	    PRINT "Sit Down"
  CASE:VOICE_SHAKEPAW 	    PRINT "Shake Paw"
  CASE:VOICE_SHAKE 	    PRINT "Shake"
  CASE:VOICE_OTHERPAW 	    PRINT "Other Paw"
  CASE:VOICE_KARATECHOP     PRINT "Karate Chop"
  CASE:VOICE_LETSPLAY 	    PRINT "Let's Play"
  CASE:VOICE_LAYDOWN 	    PRINT "Lay Down"
  CASE:VOICE_NAMEREG 	    PRINT "Name Registration"
  CASE:VOICE_WHATSYOURNAME  PRINT "What's Your Name?"
  CASE:VOICE2_AIBO          PRINT "AIBO"
  CASE:VOICE2_WHATSYOURNAME PRINT "What's Your Name?"
  CASE:VOICE2_SAYHELLO      PRINT "Say Hello"
  CASE:VOICE2_SHAKEPAW      PRINT "Shake Paw"
  CASE:VOICE2_MORNING       PRINT "Morning"
  CASE:VOICE2_HELLO         PRINT "Hello"
  CASE:VOICE2_GOODNIGHT     PRINT "Good Night"
  CASE:VOICE2_DONTDOTHAT    PRINT "Don't Do That"
  CASE:VOICE2_LETSPLAY      PRINT "Let's Play"
  CASE:VOICE2_DANCE         PRINT "Dance"
  CASE:VOICE2_POSE          PRINT "Pose"
  CASE:VOICE2_STANDUP       PRINT "Stand Up"
  CASE:VOICE2_LAYDOWN       PRINT "Lay Down"
  CASE:VOICE2_SITDOWN       PRINT "Sit Down"
  CASE:VOICE2_TURNRIGHT     PRINT "Turn Right"
  CASE:VOICE2_TURNLEFT      PRINT "Turn Left"
  CASE:VOICE2_GOFORWARD     PRINT "Go Forward"
  CASE:VOICE2_GOBACKWARD    PRINT "Go Backward"
  CASE:VOICE2_STOP          PRINT "Stop"
  CASE:VOICE2_TAKEAPICTURE  PRINT "Take a Picture"
  CASE:VOICE2_KARATECHOP    PRINT "Karate Chop"
  CASE:VOICE2_WALK          PRINT "Walk"
  CASE:VOICE2_AREYOUTIRED   PRINT "Are You Tired?"
  CASE:VOICE2_AREYOUHUNGRY  PRINT "Are You Hungry?"
  CASE:VOICE2_NAMEREG       PRINT "Name Registration"
  CASE:VOICE2_BEQUIET       PRINT "Be Quiet"
  CASE:VOICE2_IAMHERE       PRINT "I Am Here"
  CASE:VOICE2_THANKS 	    PRINT "Thanks!"
  CASE:VOICE2_HEYAIBO 	    PRINT "Hey AIBO"
  CASE:VOICE2_SEEYOU 	    PRINT "See You"
  CASE:VOICE2_HOWAREYOU	    PRINT "How Are You?"
  CASE:VOICE2_SINGSONG	    PRINT "Sing Song"
  CASE:VOICE2_CLOWNAROUND   PRINT "Clown Around"
  CASE:VOICE2_HAPPYDAY	    PRINT "Happy Day"
  CASE:VOICE2_GOAHEAD	    PRINT "Go Ahead"
  CASE:VOICE2_BANZAI	    PRINT "Banzai"
  CASE:VOICE2_SHOWTIME 	    PRINT "Show Time"
  CASE:VOICE2_SHOWOFF	    PRINT "Show Off"
  CASE:VOICE2_PINKBALL      PRINT "Pink Ball"
  CASE:VOICE2_RIGHTKICK     PRINT "Right Kick"
  CASE:VOICE2_LEFTKICK      PRINT "Left Kick"
  CASE:VOICE2_RIGHTTOUCH    PRINT "Right Touch"
  CASE:VOICE2_LEFTTOUCH     PRINT "Left Touch"
  CASE:VOICE2_OWNERREG      PRINT "Owner Registration"
  CASE:VOICE2_WHATSOWNERNAME PRINT "What's Owner Name?"
#endif

// Translate compatible VOICE2 commands into Life1 vocabulary
// to minimize changes needed to support it...
SWITCH VoiceCmd
  CASE:VOICE2_AIBO          SET VoiceCmd VOICE_AIBO
  CASE:VOICE2_WHATSYOURNAME SET VoiceCmd VOICE_WHATSYOURNAME
  CASE:VOICE2_SAYHELLO      SET VoiceCmd VOICE_SAYHELLO
  CASE:VOICE2_SHAKEPAW      SET VoiceCmd VOICE_SHAKEPAW
  CASE:VOICE2_MORNING       SET VoiceCmd VOICE_GOODMORNING
  CASE:VOICE2_HELLO         SET VoiceCmd VOICE_HELLO
  CASE:VOICE2_GOODNIGHT     SET VoiceCmd VOICE_GOODNIGHT
  CASE:VOICE2_DONTDOTHAT    SET VoiceCmd VOICE_DONTDOTHAT
  CASE:VOICE2_LETSPLAY      SET VoiceCmd VOICE_LETSPLAY
  CASE:VOICE2_DANCE         SET VoiceCmd VOICE_LETSDANCE
  CASE:VOICE2_POSE          SET VoiceCmd VOICE_POSE
  CASE:VOICE2_STANDUP       SET VoiceCmd VOICE_STANDUP
  CASE:VOICE2_LAYDOWN       SET VoiceCmd VOICE_LAYDOWN
  CASE:VOICE2_SITDOWN       SET VoiceCmd VOICE_SITDOWN
  CASE:VOICE2_TURNRIGHT     SET VoiceCmd VOICE_TURNRIGHT
  CASE:VOICE2_TURNLEFT      SET VoiceCmd VOICE_TURNLEFT
  CASE:VOICE2_GOFORWARD     SET VoiceCmd VOICE_GOFORWARD
  CASE:VOICE2_GOBACKWARD    SET VoiceCmd VOICE_GOBACK
  CASE:VOICE2_STOP          SET VoiceCmd VOICE_STOP
  CASE:VOICE2_TAKEAPICTURE  SET VoiceCmd VOICE_TAKEAPICTURE
  CASE:VOICE2_KARATECHOP    SET VoiceCmd VOICE_KARATECHOP
  CASE:VOICE2_WALK          SET VoiceCmd VOICE_WALK
  CASE:VOICE2_AREYOUTIRED   SET VoiceCmd VOICE_AREYOUTIRED
  CASE:VOICE2_AREYOUHUNGRY  SET VoiceCmd VOICE_AREYOUHUNGRY
  CASE:VOICE2_NAMEREG       SET VoiceCmd VOICE_NAMEREG
  CASE:VOICE2_BEQUIET       SET VoiceCmd VOICE_BEQUIET
  CASE:VOICE2_IAMHERE       SET VoiceCmd VOICE_IAMHERE


//
// If dictionary index has occured recently, then
// only respond to it 50% of time.   Frequent identical
// dictionary hits are likely spurious noise...
//
#ifdef RCODE250
  TIMER_VOICE := VOICE_TIMER_INTERVAL
  AP_SCANCOUNT vhcount voicehist 0 MAX_VOICEHIST VoiceDictID
  AP_BMOVE voicehist 0 1 MAX_VOICEHIST-1
  voicehist[0] := VoiceDictID
  if (vhcount>1) then
    if (F_RND100()<50) then
      PRINT "Filtered - Dictionary History"
      SET VoiceCmd 0
      SET VoiceLevel 0
      RET:GO_IDLE
    endif
  endif
#endif


//
// Hello/Goodbye filter...  RCode 1.2 voice recognition seems to catch
// spurious noise (background or AIBO servo noise) and interpreting it 
// as the various "hello" commands (and other two-syllable commands)...  
// This filter prevents more than one hello every 20 seconds.
//
SWITCH VoiceCmd
  CASE:VOICE_GOODMORNING SET hhit 1
  CASE:VOICE_GOODNIGHT   SET hhit 1
  CASE:VOICE_GOODBYE 	 SET hhit 1
  CASE:VOICE_AIBO 	 SET hhit 1
  CASE:VOICE_HELLO 	 SET hhit 1
  CASE:VOICE_SAYHELLO    SET hhit 1
  CASE:VOICE2_THANKS 	 SET hhit 1
  CASE:VOICE2_HAPPYDAY   SET hhit 1
  CASE:VOICE2_HEYAIBO    SET hhit 1
  CASE:VOICE2_SEEYOU 	 SET hhit 1

if (hhit) then
  if (TIMER_HELLO>0) then
    PRINT "Filtered - Hello Timer"
    SET VoiceCmd 0
    SET VoiceLevel 0
    RET:GO_IDLE
  else 
    TIMER_HELLO := 20	// don't allow another hello o goodbye for 20 seconds...
  endif
endif

PRINT Translated_VoiceCmd=%d VoiceCmd
RET:GO_VOICE



////////////////////////////////////////////////////////////////////
//
//  Process attention given while waiting for something...
//
:G_WAIT_ATTENTION
IF (praise+scold)>0 THEN
  RET 1
ENDIF

// HEAD_ON?
IF Head_ON <> 0 THEN
  IOR praise 1
  SET Head_ON 0
  SET back_count 0
ENDIF

// HEAD_HIT?
IF Head_Hit <> 0 THEN
  IOR scold 1
  SET Head_Hit 0
  SET back_count 0
ENDIF

// BACK_ON?
IF Back_ON <> 0 THEN
  IOR praise 2
  SET Back_ON 0
  ADD back_count 1
ENDIF

// JAW_ON?
IF Jaw_ON <> 0 THEN
  IOR praise 4
  SET Jaw_ON 0
  SET back_count 0
ENDIF

// Good-Boy/Bad-Boy?
IF AP_Voice_Cmd != 0 THEN
  IF (AP_Voice_Level < MIN_VOICE_LEVEL) THEN
    SET AP_Voice_Cmd 0
  ELSE
    SWITCH (AP_Voice_Cmd+base_voice_cmd)
      CASE:VOICE_GOODBOT GO WA_GOODBOT	 	// Good Bot
      CASE:VOICE2_GOODAIBO GO WA_GOODBOT	// Good AIBO
      CASE:VOICE_DONTDOTHAT GO WA_BADBOT	// Don't do that
      CASE:VOICE_BADBOT GO WA_BADBOT	 	// Bad Boy
      CASE:VOICE2_THATSRIGHT GO WA_GOODBOT 	// Good Bot
      CASE:VOICE2_GOODBOY GO WA_GOODBOT 	// Good Boy
      CASE:VOICE2_GOODGIRL GO WA_GOODBOT	// Good Girl
      CASE:VOICE2_BADBOY GO WA_BADBOT		// Bad Boy
      CASE:VOICE2_BADGIRL GO WA_BADBOT		// Bad Girl
  ENDIF
ENDIF

:WA_CHECK_ATTENTION
IF praise > 0 WA_PRAISE
IF scold > 0 WA_SCOLD
RET 1

:WA_SCOLD
RND rndnum 0 8
IF_1ST rndnum = last_scoldact WA_SCOLD
IF_1ST rndnum = last_scoldact2 WA_SCOLD
SWITCH rndnum
  CASE:0 PLAY ACTION SCOLDED1
  CASE:1 PLAY ACTION SCOLDED2
  CASE:2 PLAY ACTION SCOLDED3
  CASE:3 PLAY ACTION SCOLDED4
  CASE:4 PLAY ACTION SCOLDED5
  CASE:5 PLAY ACTION SCOLDED6
  CASE:6 PLAY ACTION SCOLDED7
  CASE:7 PLAY ACTION SCOLDED8
  CASE:8 PLAY ACTION SCOLDED9
SET last_scoldact2 last_scoldact
SET last_scoldact rndnum
RET 1

:WA_PRAISE
RND rndnum 0 8
IF_1ST rndnum = last_praiseact WA_PRAISE
IF_1ST rndnum = last_praiseact2 WA_PRAISE
SWITCH rndnum
  CASE:0 PLAY ACTION PRAISED1
  CASE:1 PLAY ACTION PRAISED2
  CASE:2 PLAY ACTION PRAISED3
  CASE:3 PLAY ACTION PRAISED4
  CASE:4 PLAY ACTION PRAISED5
  CASE:5 PLAY ACTION PRAISED6
  CASE:6 PLAY ACTION PRAISED7
  CASE:7 PLAY ACTION PRAISED8
  CASE:8 PLAY ACTION PRAISED9
SET last_praiseact2 last_praiseact
SET last_praiseact rndnum
RET 1

:WA_BADBOT
IOR scold 8	// Set bit 3
SET back_count 0
GO WA_CHECK_ATTENTION

:WA_GOODBOT
IOR praise 8	// Set bit 3
SET back_count 0
GO WA_CHECK_ATTENTION



////////////////////////////////////////////////////////////////////
//
//  Stall (up to 30 seconds) for skit to finish...  Must initialize
//  "init_wait" variable prior to calling this procedure.
//
:G_WAIT
  LOCAL w_temp 0
  CALL G_UPDATE_PAUSEBAR
  repeat
    WAIT 250
  until (Wait<=0) || (Wait<=init_wait) || (++w_temp>=120)
  RET 1



////////////////////////////////////////////////////////////////////
//
//  Stall until Wait variable is zero, or 30 seconds elapses...
//
:G_WAITZERO
  LOCAL wz_temp 0
  repeat
    WAIT 250
  until (Wait<=0) || (++wz_temp>=120)
  RET 1



////////////////////////////////////////////////////////////////////
//
// Wait up to 30 seconds for event to be completed from queue, 
// keeping an eye out for praise/scolding...
//
:G_WAIT_AWARE
LOCAL wa_temp 0

CALL G_UPDATE_PAUSEBAR
SET praise 0
SET scold 0

DO
  ADD wa_temp 1
  WAIT 250
  CALL G_WAIT_ATTENTION
LOOP:WHILE (Wait>0) && (Wait>init_wait) && (wa_temp<120)

// Clear praise sensors...
IF (praise>0) THEN
  SET Head_ON 0
  SET Back_ON 0
  SET Jaw_ON 0
ENDIF

// Clear scold sensors...
IF (scold>0) THEN
  SET Head_Hit 0
ENDIF

// If voice command used to praise, we've already responded to clear voice command...
IF (praise>=8) || (scold>=8) THEN
  SET AP_Voice_Cmd 0
ENDIF
RET 1



////////////////////////////////////////////////////////////////////
//
//  Someone is goofing with our tail!!! (ERS-210 only obviously)
//
:G_TAIL_TWEAKED
LOCAL tt_temp 0
WAIT 1

IF (Tail_Pan<=15) && (Tail_Pan>=-15) THEN
  RET 1 // nope
ENDIF

WAIT 1
IF (tailwag==0) || (Wait>=4) THEN
  RET 1 // too busy
ENDIF

IF F_RND100() < 33 THEN
  IF mood_happy > 5 THEN	// Tolerate if happy (for a while)...
    SUB mood_happy 2
    RET 2 // praise
  ENDIF

  IF F_RND100() < 50 THEN 	// Ok, enough already.  Aibo getting annoyed...
    RET 3 // scold
  ENDIF

  SET VoiceCmd VOICE_MEOW	// Roar/Meow
  RET 4	// voice
ENDIF

// Flick tail quickly...
WAIT 1
SET tailwag -1
SET init_tailwait Wait
PLAY ACTION TAILWAG_HORZ3
WAIT 1000
PLAY ACTION PALONE.AUTO.TAILSTOP

// Wait for tail flick to finish...
WHILE (Wait>0) && (Wait>init_tailwait) && (tt_temp<120)
  ++tt_temp
  WAIT 250
WEND
RET 1	// none



////////////////////////////////////////////////////////////////////
//
// STOP_HEAD  (Stop head from tracking ball)
//
:G_STOP_HEAD
  LOCAL init_stopwait
  LOCAL sh_temp 0

  WAIT 1
  SET init_stopwait Wait
  PLAY ACTION MOVE.HEAD.FAST Head_Pan Head_Tilt

  // Wait for head movement to stop...
  while (Wait>0) && (Wait>init_stopwait) && (sh_temp<120)
    ++sh_temp
    WAIT 250
  wend
  RET 1



////////////////////////////////////////////////////////////////////
// STOP_HEADTAIL  (Stop head & tail from moving)
:G_STOP_HEADTAIL
  CALL G_STOP_HEAD
  CALL G_STOP_TAILWAG
  RET 1



////////////////////////////////////////////////////////////////////
//
// Function returns absolute value of argument...
//
:F_ABS
  ARG value
  if (value<0) then
    return -value
  else
    return value
  endif



////////////////////////////////////////////////////////////////////
//
// Function returns sign of argument (+1, 0, or -1)...
//
:F_SIGN
  ARG value
  CSET:value < 0:-1
  CSET:value == 0:0
  CSET:value > 0:1
  return Context



////////////////////////////////////////////////////////////////////
//
// Functions to replace Fav_Color & Unfav_Color variables...
//
#ifdef RCODE250
:F_FAVCOLOR
  LOCAL temp
  AP_COLORLVL COLORINDEX_FAV temp
  CSET:temp:<:25:0
  CSET:temp:>=:25:1
  RETURN:Context

:F_UNFAVCOLOR
  LOCAL temp
  AP_COLORLVL COLORINDEX_UNFAV temp
  CSET:temp:<:25:0
  CSET:temp:>=:25:1
  RETURN:Context
#endif



////////////////////////////////////////////////////////////////////
//
// Random number functions, between given parameters.
// Usage: "F_RND(start,end)"
//        "F_RND100()"
:F_RND
  ARG start
  ARG end
  LOCAL f_temp
  RND f_temp start end
  RETURN f_temp

:F_RND100
  LOCAL f_temp
  RND f_temp 0 100
  RETURN f_temp



////////////////////////////////////////////////////////////////////
//
// STAND_UP
//
:G_STAND_UP
  CALL G_VOICE_HIT
  WAIT 1

  if (sitonly>0) then
    RET:GO_IGNORE
  ENDIF

  // If not in sit posture, or tired, or mad, get up slowly...
  if (Posture1 != POSTURE_SIT) || (mood_tired>5) || (mood_mad>2) then
    PLAY ACTION STAND
    CALL G_WAITZERO
    RET:GO_STANDPOS
  endif

  CALL G_RANDOM2
    CASE:1 PLAY ACTION STAND
    CASE:2 PLAY ACTION stand_quick
  CALL G_WAITZERO
  RET:GO_STANDPOS



////////////////////////////////////////////////////////////////////
//
// SIT_DOWN
//
:G_SIT_DOWN
  IF F_RND100() < 50 THEN
    PLAY ACTION SIT
  ELSE
    PLAY ACTION+ sit_quick
  ENDIF
  GO G_WAITZERO



////////////////////////////////////////////////////////////////////
//
// INC_BOYGIRL
//
:G_INC_BOYGIRL
  ADD boygirl 1
  IF boygirl > 3 THEN
    SET boygirl 3
  ENDIF
  RET 1



////////////////////////////////////////////////////////////////////
//
// DEC_BOYGIRL
//
:G_DEC_BOYGIRL
  SUB boygirl 1
  IF boygirl < -3 THEN
    SET boygirl -3
  ENDIF
  RET 1



////////////////////////////////////////////////////////////////////
//
// See the ball?
// Returns:
//   GO_IDLE	Nope
//   GO_IGNORE  Maybe, but ignore
//   GO_SEEBALL Yup
//
:F_SEE_BALL
  WAIT 1
  IF sitonly > 0 THEN	// Ignor ball in sitonly mode
    RETURN:GO_IGNORE
  ENDIF

  IF Pink_Ball == 0 THEN	// Nope
    RETURN:GO_IDLE
  ENDIF

  // If low soccer skill, with little endurance, and no encouragement...
  IF (soccer<25) && (endure<10) && (TIMER_GOFORIT<=0) THEN
    IF (mood_tired<4) && (mood_mad<3) THEN
      CALL G_DEC_SAD_MOOD	// seeing ball makes Aibo happier
      GO F_SEE_TOWER
    ELSE
      RETURN:GO_IGNORE
    ENDIF
  ENDIF

  // If low soccer skill & encouraged, or average soccer skill & not encouraged,
  // more tolerant of tired & bad mood...
  IF ((soccer<25) && (TIMER_GOFORIT>0)) || ((soccer<50) && (TIMER_GOFORIT<=0)) THEN
    IF (mood_tired<6) && (mood_mad<5) THEN
      CALL G_DEC_SAD_MOOD	// seeing ball makes Aibo happier
      GO F_SEE_TOWER
    ELSE
      RETURN:GO_IGNORE
    ENDIF
  ENDIF

  // If average soccer skill & encouraged, or good soccer skill & not encouraged,
  // even more tolerant of tired & bad mood...
  IF ((soccer<50) && (TIMER_GOFORIT>0)) || ((soccer<75) && (TIMER_GOFORIT<=0)) THEN
    IF (mood_tired<8) && (mood_mad<6) THEN
      CALL G_DEC_SAD_MOOD	// seeing ball makes Aibo happier
      GO F_SEE_TOWER
    ELSE
      RETURN:GO_IGNORE
    ENDIF
  ENDIF

  // Good soccer skill & encouraged...
  IF (mood_tired<9) && (mood_mad<8) THEN
    CALL G_DEC_SAD_MOOD	// seeing ball makes Aibo happier
    GO F_SEE_TOWER
  ENDIF

  // If really tired or really mad, ignor ball...
  RETURN:GO_IGNORE



////////////////////////////////////////////////////////////////////
//
// Function to decide if see play-ball or charger tower...
// Returns:
//   GO_IDLE = Can't see ball
//   GO_IGNORE = See tower ball
//   GO_SEEBALL = See play ball
//
#if ERS310
:F_SEE_TOWER
:F_SEETOWER_SLEEPPOS
  RETURN:GO_SEEBALL
#endif

#if ERS210 | ERS220
:F_SEE_TOWER
  LOCAL ball_horz
  LOCAL ball_vert
  WAIT 1

  if (Pink_Ball==0) then // nope
    RETURN:GO_IDLE
  endif

  //
  // If ball is potentially on top of charging tower, ignore it...
  //
  ball_horz := F_ABS(Head_Pan + Pink_Ball_Horz)
  ball_vert := Head_Tilt + Pink_Ball_Vert
  PRINT "Tower Check.  Posture=%d  ball h,v,d=%d,%d,%d" Posture1 ball_horz ball_vert Pink_Ball_Dist
  PRINT "  head_pan=%d  pb_horz=%d  head_tilt=%d  pb_vert=%d" Head_Pan Pink_Ball_Horz Head_Tilt Pink_Ball_Vert
  if (POSE_STANDING()) then
    if (ball_horz<100) && (ball_horz>70) FST_IGNORE
    GO F_SEETOWER_STANDPOS
  endif
  if (POSE_SIT()) then
    if (ball_horz<100) && (ball_horz>70) FST_IGNORE
    GO F_SEETOWER_SITPOS
  endif
  if (POSE_SLEEP()) then
    if (ball_horz<100) && (ball_horz>70) FST_IGNORE
    GO F_SEETOWER_SLEEPPOS
  endif

:FST_SEEBALL
  PRINT "  See Ball"
  RETURN:GO_SEEBALL


:FST_IGNORE
  if (Batt_Rest<BATTLEVEL_SELFCHARGE) then // if hungry then time to go after that charger...
    PRINT "  Hungry - Self Docking"
    RETURN:GO_SEEBALL
  endif
  PRINT "  Ignor Tower"
  RETURN:GO_IGNORE


:F_SEETOWER_STANDPOS
  ball_vert := Head_Tilt + Pink_Ball_Vert
  if (Pink_Ball_Dist>=800) then
    if (ball_vert>=-5) && (ball_vert<=10) FST_IGNORE
  else
    if (Pink_Ball_Dist>=200) then
      if (ball_vert>=-5) && (ball_vert<5) FST_IGNORE
    else
      if (Pink_Ball_Dist>=100) then
        if (ball_vert>=-10) && (ball_vert<2) FST_IGNORE
      else
        if (ball_vert>=-18) && (ball_vert<=-8) FST_IGNORE
      endif
    endif
  endif
  GO FST_SEEBALL


:F_SEETOWER_SITPOS
  if (Pink_Ball_Dist>=400) then
    if (ball_vert>=-35) && (ball_vert<-25) FST_IGNORE
  else
    if (ball_vert>=-40) && (ball_vert<=-30) FST_IGNORE
  endif
  GO FST_SEEBALL


:F_SEETOWER_SLEEPPOS
  if (Pink_Ball_Dist>=800) then
    if (ball_horz>50) then
      if (ball_vert<20) && (ball_vert>5) FST_IGNORE
    else
      if (ball_vert>=-5) && (ball_vert<=15) FST_IGNORE
    endif
    GO FST_SEEBALL
  endif
  if (Pink_Ball_Dist>=600) then
    if (ball_horz>50) then
      if (ball_vert<25) && (ball_vert>8) FST_IGNORE
    else
      if (ball_vert>=-5) && (ball_vert<=15) FST_IGNORE
    endif
    GO FST_SEEBALL
  endif
  if (Pink_Ball_Dist>=400) then
    if (ball_horz>50) then
      if (ball_vert<30) && (ball_vert>10) FST_IGNORE
    else
      if (ball_vert>=0) && (ball_vert<=15) FST_IGNORE
    endif
    GO FST_SEEBALL
  endif
  if (ball_horz>50) then
    if (ball_vert<35) && (ball_vert>15) FST_IGNORE
  else
    if (ball_vert>=5) && (ball_vert<=20) FST_IGNORE
  endif
  GO FST_SEEBALL
#endif



////////////////////////////////////////////////////////////////////
//
//  Increase endurance...
//
:G_INC_ENDURE
IF mood_tired > 5 THEN
  ADD endure 2
  IF endure > 50 THEN
    SET endure 50
  ENDIF
  VSAVE endure
ENDIF
RET 1


////////////////////////////////////////////////////////////////////
//
//  Decrease endurance...
//
:G_DEC_ENDURE
IF mood_tired < 5 THEN
  SUB endure 1
  IF endure < 1 THEN
    SET endure 1
  ENDIF
  VSAVE endure
ENDIF
RET 1


////////////////////////////////////////////////////////////////////
//
//  Shudder with excitement occasionally...
//
:G_SHUDDER
IF (mood_happy>3) && (mood_mad<1) && (F_RND100()<20) THEN
  PLAY ACTION+ shudder
  CALL G_WAITZERO 
  RET 1
ENDIF
RET 2


////////////////////////////////////////////////////////////////////
//
//  Process walk request if in sleep/sit/stand mode...
//
:G_WALK_REQUEST
CALL G_VOICE_HIT

// if really mad throw tantrum...
IF (mood_mad>5) THEN
  CALL G_TANTRUM 
  RET 2 // nowalk
ENDIF

// If not in sit-only mode, think about that walk request a little...
IF sitonly <= 0 THEN
  IF mood_tired <= 4 THEN
    RET 1 // walk
  ENDIF
  IF (mood_tired<9) && (mood_mad<1) THEN
    IF (mood_happy>=3) THEN // increase endurance if asked to walk while happy...
      CALL G_INC_ENDURE
      RET 1 // walk
    ENDIF
    IF (F_RND100()<66) THEN // 66% of time go ahead & walk...
      RET 1 // walk
    ENDIF
  ENDIF
ENDIF

// Don't want to walk...
CALL G_RANDOM2
  CASE:1 PLAY ACTION NO1
  CASE:2 PLAY ACTION NO2
CALL G_WAITZERO
RET 2 // nowalk


////////////////////////////////////////////////////////////////////
//
//  Detect if we must remain in sit or sleep position...
//
:G_CHECK_STAYSIT
IF sitonly > 0 THEN
  CALL G_TWITCH_EARS
  SET init_wait Wait
  RND rndnum 1 4
  SWITCH rndnum
    CASE:1:PLAY:ACTION:NOTHANKS
    CASE:2:PLAY:ACTION:NOT_ME
    CASE:3:PLAY:ACTION:NOWAY1
    CASE:4:PLAY:ACTION:NOWAY2
  CALL G_WAIT
  RET:GO_IGNORE
ENDIF
RET:GO_IDLE


////////////////////////////////////////////////////////////////////
//
//  Detect if we must be in sit or sleep position...
//
:G_CHECK_SITONLY
IF sitonly > 0 THEN
  RND rndnum 0 100
  IF rndnum < 50 THEN
    RET:GO_SITPOS
  ELSE
    RET:GO_DOWNPOS
  ENDIF
ENDIF
RET:GO_IDLE


////////////////////////////////////////////////////////////////////
//
//  Turn on the pause / sit-mode bar as required...
//
:G_UPDATE_PAUSEBAR
SET Warn sitonly
WAIT:32
RET:1


////////////////////////////////////////////////////////////////////
//
//  Include the various primary submodules...
//
#include "RCRLIB.R"	// AiboPet library routines (for YART)
#include "YART.R"	// YART support
#include "Custom.R"	// User customization module
#include "Startup.R" 	// Startup routines
#include "Timers.R"	// Timers
#include "Behavior.R"	// Probability behavior routines
#include "Restmode.R"	// Rest mode
#include "Station.R"	// Charger station mode
#include "Sleep.R"	// Sleep position
#include "ReadBook.R"	// Reading a book
#include "Sit.R"	// Sit position
#include "Stand.R"	// Stand position
#include "Walk.R"	// Walking around
#include "Table.R"	// Table leg investivation
#include "GameSel.R"	// Game Selector
#include "GameRPS.R"	// Rock-Paper-Scissors Game 
#include "GameTTT.R"	// Tic-Tac-Toe Game
#include "GameT4.R"	// Touch4 Game

#ifdef ERS310	
#include "Soccer3.R"	// Soccer (310)
#else
#include "Soccer2.R"	// Soccer (210/220)
#include "SelfDock.R"	// Self Docking
#endif


