
////////////////////////////////////////////////////////////////////
//                                                                //
//  DogsLife Rock-Paper-Scissors Game                             //
//  Copyright (C) 2001-2002 by DogsBody & Ratchet Software        //
//  All Rights Reserved                                           //
//                                                                //
//  This is free software and MAY NOT be sold under any           //
//  circumstances, seperately or bundled.                         //
//                                                                //
////////////////////////////////////////////////////////////////////


//
// Rock-Paper-Scissors Game...
//
:G_RPS_Game
PLAY ACTION+ rps_intro2
CALL G_WAITZERO

CALL G_CLEAR_SENSORS

SET win_count 0
SET tie_count 0
SET lose_count 0
RND limit 3 6
WAIT 500

#ifdef ERS310
  Tail_U_ON := Tail_D_ON := Tail_R_ON := Tail_L_ON := 0
#else
  Back_ON := 0
#endif

:RPS_NEWROUND
SET Head_Hit 0
SET Head_ON 0
SET Jaw_ON 0
PLAY ACTION+ rps_countdown
CALL G_WAITZERO

RND last_rps 0 2
SWITCH last_rps
  CASE:0 PLAY ACTION+ rps_rock
  CASE:1 PLAY ACTION+ rps_paper
  CASE:2 PLAY ACTION+ rps_scissors

SET Head_Hit 0
SET Head_ON 0
SET Jaw_ON 0

CALL G_WAITZERO
RND timeout 20 40	// Wait 2-4 secs...

:RPS_LOOP
CALL G_UPDATE_PAUSEBAR

WAIT 100

#ifdef ERS310
  if (Tail_U_ON || Tail_D_ON || Tail_R_ON || Tail_L_ON) || F_NEED2REST() G_RPS_ENDGAME
  if (Head_Hit>0) RPS_TIE
  if (Head_ON>0) RPS_WIN
#else
  if (Back_ON>0) || F_NEED2REST() G_RPS_ENDGAME
  if (Jaw_ON>0) RPS_TIE
  if (Head_ON>0) RPS_WIN
#endif
if (timeout<0) RPS_LOSE


//
// last_rps = Aibo's pick
//   0 = Rock
//   1 = Paper
//   2 = Scissors
//
if (Pink_Ball>0) then 	// Owner picked Rock
  PRINT "See Rock (Ball)"
  SWITCH (last_rps)
    CASE:0 GO RPS_TIE	// Rock & Rock
    CASE:1 GO RPS_WIN	// Paper wraps Rock
    CASE:2 GO RPS_LOSE	// Rock dulls scissors
endif

if (Fav_Color>0) then 	// Owner picked Paper
  PRINT "See Paper (FavColor)"
  SWITCH (last_rps)
    CASE:0 GO RPS_LOSE	// Paper wraps Rock
    CASE:1 GO RPS_TIE	// Paper & Paper
    CASE:2 GO RPS_WIN	// Scissor cuts paper
endif

if (Unfav_Color>0) then // Owner picked Scissors
  PRINT "See Scissors (UnfavColor)"
  SWITCH (last_rps)
    CASE:0 GO RPS_WIN	// Rock dulls Scissors 
    CASE:1 GO RPS_LOSE	// Scissors cuts paper 
    CASE:2 GO RPS_TIE	// Scissors & Scissors
endif

SUB timeout 1
SET Head_Hit 0
SET Head_ON 0
SET Jaw_ON 0

CALL G_RPS_ATTENTION
  CASE:GO_ENDGAME GO G_RPS_ENDGAME
  CASE:GO_PRAISE CALL G_PRAISE
  CASE:GO_SCOLD CALL G_SCOLD
  CASE:GO_VOICE GO RPS_VOICE
GO RPS_LOOP

:RPS_VOICE
SWITCH VoiceCmd
  CASE:VOICE_STOP GO G_RPS_ENDGAME	// Stop
  CASE:VOICE_FINDBALL GO RPS_DOVOICE	// Find Ball
  CASE:VOICE_KICKBALL GO RPS_DOVOICE	// Kick Ball
  CASE:VOICE2_PINKBALL GO RPS_DOVOICE	// Pink Ball
  CASE:VOICE2_RIGHTKICK GO RPS_DOVOICE	// Right Kick - ZZZ - Should add right kick code
  CASE:VOICE2_LEFTKICK GO RPS_DOVOICE	// Left Kick - ZZZ - Should add left kick code
  CASE:VOICE2_RIGHTTOUCH GO RPS_DOVOICE	// Right Touch - ZZZ - Should add right touch code
  CASE:VOICE2_LEFTTOUCH GO RPS_DOVOICE	// Left Touch - ZZZ - Should add left touch code
  CASE:VOICE_LAYDOWN GO RPS_DOVOICE	// Lie Down / Play Dead
  CASE:VOICE_GOODNIGHT GO RPS_DOVOICE	// Good Night
  CASE:VOICE_GOODBYE GO RPS_DOVOICE	// Goodbye
  CASE:VOICE2_SEEYOU GO RPS_DOVOICE	// See You
  CASE:VOICE2_YOUWON GO RPS_WIN		// Win!
  CASE:VOICE2_YOULOST GO RPS_LOSE	// Lost!
CALL G_WAITZERO
GO RPS_LOOP

:RPS_DOVOICE
SET AP_Voice_Cmd (VoiceCmd-base_voice_cmd) // Make normal loop respond to voice command...
SET AP_Voice_Level MIN_VOICE_LEVEL
GO G_RPS_ENDGAME


// Lost round...
:RPS_LOSE
  CALL G_RPS_LOST_GAME
  SET temp lose_count
  GO RPS_CHECKLIMIT

// Won round!!!
:RPS_WIN
  CALL G_RPS_WON_GAME
  SET temp win_count
  if (win_count>2) then // this is now our favorate game
    behavior[BEHAVIOR_FAV_GAME] := 0
  endif
  GO RPS_CHECKLIMIT

// Got a tie!
:RPS_TIE
  CALL G_RPS_TIE_GAME
  SET temp tie_count

// Had enough yet?
:RPS_CHECKLIMIT	
  IF temp < limit RPS_NEWROUND // nope
  if tie_count>=limit G_RPS_TIE_ENDGAME
  if win_count>lose_count G_RPS_WON_ENDGAME
  GO G_RPS_LOST_ENDGAME




////////////////////////////////////////////////////////////////////
//
//  Reactions to winning, losing or tie...
//
:G_RPS_LOST_GAME
  ADD lose_count 1
  CALL G_DEC_HAPPY_MOOD
  CALL G_INC_MAD_MOOD
  CALL G_RANDOM3
  CASE:1 PLAY ACTION+ rps_lose1
  CASE:2 PLAY ACTION+ rps_lose2
  CASE:3 PLAY ACTION+ rps_lose3
  GO G_WAITZERO


:G_RPS_WON_GAME
  ADD win_count 1
  CALL G_INC_HAPPY_MOOD
  CALL G_DEC_MAD_MOOD
  CALL G_RANDOM3
  CASE:1 PLAY ACTION+ rps_win1
  CASE:2 PLAY ACTION+ rps_win2
  CASE:3 PLAY ACTION+ rps_win3
  GO G_WAITZERO


:G_RPS_TIE_GAME
  ADD tie_count 1
  CALL G_DEC_HAPPY_MOOD
  CALL G_RANDOM3
  CASE:1 PLAY ACTION+ rps_tie1
  CASE:2 PLAY ACTION+ rps_tie2
  CASE:3 PLAY ACTION+ rps_tie3
  GO G_WAITZERO



////////////////////////////////////////////////////////////////////
//
//  Endgame reactions to winning, losing or tie...  These are
//  played when AIBO decides its had enough.
//
:G_RPS_ENDGAME
  PLAY ACTION+ rps_close
  GO G_WAITZERO


:G_RPS_LOST_ENDGAME
  CALL G_RPS_ENDGAME
  RND rndnum 0 2
  SWITCH rndnum
    CASE:0 PLAY ACTION NOT_ME
    CASE:1 PLAY ACTION DONTWANNA1
    CASE:2 PLAY ACTION NOTHANKS
  GO G_WAITZERO


:G_RPS_WON_ENDGAME
  CALL G_RPS_ENDGAME
  RND rndnum 0 2
  SWITCH rndnum
    CASE:0 PLAY ACTION POUNCE1
    CASE:1 PLAY ACTION CUTE_BANZAI1
    CASE:2 PLAY ACTION SALUTE2
  GO G_WAITZERO


:G_RPS_TIE_ENDGAME
  CALL G_RPS_ENDGAME
  RND rndnum 0 2
  SWITCH rndnum
    CASE:0 PLAY ACTION BORED_SIT2
    CASE:1 PLAY ACTION IMPATIENT_SIT1
    CASE:2 PLAY ACTION IMPATIENT_SIT2
  CALL G_WAITZERO
  PLAY ACTION SIT
  GO G_WAITZERO



////////////////////////////////////////////////////////////////////
//
//  Check for user voice input...
//
:G_RPS_ATTENTION
SET pet 0
SET praise 0
SET scold 0
WAIT 1

#ifdef ERS310
  if (Tail_U_ON || Tail_D_ON || Tail_R_ON || Tail_L_ON) || F_NEED2REST() then
    ADD pet 2
    ADD back_count 1
    RET:GO_ENDGAME
  endif
#else
  if (Back_ON>0) || F_NEED2REST() then
    ADD pet 2
    ADD back_count 1
    RET:GO_ENDGAME
  endif
#endif

IF AP_Voice_Cmd != 0 THEN
  CALL G_VOICECMD
    CASE:GO_VOICE GO RPSA_VOICECMD
ENDIF

IF AP_Tone > 0 THEN
  CALL G_TONECMD
    CASE:1 GO RPSA_VOICECMD
ENDIF

RET:GO_IDLE // none
  

:RPSA_VOICECMD
SET back_count 0
WAIT 1

IF VoiceCmd == VOICE_GOODBOT THEN
  IF VoiceDictID >= 149	THEN 	// Good Boy
    IF VoiceDictID <= 150 THEN
      CALL G_INC_BOYGIRL
      RET:GO_PRAISE
    ENDIF
  ENDIF

  IF VoiceDictID >= 151	THEN 	// Good Girl
    IF VoiceDictID <= 154 THEN
      CALL G_DEC_BOYGIRL
      RET:GO_PRAISE
    ENDIF
  ENDIF
ENDIF

IF VoiceCmd == VOICE_BADBOT THEN 
  IF VoiceDictID >= 160 THEN	// Bad Boy
    IF VoiceDictID <= 161 THEN
      CALL G_INC_BOYGIRL
      RET:GO_SCOLD
    ENDIF
  ENDIF

  IF VoiceDictID >= 162 THEN	// Bad Girl
    IF VoiceDictID <= 165 THEN	
      CALL G_DEC_BOYGIRL
      RET:GO_SCOLD
    ENDIF
  ENDIF
ENDIF

IF VoiceCmd == VOICE2_GOODBOY THEN		// Good Boy (voice2)
  CALL G_INC_BOYGIRL
  RET:GO_PRAISE
ENDIF

IF VoiceCmd == VOICE2_GOODGIRL THEN		// Good Girl (voice2)
  CALL G_DEC_BOYGIRL
  RET:GO_PRAISE
ENDIF

IF VoiceCmd == VOICE2_BADBOY THEN		// Bad Boy (voice2)
  CALL G_INC_BOYGIRL
  RET:GO_SCOLD
ENDIF

IF VoiceCmd == VOICE2_BADGIRL THEN		// Bad Girl (voice2)
  CALL G_DEC_BOYGIRL
  RET:GO_SCOLD
ENDIF

IF VoiceCmd == VOICE_GOFORIT THEN	// Go For It
  SET TIMER_GOFORIT 60
  RET:GO_PRAISE
ENDIF

IF VoiceCmd == VOICE_DONTDOTHAT THEN
  RET:GO_SCOLD
ENDIF

IF VoiceCmd == VOICE_TAKEAPICTURE THEN
  IF Posture1 != POSTURE_WALK THEN
    CALL G_TAKE_A_PICTURE
  ENDIF
  RET:GO_IDLE
ENDIF

RET:GO_VOICE


