
///////////////////////////////////////////////////////////
//                                                       //
//  DogsLife Game Selector                               //
//  Copyright (C) 2003 by DogsBody & Ratchet Software    //
//  All Rights Reserved                                  //
//                                                       //
//  This is free software and MAY NOT be sold under any  //
//  circumstances, seperately or bundled.                //
//                                                       //
///////////////////////////////////////////////////////////


//
// Routine for when AIBO allows user to select which game 
// they wish to play.  AIBO waits for 5-10 seconds (less
// time if there is game he/she particularly likes), then
// starts a timeout.  After timeout (a max of 15 seconds), 
// AIBO picks a favorate game, and your off...
//
// User selects game by pressing AIBO's rear paws.  Game 
// starts when user presses head sensor.
//
:G_Select_Game
  CALL G_TWITCH_EARS		// Acknowledge voice command...

  PLAY ACTION game_intro
  CALL G_WAITZERO
  CALL G_CLEAR_SENSORS

  Warn := 0
  Clock := 0
  gs_state := 0			// Indicates if user has made a selection.
  gs_select := 0		// Current game selection.
  gs_update_interval := 32	// One second update interval (initially)
  gs_timeout_count := 42 	// equals 20 seconds => 14(1tick/sec) + 2(2tick/sec) + 2(4tick/sec) + 2(8tick/sec)
  RRLeg_ON := LRLeg_ON := 0

#ifdef ERS310
  Tail_U_ON := Tail_D_ON := Tail_R_ON := Tail_L_ON := 0
#else
  Back_ON := 0
#endif

  CALL G_SG_SETUPEYES

:SG_LOOP
  // User changing the selection?
  WAIT:1
  if (RRLeg_ON>0) || (LRLeg_ON>0) then
    RRLeg_ON := 0
    LRLeg_ON := 0
    gs_state := 1
    if (++gs_select>2) then
      gs_select := 0
    endif
    CALL G_SG_SETUPEYES
  endif

  // User made a decision...
#ifdef ERS310
  if (Head_ON>0) || (Tail_U_ON || Tail_D_ON || Tail_R_ON || Tail_L_ON) SG_GOTGAME
#else
  if (Head_ON>0) || (Back_ON>0) SG_GOTGAME
#endif

  // Has timer expired yet?
  if (Clock>=gs_update_interval) then
    // reset timer...
    Clock := 0

    // Cycle through games while waiting (if user hasent done anything)...
    if (gs_state==0) then
      if (++gs_select>2) then
        gs_select := 0
      endif
      CALL G_SG_SETUPEYES
    endif

    // Tired of waiting for user?
    if (--gs_timeout_count==0) then
      if (gs_state==0) then
        // Which game has AIBO been winning at?  It gets 50% probability.  
        // The other two games get 25% each.
	gs_favgame := behavior[BEHAVIOR_FAV_GAME]

        RND rndnum 0 100
        if (rndnum<50) then
          gs_select := gs_favgame
        else
          gs_select := 1+(gs_favgame!=2) // if favgame==(0 or 1), game 2.  otherwise game 1.
          if (rndnum<75) && (gs_favgame!=0) then
	    gs_select := 0
          endif
        endif
        CALL G_SG_SETUPEYES
      endif

      PLAY ACTION game_timeout
      CALL G_WAITZERO
      GO SG_GOTGAME
    endif

    // start beeping if user taking too long to decide...
    if (gs_timeout_count<=32) && (Wait==0) then
      PLAY ACTION game_beep
    endif

    switch (gs_timeout_count)
      case 28: SET gs_update_interval 16	// Two beeps per second
      case 24: SET gs_update_interval 8		// Four beeps per second
      case 16: SET gs_update_interval 4		// Eight beeps per second
  endif
  GO SG_LOOP


//
// A game selection has been made (either by owner or AIBO)...
//
:SG_GOTGAME
#ifdef ERS310
  if (Tail_U_ON || Tail_D_ON || Tail_R_ON || Tail_L_ON) || F_NEED2REST() then
    gs_select := -1
  endif
  Tail_U_ON := Tail_D_ON := Tail_R_ON := Tail_L_ON := 0
  Horn_O := Horn_G := Horn_B := 0
#else
  if (Back_ON>0) || F_NEED2REST() then // user doesn't want to play a game
    gs_select := -1
  endif
  Head_ON := Back_ON := 0
  Eye_R3 := Eye_L3 := Eye_R2 := Eye_L2 := Eye_R1 := Eye_L1 := 0
#endif

  WAIT:500
  CALL G_WAITZERO

  // Jump to selected game...
  if (gs_select==0) G_RPS_Game
  if (gs_select==1) G_TicTacToe_Game
  if (gs_select==2) G_Touch4_Game

  // If no game selected, quit...
  PLAY ACTION game_quit
  GO G_WAITZERO


//
// Setup eyes to display current game selection...
//
:G_SG_SETUPEYES
#ifdef ERS310
  Horn_O := (gs_select==0)
  Horn_G := (gs_select==1)
  Horn_B := (gs_select==2)
#else
  Eye_R3 := Eye_L3 := (gs_select==0)
  Eye_R2 := Eye_L2 := (gs_select==1)
  Eye_R1 := Eye_L1 := (gs_select==2)
#endif
  WAIT:1
  RET:1

