
///////////////////////////////////////////////////////////
//                                                       //
//  DogsLife Touch-4 Game                                //
//  Copyright (C) 2003 by DogsBody & Ratchet Software    //
//  All Rights Reserved                                  //
//                                                       //
//  This is free software and MAY NOT be sold under any  //
//  circumstances, seperately or bundled.                //
//                                                       //
///////////////////////////////////////////////////////////


//
// Touch-4 Game - A memory exercise similar to the Simon handheld game.
//
// 210/220:  AIBO blinks a pattern on four eye LED's.   You must remember the
// pattern & repeat it on AIBO's four foot pads.
//
// At start of each round AIBO flashes the pattern you must repeat.
// As the game advances AIBO will flash the LED pattern faster & faster.  
// Rounds with 3 lights and increase to 20.
// 
// If you correctly remember all 20 moves you win a little victory
// dance from AIBO.  
//
// AIBO gets happy when you finish a round & shakes his head in dispair when 
// you lose (those silly humans),
//
// Note: Back sensor will end the game at any point.
//
:G_Touch4_Game
  PLAY ACTION t4_intro2
  CALL G_WAITZERO

  // If user gives too many back-to-back attempts, give up...
  SET t4_wrongcount 0
  RND limit 3 6


  //
  // Let user select length of game...  
  //
  :T4_GAMESTART
  CALL G_CLEAR_SENSORS
  SET t4_gamenum 0


  //
  // Start the game!!!
  //
  SWITCH (t4_gamenum)
    case 0 : SET t4_start_moves 3
    case 1 : SET t4_start_moves 6
    case 2 : SET t4_start_moves 10

  SWITCH (t4_gamenum)
    case 0 : SET t4_max_moves 20
    case 1 : SET t4_max_moves 30
    case 2 : SET t4_max_moves 40

  SWITCH (t4_gamenum)
    case 0 : SET t4_speed 0
    case 1 : SET t4_speed 3
    case 2 : SET t4_speed 9

  // Pick first few moves...
  t4_moves := 0
  while (t4_moves<t4_start_moves)
    RND rndnum 1 4
    trackarray[t4_moves++] := rndnum
  wend

:GT4_ROUND
  // See if user wants to quit...
  #ifdef ERS310
    if (Tail_U_ON || Tail_D_ON || Tail_R_ON || Tail_L_ON) || F_NEED2REST() GT4_ENDGAME
  #else
    if (Back_ON>0) || F_NEED2REST() GT4_ENDGAME
  #endif

  // Play the pattern...
  CALL GT4_REVIEWMOVES

  // Now see if user can remember...
  SET t4_matchnum 0
  while ((t4_matchnum>=0) && (t4_matchnum<t4_moves))
    SET t4_usermove 0
    SET timeout 63 // give user two seconds per move

    while ((t4_usermove==0) && ((--timeout)>0))
      WAIT:32

      // User wants to quit game?
      #ifdef ERS310
        if (Tail_U_ON || Tail_D_ON || Tail_R_ON || Tail_L_ON) || F_NEED2REST() GT4_ENDGAME
      #else
        if (Back_ON>0) || F_NEED2REST() GT4_ENDGAME
      #endif

      // Check for voice command...
      CALL G_RPS_ATTENTION
        CASE:GO_ENDGAME GO GT4_ENDGAME
        CASE:GO_PRAISE CALL G_PRAISE
        CASE:GO_SCOLD CALL G_SCOLD

      if (Context==GO_VOICE) then
        SWITCH VoiceCmd
          CASE:VOICE_STOP GO TTT_ENDGAME	// Stop
          CASE:VOICE_FINDBALL GO TTT_DOVOICE	// Find Ball
          CASE:VOICE_KICKBALL GO TTT_DOVOICE	// Kick Ball
          CASE:VOICE2_PINKBALL GO TTT_DOVOICE	// Pink Ball
          CASE:VOICE2_RIGHTKICK GO TTT_DOVOICE	// Right Kick - ZZZ - Should add right kick code
          CASE:VOICE2_LEFTKICK GO TTT_DOVOICE	// Left Kick - ZZZ - Should add left kick code
          CASE:VOICE2_RIGHTTOUCH GO TTT_DOVOICE	// Right Touch - ZZZ - Should add right touch code
          CASE:VOICE2_LEFTTOUCH GO TTT_DOVOICE	// Left Touch - ZZZ - Should add left touch code
          CASE:VOICE_LAYDOWN GO TTT_DOVOICE	// Lie Down / Play Dead
          CASE:VOICE_GOODNIGHT GO TTT_DOVOICE	// Good Night
          CASE:VOICE_GOODBYE GO TTT_DOVOICE	// Goodbye
          CASE:VOICE2_SEEYOU GO TTT_DOVOICE	// See You
      endif

      if (LFLeg_ON>0) then
        LFLeg_ON := 0
        t4_usermove := 1
      endif

      if (LRLeg_ON>0) then
        LRLeg_ON := 0
        t4_usermove := 2
      endif

      if (RFLeg_ON>0) then
        RFLeg_ON := 0
        t4_usermove := 3
      endif

      if (RRLeg_ON>0) then
        RRLeg_ON := 0
        t4_usermove := 4
      endif
    wend

    // User took too long...
    if (timeout<=0) then
      RND rndnum 0 2
      SWITCH (rndnum)
        case 0: PLAY ACTION t4_tooslow0
        case 1: PLAY ACTION t4_tooslow1
        case 2: PLAY ACTION t4_tooslow2
      CALL G_WAITZERO

      t4_wrongcount++
      if (t4_wrongcount>=limit) then
        PLAY ACTION t4_endgame
        CALL G_WAITZERO
        RET:2
      endif
      go T4_GAMESTART
    endif

    // User got it right...
    if (trackarray[t4_matchnum] == t4_usermove) then
      SWITCH (t4_usermove)
        case:1 PLAY ACTION t4_correct_lf // left-front foot
        case:2 PLAY ACTION t4_correct_lr // left-rear foot
        case:3 PLAY ACTION t4_correct_rf // right-front foot
        case:4 PLAY ACTION t4_correct_rr // right-rear foot
      CALL G_WAITZERO

    // User got it wrong... heh heh...
    else 
      rnd rndnum 0 2
      SWITCH (rndnum)
        case 0 : PLAY ACTION t4_wrong0
        case 1 : PLAY ACTION t4_wrong1
        case 2 : PLAY ACTION t4_wrong2
      CALL G_WAITZERO

      t4_wrongcount++
      if (t4_wrongcount>=limit) then
        PLAY ACTION t4_endgame
        CALL G_WAITZERO
        RET:3
      endif
      go T4_GAMESTART
    endif

    t4_matchnum++
  wend

  SET t4_wrongcount 0

  // Has user won game yet?
  RND rndnum 0 2
  if (t4_moves>=t4_max_moves) then // yup
    SWITCH (rndnum)
      case 0 : PLAY ACTION t4_wingame0
      case 1 : PLAY ACTION t4_wingame1
      case 2 : PLAY ACTION t4_wingame2
    CALL G_WAITZERO
    PLAY ACTION t4_endgame
    CALL G_WAITZERO
    RND rndnum 0 2
    SWITCH rndnum
      CASE:0 PLAY ACTION POUNCE1
      CASE:1 PLAY ACTION CUTE_BANZAI1
      CASE:2 PLAY ACTION SALUTE2
    GO G_WAITZERO
  endif

  // Not won game yet (only a round)...  Add another 
  // move & bump up the speed...
  SWITCH (rndnum)
    case 0 : PLAY ACTION t4_winround0
    case 1 : PLAY ACTION t4_winround1
    case 2 : PLAY ACTION t4_winround2
  CALL G_WAITZERO

  RND rndnum 1 4
  trackarray[t4_moves++] := rndnum
  t4_speed++
  GO GT4_ROUND

:GT4_DOVOICE
  PRINT "Quit Touch4.  VoiceCmd=%d" VoiceCmd
  SET AP_Voice_Cmd (VoiceCmd-base_voice_cmd)	// Make normal loop respond to voice command...
  SET AP_Voice_Level MIN_VOICE_LEVEL

:GT4_ENDGAME
  PLAY ACTION t4_endgame
  CALL G_WAITZERO
  RET:1


///////////////////////////////////////////////////////////////////////////
//
//  Pick a random move & display approprate eye...
//
:GT4_REVIEWMOVES
  LOCAL count 0
  LOCAL speed

  while (count<t4_moves)
    #ifdef ERS310
      // User wants to quit?
      if (Tail_U_ON || Tail_D_ON || Tail_R_ON || Tail_L_ON) || F_NEED2REST() then
        RET:1
      endif
      SWITCH (trackarray[count++])
        case:1 SET Horn_B 1 // lower-left  (left-front foot)
        case:2 SET Horn_R 1 // upper-left  (left-rear foot)
        case:2 SET Horn_B 1 // upper-left  (left-rear foot)
        case:3 SET Horn_G 1 // lower-right (right-front foot)
        case:4 SET Horn_O 1 // upper-right (right-rear foot)
    #else
      // User wants to quit?
      if (Back_ON>0) || F_NEED2REST() then
        RET:1
      endif
      SWITCH (trackarray[count++])
        case:1 SET Eye_L1 1 // lower-left  (left-front foot)
        case:2 SET Eye_L3 1 // upper-left  (left-rear foot)
        case:3 SET Eye_R1 1 // lower-right (right-front foot)
        case:4 SET Eye_R3 1 // upper-right (right-rear foot)
    #endif

    PLAY ACTION t4_review // bleep sound
    speed := t4_speed/3

    // Give user time to remember...
    if (speed>6) then
      WAIT:150
    else
      SWITCH (speed)
        case:0 WAIT:800
        case:1 WAIT:700
        case:2 WAIT:600
        case:3 WAIT:500
        case:4 WAIT:400
        case:5 WAIT:300
        case:6 WAIT:200
    endif

    // Turn off eye...
  #ifdef ERS310
    Horn_O := Horn_G := Horn_B := 0
  #else
    Eye_L1 := Eye_L3 := Eye_R1 := Eye_R3 := 0
  #endif

    if (speed>5) then
      WAIT:100
    else
      SWITCH (speed)
        case:0 WAIT:250
        case:1 WAIT:225
        case:2 WAIT:200
        case:3 WAIT:175
        case:4 WAIT:150
        case:5 WAIT:125
    endif
  wend
  RET:1

