
////////////////////////////////////////////////////////////////////
//                                                                //
//  DogsLife Reading Position Behavior Module                     //
//  Copyright (C) 2001-2003 by DogsBody & Ratchet Software        //
//  All Rights Reserved                                           //
//                                                                //
//  This is free software and MAY NOT be sold under any           //
//  circumstances, seperately or bundled.                         //
//                                                                //
////////////////////////////////////////////////////////////////////


//
// Behavior when in sleeppos & reading a book...
//
:G_READBOOK

// Decide how long to read...
RND rb_readtimer 15 45

:RB_STARTBOOK
PLAY ACTION reading_start
CALL G_WAITZERO
Clock := 0

:RB_LOOP
WAIT:1
IF Clock<0 THEN
  SET Clock 0
ENDIF

IF Clock>32 THEN
  Clock := 0
  SUB rb_readtimer 1
  if (rb_readtimer<0) RB_STOPBOOK
  CALL G_RB_PLAYSKIT
ENDIF

// Is the ball visible?
if (F_SEE_BALL()==GO_SEEBALL) RB_SEEBALL

CALL G_RB_ATTENTION
  CASE:GO_PRAISE GO RB_PRAISE
  CASE:GO_SCOLD GO RB_SCOLD
  CASE:GO_VOICE GO RB_VOICE
GO RB_LOOP

:RB_PRAISE
PLAY ACTION reading_stop
CALL G_WAITZERO
CALL G_PRAISE
GO RB_STARTBOOK

:RB_SCOLD
PLAY ACTION reading_stop
CALL G_WAITZERO
CALL G_SCOLD
GO RB_STARTBOOK

:RB_VOICE
SWITCH VoiceCmd
  CASE:VOICE_AIBO GO RB_DOVOICE			// Name
  CASE:VOICE2_HEYAIBO GO RB_DOVOICE		// Hey AIBO
  CASE:VOICE2_HAPPYDAY GO RB_DOVOICE		// Happy Day
  CASE:VOICE2_THANKS GO RB_DOVOICE		// Thanks
  CASE:VOICE_GOFORIT GO RB_DOVOICE		// Go for it
  CASE:VOICE2_CHEERUP GO RB_DOVOICE		// Cheer up
  CASE:VOICE2_READYSETGO GO RB_DOVOICE		// Ready Set Go
  CASE:VOICE_STOP GO RB_STOPBOOK		// Stop
  CASE:VOICE_WALK GO RB_DOVOICE			// Walk
  CASE:VOICE_FINDBALL GO RB_DOVOICE		// Find Ball
  CASE:VOICE_KICKBALL GO RB_DOVOICE		// Kick Ball
  CASE:VOICE2_PINKBALL GO RB_DOVOICE		// Pink Ball
  CASE:VOICE2_RIGHTKICK GO RB_DOVOICE		// Right Kick
  CASE:VOICE2_LEFTKICK GO RB_DOVOICE		// Left Kick
  CASE:VOICE2_RIGHTTOUCH GO RB_DOVOICE		// Right Touch
  CASE:VOICE2_LEFTTOUCH GO RB_DOVOICE		// Left Touch
  CASE:VOICE_LETSDANCE GO RB_DOVOICE		// Dance
  CASE:VOICE2_BANZAI GO RB_DOVOICE		// Banzai
  CASE:VOICE2_SHOWTIME GO RB_DOVOICE		// Show Time
  CASE:VOICE2_SHOWOFF GO RB_DOVOICE		// Show Off
  CASE:VOICE2_SORRY GO RB_DOVOICE		// Sorry
  CASE:VOICE_GOODMORNING GO RB_DOVOICE		// Good Morning
  CASE:VOICE_GOODNIGHT GO RB_DOVOICE		// Good Night
  CASE:VOICE_GOODBYE GO RB_DOVOICE		// Goodbye
  CASE:VOICE2_SEEYOU GO RB_DOVOICE		// See You
  CASE:VOICE_AREYOUOK GO RB_DOVOICE		// Ok?
  CASE:VOICE_AREYOUTIRED GO RB_DOVOICE 		// Tired?
  CASE:VOICE_AREYOUHUNGRY GO RB_DOVOICE		// Hungry?
  CASE:VOICE_LAYDOWN GO RB_DOVOICE		// Lie Down / Play Dead
  CASE:VOICE_SITDOWN GO RB_DOVOICE		// Sit Down
  CASE:VOICE_ROAR GO RB_DOVOICE			// Roar / Roll Over
  CASE:VOICE_IAMHERE GO RB_DOVOICE		// I'm Here
  CASE:VOICE_WHATSYOURNAME GO RB_DOVOICE	// What's your name?
  CASE:VOICE2_WHATSOWNERNAME GO RB_DOVOICE	// What's owners name?
  CASE:VOICE_NAMEREG GO RB_DOVOICE		// Name Registration
  CASE:VOICE2_OWNERREG GO RB_DOVOICE		// Owner Registration
  CASE:VOICE2_ACTION1 GO RB_DOVOICE		// Self Dock ("Action 1")

PLAY ACTION reading_annoyed
WAIT
GO RB_LOOP

:RB_DOVOICE
PLAY ACTION reading_stop
CALL G_WAITZERO
RET:GO_VOICE

:RB_STOPBOOK
PLAY ACTION reading_stop
CALL G_WAITZERO
RET:GO_IDLE

:RB_SEEBALL
PLAY ACTION reading_stop
CALL G_WAITZERO
RET:GO_SEEBALL


//
// Pick a scan-page skit randomly...
//
:G_RB_PLAYSKIT
RND rndnum 1 105
CSET rndnum < 5   1	// 25% chance of page turn
CSET rndnum < 10  2	// 70% chance of scan page (looking over the book)
CSET rndnum < 15  3	// 5% chance of itchy ear
CSET rndnum < 20  4
CSET rndnum < 25  5
CSET rndnum < 48  6
CSET rndnum < 72  7
CSET rndnum < 97  8
CSET rndnum >= 97 9
CASE:1 PLAY ACTION reading_turnpage1
CASE:2 PLAY ACTION reading_turnpage2
CASE:3 PLAY ACTION reading_turnpage3
CASE:4 PLAY ACTION reading_turnpage4
CASE:5 PLAY ACTION reading_turnpage5
CASE:6 PLAY ACTION reading_scanpage
CASE:7 PLAY ACTION reading_scanpage2
CASE:8 PLAY ACTION reading_scanpage3
CASE:9 PLAY ACTION reading_scratch_ear
GO G_WAITZERO


////////////////////////////////////////////////////////////////////
//
//  Check for user voice input...
//
:G_RB_ATTENTION
SET pet 0
SET praise 0
SET scold 0
WAIT 1

IF Back_ON > 0 THEN
  ADD pet 2
  SET Back_ON 0
  ADD back_count 1
  RET:GO_PRAISE
ENDIF

IF AP_Voice_Cmd != 0 THEN
  CALL G_VOICECMD
    CASE:GO_VOICE GO RBA_VOICECMD
ENDIF

IF AP_Tone > 0 THEN
  CALL G_TONECMD
    CASE:1 GO RBA_VOICECMD
ENDIF

RET:GO_IDLE // none
  

:RBA_VOICECMD
SET back_count 0
WAIT 1

IF VoiceCmd == VOICE_GOODBOT THEN
  IF VoiceDictID >= 149	THEN 	// Good Boy
    IF VoiceDictID <= 150 THEN
      CALL G_INC_BOYGIRL
      RET:GO_PRAISE
    ENDIF
  ENDIF

  IF VoiceDictID >= 151	THEN 	// Good Girl
    IF VoiceDictID <= 154 THEN
      CALL G_DEC_BOYGIRL
      RET:GO_PRAISE
    ENDIF
  ENDIF
ENDIF

IF VoiceCmd == VOICE_BADBOT THEN 
  IF VoiceDictID >= 160 THEN	// Bad Boy
    IF VoiceDictID <= 161 THEN
      CALL G_INC_BOYGIRL
      RET:GO_SCOLD
    ENDIF
  ENDIF

  IF VoiceDictID >= 162 THEN	// Bad Girl
    IF VoiceDictID <= 165 THEN	
      CALL G_DEC_BOYGIRL
      RET:GO_SCOLD
    ENDIF
  ENDIF
ENDIF

IF VoiceCmd == VOICE2_GOODBOY THEN		// Good Boy (voice2)
  CALL G_INC_BOYGIRL
  RET:GO_PRAISE
ENDIF

IF VoiceCmd == VOICE2_GOODGIRL THEN		// Good Girl (voice2)
  CALL G_DEC_BOYGIRL
  RET:GO_PRAISE
ENDIF

IF VoiceCmd == VOICE2_BADBOY THEN		// Bad Boy (voice2)
  CALL G_INC_BOYGIRL
  RET:GO_SCOLD
ENDIF

IF VoiceCmd == VOICE2_BADGIRL THEN		// Bad Girl (voice2)
  CALL G_DEC_BOYGIRL
  RET:GO_SCOLD
ENDIF

IF VoiceCmd == VOICE_DONTDOTHAT THEN
  RET:GO_SCOLD
ENDIF

RET:GO_VOICE


