
////////////////////////////////////////////////////////////////////
//                                                                //
//  DogsLife Sit Position Behavior Module                         //
//  Copyright (C) 2001-2002 by DogsBody & Ratchet Software        //
//  All Rights Reserved                                           //
//                                                                //
//  This is free software and MAY NOT be sold under any           //
//  circumstances, seperately or bundled.                         //
//                                                                //
////////////////////////////////////////////////////////////////////


//
//  Behavior when sitting...
//
:G_SITPOS
CALL G_INIT_SITPOS

:SIT_LOOP	// INIT_TIMERS
CALL G_UPDATE_PAUSEBAR
SET Clock 0
RND TIMER_BORED 3 10		// 3 to 10 seconds
RND TIMER_LOOKAROUND 0 2	// 0 to 2 seconds
RND TIMER_REST 5 10		// 5 to 10 seconds
SET tailwag 0
SET tilt Head_Tilt
SET pan Head_Pan

if (mood_happy>3) CALL G_START_TAILWAG_SLOW

:1895	// NEED2REST?
if (F_NEED2REST()) then
  CALL G_STOP_TAILWAG
  RET:GO_RESTPOS
endif

WAIT 50
CALL G_REST_TIMER

// Is the ball visible?
if (F_SEE_BALL()==GO_SEEBALL) SIT_SEEBALL

:SIT_CHECKATTENTION
CALL G_SIT_ATTENTION
  CASE:GO_IDLE     GO 1927
  CASE:GO_PRAISE   GO 1926
  CASE:GO_PETTED   GO 1925 
  CASE:GO_SCOLD    GO 1922 
  CASE:GO_SITPOS   GO 1902
  CASE:GO_RESTPOS  RET GO_RESTPOS
  CASE:GO_DOWNPOS  RET GO_DOWNPOS
  CASE:GO_STANDPOS RET GO_STANDPOS
  CASE:GO_WALK     RET GO_WALK

// Call YART voice command customization routine...
:SIT_PROCESSVOICE
CALL G_YART_VoiceCmd
  CASE:GO_RESTPOS  RET GO_RESTPOS
  CASE:GO_DOWNPOS  RET GO_DOWNPOS
  CASE:GO_STANDPOS RET GO_STANDPOS
  CASE:GO_WALK     RET GO_WALK
  CASE:GO_SITPOS   GO 1902

// Call voice command customization routine...
IF sitonly > 0 THEN
  CALL G_CUSTOM_SIT_VOICECMD
    CASE:GO_DOWNPOS  RET:GO_DOWNPOS
    CASE:GO_STANDPOS GO 1902
    CASE:GO_WALK     GO 1902
    CASE:GO_SEEBALL  GO 1902
    CASE:GO_IGNORE   GO 1902
ELSE
  CALL G_CUSTOM_SIT_VOICECMD
    CASE:GO_DOWNPOS  RET:GO_DOWNPOS
    CASE:GO_STANDPOS RET:GO_STANDPOS
    CASE:GO_WALK     RET:GO_WALK
    CASE:GO_SEEBALL  GO SIT_SEEBALL
    CASE:GO_IGNORE   GO 1902
ENDIF

// If not overridden, do normal voice command processing...
CALL G_SIT_VOICE_HANDLER
  CASE:GO_IGNORE GO 1903
  CASE:GO_WALK RET:GO_WALK
  CASE:GO_DOWNPOS RET:GO_DOWNPOS
  CASE:GO_SEEBALL RET:GO_SEEBALL
  CASE:GO_STANDPOS RET:GO_STANDPOS
  CASE:GO_SITPOS RET:GO_RESTPOS

:1902	// loop
ADD change_thres 2
GO SIT_LOOP

:1903	// NOSE_SENSE?
CALL G_SIT_NOSE_SENSE
CALL G_BORED_TIMER
  CASE:1 GO 1895

// Go process pending voice command...
if (AP_Voice_Cmd!=0) && (AP_Voice_Level>=MIN_VOICE_LEVEL) SIT_CHECKATTENTION

// Should we go walking?  10% of the time, yes (if not too tired)...
RND rndnum 0 100
IF (sitonly == 0) && (rndnum<=10) && (mood_tired<=5) && (bored_count<1) THEN
  RET:GO_WALK
ENDIF

IF rndnum <= 10 THEN
  SET sleepsit 1
  RET:GO_DOWNPOS
ENDIF

IF rndnum < change_thres THEN
  CALL G_SIT_CHANGEPOS
  ADD change_thres 2
  GO SIT_LOOP
ENDIF

IF rndnum < 90 THEN
  RND rndnum 0 100

  // If upset, cry...
  IF (mood_sad>5) && (rndnum<(mood_sad-5)*10) THEN
    CALL:G_SAD
    GO SIT_LOOP
  ENDIF

  // Bored skit?
  IF (rndnum>33) && (bored_count<3) THEN 
    // Process YART sitting position bored behavior...
    CALL G_YART_Bored_Sit
      CASE:GO_RESTPOS RET:GO_RESTPOS
      CASE:GO_DOWNPOS RET:GO_DOWNPOS
      CASE:GO_STANDPOS RET:GO_STANDPOS
      CASE:GO_WALK RET:GO_WALK
      CASE:GO_SITPOS GO SIT_LOOP

    CALL G_SIT_BORED
    CALL G_BEHAVIOR_BORED
    ADD change_thres 2
    GO SIT_LOOP
  ENDIF

  // Happy skit?
  IF (rndnum>66) && (bored_count>=3) && (mood_happy>5) THEN 
    // Process YART sitting position happy behavior...
    CALL G_YART_Happy_Sit
      CASE:GO_RESTPOS RET:GO_RESTPOS
      CASE:GO_DOWNPOS RET:GO_DOWNPOS
      CASE:GO_STANDPOS RET:GO_STANDPOS
      CASE:GO_WALK RET:GO_WALK
      CASE:GO_SITPOS GO SIT_LOOP

    CALL G_SIT_HAPPY
    ADD change_thres 2
    GO SIT_LOOP
  ENDIF

  // Tailsong skit?
  IF (rndnum>66) && (bored_count>=3) && (mood_happy>2) THEN 
    CALL G_SIT_TAILSONG
    ADD change_thres 2
    GO SIT_LOOP
  ENDIF
ENDIF

// Process YART sitting position calm behavior...
CALL G_YART_Calm_Sit
  CASE:GO_RESTPOS RET:GO_RESTPOS
  CASE:GO_DOWNPOS RET:GO_DOWNPOS
  CASE:GO_STANDPOS RET:GO_STANDPOS
  CASE:GO_WALK RET:GO_WALK
  CASE:GO_SITPOS GO SIT_LOOP

CALL G_SIT_CALM
ADD change_thres 2
GO SIT_LOOP

:1922	// SCOLD
CALL G_SCOLD_REST

:1923	// RESET_BORED
RND bored_count 5 10
CALL G_CLEAR_SENSORS
ADD change_thres 2
GO SIT_LOOP

:1925	// SIT_PETTED
CALL G_SIT_PETTED
GO 1923

:1926	// PRAISE
CALL G_PRAISE_REST
GO 1923

:1927	// LOOK_TIMER
CALL G_LOOK_TIMER
GO 1903




//
// Seen the ball.  Standup and look for it...
//
:SIT_SEEBALL
  if (Pink_Ball>0) && (F_RND100()<25) then
    PLAY ACTION TRACK_HEAD PINK_BALL	// lock head onto ball
    WAIT 1000

    SET kick_pan Head_Pan
    SET kick_tilt Head_Tilt
    SET swing_kick 0

    PRINT "SitKick pan/tilt=%d,%d" kick_pan kick_tilt

    if (Head_Tilt<-70) && (Head_Pan<-30) then
      SET swing_kick 200
    endif

    if (Head_Tilt<-70) && (Head_Pan>30) then
      SET swing_kick 201
    endif

    if (Head_Tilt<-65) && (Head_Pan>5) && (Head_Pan<20) then
      SET swing_kick 202
    endif

    if (Head_Tilt<-65) && (Head_Pan<-5) && (Head_Pan>-20) then
      SET swing_kick 203
    endif

    SET init_wait Wait
    SWITCH:swing_kick
      CASE:200 PLAY ACTION kick_sitpos_left
      CASE:201 PLAY ACTION kick_sitpos_right
      CASE:202 PLAY ACTION kick_sitpos_fwdleft
      CASE:203 PLAY ACTION kick_sitpos_fwdright

    if (swing_kick>0) then
      CALL G_WAIT
      CALL G_SOCCER_KICK_MOOD
    endif
  endif

  CALL G_STAND4BALL
    CASE:GO_IDLE RET:GO_STANDPOS
    CASE:GO_RESTPOS RET:GO_RESTPOS
    CASE:GO_SEEBALL RET:GO_SEEBALL

  GO SIT_CHECKATTENTION



////////////////////////////////////////////////////////////////////
// INIT_SITPOS
:G_INIT_SITPOS
WAIT 1
PRINT SITPOS
SET sitstate 0	// 0=pos,1=wide,2=flat
SET change_thres 40	// Change threshold
SET nosecount 0	// # of nose triggers
SET back_count 0	// # b2b back pets
SET init_wait Wait
PLAY ACTION SIT
SET tilt -25
SET pan 0
CALL G_WAIT
CALL G_CLEAR_SENSORS
IF_1ST sleepsit > 0
IF_AND bored_count < 3 1238
IF_1ST sleepsit > 0 1237
RND bored_count 3 10

:1237	// DONE
SET sleepsit 0
RET 1

:1238	// SLEEP2SIT
RND bored_count 3 5
SET sleepsit 0
RET 1


////////////////////////////////////////////////////////////////////
// SIT_ATTENTION
:G_SIT_ATTENTION
CALL G_ATTENTION_HANDLER
  CASE:GO_PRAISE   RET GO_PRAISE
  CASE:GO_PETTED   RET GO_PETTED
  CASE:GO_SCOLD    RET GO_SCOLD
  CASE:GO_VOICE    RET GO_VOICE
  CASE:GO_RESTPOS  RET GO_RESTPOS
  CASE:GO_DOWNPOS  RET GO_DOWNPOS
  CASE:GO_SITPOS   RET GO_SITPOS
  CASE:GO_STANDPOS RET GO_STANDPOS
  CASE:GO_WALK     RET GO_WALK

CALL G_TAIL_TWEAKED
  CASE:2 RET GO_PRAISE
  CASE:3 RET GO_SCOLD
  CASE:4 RET GO_VOICE

IF sitstate != 0 THEN	// Rear feet not on floor
  WAIT 1
  IF RRLeg_3 < 30 THEN
    IF RRLeg_ON > 0 THEN
      ADD pet 32
      SET RRLeg_ON 0
      SET back_count 0
    ENDIF
  ENDIF

  IF LRLeg_3 < 30 THEN
    IF LRLeg_ON > 0 THEN
      ADD pet 64
      SET LRLeg_ON 0
      SET back_count 0
    ENDIF
  ENDIF
ENDIF

if (pet==0) then
  RET GO_IDLE
endif

RET GO_PETTED



////////////////////////////////////////////////////////////////////
// SIT_BORED
:G_SIT_BORED

:1580	// SITSTATE?
IF_1ST sitstate = 0 1589	// SitPos
SET rndbase 1150
SET rndcount 3
SET lastact1 last_boredact
SET lastact2 last_boredact
CALL G_BEHAVIOR_RNDNM
  CASE:1 GO 1588
  CASE:3 RET 1
SWITCH rndnum
  CASE:1150 PLAY ACTION BORED_SIT1
  CASE:1151 PLAY ACTION HOWL_SIT1
  CASE:1152 PLAY ACTION HOWL_SIT2
SET last_boredact rndnum
WAIT
PLAY ACTION SIT
WAIT
SET sitstate 0
RET 1

:1588	// SIT_PICKPOS
CALL G_SIT_PICKPOS
GO 1580

:1589	// SITPOS
SET rndbase 1100
SET rndcount 13
SET lastact1 last_boredact
SET lastact2 last_boredact
CALL G_BEHAVIOR_RNDNM
  CASE:1 GO 1588
  CASE:3 RET 1
IF_1ST rndnum = 1100
IF_AND mood_tired < 9 1605
SWITCH rndnum
  CASE:1101 PLAY ACTION BORED_SIT2
  CASE:1102 PLAY ACTION BORED_SIT3
  CASE:1103 PLAY ACTION BEG_PET1
  CASE:1104 PLAY ACTION IMPATIENT_SIT1
  CASE:1105 PLAY ACTION IMPATIENT_SIT2
  CASE:1106 PLAY ACTION NOBI4
  CASE:1107 PLAY ACTION ANYONE_THERE5
  CASE:1108 PLAY ACTION SIGH
  CASE:1109 PLAY ACTION WANT_ATTENTION_SIT1
  CASE:1110 PLAY ACTION WANT_ATTENTION_SIT2
  CASE:1111 PLAY ACTION COMEON
  CASE:1112 GO SIT_CALL_OWNERNAME

:1594	// WAIT_POS
SET last_boredact rndnum
SET sitstate 0
WAIT
RET 1

:1605	// beg_ball
IF_1ST sitonly > 0 1589	// no begging in sitonly mode
PLAY ACTION BEG_BALL
GO 1594

:SIT_CALL_OWNERNAME
if (F_RND100()<10) G_PLAYBACK_OWNERNAME
RET 1


////////////////////////////////////////////////////////////////////
// SIT_CALM
:G_SIT_CALM

:1608	// SITSTATE?
SWITCH sitstate
  CASE:0 GO 1633	// SitPos
  CASE:1 GO 1620	// SitPos
SET rndbase 1400
SET rndcount 4
SET lastact1 last_calmact
SET lastact2 last_calmact2
CALL G_BEHAVIOR_RNDNM
  CASE:1 GO 1619
  CASE:2 GO 1612
RET 1

:1612	// SELECT_FLAT
SWITCH rndnum
  CASE:1400 PLAY ACTION EXERCISE5
  CASE:1401 PLAY ACTION EXERCISE6
  CASE:1402 PLAY ACTION EXERCISE7
  CASE:1403 PLAY ACTION EXERCISE8
GO 1634

:1619	// SIT_PICKPOS(2)
CALL G_SIT_PICKPOS
GO 1608

:1620	// SITWIDE
SET rndbase 1350
SET rndcount 9
SET lastact1 last_calmact
SET lastact2 last_calmact2
CALL G_BEHAVIOR_RNDNM
  CASE:1 GO 1619
  CASE:3 RET 1

SWITCH rndnum
  CASE:1350 PLAY ACTION LOOKAROUND_SIT1
  CASE:1351 PLAY ACTION STRETCH1
  CASE:1352 PLAY ACTION SCRATCH_LEFTEAR
  CASE:1353 PLAY ACTION STRETCH2
  CASE:1354 PLAY ACTION SCRATCH_RIGHTEAR1
  CASE:1355 PLAY ACTION TAP_RIGHT
  CASE:1356 PLAY ACTION HICCUPS_SIT1
  CASE:1357 PLAY ACTION TAP_LEFT
  CASE:1358 PLAY ACTION HICCUPS_SIT2
GO 1634

:1633	// SITPOS
SET rndbase 1300
SET rndcount 24
SET lastact1 last_calmact
SET lastact2 last_calmact2
CALL G_BEHAVIOR_RNDNM
  CASE:1 GO 1619
  CASE:3 RET 1

SWITCH rndnum
  CASE:1300 PLAY ACTION CLEANPAW
  CASE:1301 PLAY ACTION LOOKBACK1
  CASE:1302 PLAY ACTION LOOKBACK2
  CASE:1303 PLAY ACTION LOOKAROUND_SIT2
  CASE:1304 PLAY ACTION LOOKAROUND_SIT3
  CASE:1305 PLAY ACTION SWATFLY
  CASE:1306 PLAY ACTION SCRATCH_RIGHTEAR2
  CASE:1307 PLAY ACTION SCRATCH_RIGHTEAR3
  CASE:1308 PLAY ACTION SCRATCH_LEFTEAR1
  CASE:1309 PLAY ACTION LOOKUP1
  CASE:1310 PLAY ACTION LOOKUP2
  CASE:1311 PLAY ACTION SCRATCH_MOUTH
  CASE:1312 PLAY ACTION SCRATCH_RIGHTCHEEK
  CASE:1313 PLAY ACTION piano
  CASE:1314 PLAY ACTION beethoven5
  CASE:1315 PLAY ACTION Minuet1b
  CASE:1316 PLAY ACTION scratch_rearend
  CASE:1317 PLAY ACTION scratch_rearend2
  CASE:1318 PLAY ACTION scratch_rearend3
  CASE:1319 PLAY ACTION typing2
  CASE:1320 PLAY ACTION drum_roll
  CASE:1321 GO 1639 // tea
  CASE:1322 GO 1638 // typing
  CASE:1323 GO 1637 // driving

:1634
WAIT
SET last_calmact2 last_calmact
SET last_calmact rndnum
RET 1

:1637
IF_1ST Batt_Rest < 50 1633
PLAY ACTION driving0
WAIT
PLAY ACTION driving1
GO 1634

:1638	// TYPING
PLAY ACTION typing
WAIT
PLAY ACTION sigh
WAIT
if (F_RND100()>50) then
  PLAY ACTION+ answer_phone
else
  PLAY ACTION+ answer_phone2
endif
GO 1634

:1639
PLAY ACTION tea_buttonclick
WAIT
PLAY ACTION tea_cupsaucer
WAIT
PLAY ACTION tea_kettlewhistle
WAIT
PLAY ACTION tea_pour
WAIT
PLAY ACTION tea_stirring_cup
WAIT
PLAY ACTION tea_slurp
GO 1634



////////////////////////////////////////////////////////////////////
// SIT_SHOWTIME  (Do a little show of some of the fun skits)
:G_SIT_SHOWTIME

SET rndbase 2000
SET rndcount 18
CALL G_BEHAVIOR_RNDNM
  CASE:1 RET 1
  CASE:3 RET 1

SWITCH rndnum
  CASE:2000 PLAY ACTION piano
  CASE:2001 PLAY ACTION beethoven5
  CASE:2002 PLAY ACTION scratch_rearend
  CASE:2003 PLAY ACTION typing2
  CASE:2004 PLAY ACTION DANCE_SIT1
  CASE:2005 PLAY ACTION DANCE_SIT2
  CASE:2006 PLAY ACTION DANCE_SIT3
  CASE:2007 PLAY ACTION DANCE_SIT4
  CASE:2008 PLAY ACTION DANCE_SIT5
  CASE:2009 PLAY ACTION DANCE_SIT6
  CASE:2010 PLAY ACTION KARATE1
  CASE:2011 PLAY ACTION KARATE2
  CASE:2012 PLAY ACTION KARATE3
  CASE:2013 PLAY ACTION squeaky_trumpet
  CASE:2014 PLAY ACTION addams_family
  CASE:2015 PLAY ACTION Minuet1b
  CASE:2016 GO SIT_SHOWTIME_DRIVE
  CASE:2017 GO SIT_SHOWTIME_TYPING
WAIT
RET 1

:SIT_SHOWTIME_DRIVE
IF_1ST Batt_Rest < 50 G_SIT_SHOWTIME
PLAY ACTION+ driving0
WAIT
PLAY ACTION+ driving1
WAIT
RET 1

:SIT_SHOWTIME_TYPING
PLAY ACTION+ typing
WAIT
PLAY ACTION+ sigh
WAIT
if (F_RND100()>50) then
  PLAY ACTION+ answer_phone
else
  PLAY ACTION+ answer_phone2
endif
WAIT
RET 1



////////////////////////////////////////////////////////////////////
// SIT_CHANGEPOS  (Change into new sitting leg position)
:G_SIT_CHANGEPOS
CALL G_SIT_PICKPOS
SWITCH sitstate
  CASE:0 PLAY ACTION SIT
  CASE:1 PLAY ACTION SITWIDE
  CASE:ELSE PLAY ACTION SITFLAT
SET change_thres 15
WAIT
CALL G_CLEAR_SENSORS
RET 1


////////////////////////////////////////////////////////////////////
//
//  Do a dance while sitting...
//
:G_SIT_DANCE

// If not in normal sit position...
IF sitstate > 0 THEN
  SET rndbase 1550
  SET rndcount 4
  SET lastact1 last_danceact
  SET lastact2 last_danceact
  CALL G_BEHAVIOR_RNDNM
    CASE:1 GO 1674
    CASE:3 RET 1
  SWITCH rndnum
    CASE:1550 PLAY ACTION DANCE_SIT7 
    CASE:1551 PLAY ACTION DANCE_SIT8
    CASE:1552 PLAY ACTION DANCE_SIT9
    CASE:1553 PLAY ACTION DANCE_SIT10
  SET last_danceact rndnum
  WAIT
  RET 1
ENDIF

// Normal sit position dance code...
SET rndbase 1500
SET rndcount 7
SET lastact1 last_danceact
SET lastact2 last_danceact
CALL G_BEHAVIOR_RNDNM
  CASE:1 GO 1674
  CASE:3 RET 1
SWITCH rndnum
  CASE:1500 PLAY ACTION DANCE_SIT1
  CASE:1501 PLAY ACTION DANCE_SIT2
  CASE:1502 PLAY ACTION DANCE_SIT3
  CASE:1503 PLAY ACTION DANCE_SIT4
  CASE:1504 PLAY ACTION DANCE_SIT5
  CASE:1505 PLAY ACTION DANCE_SIT6
  CASE:1506 PLAY ACTION addams_family
SET last_danceact rndnum
WAIT
RET 1

:1674	// SIT_PICKPOS
CALL G_SIT_PICKPOS
GO G_SIT_DANCE



////////////////////////////////////////////////////////////////////
//
//  Do something happy while sitting...
//
:G_SIT_HAPPY
  if sitstate == 0 then // normal sit position
    SET rndbase 1200
    SET rndcount 14
  else 			// not normal sit position (sitwide or sitflat)...
    SET rndbase 1250
    SET rndcount 7
  endif

  SET lastact1 last_happyact
  SET lastact2 last_happyact
  CALL G_BEHAVIOR_RNDNM
    CASE:1 GO SH_PICKPOS // nothing found
    CASE:3 RET 1

  // Boy boys don't like doing certain things...
  IF (BOYBOT && ((rndnum==1201) || (rndnum==1202))) G_SIT_HAPPY

  SWITCH rndnum
    CASE:1200 GO SH_DIALPHONE
    CASE:1201 PLAY ACTION KISS1
    CASE:1202 PLAY ACTION KISS2
    CASE:1203 PLAY ACTION DANCE_SIT1
    CASE:1204 PLAY ACTION DANCE_SIT2
    CASE:1205 PLAY ACTION DANCE_SIT3
    CASE:1206 PLAY ACTION DANCE_SIT4
    CASE:1207 PLAY ACTION DANCE_SIT5
    CASE:1208 PLAY ACTION DANCE_SIT6
    CASE:1209 PLAY ACTION DRUMS_SONG
    CASE:1210 PLAY ACTION LETSPLAY3
    CASE:1211 PLAY ACTION LETSPLAY4
    CASE:1212 PLAY ACTION LETSPLAY5
    CASE:1213 PLAY ACTION LETSPLAY6

    CASE:1250 PLAY ACTION CUTE_JOY1
    CASE:1251 PLAY ACTION CUTE_JOY2
    CASE:1252 PLAY ACTION DANCE_SIT7
    CASE:1253 PLAY ACTION DANCE_SIT8
    CASE:1254 PLAY ACTION DANCE_SIT9
    CASE:1255 PLAY ACTION DANCE_SIT10
    CASE:1256 PLAY ACTION DANCE_SIT11

:SH_WAIT4ACT
  SET last_happyact rndnum
  CALL G_WAITZERO 
  RET 1

:SH_DIALPHONE
  PLAY ACTION+ dial_phone
  CALL G_WAITZERO 
  PLAY ACTION+ dial_phone2
  GO SH_WAIT4ACT

:SH_PICKPOS
  CALL G_SIT_PICKPOS
  GO G_SIT_HAPPY



////////////////////////////////////////////////////////////////////
// SIT_NOSE_SENSE
:G_SIT_NOSE_SENSE
  WAIT 1

  // If hand near nose, then 1/3 of time (if totally idle, or idle with tailwag)...
  RND rndnum 1 100
  if (Distance<200) && (Head_Tilt>-45) && (nosecount<3) && (rndnum<33) then
    if ((Wait==0) || ((Wait==1) && (tailwag>0))) then
      nosecount++

      init_wait := Wait
      if (rndnum<8) then
        PLAY ACTION sniff_once
        CALL G_WAIT
      else
        if (rndnum<16) then
          PLAY ACTION sniff_twice
          CALL G_WAIT
        else
          CALL G_SIT_SHAKEHANDS
        endif
      endif
    endif
  endif
  RET 1



////////////////////////////////////////////////////////////////////
// SIT_PETTED
:G_SIT_PETTED
CALL G_RANDOM3
  CASE:1 GO 1784
  CASE:2 GO 1779

:1751	// LOTS_BACK_PET?
IF_1ST back_count > 4 1776

:1752	// RNDNUM
RND rndnum 0 16
WAIT 1
SET init_wait Wait
IF_1ST rndnum = last_petsong 1752
SWITCH rndnum
  CASE:0 PLAY ACTION BEEN_PETTED1
  CASE:1 PLAY ACTION BEEN_PETTED8
  CASE:2 PLAY ACTION BEEN_PETTED2
  CASE:3 PLAY ACTION BEEN_PETTED9
  CASE:4 PLAY ACTION BEEN_PETTED3
  CASE:5 PLAY ACTION BEEN_PETTED10
  CASE:6 PLAY ACTION BEEN_PETTED4
  CASE:7 PLAY ACTION BEEN_PETTED11
  CASE:8 PLAY ACTION BEEN_PETTED5
  CASE:9 PLAY ACTION BEEN_PETTED12
  CASE:10 PLAY ACTION BEEN_PETTED6
  CASE:11 PLAY ACTION BEEN_PETTED13
  CASE:12 PLAY ACTION BEEN_PETTED7
  CASE:13 PLAY ACTION BEEN_PETTED14
  CASE:14 PLAY ACTION BEEN_PETTED18
  CASE:15 PLAY ACTION BEEN_PETTED19
  CASE:16 PLAY ACTION BEEN_PETTED20
SET last_petsong rndnum
CALL G_WAIT

:1758	// INC_HAPPY_MOOD
CALL G_INC_HAPPY_MOOD
CALL G_DEC_MAD_MOOD
CALL G_DEC_SAD_MOOD
RET 1

:1776	// petkick
WAIT 1
SET init_wait Wait
RND rndnum 0 1
SWITCH rndnum 
  CASE 0 : PLAY ACTION+ petting_kick_sit_left
  CASE 1 : PLAY ACTION+ petting_kick_sit_right
SET sleepstate 0
SET last_petsong 999
CALL G_WAIT
SET Back_ON 0
GO 1758

:1779	// petted2
WAIT 1
SET init_wait Wait
PLAY ACTION TUNE_PETTED2

:1780	// WAIT
CALL G_WAIT
IF_1ST mood_happy > 4 1783
CALL G_RANDOM1/3
  CASE:1 GO 1751
GO 1758

:1783	// RANDOM(1)
CALL G_RANDOM1/3
  CASE:1 GO 1758
GO 1751

:1784	// petted1
WAIT 1
SET init_wait Wait
PLAY ACTION TUNE_PETTED1
GO 1780



////////////////////////////////////////////////////////////////////
// SIT_PICKPOS
:G_SIT_PICKPOS

:1787	// NEW_STATE
RND rndnum 0 2
IF_1ST rndnum = sleepstate 1787
SET sitstate rndnum
RET 1



////////////////////////////////////////////////////////////////////
// SIT_POSE
:G_SIT_POSE
CALL G_VOICE_HIT

IF_1ST sitstate <> 1 1804 // Nope
CALL G_RANDOM1/3
  CASE:1 GO 1804

// Poses when in SITWIDE position...
SET rndbase 1050
SET rndcount 3
if (F_BEHAVIOR_RNDN()) then
  WAIT 1
  SET init_wait Wait
  SWITCH rndnum
    CASE:1050 PLAY ACTION POSE_SIT1
    CASE:1051 PLAY ACTION POSE_SIT2
    CASE:1052 PLAY ACTION POSE_SIT3
  CALL G_WAIT
  SET last_poseact rndnum
  SET sitstate 1
endif
RET 1

:1804	// SITPOS

// Poses when sitting straight...
SET rndbase 1000
SET rndcount 5
if (F_BEHAVIOR_RNDN()) then
  WAIT 1
  SET init_wait Wait
  SWITCH rndnum
    CASE:1000 PLAY ACTION POSE_ATLAS
    CASE:1001 PLAY ACTION POSE_MUSCLE
    CASE:1002 PLAY ACTION POSE_SUPERMAN
    CASE:1003 PLAY ACTION POSE_TAPAIR
    CASE:1004 GO G_SIT_HEADSTAND
  CALL G_WAIT
  SET last_poseact rndnum
  SET sitstate 0
endif
RET 1

:G_SIT_HEADSTAND
SET:NoFallDown:1
PLAY ACTION headstand_sit
CALL G_WAIT
SET:NoFallDown:0
SET last_poseact rndnum
SET sitstate 0
RET 1



////////////////////////////////////////////////////////////////////
// SIT_SHAKEHANDS
:G_SIT_SHAKEHANDS
WAIT 1
SET init_wait Wait
CALL G_RANDOM4
  CASE:1 PLAY ACTION SHAKERIGHT3
  CASE:1 SET last_shakehand 0
  CASE:2 PLAY ACTION SHAKERIGHT4
  CASE:2 SET last_shakehand 0
  CASE:3 PLAY ACTION SHAKELEFT3
  CASE:3 SET last_shakehand 1
  CASE:4 PLAY ACTION SHAKELEFT4
  CASE:4 SET last_shakehand 1

:G_WAITFOR_HANDSHAKE
CALL G_WAIT

SET timetrack Sec
RND maxtime 2 4	// Time to wait with paw extended (2 to 4 seconds)
SET RFLeg_ON 0
SET LFLeg_ON 0

WHILE maxtime>=0 
  WAIT 1

  // Hand shaken!  :-)
  IF ((RFLeg_ON>0) && (last_shakehand==0)) || ((LFLeg_ON>0) && (last_shakehand==1)) THEN
    CALL G_PRAISE
    PLAY ACTION SIT
    CALL G_WAIT
    RET 1
  ENDIF

  SET newtime Sec
  IF (newtime != timetrack) THEN
    SET timetrack newtime
    SUB maxtime 1
  ENDIF
WEND

// Hand not shaken... :-(
PLAY ACTION SIT
CALL G_SAD
CALL G_INC_SAD_MOOD
CALL G_DEC_HAPPY_MOOD
RET 1


:G_SIT_OTHERHAND
WAIT 1
SET init_wait Wait
IF last_shakehand > 0 THEN
  SET last_shakehand 0
  CALL G_RANDOM2
    CASE:1 PLAY ACTION SHAKERIGHT3
    CASE:2 PLAY ACTION SHAKERIGHT4
ELSE
  SET last_shakehand 1
  CALL G_RANDOM2
    CASE:1 PLAY ACTION SHAKELEFT3
    CASE:2 PLAY ACTION SHAKELEFT4
ENDIF
GO G_WAITFOR_HANDSHAKE



////////////////////////////////////////////////////////////////////
// SIT_TAILSONG
:G_SIT_TAILSONG
SET rndbase 1450
SET rndcount 3
if (F_BEHAVIOR_RNDN()) then
  SWITCH rndnum
    CASE:1450 PLAY ACTION TAILWAG_SONG7
    CASE:1451 PLAY ACTION TAILWAG_SONG8
    CASE:1452 PLAY ACTION TAILWAG_SONG9
  CALL G_WAITZERO
endif
RET 1



////////////////////////////////////////////////////////////////////
// SIT_VOICE_HANDLER  (Voice Processing when sitting down)
:G_SIT_VOICE_HANDLER
CALL G_STOP_HEAD

SWITCH VoiceCmd
  CASE:HEARD_RHYTHM GO 1860		 // Heard Rhythm
  CASE:VOICE_WALK GO SVH_WALK_REQUEST	 // Walk
  CASE:VOICE_FINDBALL GO SVH_FINDBALL	 // Find Ball
  CASE:VOICE_KICKBALL GO SVH_FINDBALL	 // Kick Ball
  CASE:VOICE2_PINKBALL GO SVH_FINDBALL	 // Pink Ball
  CASE:VOICE2_RIGHTKICK GO SVH_FINDBALL	 // Right Kick - ZZZ - Should add right kick code
  CASE:VOICE2_LEFTKICK GO SVH_FINDBALL	 // Left Kick - ZZZ - Should add left kick code
  CASE:VOICE2_RIGHTTOUCH GO SVH_FINDBALL // Right Touch - ZZZ - Should add right touch code
  CASE:VOICE2_LEFTTOUCH GO SVH_FINDBALL	 // Left Touch - ZZZ - Should add left touch code
  CASE:VOICE_AREYOUHUNGRY GO 1870	 // Hungry?
  CASE:VOICE_LETSDANCE GO 1868		 // Dance
  CASE:VOICE2_SHOWTIME GO 1869		 // Show Time
  CASE:VOICE2_SHOWOFF GO 1869		 // Show Off
  CASE:VOICE_AREYOUOK GO 1867		 // Are you ok?
  CASE:VOICE2_HOWAREYOU GO 1867		 // How are you?
  CASE:VOICE_GOODNIGHT GO 1866		 // Good Night
  CASE:VOICE_GOODBYE GO 1866		 // Goodbye
  CASE:VOICE2_SEEYOU GO 1866		 // See you
  CASE:VOICE_AIBO GO 1866		 // AIBO
  CASE:VOICE2_HEYAIBO GO 1866		 // Hey AIBO
  CASE:VOICE_GOODMORNING GO 1866	 // Good Morning
  CASE:VOICE_HELLO GO 1866		 // Hello
  CASE:VOICE2_THANKS GO 1866		 // Thanks
  CASE:VOICE2_HAPPYDAY GO 1866		 // Happy Day
  CASE:VOICE_SAYHELLO GO 1866		 // Say Hello
  CASE:VOICE_SITDOWN GO 1865		 // Sit down
  CASE:VOICE_KARATECHOP GO 1864		 // Karate Chop
  CASE:VOICE2_BANZAI GO 1864		 // Banzai
  CASE:VOICE_POSE GO 1863		 // Pose
  CASE:VOICE2_CLOWNAROUND GO 1863	 // Clown around
  CASE:VOICE_AREYOUTIRED GO 1862	 // Tired?
  CASE:VOICE_LETSPLAY GO 1861		 // Let's Play
  CASE:VOICE_SHAKEPAW GO 1858		 // Shake
  CASE:VOICE_SHAKE GO 1858		 // Shake
  CASE:VOICE_OTHERPAW GO 1856		 // Other Paw
  CASE:VOICE_ROAR GO 1855		 // Roar
  CASE:VOICE_MEOW GO 1855		 // Meow
  CASE:VOICE2_SINGSONG GO 1855		 // Sing Song
  CASE:VOICE_TURNLEFT GO 1854		 // Left
  CASE:VOICE_GOFORWARD GO 1853		 // Forward
  CASE:VOICE2_GOAHEAD GO 1853		 // Go Ahead
  CASE:VOICE_TURNRIGHT GO 1852		 // Right
  CASE:VOICE_GOBACK GO 1851		 // Back
  CASE:VOICE_GETUP GO 1850		 // Get Up
  CASE:VOICE_STANDUP GO 1850		 // Stand Up
  CASE:VOICE_LAYDOWN GO 1848		 // Lay Down
  CASE:VOICE_WHATSYOURNAME GO 1871	 // What's your name?
  CASE:VOICE2_WHATSOWNERNAME GO 1872	 // What's owners name?
  CASE:VOICE_NAMEREG GO 1873		 // Name Registration
  CASE:VOICE2_OWNERREG GO 1874		 // Owner Registration
#if ERS210 || ERS220
  CASE:VOICE2_ACTION1 GO 1875		 // Self Dock ("Action 1")
#endif
RET GO_IGNORE

:1848	// LAY_DOWN
CALL G_VOICE_HIT
PLAY ACTION LIE
WAIT
RET GO_DOWNPOS

:1850	// STAND_UP
CALL G_CHECK_STAYSIT
  CASE:GO_IGNORE RET GO_SITPOS
CALL G_STAND_UP
RET GO_STANDPOS

:1851	// BACK
CALL G_CHECK_STAYSIT
  CASE:GO_IGNORE RET GO_SITPOS
CALL G_GO_BACK
RET GO_STANDPOS

:1852	// RIGHT
CALL G_LAZY_GORIGHT
  CASE:1 RET GO_SITPOS
RET GO_STANDPOS

:1853	// FWD
CALL G_CHECK_STAYSIT
  CASE:GO_IGNORE RET GO_SITPOS
CALL G_GO_FORWARD
RET GO_STANDPOS

:1854	// LEFT
CALL G_LAZY_GOLEFT
  CASE:1 RET GO_SITPOS
RET GO_STANDPOS

:1855	// BARK
CALL G_CHECK_STAYSIT
  CASE:GO_IGNORE RET GO_SITPOS
CALL G_STAND_BARK
RET GO_STANDPOS

:1856	// OTHERPAW_CMD
CALL G_VOICE_HIT
CALL G_SIT_OTHERHAND
RET GO_SITPOS

:1858	// SHAKEPAW_CMD
CALL G_VOICE_HIT
CALL G_SIT_SHAKEHANDS
RET GO_SITPOS

:1860	// SIT_RHYTHM
CALL G_SIT_RHYTHM
RET GO_SITPOS

:1861	// Game Time
CALL G_Select_Game
RET GO_SITPOS

:1862	// ARE_YOU_TIRED?
CALL G_QUERY_TIRED
RET GO_SITPOS

:1863	// SIT_POSE
CALL G_SIT_POSE
RET GO_SITPOS

:1864	// KARATE_CHOP
CALL G_KARATE_CHOP
RET GO_SITPOS

:1865	// SIT_HUH?
CALL G_SIT_HUH
RET GO_SITPOS

:1866	// SIT_GREET
CALL G_SIT_GREET
RET GO_SITPOS

:1867	// ARE_YOU_OK?
CALL G_QUERY_MOOD
RET GO_SITPOS

:1868	// LETS_DANCE
CALL G_VOICE_HIT
CALL G_SIT_DANCE
RET GO_SITPOS

:1869   // SHOW_TIME
CALL G_VOICE_HIT
CALL G_SIT_SHOWTIME
RET GO_SITPOS

:1870	// HUNGRY?
CALL G_QUERY_HUNGRY
RET GO_SITPOS

:1871   // What's your name?
CALL G_PLAYBACK_AIBONAME
RET GO_SITPOS

:1872   // What's owner name?
CALL G_PLAYBACK_OWNERNAME
RET GO_SITPOS

:1873	// Name Registration
CALL G_NAME_REGISTRATION
RET GO_SITPOS

:1874	// Owner Registration
CALL G_OWNER_REGISTRATION
if (POSE_SIT()) then 
  RET GO_SITPOS
endif
RET GO_DOWNPOS

#if ERS210 || ERS220
:1875   // Self Dock
CALL G_SELFDOCK
RET GO_STANDPOS
#endif



:SVH_FINDBALL
  CALL G_VOICE_HIT

  // If too tired, cranky, or in sitonly mode, look at ball but otherwise ignore it...
  if (mood_tired>=9) || (mood_mad>5) || (sitonly>0) THEN
    CALL G_SOCCER_LOOK4BALL
    RET GO_SITPOS
  ENDIF

  // search for ball
  CALL G_SOCCER_SEARCH4BALL
    CASE:1 RET GO_RESTPOS
    CASE:3 GO SVH_FINDBALL_FAILED

  // If saw ball, but too tired...
  if (mood_tired >= 7) then
    GO SVH_FINDBALL_FAILED
  endif

  // If saw ball and now standing...
  if (searchmove <> 0) then
    RET GO_SEEBALL
  endif
  
  // Saw ball and still sitting.  Stand up and reaquire the ball...
  SET tilt Head_Tilt
  SET pan Head_Pan
  SET init_wait Wait
  PLAY ACTION STAND
  CALL G_WAIT_AWARE
  PLAY ACTION MOVE.HEAD.FAST pan tilt
  CALL G_WAIT_AWARE

  if Pink_Ball <> 0 then
    RET GO_SEEBALL
  endif

  CALL G_SOCCER_SEARCH4BALL
    CASE:1 RET GO_RESTPOS
    CASE:2 RET GO_SEEBALL
  RET GO_SITPOS

:SVH_FINDBALL_FAILED
  if (!POSE_SIT()) CALL G_SIT_DOWN
  RET GO_SITPOS


:SVH_WALK_REQUEST
  CALL G_WALK_REQUEST
    CASE:1 RET GO_WALK	// walk
  RET GO_SITPOS



////////////////////////////////////////////////////////////////////
// SIT_GREET
:G_SIT_GREET
  WAIT 1
  SET sitstate 0
  SET init_wait Wait
  RND rndnum 0 19
  SWITCH rndnum
    CASE:0 PLAY ACTION WINK_LEFT1
    CASE:1 PLAY ACTION WINK_LEFT2
    CASE:2 PLAY ACTION WINK_RIGHT1
    CASE:3 PLAY ACTION WINK_RIGHT2
    CASE:4 PLAY ACTION WAVE_RIGHT_SIT1
    CASE:5 PLAY ACTION WAVE_RIGHT_SIT2
    CASE:6 PLAY ACTION WAVE_RIGHT_SIT3
    CASE:7 PLAY ACTION WAVE_RIGHT_SIT5
    CASE:8 PLAY ACTION WAVE_RIGHT_SIT6
    CASE:9 PLAY ACTION WAVE_LEFT_SIT9
    CASE:10 PLAY ACTION WAVE_LEFT_SIT10
    CASE:11 PLAY ACTION WAVE_LEFT_SIT1
    CASE:12 PLAY ACTION WAVE_LEFT_SIT2
    CASE:13 PLAY ACTION WAVE_LEFT_SIT4
    CASE:14 PLAY ACTION WAVE_LEFT_SIT3
    CASE:15 PLAY ACTION WAVE_LEFT_SIT5
    CASE:16 PLAY ACTION WAVE_LEFT_SIT6
    CASE:17 PLAY ACTION WAVE_RIGHT_SIT4
    CASE:17 SET sitstate 1
    CASE:18 PLAY ACTION WAVE_LEFT_SIT7
    CASE:18 SET sitstate 1
    CASE:19 PLAY ACTION WAVE_LEFT_SIT8
    CASE:19 SET sitstate 1
  GO G_WAIT_AWARE



////////////////////////////////////////////////////////////////////
// SIT_HUH
:G_SIT_HUH
  CALL G_VOICE_HIT
  RND rndnum 1 6
  if (rndnum<5) then
    SET sitstate 0
  endif

  SWITCH rndnum
    CASE:1 PLAY ACTION HUH_SIT1
    CASE:2 PLAY ACTION HUH_SIT2
    CASE:3 PLAY ACTION HUH_SIT3
    CASE:4 PLAY ACTION HUH_SIT4
    CASE:5 PLAY ACTION HUH_LEFT
    CASE:6 PLAY ACTION HUH_RIGHT
  GO G_WAITZERO



////////////////////////////////////////////////////////////////////
// SIT_RHYTHM
:G_SIT_RHYTHM
  SET rndbase 1900
  SET rndcount 7
  CALL G_BEHAVIOR_RNDNM
    CASE:3 RET 1	// no valid number available

  SWITCH rndnum
    CASE:1900 PLAY ACTION+ dancestep_aibosit_beat
    CASE:1901 PLAY ACTION+ dancestep_aibosit1
    CASE:1902 PLAY ACTION+ dancestep_aibosit2
    CASE:1903 PLAY ACTION+ dancestep_aibosit3
    CASE:1904 PLAY ACTION+ dancestep_sit_conduct1
    CASE:1905 PLAY ACTION+ dancestep_sit_conduct2
    CASE:1906 PLAY ACTION+ dancestep_sit_piano
  GO G_WAITZERO


