
////////////////////////////////////////////////////////////////////
//                                                                //
//  DogsLife Sleep Position Behavior Module                       //
//  Copyright (C) 2001-2003 by DogsBody & Ratchet Software        //
//  All Rights Reserved                                           //
//                                                                //
//  This is free software and MAY NOT be sold under any           //
//  circumstances, seperately or bundled.                         //
//                                                                //
////////////////////////////////////////////////////////////////////


//
//  Behavior when laying down...
//
:G_SLEEPPOS
CALL G_INIT_SLEEPPOS

:SLEEP_LOOP	// INIT_TIMERS
CALL G_UPDATE_PAUSEBAR
SET Clock 0
RND TIMER_BORED 3 10		// 3 to 10 seconds (bored timer, how long before AIBO becomes increasingly bored)
RND TIMER_LOOKAROUND 0 2	// 0 to 2 seconds (look around timer, how often AIBO moves his head)
RND TIMER_REST 5 10		// 5 to 10 seconds (rest timer, how ofter "mood_tired" is decremented)
SET tailwag 0
SET tilt Head_Tilt
SET pan Head_Pan

if (mood_happy>3) CALL G_START_TAILWAG_SLOW

:2257	// NEED2REST?
if (F_NEED2REST()) then
  CALL G_STOP_TAILWAG
  RET:GO_RESTPOS
endif

WAIT 50
CALL G_REST_TIMER

// Is the ball visible?
if (F_SEE_BALL()==GO_SEEBALL) SLEEP_SEEBALL

:SLEEP_CHECKATTENTION
CALL G_SLEEP_ATTENTION
  CASE:GO_IDLE     GO 2289 // look timer
  CASE:GO_PRAISE   GO 2288
  CASE:GO_PETTED   GO 2287
  CASE:GO_SCOLD    GO 2284
  CASE:GO_DOWNPOS  GO SLEEP_NEXTLOOP
  CASE:GO_RESTPOS  RET GO_RESTPOS
  CASE:GO_SITPOS   RET GO_SITPOS
  CASE:GO_STANDPOS RET GO_STANDPOS
  CASE:GO_WALK     RET GO_WALK

// Call YART & custom user voice command processing routines...
:SLEEP_PROCESSVOICE
CALL G_YART_VoiceCmd
  CASE:GO_RESTPOS  RET:GO_RESTPOS
  CASE:GO_DOWNPOS  GO SLEEP_NEXTLOOP
  CASE:GO_SITPOS   RET:GO_SITPOS
  CASE:GO_STANDPOS RET:GO_STANDPOS
  CASE:GO_WALK     RET:GO_WALK
  CASE:GO_SEEBALL  RET:GO_SEEBALL

IF sitonly > 0 THEN
  CALL G_CUSTOM_SLEEP_VOICECMD
    CASE:GO_RESTPOS  RET:GO_RESTPOS
    CASE:GO_DOWNPOS  GO SLEEP_NEXTLOOP
    CASE:GO_SITPOS   RET:GO_SITPOS
    CASE:GO_STANDPOS GO SLEEP_NEXTLOOP
    CASE:GO_WALK     GO SLEEP_NEXTLOOP
    CASE:GO_SEEBALL  GO SLEEP_NEXTLOOP
    CASE:GO_IGNORE   GO SLEEP_NEXTLOOP
ELSE
  CALL G_CUSTOM_SLEEP_VOICECMD
    CASE:GO_RESTPOS RET:GO_RESTPOS
    CASE:GO_DOWNPOS  GO SLEEP_NEXTLOOP
    CASE:GO_SITPOS   RET:GO_SITPOS
    CASE:GO_STANDPOS RET:GO_STANDPOS
    CASE:GO_WALK     RET:GO_WALK
    CASE:GO_SEEBALL  RET:GO_SEEBALL
    CASE:GO_IGNORE   GO SLEEP_NEXTLOOP
ENDIF

// If not overridden, do normal voice command processing...
CALL G_SLEEP_VOICE_HANDLER
  CASE:GO_RESTPOS RET:GO_RESTPOS
  CASE:GO_DOWNPOS GO SLEEP_NEXTLOOP
  CASE:GO_SITPOS RET:GO_SITPOS
  CASE:GO_STANDPOS RET:GO_STANDPOS
  CASE:GO_SEEBALL RET:GO_SEEBALL
  CASE:GO_WALK RET:GO_WALK

:2265	// NOSE_SENSE?
CALL G_SLEEP_NOSE_SENSE
CALL G_BORED_TIMER
  CASE:1 GO 2257

// Go process pending voice command...
if (AP_Voice_Cmd!=0) && (AP_Voice_Level>=MIN_VOICE_LEVEL) SLEEP_CHECKATTENTION

// Should we go walking?  10% of the time, yes (if not too tired)...
RND rndnum 0 100
IF (sitonly == 0) && (rndnum<=10) && (mood_tired<=5) && (bored_count<1) THEN
  RET:GO_WALK
ENDIF

// Should we sit?
IF rndnum <= 20 THEN // 20% of the time, yes...
  SET sleepsit 1
  RET:GO_SITPOS
ENDIF

// Change sleep position?
IF_1ST rndnum < change_thres SLEEP_CHANGEPOS

IF rndnum < 90 THEN
  RND rndnum 0 100
  // If upset, cry...
  IF (mood_sad>5) && (rndnum<(mood_sad-5)*10) THEN
    CALL G_SAD
    GO SLEEP_LOOP
  ENDIF

  // Bored skit? 
  IF (rndnum>33) && (rndnum<40) && (bored_count<4) THEN // 6% chance of reading book
    sleepstate := 2 // readbook leaves AIBO in sleep-flat pose
    CALL G_READBOOK
      CASE:GO_IDLE GO SLEEP_LOOP
      CASE:GO_SEEBALL GO SLEEP_SEEBALL
      CASE:GO_VOICE GO SLEEP_PROCESSVOICE
  ELSE
    IF (rndnum>33) && (bored_count<3) THEN
      // Process YART sitting position bored behavior...
      CALL G_YART_Bored_Sleep
        CASE:GO_RESTPOS RET:GO_RESTPOS
        CASE:GO_DOWNPOS GO SLEEP_LOOP
        CASE:GO_SITPOS RET:GO_SITPOS
        CASE:GO_STANDPOS RET:GO_STANDPOS
        CASE:GO_WALK RET:GO_WALK

      CALL G_SLEEP_BORED
      CALL G_BEHAVIOR_BORED
      ADD change_thres 2
      GO SLEEP_LOOP
    ENDIF
  ENDIF

  // Happy skit?
  IF (rndnum > 66) && (bored_count >= 3) && (mood_happy > 5) THEN
    // Process YART sitting position happy behavior...
    CALL G_YART_Happy_Sleep
      CASE:GO_RESTPOS RET:GO_RESTPOS
      CASE:GO_DOWNPOS GO SLEEP_LOOP
      CASE:GO_SITPOS RET:GO_SITPOS
      CASE:GO_STANDPOS RET:GO_STANDPOS
      CASE:GO_WALK RET:GO_WALK

    CALL G_SLEEP_HAPPY
    ADD change_thres 2
    GO SLEEP_LOOP
  ENDIF

  // Tailsong skit?
  IF (rndnum > 66) && (bored_count >= 3) && (mood_happy > 2) THEN
    CALL G_SLEEP_TAILSONG
    ADD change_thres 2
    GO SLEEP_LOOP
  ENDIF
ENDIF

// Process YART sitting position calm behavior...
CALL G_YART_Calm_Sleep
  CASE:GO_RESTPOS RET:GO_RESTPOS
  CASE:GO_DOWNPOS GO SLEEP_LOOP
  CASE:GO_SITPOS RET:GO_SITPOS
  CASE:GO_STANDPOS RET:GO_STANDPOS
  CASE:GO_WALK RET:GO_WALK

// Do little "calm" act while in sleep position...
CALL G_SLEEP_CALM

:SLEEP_NEXTLOOP
ADD change_thres 2
GO SLEEP_LOOP

:SLEEP_CHANGEPOS
CALL G_SLEEP_CHANGEPOS
GO SLEEP_NEXTLOOP

:2284	// SCOLD
CALL G_SCOLD_REST

:2285	// RESET_BORED
RND bored_count 5 10
CALL G_CLEAR_SENSORS
GO SLEEP_NEXTLOOP

:2287	// SLEEP_PETTED
CALL G_SLEEP_PETTED
GO 2285

:2288	// PRAISE
CALL G_PRAISE_REST
GO 2285

:2289	// LOOK_TIMER
CALL G_LOOK_TIMER
GO 2265



//
// Seen the ball.  Standup and look for it...
//
:SLEEP_SEEBALL

  // If the ball is right in front of AIBO, occasionally have a go at
  // ball from sleep position (before standing up)...
  if (Pink_Ball>0) && (F_RND100()<25) then
    PLAY ACTION TRACK_HEAD PINK_BALL	// lock head onto ball
    WAIT 1000

    SET kick_pan Head_Pan
    SET kick_tilt Head_Tilt
    SET swing_kick 0

    if (F_TRIANGLE_HIT(F_ABS(Head_Pan),Head_Tilt,35,-40,60,-70)) then
      if (Head_Pan<0) then
        SET swing_kick 100
      else
        SET swing_kick 101
      endif
    endif
/*
    if (Head_Tilt<-60) && (Head_Pan<-45) then
      SET swing_kick 100
    endif

    if (Head_Tilt<-60) && (Head_Pan>45) then
      SET swing_kick 101
    endif
*/
    if (Head_Tilt>-45) && (Head_Tilt<-20) && (F_ABS(Head_Pan)<10) then
      SET swing_kick 102
    endif

    SET init_wait Wait
    SWITCH:swing_kick
      CASE:100 PLAY ACTION kick_sleeppos_left
      CASE:101 PLAY ACTION kick_sleeppos_right
      CASE:102 PLAY ACTION kick_sleeppos_center
 
    if (swing_kick>0) then
      CALL G_WAIT
      CALL G_SOCCER_KICK_MOOD
    endif
  endif

  CALL G_STAND4BALL
    CASE:GO_IDLE RET:GO_STANDPOS
    CASE:GO_RESTPOS RET:GO_RESTPOS
    CASE:GO_SEEBALL RET:GO_SEEBALL

  GO SLEEP_CHECKATTENTION



//
// See if head position (head_pan,head_tilt) falls within triangle 
// defined by points (xul,yul),(xul,ylr),(xlr,ylr)...
//
//    (xul,yul)
//        |\
//        | \
//        |  \
//        |   \
//        |    \
//         ----- (xlr,ylr)
//    (xul,ylr)
//
:F_TRIANGLE_HIT 
  ARG:x
  ARG:y
  ARG:xul
  ARG:yul
  ARG:xlr
  ARG:ylr
  SET Context 0
  CSET:x:<:xul:1
  CSET:x:>:xlr:1
  CSET:y:>:ylr:1
  if (Context) then
    RETURN:FALSE
  endif
  RETURN (y<=((x-xul)*(ylr-yul)/(xlr-xul)+yul))



////////////////////////////////////////////////////////////////////
// INIT_SLEEPPOS
:G_INIT_SLEEPPOS
PRINT SLEEPPOS
SET sleepstate 0	// 0=pos,1=wide,2=flat
SET change_thres 40	// Change threshold
SET nosecount 0		// # of nose triggers
SET back_count 0	// # b2b back pets

WAIT 1
SET init_wait Wait

PLAY ACTION LIE
CALL G_WAIT
CALL G_CLEAR_SENSORS

WAIT 1
IF_1ST sleepsit > 0
IF_AND bored_count < 3 1247
IF_1ST sleepsit > 0 1246
RND bored_count 3 10

:1246	// DONE
SET sleepsit 0
SET tiltadj Head_Tilt	// See how out-of-whack head tilt is
RET 1

:1247	// SIT2SLEEP
RND bored_count 3 5
SET sleepsit 0
SET tiltadj Head_Tilt	// See how out-of-whack head tilt is
RET 1


////////////////////////////////////////////////////////////////////
//
//  Process user praise/scolding while in sleep position...
//
:G_SLEEP_ATTENTION
CALL G_ATTENTION_HANDLER
  CASE:GO_PRAISE   RET GO_PRAISE
  CASE:GO_PETTED   RET GO_PETTED
  CASE:GO_SCOLD    RET GO_SCOLD
  CASE:GO_VOICE    RET GO_VOICE
  CASE:GO_RESTPOS  RET GO_RESTPOS
  CASE:GO_DOWNPOS  RET GO_DOWNPOS
  CASE:GO_SITPOS   RET GO_SITPOS
  CASE:GO_STANDPOS RET GO_STANDPOS
  CASE:GO_WALK     RET GO_WALK

CALL G_TAIL_TWEAKED
  CASE:2 RET GO_PRAISE
  CASE:3 RET GO_SCOLD
  CASE:4 RET GO_VOICE

WAIT 1
if RFLeg_ON<>0 then
  ADD pet 8
  SET RFLeg_ON 0
  SET back_count 0
endif

if LFLeg_ON<>0 then
  ADD pet 16
  SET LFLeg_ON 0
  SET back_count 0
endif

if (sleepstate != 0) then // rear feet not flat on floor
  if (RRLeg_3<30) && (RRLeg_ON>0) then
    ADD pet 32
    SET RRLeg_ON 0
    SET back_count 0
  endif
  if (LRLeg_3<30) && (LRLeg_ON>0) then
    ADD pet 64
    SET LRLeg_ON 0
    SET back_count 0
  endif
endif

if (pet==0) then
  RET GO_IDLE
endif
RET GO_PETTED


////////////////////////////////////////////////////////////////////
// SLEEP_BORED  (Do something when bored in sleep position)
:G_SLEEP_BORED

:1954	// SLEEPSTATE?
SWITCH sleepstate
  CASE:0 GO 1986	// SleepPos
  CASE:1 GO 1975	// SleepWide
  CASE:2 GO 1963	// SleepFlat

SET rndbase 250
SET rndcount 2
SET lastact1 last_boredact
SET lastact2 last_boredact
CALL G_BEHAVIOR_RNDNM
  CASE:1 GO 1962
  CASE:3 RET 1

IF_1ST rndnum = 250 1961
PLAY ACTION HOWL_BELLY2
SET last_boredact rndnum

:4119	// WAIT_BELLY
WAIT
RET 1

:1961	// bhowl1
PLAY ACTION HOWL_BELLY1
SET last_boredact rndnum
GO 4119

:1962	// SLEEP_PICKPOS
CALL G_SLEEP_PICKPOS
GO 1954

:1963	// SLEEPFLAT
SET rndbase 200
SET rndcount 8
SET lastact1 last_boredact
SET lastact2 last_boredact
CALL G_BEHAVIOR_RNDNM
  CASE:1 GO 1962
  CASE:3 RET 1
SWITCH rndnum
  CASE:200 PLAY ACTION ANYONE_THERE1
  CASE:201 PLAY ACTION ANYONE_THERE2
  CASE:202 PLAY ACTION ANYONE_THERE3
  CASE:203 PLAY ACTION ANYONE_THERE4
  CASE:204 PLAY ACTION BORED_SLEEP1
  CASE:205 PLAY ACTION HOWL_SLEEP1
  CASE:206 PLAY ACTION HOWL_SLEEP2
  CASE:207 PLAY ACTION PET_ME
SET last_boredact rndnum
WAIT
RET 1

:1975	// SLEEPWIDE
SET rndbase 150
SET rndcount 7
SET lastact1 last_boredact
SET lastact2 last_boredact
CALL G_BEHAVIOR_RNDNM
  CASE:1 GO 1962
  CASE:3 RET 1
SWITCH rndnum
  CASE:150 PLAY ACTION BORED_SLEEP5
  CASE:151 PLAY ACTION BORED_SLEEP6
  CASE:152 PLAY ACTION BORED_SLEEP7
  CASE:153 PLAY ACTION BORED_SLEEP8
  CASE:154 PLAY ACTION BORED_SLEEP9
  CASE:155 PLAY ACTION BORED_SLEEP10
  CASE:156 PLAY ACTION TWITCHY
SET last_boredact rndnum
WAIT
RET 1

:1986	// SLEEPPOS
SET rndbase 100
SET rndcount 10
SET lastact1 last_boredact
SET lastact2 last_boredact
CALL G_BEHAVIOR_RNDNM
  CASE:1 GO 1962
  CASE:3 RET 1
SWITCH rndnum
  CASE:100 PLAY ACTION BORED_SLEEP2
  CASE:101 PLAY ACTION BORED_SLEEP3
  CASE:102 PLAY ACTION BORED_SLEEP4
  CASE:103 PLAY ACTION NOBI1
  CASE:104 PLAY ACTION NOBI2
  CASE:105 PLAY ACTION NOBI3
  CASE:106 PLAY ACTION WANT_ATTENTION_SLEEP1
  CASE:107 PLAY ACTION WANT_ATTENTION_SLEEP2
  CASE:108 PLAY ACTION IMPATIENT_SLEEP
  CASE:109 GO SLEEP_CALL_OWNERNAME
SET last_boredact rndnum
WAIT
RET 1

:SLEEP_CALL_OWNERNAME
if (F_RND100()<10) G_PLAYBACK_OWNERNAME
RET 1



////////////////////////////////////////////////////////////////////
// SLEEP_CALM  (Do something when calm in sleep position)
:G_SLEEP_CALM

:2001	// SLEEPSTATE?
SWITCH sleepstate
  CASE:0 GO 2036	// SleepPos
  CASE:1 GO 2023	// SleepWide
  CASE:2 GO 2019	// SleepFlat

SET rndbase 700
SET rndcount 10
SET lastact1 last_calmact
SET lastact2 last_calmact2
CALL G_BEHAVIOR_RNDNM
  CASE:1 GO 2018
  CASE:3 RET 1

SWITCH rndnum
  CASE:700 PLAY ACTION CONFUSED1
  CASE:701 PLAY ACTION CONFUSED2
  CASE:702 PLAY ACTION OHWELL
  CASE:703 PLAY ACTION BOTH_EAR_TWITCH4
  CASE:704 PLAY ACTION BOTH_EAR_TWITCH5
  CASE:705 PLAY ACTION WAVE_LEFT_BELLY1
  CASE:706 PLAY ACTION WAVE_LEFT_BELLY2
  CASE:707 PLAY ACTION WAVE_RIGHT_BELLY1
  CASE:708 PLAY ACTION WAVE_RIGHT_BELLY2
  CASE:709 PLAY ACTION THINKING_BELLY
CALL G_WAITZERO
SET last_calmact2 last_calmact
SET last_calmact rndnum
RET 1

:2018	// SLEEP_PICKPOS
CALL G_SLEEP_PICKPOS
GO 2001

:2019	// SLEEPFLAT
RND rndnum 650 650
IF_1ST rndnum = last_calmact 2018
IF_1ST rndnum = last_calmact2 2018
PLAY ACTION LOOKAROUND_SLEEP1
CALL G_WAITZERO
SET last_calmact2 last_calmact
SET last_calmact rndnum
RET 1

:2023	// SLEEPWIDE
SET rndbase 600
SET rndcount 9
SET lastact1 last_calmact
SET lastact2 last_calmact2
CALL G_BEHAVIOR_RNDNM
  CASE:1 GO 2018
  CASE:3 RET 1
SWITCH rndnum
  CASE:600 PLAY ACTION PLAY_VIOLIN
  CASE:601 PLAY ACTION TAP_REARRIGHT
  CASE:602 PLAY ACTION SMOKING
  CASE:603 PLAY ACTION SNEEZE
  CASE:604 PLAY ACTION CUTE_BOXING
  CASE:605 PLAY ACTION SCRATCH_REAR
  CASE:606 PLAY ACTION DRINKING
  CASE:607 PLAY ACTION LOOKAROUND_SLEEP3
  CASE:608 PLAY ACTION EATING
CALL G_WAITZERO
SET last_calmact2 last_calmact
SET last_calmact rndnum
RET 1

:2036	// SLEEPPOS
SET rndbase 550
SET rndcount 8
SET lastact1 last_calmact
SET lastact2 last_calmact2
CALL G_BEHAVIOR_RNDNM
  CASE:1 GO 2018
  CASE:3 RET 1
SWITCH rndnum
  CASE:550 PLAY ACTION HICCUPS_SLEEP
  CASE:551 PLAY ACTION YOGA
  CASE:552 PLAY ACTION CUTE_EXERCISE1
  CASE:553 PLAY ACTION CUTE_EXERCISE2
  CASE:554 PLAY ACTION CUTE_EXERCISE4
  CASE:555 PLAY ACTION SCRATCH_LEFTEAR2
  CASE:556 PLAY ACTION THINKING_SLEEP
  CASE:557 PLAY ACTION LOOKAROUND_SLEEP2
CALL G_WAITZERO
SET last_calmact2 last_calmact
SET last_calmact rndnum
RET 1


////////////////////////////////////////////////////////////////////
// SLEEP_CHANGEPOS  (Change to new sleep position)
:G_SLEEP_CHANGEPOS
CALL G_SLEEP_PICKPOS
SWITCH sleepstate
  CASE:0 PLAY ACTION LIE
  CASE:1 PLAY ACTION SLEEPWIDE
  CASE:2 PLAY ACTION SLEEPFLAT
  CASE:3 PLAY ACTION BELLYPOS
SET change_thres 15
WAIT
CALL G_CLEAR_SENSORS
RET 1

////////////////////////////////////////////////////////////////////
// SLEEP_DANCE  (Perform dance when in lay-down (sleep) position)
:G_SLEEP_DANCE

:2060	// SLEEPSTATE?
SWITCH sleepstate
  CASE:0 GO 2086	// SleepPos
  CASE:1 GO 2077	// SleepWide
  CASE:2 GO 2073	// SleepFlat

SET rndbase 900
SET rndcount 6
SET lastact1 last_danceact
SET lastact2 last_danceact
CALL G_BEHAVIOR_RNDNM
  CASE:1 GO 2072
  CASE:3 RET 1

SWITCH rndnum
  CASE:900 PLAY ACTION DANCE_BELLY1
  CASE:901 PLAY ACTION DANCE_BELLY2
  CASE:902 PLAY ACTION DANCE_BELLY3
  CASE:903 PLAY ACTION DANCE_BELLY4
  CASE:904 PLAY ACTION DANCE_BELLY5
  CASE:905 PLAY ACTION DANCE_BELLY6
SET last_danceact rndnum
WAIT
RET 1

:2072	// SLEEP_PICKPOS
CALL G_SLEEP_PICKPOS
GO 2060

:2073	// RNDNUM_FLAT
RND rndnum 200 200
IF_1ST rndnum = last_danceact 2072
PLAY ACTION DANCE_SLEEP1
SET last_danceact rndnum
WAIT
RET 1

:2077	// SLEEPWIDE
SET rndbase 800
SET rndcount 5
SET lastact1 last_danceact
SET lastact2 last_danceact
CALL G_BEHAVIOR_RNDNM
  CASE:1 GO 2072
  CASE:3 RET 1
SWITCH rndnum
  CASE:800 PLAY ACTION DANCE_SLEEP5
  CASE:801 PLAY ACTION DANCE_SLEEP6
  CASE:802 PLAY ACTION DANCE_SLEEP7
  CASE:803 PLAY ACTION SONG_SLEEP1
  CASE:804 PLAY ACTION SONG_SLEEP2
SET last_danceact rndnum
WAIT
RET 1

:2086	// SLEEPPOS
SET rndbase 750
SET rndcount 6
SET lastact1 last_danceact
SET lastact2 last_danceact
CALL G_BEHAVIOR_RNDNM
  CASE:1 GO 2072
  CASE:3 RET 1
SWITCH rndnum
  CASE:750 PLAY ACTION DANCE_SLEEP2
  CASE:751 PLAY ACTION DANCE_SLEEP3
  CASE:752 PLAY ACTION DANCE_SLEEP4
  CASE:753 PLAY ACTION foot_loose
  CASE:754 PLAY ACTION acdc_sleeppos
  CASE:755 PLAY ACTION popgoes_sleeppos
SET last_danceact rndnum
WAIT
RET 1


////////////////////////////////////////////////////////////////////
// SLEEP_GREET  (Do little greeting.)
:G_SLEEP_GREET
WAIT 1
SET init_wait Wait
CALL G_RANDOM1/3
  CASE:1 GO 2110

:2097	// POSITION?
SWITCH sleepstate
  CASE:0 GO 2107
  CASE:1 GO 2104
CALL G_RANDOM4
  CASE:1 PLAY ACTION WAVE_LEFT_BELLY1
  CASE:2 PLAY ACTION WAVE_LEFT_BELLY2
  CASE:3 PLAY ACTION WAVE_RIGHT_BELLY1
  CASE:4 PLAY ACTION WAVE_RIGHT_BELLY2
SET sleepstate 3

:2100	// WAIT
CALL G_WAIT_AWARE
RET 1

:2104	// RANDOM2(2)
CALL G_RANDOM2
  CASE:1 PLAY ACTION SHYWAVE1
  CASE:2 PLAY ACTION SHYWAVE2
SET sleepstate 1
GO 2100

:2107	// RANDOM2
CALL G_RANDOM2
  CASE:1 PLAY ACTION WAVE_LEFT_SLEEP
  CASE:2 PLAY ACTION WAVE_RIGHT_SLEEP
SET sleepstate 0
GO 2100

:2110	// SLEEP_PICKPOS
CALL G_SLEEP_PICKPOS
GO 2097


////////////////////////////////////////////////////////////////////
// SLEEP_HAPPY  (Do something when happy in sleep position)
:G_SLEEP_HAPPY

:2113	// SLEEPSTATE?
SWITCH sleepstate
  CASE:0 GO 2140	// SleepPos
  CASE:1 GO 2130	// SleepWide
  CASE:2 GO 2126	// SleepFlat

SET rndbase 450
SET rndcount 6
SET lastact1 last_happyact
SET lastact2 last_happyact
CALL G_BEHAVIOR_RNDNM
  CASE:1 GO 2125
  CASE:3 RET 1

SWITCH rndnum
  CASE:450 PLAY ACTION DANCE_BELLY1
  CASE:451 PLAY ACTION DANCE_BELLY2
  CASE:452 PLAY ACTION DANCE_BELLY3
  CASE:453 PLAY ACTION DANCE_BELLY4
  CASE:454 PLAY ACTION DANCE_BELLY5
  CASE:455 PLAY ACTION DANCE_BELLY6
SET last_happyact rndnum
WAIT
RET 1

:2125	// SLEEP_PICKPOS
CALL G_SLEEP_PICKPOS
GO 2113

:2126	// SLEEPFLAT
RND rndnum 400 400
IF_1ST rndnum = last_happyact 2125
PLAY ACTION DANCE_SLEEP1
SET last_happyact rndnum
WAIT
RET 1

:2130	// SLEEPWIDE
SET rndbase 350
SET rndcount 6
SET lastact1 last_happyact
SET lastact2 last_happyact
CALL G_BEHAVIOR_RNDNM
  CASE:1 GO 2125
  CASE:3 RET 1
SWITCH rndnum
  CASE:350 PLAY ACTION DANCE_SLEEP5
  CASE:351 PLAY ACTION DANCE_SLEEP6
  CASE:352 PLAY ACTION DANCE_SLEEP7
  CASE:353 PLAY ACTION LAUGH
  CASE:354 PLAY ACTION SONG_SLEEP1
  CASE:355 PLAY ACTION SONG_SLEEP2
SET last_happyact rndnum
WAIT
RET 1

:2140	// SLEEPPOS
SET rndbase 300
SET rndcount 3
SET lastact1 last_happyact
SET lastact2 last_happyact
CALL G_BEHAVIOR_RNDNM
  CASE:1 GO 2125
  CASE:3 RET 1
SWITCH rndnum
  CASE:300 PLAY ACTION DANCE_SLEEP2
  CASE:301 PLAY ACTION DANCE_SLEEP3
  CASE:302 PLAY ACTION DANCE_SLEEP4
SET last_happyact rndnum
WAIT
RET 1


////////////////////////////////////////////////////////////////////
// SLEEP_NOSE_SENSE
:G_SLEEP_NOSE_SENSE
WAIT 1
// If hand near nose, then 1/3 of time (if totally idle, or idle with tailwag)...
if (Distance<200) && (Head_Tilt>-25) && (nosecount<3) && (F_RND100()<33) then
  if ((Wait==0) || ((Wait==1) && (tailwag>0))) then
    nosecount++
    init_wait := Wait
    CALL G_RANDOM4
      case:1 PLAY ACTION LOOKAWAY_LEFT_SLEEP1
      case:2 PLAY ACTION LOOKAWAY_RIGHT_SLEEP1
      case:3 PLAY ACTION sniff_once
      case:4 PLAY ACTION sniff_twice
    sleepstate := 0
    CALL G_WAIT_AWARE
  endif
endif
RET 1



////////////////////////////////////////////////////////////////////
// SLEEP_PETTED
:G_SLEEP_PETTED

WAIT 1
SET init_wait Wait
CALL G_RANDOM3
  CASE:1 PLAY ACTION TUNE_PETTED1
  CASE:2 PLAY ACTION TUNE_PETTED2
  CASE:3 GO 2160

CALL G_WAIT
if (F_RND100()>((mood_happy>4)?66:33)) 2167

:2160	// LOTS_BACK_PET?
WAIT 1
SET init_wait Wait

if (back_count>4) then
  RND rndnum 0 1
  SWITCH rndnum
    CASE:0 PLAY ACTION+ petting_kick_sleep_left
    CASE:1 PLAY ACTION+ petting_kick_sleep_right
  CALL G_WAIT
  SET sleepstate 0
  SET last_petsong 999
  SET Back_ON 0
else
  repeat 
    RND rndnum 0 5
  until rndnum != last_petsong 
  SWITCH rndnum
    CASE:0 PLAY ACTION BEEN_PETTED15
    CASE:0 SET sleepstate 0
    CASE:1 PLAY ACTION BEEN_PETTED16
    CASE:1 SET sleepstate 0
    CASE:2 PLAY ACTION BEEN_PETTED17
    CASE:2 SET sleepstate 0
    CASE:3 PLAY ACTION BEEN_PETTED18
    CASE:4 PLAY ACTION BEEN_PETTED19
    CASE:5 PLAY ACTION BEEN_PETTED20
  SET last_petsong rndnum
  CALL G_WAIT
endif

:2167	// INC_HAPPY_MOOD
CALL G_INC_HAPPY_MOOD
CALL G_DEC_MAD_MOOD
CALL G_DEC_SAD_MOOD
RET 1



////////////////////////////////////////////////////////////////////
// SLEEP_PICKPOS  (Pick a new sleep position (but dont change to it))
:G_SLEEP_PICKPOS
repeat
  RND rndnum 0 3
until (rndnum != sleepstate)
sleepstate := rndnum
ret 1


////////////////////////////////////////////////////////////////////
// SLEEP_TAILSONG  (Play a little tune accompanied with tail wagging)
:G_SLEEP_TAILSONG
SET rndbase 500
SET rndcount 6
if (F_BEHAVIOR_RNDN()) then
  SWITCH rndnum
    CASE:500 PLAY ACTION TAILWAG_SONG1
    CASE:501 PLAY ACTION TAILWAG_SONG2
    CASE:502 PLAY ACTION TAILWAG_SONG3
    CASE:503 PLAY ACTION TAILWAG_SONG4
    CASE:504 PLAY ACTION TAILWAG_SONG5
    CASE:505 PLAY ACTION TAILWAG_SONG6
  SET sleepstate 0
  CALL G_WAITZERO
endif
RET 1


////////////////////////////////////////////////////////////////////
//
//  Voice Processing when laying down...
//
:G_SLEEP_VOICE_HANDLER
CALL G_STOP_HEAD
SWITCH VoiceCmd
  CASE:HEARD_RHYTHM GO 2222		 // Rhythm?
  CASE:VOICE_WALK GO GSL_WALK		 // Walk
  CASE:VOICE_FINDBALL GO GSL_FINDBALL	 // Find Ball
  CASE:VOICE_KICKBALL GO GSL_FINDBALL	 // Kick Ball
  CASE:VOICE2_PINKBALL GO GSL_FINDBALL	 // Pink Ball
  CASE:VOICE2_RIGHTKICK GO GSL_FINDBALL	 // Right Kick - ZZZ - Should add right kick code
  CASE:VOICE2_LEFTKICK GO GSL_FINDBALL	 // Left Kick - ZZZ - Should add left kick code
  CASE:VOICE2_RIGHTTOUCH GO GSL_FINDBALL // Right Touch - ZZZ - Should add right touch code
  CASE:VOICE2_LEFTTOUCH GO GSL_FINDBALL	 // Left Touch - ZZZ - Should add left touch code
  CASE:VOICE_LETSDANCE GO 2231		 // Dance
  CASE:VOICE2_SHOWTIME GO 2231		 // Show Time
  CASE:VOICE2_SHOWOFF GO 2231		 // Show Off
  CASE:VOICE_AREYOUOK GO 2230		 // Are you ok?
  CASE:VOICE2_HOWAREYOU GO 2230		 // How are you?
  CASE:VOICE_GOODNIGHT GO 2229		 // Good Night
  CASE:VOICE_GOODBYE GO 2229		 // Goodbye
  CASE:VOICE_AIBO GO 2226		 // AIBO
  CASE:VOICE2_HEYAIBO GO 2226		 // Hey AIBO
  CASE:VOICE_GOODMORNING GO 2226	 // Good Morning
  CASE:VOICE_HELLO GO 2226		 // Hello
  CASE:VOICE2_THANKS GO 2226		 // Thanks
  CASE:VOICE2_HAPPYDAY GO 2226		 // Happy Day
  CASE:VOICE_SAYHELLO GO 2226		 // Say Hello
  CASE:VOICE_AREYOUTIRED GO 2225	 // Tired?
  CASE:VOICE_LAYDOWN GO 2223		 // Lie Down / Play Dead
  CASE:VOICE_ROAR GO 2223		 // Roar / Roll Over
  CASE:VOICE_AREYOUHUNGRY GO 2221	 // Hungry?
  CASE:VOICE_ROAR GO 2220		 // Roar
  CASE:VOICE_MEOW GO 2220		 // Meow
  CASE:VOICE2_SINGSONG GO 2220		 // Sing Song
  CASE:VOICE_TURNLEFT GO 2219		 // Left
  CASE:VOICE_GOFORWARD GO 2218		 // Forward
  CASE:VOICE_TURNRIGHT GO 2217		 // Right
  CASE:VOICE_GOBACK GO 2216		 // Back
  CASE:VOICE_GETUP GO 2215		 // Get Up
  CASE:VOICE_STANDUP GO 2215		 // Stand Up
  CASE:VOICE_SITDOWN GO 2213		 // Sit Down
  CASE:VOICE_SHAKEPAW GO 2211		 // Shake
  CASE:VOICE_SHAKE GO 2211		 // Shake
  CASE:VOICE_OTHERPAW GO 2209		 // Other Paw
  CASE:VOICE_LETSPLAY GO 2208		 // Let's Play
  CASE:VOICE_KARATECHOP GO 2207		 // Karate Chop
  CASE:VOICE2_BANZAI GO 2207		 // Banzai
  CASE:VOICE_POSE GO 2206		 // Pose
  CASE:VOICE2_CLOWNAROUND GO 2206	 // Clown around
  CASE:VOICE_WHATSYOURNAME GO 2232	 // What's your name?
  CASE:VOICE2_WHATSOWNERNAME GO 2233	 // What's owners name?
  CASE:VOICE_NAMEREG GO 2234		 // Name Registration
  CASE:VOICE2_OWNERREG GO 2235		 // Owner Registration
#if ERS210 || ERS220
  CASE:VOICE2_ACTION1 GO 2236		 // Self Dock
#endif
RET GO_IGNORE

:2206	// SIT_POSE
CALL G_SIT_POSE
RET GO_SITPOS

:2207	// KARATE_CHOP
CALL G_KARATE_CHOP
RET GO_SITPOS

:2208	// Game Time
CALL G_Select_Game
RET GO_SITPOS

:2209	// OTHERPAW_CMD
CALL G_VOICE_HIT
CALL G_SIT_OTHERHAND
RET GO_SITPOS

:2211	// SHAKEPAW_CMD
CALL G_VOICE_HIT
CALL G_SIT_SHAKEHANDS
RET GO_SITPOS

:2213	// SIT_DOWN
CALL G_VOICE_HIT
PLAY ACTION SIT
CALL G_WAITZERO
RET GO_SITPOS

:2215	// STAND_UP
CALL G_CHECK_STAYSIT
  CASE:GO_IGNORE RET GO_IGNORE
CALL G_STAND_UP
RET GO_STANDPOS

:2216	// BACK
CALL G_CHECK_STAYSIT
  CASE:GO_IGNORE RET GO_IGNORE
CALL G_GO_BACK
RET GO_STANDPOS

:2217	// RIGHT
CALL G_LAZY_GORIGHT
  CASE:1 RET GO_DOWNPOS
RET GO_STANDPOS

:2218	// FWD
CALL G_CHECK_STAYSIT
  CASE:GO_IGNORE RET GO_IGNORE
CALL G_GO_FORWARD
RET GO_STANDPOS

:2219	// LEFT
CALL G_LAZY_GOLEFT
  CASE:1 RET GO_DOWNPOS
RET GO_STANDPOS

:2220	// BARK
CALL G_CHECK_STAYSIT
  CASE:GO_IGNORE RET GO_IGNORE
CALL G_STAND_BARK
RET GO_STANDPOS

:2221	// HUNGRY?
CALL G_QUERY_HUNGRY
  CASE:1 RET GO_DOWNPOS
RET GO_SITPOS

:2222	// SLEEP_RHYTHM
CALL G_SLEEP_RHYTHM
RET GO_DOWNPOS

:2223	// LAYDOWN
CALL G_VOICE_HIT

// If rolling over is disabled, say don't wanna...
if (behavior[BEHAVIOR_DISABLE_ROLLOVER]>0) then
  CALL G_DEC_HAPPY_MOOD
  CALL G_INC_MAD_MOOD
  CALL G_INC_SAD_MOOD
  PLAY ACTION DONTWANNA4
  CALL G_WAITZERO
  RET GO_DOWNPOS
endif

IF sitonly == 0 THEN
#ifdef ERS310
  SET:NoFallDown:1
  PLAY ACTION playdead_sleep
  CALL G_WAITZERO
  SET:NoFallDown:0
  PLAY MWCID 2514
  CALL G_WAITZERO
  PLAY ACTION SHUDDER
  CALL G_WAITZERO
  RET GO_STANDPOS
#else
  PLAY ACTION playdead_sleep
  CALL G_WAITZERO
#endif
ENDIF
RET GO_DOWNPOS

:2225	// ARE_YOU_TIRED?
CALL G_QUERY_TIRED
RET GO_DOWNPOS

:2226	// HELLO?
RND rndnum 1 4
if (rndnum>2) then
  CALL G_SLEEP_GREET
  RET GO_DOWNPOS
endif

WAIT 1
SET init_wait Wait
if (rndnum==1) then
  PLAY ACTION HELLO_SLEEP
else
  SWITCH:VoiceHorz
    CASE:1 PLAY ACTION hello_front
    CASE:2 PLAY ACTION hello_right
    CASE:4 PLAY ACTION hello_right
    CASE:8 PLAY ACTION hello_right
    CASE:16 PLAY ACTION hello_front
    CASE:32 PLAY ACTION hello_left
    CASE:64 PLAY ACTION hello_left
    CASE:128 PLAY ACTION hello_left
endif
CALL G_WAIT_AWARE
RET GO_DOWNPOS

:2229	// SLEEP_GREET
CALL G_SLEEP_GREET
RET GO_DOWNPOS

:2230	// ARE_YOU_OK?
CALL G_QUERY_MOOD
RET GO_DOWNPOS

:2231	// LETS_DANCE
CALL G_TWITCH_EARS
CALL G_SLEEP_DANCE
RET GO_DOWNPOS

:2232   // What's your name?
CALL G_PLAYBACK_AIBONAME
RET GO_DOWNPOS

:2233   // What's owner name?
CALL G_PLAYBACK_OWNERNAME
RET GO_DOWNPOS

:2234	// Name Registration
CALL G_NAME_REGISTRATION
RET GO_SITPOS

:2235	// Owner Registration
CALL G_OWNER_REGISTRATION
if (POSE_SIT()) then 
  RET GO_SITPOS
endif
RET GO_DOWNPOS

#if ERS210 || ERS220
:2236   // Self Dock
CALL G_SELFDOCK
RET GO_STANDPOS
#endif


:GSL_WALK	// WALK_REQUEST
  CALL G_WALK_REQUEST
    CASE:1 RET GO_WALK
  RET GO_DOWNPOS


:GSL_FINDBALL	// FIND_BALL
  CALL G_VOICE_HIT

  // If too tired, cranky, or in sitonly mode, look at ball but otherwise ignore it...
  if (mood_tired>=9) || (mood_mad>5) || (sitonly>0) THEN
    CALL G_SOCCER_LOOK4BALL
    RET GO_DOWNPOS
  ENDIF

  CALL G_SOCCER_SEARCH4BALL
    CASE:1 RET GO_RESTPOS
    CASE:3 GO GSL_NOBALL  // noball

  // If too tired, ignore the ball...
  if (mood_tired>=7) GSL_NOBALL

  // Found the ball!!!
  if (POSE_STANDING()) then // exit if already standing.
    RET:GO_SEEBALL
  endif

  // Standup, and adjust head position to compensate 
  // (don't want to loose track of the ball)...
  SET pan Head_Pan
  SET tilt Head_Tilt
  SUB tilt tiltadj
  SUB tilt 15
  WAIT 1

  SET init_wait Wait
  PLAY ACTION STAND
  CALL G_WAIT_AWARE

  PLAY ACTION MOVE.HEAD.FAST pan tilt
  CALL G_WAIT_AWARE

  if (Pink_Ball!=0) then
    RET:GO_SEEBALL
  endif

  CALL G_SOCCER_SEARCH4BALL
    CASE:1 RET GO_RESTPOS
    CASE:2 RET GO_SEEBALL
  RET GO_DOWNPOS


:GSL_NOBALL
  if (!POSE_SLEEP()) then
    PLAY ACTION LIE
    CALL G_WAITZERO
  endif
  RET GO_DOWNPOS




////////////////////////////////////////////////////////////////////
// SLEEP_RHYTHM
:G_SLEEP_RHYTHM
SET rndbase 1850
SET rndcount 4
CALL G_BEHAVIOR_RNDNM
  CASE:3 RET 1	// no valid number available

SWITCH rndnum
  CASE:1850 PLAY ACTION+ dancestep_aibosleep
  CASE:1851 PLAY ACTION+ dancestep_sleep1
  CASE:1852 PLAY ACTION+ dancestep_sleep2
  CASE:1853 PLAY ACTION+ dancestep_sleep3
WAIT
RET 1


