////////////////////////////////////////////////////////////////////
//                                                                //
//  DogsLife Soccer Module for ERS-210/220                        //
//  Copyright (C) 2001-2003 by DogsBody & Ratchet Software        //
//  All Rights Reserved                                           //
//                                                                //
//  This is free software and MAY NOT be sold under any           //
//  circumstances, seperately or bundled.                         //
//                                                                //
////////////////////////////////////////////////////////////////////


#define GO_S_NOBALL 2000
#define GO_S_TRACK 2001
#define GO_S_BALLCLOSE 2002
#define GO_S_TOUCHIT 2003
#define GO_S_KICKIT 2004
#define GO_S_KICKED 2005
#define GO_S_SEARCH 2006
#define GO_S_BALLABOVE 2007

#define HEAD_TILT() (Head_Tilt)


////////////////////////////////////////////////////////////////////
//
//  Chase and kick ball until bored or we lose it...
//
:G_SOCCER
CALL G_CHECK_SITONLY
  CASE:GO_DOWNPOS RET:GO_DOWNPOS
  CASE:GO_SITPOS RET:GO_SITPOS

SET scale 10		// Distance scaling factor
PLAY ACTION TRACK_HEAD PINK_BALL
WAIT 500

SET lastmove -1		// 0=Left, 1=Right, 2=Fwd, 3=Back
SET kick_tilt 999	// Headtilt before last kick
SET kick_pan 999	// Headpan before last kick
SET miss_count 0	// # of consequtive misses

RND TIMER_TIRED 5 10
ADD TIMER_TIRED endure

IF Pink_Ball <= 0 THEN
  RET:GO_WALK
ENDIF

SET pan Head_Pan
SET tilt HEAD_TILT()
CALL G_STOP_HEAD

// If looking at tower, then turn away from it...
if (F_SEE_TOWER()==GO_IGNORE) then
  CALL G_TURN_AWAY
  RET:GO_WALK
endif

// If hungry, time to find that charger...
if (Batt_Rest<BATTLEVEL_SELFCHARGE) then
  CALL G_SELFDOCK
  CALL G_TURN_AWAY
  RET:GO_RESTPOS
endif

// Call YART "see-the-ball" override...
CALL G_YART_Soccer_SeeBall
if (Context != GO_AHEAD) then
  if (!POSE_STANDING()) then
    PLAY ACTION STAND
    CALL G_WAIT
  endif
else
  if (Head_Tilt<-8) then
    SET init_wait Wait
    SWITCH:behavior[BEHAVIOR_SEEBALL_MODE]
      CASE:0 PLAY ACTION TUNE_SEEBALL
      CASE:1 PLAY ACTION dog_1bark_anypos
    CALL G_WAIT

    if (Head_Pan <= 10) && (Head_Pan >= -10) && (Pink_Ball > 0) then
      STOP
      PLAY ACTION+ happy_eyes
      CALL G_WAITZERO
      PLAY ACTION+ pounce
      CALL G_WAITZERO
    endif
  endif
endif

:2305	// SEE_BALL?(2)
WAIT 1
if Pink_Ball > 0 then
  CALL G_SOCCER_ATTENTION_HANDLER
    CASE:GO_DOWNPOS GO SOCCER_MUSTLAYDOWN
    CASE:GO_SITPOS GO SOCCER_MUSTSITDOWN
    CASE:GO_RESTPOS GO 2307
    CASE:GO_SEEBALL GO 2311
    CASE:GO_IDLE GO 2311
    CASE:GO_STOP RET:GO_STANDPOS
endif

:2306	// SEARCH4BALL
CALL G_CHECK_SITONLY
  CASE:GO_DOWNPOS RET:GO_DOWNPOS
  CASE:GO_SITPOS RET:GO_SITPOS

CALL G_SOCCER_SEARCH4BALL
  CASE:2 GO 2305
  CASE:3 GO SOCCER_LOSTBALL

:2307	// TURN_AWAY
CALL G_TURN_AWAY
CALL G_INC_ENDURE
RET:GO_RESTPOS

:2311	// START_TRACK
PLAY ACTION TRACK_HEAD PINK_BALL
WAIT 1000
SET scale 10	// Distance scaling factor
SET ballhint 0	// 1=left, 2=right

:2312	// SEE_BALL?(3)
WAIT 1
IF_1ST Pink_Ball <= 0 2306
CALL G_SOCCER_TRACK_BALL
  CASE:GO_DOWNPOS GO SOCCER_MUSTLAYDOWN
  CASE:GO_SITPOS GO SOCCER_MUSTSITDOWN
  CASE:GO_RESTPOS GO 2307
  CASE:GO_S_NOBALL GO 2318
  CASE:GO_S_BALLCLOSE GO 2315	// near to ball
  CASE:GO_S_SEARCH GO 2306
  CASE:GO_STANDPOS RET:GO_STANDPOS

:2314	// BALLABOVE
CALL G_SOCCER_BALLABOVE
  CASE:1 GO 2307
  CASE:2 RET:GO_WALK
GO 2312

:2315	// NEARBALL
WAIT 1
SET pan Head_Pan	// Save head position
SET tilt HEAD_TILT()	// prior to delay...
CALL G_SOCCER_KICK_BALL
  CASE:2 GO 2307
  CASE:3 GO 2306
  CASE:4 GO 2314
  CASE:GO_DOWNPOS  RET:GO_DOWNPOS
  CASE:GO_SITPOS   RET:GO_SITPOS
  CASE:GO_STANDPOS RET:GO_STANDPOS
  CASE:GO_WALK     RET:GO_WALK
if (F_NEED2REST()) 2307
GO 2305

:2318	// MOVEBACK
WAIT 1
SET init_wait Wait
PLAY ACTION+ mad_eyes
WAIT 200
PLAY ACTION WALK 180 150
SET lastmove 3	// lastmove=back
CALL G_WAIT_AWARE
if (F_NEED2REST()) 2307
GO 2305

:SOCCER_MUSTLAYDOWN
  CALL G_DEC_ENDURE
  RET:GO_DOWNPOS

:SOCCER_MUSTSITDOWN
  CALL G_DEC_ENDURE
  RET:GO_SITPOS

:SOCCER_LOSTBALL
  CALL G_YART_Soccer_LoseBall
  if (Context != GO_AHEAD) then
    RET:Context
  endif
  RET:GO_WALK



////////////////////////////////////////////////////////////////////
//
//  Someone is holding the ball above our head...
//
:G_SOCCER_BALLABOVE
if (F_NEED2REST()) then
  RET 1 // rest
endif
SET above_angle 0
SET last_teasedact -1
SET last_teasedact2 -1
SET actcount 0
RND tease 100 300	// 10-30 second timeout

:2329	// START_TRACK
CALL G_SOCCER_START_TRACK

:2330
WAIT 1
IF (Pink_Ball>0) THEN
  IF HEAD_TILT()>=above_angle 2333
  RET 3 // ball
ENDIF
RET 2 // noball

:2333	// START_TAIL
PLAY ACTION+ happy_eyes
CALL G_START_TAILWAG_NORMAL
RND impat 20 50	// 2-5 secs

:2334	// WAIT4BALL
CALL G_CHECK_SITONLY
  CASE:GO_DOWNPOS RET:2
  CASE:GO_SITPOS RET:2

WAIT 100
SUB tease 1
SUB impat 1
WAIT 1

IF (HEAD_TILT()>=above_angle) && Pink_Ball && tease 2342
IF HEAD_TILT() < above_angle 2341
IF Pink_Ball = 0 2341
IF tease > 0 2341

WAIT 1
SET init_wait Wait
#ifdef ERS210
PLAY ACTION PALONE.AUTO.TAILSTOP
#endif
PLAY ACTION MOVE_HEAD 0 0
CALL G_WAIT_AWARE
tailwag := 0

:2338	// TURN_AWAY
WAIT 1
SET init_wait Wait
RND angle 100 180	// Pick random turn.
RND temp 0 1		// Make random pos/neg.
MUL temp 2
MUL temp angle
SUB temp angle

IF Head_Pan > 0 THEN
  RND pan -20 0
ELSE
  RND pan 0 20
ENDIF

SET tilt HEAD_TILT()
PLAY ACTION MOVE_HEAD pan tilt
PLAY ACTION TURN 180
CALL G_INC_MAD_MOOD
CALL G_WAIT_AWARE
RET 2	// noball

:2341	// STOP_TAIL
WAIT 500
#ifdef ERS210
PLAY ACTION PALONE.AUTO.TAILSTOP
#endif
SET init_wait 1
GO 2330

:2342	// IMPATIENT?
IF_1ST impat > 0 2334
WAIT 1
SET pan Head_Pan
SET tilt HEAD_TILT()
SET above_angle 0	// Reset above angle...
CALL G_SOCCER_STOP_TRACK

:2345	// PICK_ACT
RND temp 0 25
IF_1ST temp = last_teasedact 2345
IF_1ST temp = last_teasedact2 2345
IF_1ST temp <= 8 2370
IF_1ST temp <= 21 2353
IF_1ST actcount < 2 2345
IF_1ST temp = 22 2352
IF_1ST temp = 23 2351
IF_1ST temp = 24 2350
CALL G_TANTRUM
SET mood_mad MOOD_MAX
SET mood_happy 0
GO 2338

:2350	// resign
PLAY ACTION RESIGNATION
WAIT
GO 2338

:2351	// so_sad
CALL G_INC_SAD_MOOD
PLAY ACTION NOD_STAND
WAIT
GO 2338

:2352	// frust
PLAY ACTION FRUSTRATED
WAIT
GO 2338

:2353	// SELECT_SITACT
SWITCH temp
  CASE:9 PLAY ACTION BEG_BALL
  CASE:10 PLAY ACTION NOBI4
  CASE:11 PLAY ACTION SIT
  CASE:12 PLAY ACTION CUTE_BANZAI1
  CASE:13 PLAY ACTION COMEON
  CASE:14 PLAY ACTION IMPATIENT_SIT1
  CASE:15 PLAY ACTION IMPATIENT_SIT2
  CASE:16 PLAY ACTION LOOKAROUND_SIT3
  CASE:17 PLAY ACTION SIGH
  CASE:18 PLAY ACTION YOUSILLY1
  CASE:19 PLAY ACTION YOUSILLY2
  CASE:20 PLAY ACTION YOUSILLY3
  CASE:ELSE PLAY ACTION YOUSILLY4
WAIT
SET last_teasedact2 last_teasedact
SET last_teasedact temp
SET above_angle -25	// Head level at -25 now
ADD actcount 1

:2356	// DEC_HAPPY_MOOD
CALL G_DEC_HAPPY_MOOD
PLAY ACTION MOVE_HEAD pan tilt
WAIT
GO 2329

:2370	// SELECT_STAND
SWITCH temp
  CASE:0 PLAY ACTION CUTE_SMILE1
  CASE:1 PLAY ACTION+ beg_leftpaw
  CASE:2 PLAY ACTION+ beg_rightpaw
  CASE:3 PLAY ACTION CUTE_BARK2
  CASE:4 PLAY ACTION LETSPLAY1
  CASE:5 PLAY ACTION LETSPLAY2
  CASE:6 PLAY ACTION LEANRIGHT
  CASE:7 PLAY ACTION WANTBALL
  CASE:ELSE PLAY ACTION TUNE_JAWS
WAIT
SET last_teasedact2 last_teasedact
SET last_teasedact temp
ADD actcount 1
GO 2356

:2383	// ball
RET 3



////////////////////////////////////////////////////////////////////
//
//  Estimate Distance to the Ball...
//
:G_SOCCER_DIST2BALL
IF Pink_Ball==0 THEN
  RET 1 // noball
ENDIF

WAIT 1
SET tilt Head_Tilt
if (tilt>=10) 2401 // ball-above
if ((tilt<=-60) && (Head_Pan>-20) && (Head_Pan<20)) || (tilt<=-65) 2402 // ball in front
if (tilt>-45) && (Pink_Ball_Dist<PINK_BALL_NEAR) then
  PRINT "dist2ball: Pink Near dist=%d tilt=%d pan=%d" Pink_Ball_Dist tilt Head_Pan
  GO 2402
endif

IF_1ST tilt > 0 2400
IF_1ST tilt > -10 2399
IF_1ST tilt > -15 2398
IF_1ST tilt > -20 2397
IF_1ST tilt > -30 2396
IF_1ST tilt > -40 2395
IF_1ST tilt > -60 2394
SET d 20
ADD tilt 70
MUL tilt 3
ADD d tilt

:2389	// ADJUST_DIST
MUL d scale
DIV d 10
SUB d 20

IF d > 1000 THEN // max
  SET d 1000
ENDIF
IF d < 0 THEN // min
  SET d 0
ENDIF
RET 2	// balldist

:2394	// TILT60
SET d 50
ADD tilt 60
MUL tilt 6
ADD d tilt
GO 2389

:2395	// TILT40
SET d 170
ADD tilt 40
MUL tilt 9
ADD d tilt
GO 2389

:2396	// TILT30
SET d 260
ADD tilt 30
MUL tilt 12
ADD d tilt
GO 2389

:2397	// TILT20
SET d 380
ADD tilt 20
MUL tilt 20
ADD d tilt
GO 2389

:2398	// TILT15
SET d 480
ADD tilt 15
MUL tilt 62
ADD d tilt
GO 2389

:2399	// TILT10
SET d 800
GO 2389

:2400	// ABOVE
SET d 200
GO 2389

:2401	// ABOVE10
SET d 0
RET 3	// ballabove

:2402	// BALL
SET d 0
RET 4	// nearball



////////////////////////////////////////////////////////////////////
//
//  Try to infer where ball might have gone, based on last 
//  head track position...
//
:G_SOCCER_INFER_BALL
SET panr pan
SET panl pan
SET tiltd tilt
SET tiltu tilt
SUB panr 5
ADD panl 5
SUB tiltd 5
ADD tiltu 5
SET pan2 0

WAIT 1

// Maybe to the right?  
IF Head_Pan < panr THEN
  IF HEAD_TILT() > tilt THEN // Right-forward
    SET d 300
  ELSE
    SET d 0
  ENDIF
  GO G_SOCCER_SEARCHTURN
ENDIF

// Maybe to the right?
IF Head_Pan > panl THEN
  IF HEAD_TILT() > tilt THEN // Left-forward
    SET d 300
  ELSE
    SET d 0
  ENDIF
  GO G_SOCCER_SEARCHTURN
ENDIF

// Maybe forward?
IF HEAD_TILT() > tiltu THEN
  SET d 300
  GO G_SOCCER_SEARCHTURN
ENDIF

IF HEAD_TILT() >= tiltd THEN
  RET:GO_IDLE
ENDIF

PLAY ACTION WALK 180 200
RET:GO_IDLE



////////////////////////////////////////////////////////////////////
//
//  Kick the ball...
//
:G_SOCCER_KICK_BALL
WAIT 1

// If no ball, try to infer where it went...
IF Pink_Ball == 0 THEN
  CALL G_SOCCER_INFER_BALL
    CASE:GO_SEEBALL RET:1
  RET 3
ENDIF

CALL G_SOCCER_DIST2BALL
  CASE:1 RET 3	// noball
  CASE:2 RET 1	// track
  CASE:3 RET 4	// ballabove
WAIT 1

// Check to see if can kick from walking posture...
IF (Posture1 == POSTURE_WALK) && (HEAD_TILT()<-70) THEN
  IF ((Head_Pan<-5) && (Head_Pan>-35)) || ((Head_Pan>5) && (Head_Pan<35)) THEN
    CALL G_SOCCER_OK_TO_KICK
      CASE:1 GO SKB_SMALLSTEP
      CASE:2 GO SKB_WALKPOSE_KICK
  ENDIF
ENDIF

// If not standing straight already, see if too close to ball.  Backup slightly if so...
if (Posture1 != POSTURE_STAND) then
  WAIT 1
  while (Pink_Ball>0) && (Pink_Ball_Vert<0) && (HEAD_TILT()<-73) && (Wait!=0) 
    SET init_wait Wait
    PLAY ACTION WALK 180 10	// Take a step backwards
    CALL G_WAIT_AWARE
    WAIT 500
  wend

  if Pink_Ball==0 then
    RET 3 // noball
  endif

  // Stand straight...
  WAIT 1
  SET init_wait Wait
  PLAY ACTION STOP_WALK
  CALL G_WAIT_AWARE
endif

// Stop tracking the ball...
CALL G_SOCCER_STOP_TRACK

// Call customization routine...
CALL G_CUSTOM_SOCCER_KICK
  CASE:GO_DOWNPOS  RET:GO_DOWNPOS
  CASE:GO_SITPOS   RET:GO_SITPOS
  CASE:GO_STANDPOS RET:GO_STANDPOS
  CASE:GO_WALK     RET:GO_WALK

// Still close enough to kick?
CALL G_SOCCER_CLOSE_ENOUGH?
  CASE:GO_S_NOBALL RET 3	// noball
  CASE:GO_S_TRACK GO SKB_NOKICK

// Close enough...
CALL G_SOCCER_INIT_KICK

// 80% of time do a normal kick...
IF F_RND100()<80 THEN
  // If mad, only aibo kicks are performed.  Good mood needed to do something fancy.
  // This intentionally creates situations where Aibo misses & makes himself angrier.
  // Otherwise, 4/5ths of time do aibo kick (if ball in range)...
  if (!F_BEHAVIOR_RND()) then
    RET 2 // no kick options available?
  endif

  WAIT 1
  IF (Pink_Ball==0) SKB_SURPRISE	// Hey?!?
  if (mood_mad>1) || ((rndnum==rndbase) && (pan>=-35) && (pan<=35) && (tilt<=-65)) then
    SET init_wait 1
    PLAY ACTION TRACK_HEAD PINK_BALL
    CALL G_SKB_AIBOKICK // do soccer kick that allows head to track
    GO SKB_WAIT4KICK
  endif
ELSE
  // See if ball close enough to touch...
  CALL G_SOCCER_TOUCH_BALL
    CASE:GO_S_NOBALL GO SKB_SURPRISE
    CASE:GO_S_TRACK GO SKB_NOKICK
ENDIF

// Select swing kick to use...
CALL G_SOCCER_CHECK_SWING
  CASE:GO_S_TRACK GO SKB_NOKICK

// Perform the kick...
CALL G_SOCCER_PLAY_SWING
  CASE:GO_S_KICKED GO SKB_WAIT4KICK

:SKB_NOKICK
SET pan 999
SET tilt 999

:SKB_RESUMETRACK
SET init_wait 1
PLAY ACTION TRACK_HEAD PINK_BALL
SUB TIMER_TIRED 3 // accelerate getting tired (since tired timer doesn't work here...)

:SKB_WAIT4KICK	
CALL G_WAIT_AWARE
SET kick_pan pan
SET kick_tilt tilt
RET 1	// track


// Kick ball from walking pose, but need small step to get 
// into a stable stance to avoid a face-plant...
:SKB_SMALLSTEP
WAIT 1
SET init_wait Wait
PLAY ACTION WALK 0 10
CALL G_WAIT_AWARE

// Kick ball from walking pose...
:SKB_WALKPOSE_KICK
WAIT 1
IF Head_Pan > 0 THEN // kick left
  PRINT KICKL
  SET pan Head_Pan
  SET tilt HEAD_TILT()
  PLAY ACTION KICK LEFTFRONT
  SET last_kick 1
ELSE
  PRINT KICKR
  SET pan Head_Pan
  SET tilt HEAD_TILT()
  PLAY ACTION KICK RIGHTFRONT
  SET last_kick 2
ENDIF
GO SKB_RESUMETRACK

:SKB_SURPRISE
CALL G_SURPRISE
RET 3	// noball



////////////////////////////////////////////////////////////////////
//
//  Update mood after kicking (or missing ball).  See if it 
//  moved and update...
//
:G_SOCCER_KICK_MOOD

// If no kick has occured, exit now...
IF (kick_tilt>=999) && (kick_pan>=999) THEN
  RET 2
ENDIF

WAIT 1
SET pan Head_Pan	// Remember where head currently pointed.
SET tilt HEAD_TILT()
SUB kick_pan pan	// Compute movement.
SUB kick_tilt tilt

// If ball moved more than 15 degrees, get happy...
if (kick_pan>15) || (kick_pan<-15) || (kick_tilt>15) || (kick_tilt<-15) then
  // Yea!  Kicked the ball!!!
  PRINT KICKED_BALL
  SET miss_count 0
  ADD soccer 2
  CALL G_INC_HAPPY_MOOD
  CALL G_DEC_MAD_MOOD

  // Occasionally do a happy dance...
  if (F_RND100()>=75) && (mood_happy>=4) && (mood_mad<=0) then
    CALL G_YART_Soccer_Happy
    if (Context == GO_AHEAD) CALL G_HAPPYDANCE
    GO SKM_LOOK2BALL
  endif

  CALL G_YART_Soccer_GoodKick
  if (Context==GO_AHEAD) then
    WAIT 1
    SET init_wait Wait
    PLAY ACTION+ happy_eyes
    CALL G_WAIT_AWARE
  endif
  GO SKM_DONE
endif

// Otherwise, not happy...
PRINT "MISSED_BALL"
ADD miss_count 1
SUB soccer 1
CALL G_INC_MAD_MOOD
CALL G_DEC_HAPPY_MOOD

// If getting mad, show our frustration...
if (F_RND100()<50) && (mood_mad>=4) && POSE_STANDING() then
  CALL G_YART_Soccer_Frustrated
  if (Context==GO_AHEAD) then
    WAIT 1
    SET init_wait Wait
    PLAY ACTION FRUSTRATED
    CALL G_WAIT_AWARE
  endif
  GO SKM_LOOK2BALL
endif

CALL G_YART_Soccer_MissedKick
if (Context==GO_AHEAD) then
  // Flash mad eye's...
  WAIT 1
  SET init_wait Wait
  PLAY ACTION+ mad_eyes
  CALL G_WAIT_AWARE
endif

:SKM_DONE
SET kick_pan 999
SET kick_tilt 999
CALL G_SAVE_SOCCER
RET 1	// done


// Look at ball & resume soccer play...
:SKM_LOOK2BALL	
WAIT 1
SET init_wait Wait
PLAY ACTION MOVE.HEAD.FAST pan tilt
CALL G_WAIT_AWARE
CALL G_SOCCER_START_TRACK
GO SKM_DONE




////////////////////////////////////////////////////////////////////
//
//  Look for the ball...
//  Return:
//    GO_IDLE - Didn't find ball
//    GO_SEEBALL - Found the ball
//
:G_SOCCER_LOOK4BALL
  LOCAL slb_temp 0
  CALL G_SOCCER_STOP_TRACK

  WAIT 1
  SET init_wait Wait

  // Center up head position before starting ball search...
  PLAY ACTION MOVE_HEAD 0 -60
  WHILE (Wait>0) && (Wait>init_wait) && (Pink_Ball==0) && (slb_temp<600)
    ADD slb_temp 1
    WAIT 100
  WEND

  IF Pink_Ball > 0 THEN
    RET GO_SEEBALL
  ENDIF

  IF searchmode == 0 THEN // search low
    PLAY ACTION SEARCH.HEAD.LOWCENT PINK_BALL
  ELSE
    IF F_RND100() < 33 THEN // search fast
      PLAY ACTION SEARCH.HEAD.FASTCENT PINK_BALL
    ELSE
      PLAY ACTION SEARCH.HEAD.NORMALCENT PINK_BALL
    ENDIF
  ENDIF

  // Wait for search to complete...
  SET slb_temp 0
  WHILE (Wait>0) && (Wait>init_wait) && (Pink_Ball==0) && (slb_temp<600)
    ADD slb_temp 1
    WAIT 100
  WEND

  IF Pink_Ball > 0 THEN
    RET GO_SEEBALL
  ENDIF

  RET GO_IDLE




////////////////////////////////////////////////////////////////////
//
//  Move to ball, keeping an eye out for obstructions & cliff's...
//
:G_SOCCER_MOVE2BALL
PRINT "MOVE2BALL"

CALL G_SOCCER_DIST2BALL
  CASE:1 GO 2520 // noball
  CASE:3 RET 6   // ballabove
  CASE:4 RET 5   // nearball

WAIT 1
IF Wait == 0 THEN			// Resume tracking.
  PLAY ACTION TRACK_HEAD PINK_BALL
  WAIT 500
  GO G_SOCCER_MOVE2BALL
ENDIF

// If tracking not good, loop...
IF (Wait < 1) || (Pink_Ball==0) THEN
  WAIT 250
  GO G_SOCCER_MOVE2BALL
ENDIF

WAIT 1
SET dd d
RND temp 0 1				// Randomly decide to
MUL temp Head_Pan			// walk at an angle
SET lastmove 2				// towards ball...

RND rndnum 0 100
IF_1ST d < 200 2518			// If close, or normal
IF_1ST last_walkmode = 0 2518		//  walk used earlier...
IF_1ST last_walkmode = 1 2501		// If stalked before...
IF_1ST Posture1 <> POSTURE_STAND 2518	// If already walking,
IF_1ST rndnum < 80 2518			//  do normal walk.

:2501	// STALK1
SET last_walkmode 1
PLAY ACTION BALLSTALK temp d

:2502	// HEAD_POSITION
WAIT 1
SET tilt HEAD_TILT()
SET pan Head_Pan
CALL G_SOCCER_ATTENTION_HANDLER
  CASE:GO_DOWNPOS RET 2	 // down
  CASE:GO_RESTPOS RET 1	 // rest
  CASE:GO_SITPOS RET 7	 // sit
  CASE:GO_STANDPOS RET 8 // search
  CASE:GO_STOP RET 9	 // stand
WAIT 1

IF Pink_Ball == 0 THEN
  WAIT 1
  SET init_wait Wait
  PLAY ACTION WALK 0 0
  CALL G_WAIT_AWARE
  WAIT 500
  RET 3	// noball
ENDIF

IF tilt >= 10 THEN
  WAIT 1
  SET init_wait Wait
  PLAY ACTION WALK 0 0
  CALL G_WAIT_AWARE
  WAIT 500
  RET 6 // ballabove
ENDIF

CALL G_SOCCER_NEAR2BALL?
  CASE:1 GO 2509
WAIT 1
SET init_wait Wait
PLAY ACTION WALK 0 0
CALL G_WAIT_AWARE

:2508	// PAN2BALL?
CALL G_SOCCER_PAN2BALL?
  CASE:1 GO G_SOCCER_MOVE2BALL
RET 5	// nearball

:2509	// WALKING?
WAIT 1
IF_1ST Wait <= 1 2508

// If looking straight & distance is too far, might be a cliff!
IF (HEAD_TILT()<-30) && (Head_Pan<30) && (Head_Pan>-30) && (Distance>CLIFFDIST) THEN
  WAIT 1
  SET init_wait Wait
  PLAY ACTION+ sad_eyes
  PLAY ACTION WALK 0 0
  CALL G_WAIT_AWARE

  // Once standing still, if still see cliff, exit...
  IF (HEAD_TILT()<-30) && (Head_Pan<30) && (Head_Pan>-30) && (Distance>CLIFFDIST) THEN
    RET 4
  ENDIF
  GO G_SOCCER_MOVE2BALL
ENDIF

WAIT 100
GO 2502


:2518	// WALK
SET last_walkmode 0
PLAY ACTION WALK temp d
GO 2502

:2520	// debug2
WAIT 200
RET 3	// noball



////////////////////////////////////////////////////////////////////
//
//  SOCCER NEAR2BALL?
//
:G_SOCCER_NEAR2BALL?
WAIT 1
if (tilt>-45) && (Pink_Ball_Dist<PINK_BALL_NEAR) then
  PRINT "dist2ball: Pink Near dist=%d tilt=%d pan=%d" Pink_Ball_Dist tilt pan
  RET 2 // yes
endif

// If stalking, close enough?
if (last_walkmode==1) then 
  if ((tilt<=-40) && (pan>-20) && (pan<20)) || (tilt<=-50) then
    RET 2 // yes
  endif
  RET 1	// no
endif

// Close enough while walking normally?
if ((mood_mad<2) && (tilt<=-60) && (pan>-20) && (pan<20)) || (tilt<=-70) then
  RET 2 // yes
endif

// Need to turn?
if (tilt<=-50) && ((pan>40) || (pan<-40)) then
  RET 3 // turn
endif
RET 1 // no



////////////////////////////////////////////////////////////////////
//
//  Check if ok to kick from walking position? (versas standing)...
//
:G_SOCCER_OK_TO_KICK
WAIT 1
SET mRFLeg_1 RFLeg_1/8
SET mRFLeg_2 RFLeg_2/8
SET mRFLeg_3 RFLeg_3/8
SET mLFLeg_1 LFLeg_1/8
SET mLFLeg_2 LFLeg_2/8
SET mLFLeg_3 LFLeg_3/8
SET mRRLeg_1 RRLeg_1/8
SET mRRLeg_2 RRLeg_2/8
SET mRRLeg_3 RRLeg_3/8
SET mLRLeg_1 LRLeg_1/8
SET mLRLeg_2 LRLeg_2/8
SET mLRLeg_3 LRLeg_3/8

IF_1ST mRFLeg_1 = -1 2578
IF_1ST mRFLeg_1 = 0 2578

:2542	// CROUCH?(1)
IF_1ST mRFLeg_2 = -1 2574
IF_1ST mRFLeg_2 = 0 2574

:2543	// OK?(1)
SWITCH mRFLeg_1
  CASE:1 GO 2567
  CASE:0 GO 2567

:2544	// OK?(11)
SWITCH mLFLeg_1
  CASE:1 GO 2560
  CASE:0 GO 2560

:2545	// NEEDSTEP?(1)
SWITCH mRFLeg_1
  CASE:2 GO 2554
  CASE:1 GO 2554

:2546	// NEEDSTEP?(11)
SWITCH mLFLeg_1
  CASE:2 GO 2548
  CASE:1 GO 2548
RET 3	// not_ok

:2548	// NEEDSTEP?(12)
SWITCH mLFLeg_2
  CASE:0 GO 2549
  CASE:1 GO 2549
RET 3	// not_ok

:2549	// NEEDSTEP?(13)
SWITCH mRFLeg_2
  CASE:1 GO 2550
  CASE:0 GO 2550
RET 3	// not_ok

:2550	// NEEDSTEP?(14)
SWITCH mRRLeg_3
  CASE:11 GO 2551
  CASE:10 GO 2551
RET 3	// not_ok

:2551	// NEEDSTEP?(15)
SWITCH mRFLeg_3
  CASE:5 GO 2552
  CASE:6 GO 2552
RET 3	// not_ok

:2552	// NEEDSTEP?(16)
IF_1ST mRRLeg_2 = 0
IF_AND mRRLeg_2 = 1 2553
RET 3	// not_ok

:2553	// NEEDSTEP?(18)
WAIT 1
IF_1ST mLFLeg_3 = 2
IF_AND mRFLeg_1 = -1
IF_AND mLRLeg_1 = -5
IF_AND mLRLeg_2 = 1
IF_AND mLRLeg_3 = 12
IF_AND mRRLeg_1 = -2
IF_AND Head_Pan < 0 2582
RET 3	// not_ok

:2554	// NEEDSTEP?(2)
SWITCH mRFLeg_2
  CASE:0 GO 2555
  CASE:1 GO 2555
GO 2546

:2555	// NEEDSTEP?(3)
SWITCH mLFLeg_2
  CASE:1 GO 2556
  CASE:0 GO 2556
GO 2546

:2556	// NEEDSTEP?(4)
SWITCH mLRLeg_3
  CASE:11 GO 2557
  CASE:10 GO 2557
GO 2546

:2557	// NEEDSTEP?(5)
SWITCH mLFLeg_3
  CASE:5 GO 2558
  CASE:6 GO 2558
GO 2546

:2558	// NEEDSTEP?(6)
IF_1ST mLRLeg_2 = 0
IF_AND mLRLeg_2 = 1 2559
GO 2546

:2559	// NEEDSTEP?(8)
WAIT 1
IF_1ST mRFLeg_3 = 2
IF_AND mLFLeg_1 = -1
IF_AND mRRLeg_1 = -5
IF_AND mRRLeg_2 = 1
IF_AND mRRLeg_3 = 12
IF_AND mLRLeg_1 = -2
IF_AND Head_Pan > 0 2582
GO 2546

:2560	// OK?(12)
SWITCH mRRLeg_2
  CASE:3 GO 2561
  CASE:2 GO 2561
GO 2545

:2561	// OK?(13)
IF_1ST mRFLeg_1 = -1 2562
IF_1ST mRFLeg_1 <> 0 2545

:2562	// OK?(14)
SWITCH mRRLeg_3
  CASE:11 GO 2563
  CASE:10 GO 2563
GO 2545

:2563	// OK?(15)
IF_1ST mLRLeg_1 = -4 2564
IF_1ST mLRLeg_1 <> -3 2545

:2564	// OK?(16)
SWITCH mRFLeg_2
  CASE:2 GO 2565
  CASE:1 GO 2565
GO 2545

:2565	// OK?(17)
SWITCH mRFLeg_3
  CASE:3 GO 2566
  CASE:2 GO 2566
GO 2545

:2566	// OK?(18)
WAIT 1
IF_1ST mLFLeg_2 = 0
IF_AND mLFLeg_3 = 2
IF_AND mLRLeg_2 = 0
IF_AND mLRLeg_3 = 12
IF_AND mRRLeg_1 = -6
IF_AND Head_Pan < 0 2583
GO 2545

:2567	// OK?(2)
SWITCH mLRLeg_2
  CASE:3 GO 2568
  CASE:2 GO 2568
GO 2544

:2568	// OK?(3)
IF_1ST mLFLeg_1 = -1 2569
IF_1ST mLFLeg_1 <> 0 2544

:2569	// OK?(4)
SWITCH mLRLeg_3
  CASE:11 GO 2570
  CASE:10 GO 2570
GO 2544

:2570	// OK?(5)
IF_1ST mRRLeg_1 = -4 2571
IF_1ST mRRLeg_1 <> -3 2544

:2571	// OK?(6)
SWITCH mLFLeg_2
  CASE:2 GO 2572
  CASE:1 GO 2572
GO 2544

:2572	// OK?(7)
SWITCH mLFLeg_3
  CASE:3 GO 2573
  CASE:2 GO 2573
GO 2544

:2573	// OK?(8)
WAIT 1
IF_1ST mRFLeg_2 = 0
IF_AND mRFLeg_3 = 2
IF_AND mRRLeg_2 = 0
IF_AND mRRLeg_3 = 12
IF_AND mLRLeg_1 = -6
IF_AND Head_Pan > 0 2583
GO 2544

:2574	// CROUCH?(2)
IF_1ST mLFLeg_2 = -1 2575
IF_1ST mLFLeg_2 <> 0 2543

:2575	// CROUCH?(3)
IF_1ST mRRLeg_1 = -2 2576
IF_1ST mRRLeg_1 <> -3 2543

:2576	// CROUCH?(4)
IF_1ST mLRLeg_1 = -2 2577
IF_1ST mLRLeg_1 <> -3 2543

:2577	// CROUCH?(5)
IF_1ST mRFLeg_1 = -3
IF_AND mRFLeg_3 = 8
IF_AND mLFLeg_1 = -3
IF_AND mLFLeg_3 = 8
IF_AND mRRLeg_2 = 0
IF_AND mRRLeg_3 = 9
IF_AND mLRLeg_2 = 0
IF_AND mLRLeg_3 = 9 2583
GO 2543

:2578	// STANDING?(2)
IF_1ST mLFLeg_1 = -1 2579
IF_1ST mLFLeg_1 <> 0 2542

:2579	// STANDING?(3)
SWITCH mRRLeg_3
  CASE:3 GO 2580
  CASE:2 GO 2580
GO 2542

:2580	// STANDING?(4)
SWITCH mLRLeg_3
  CASE:3 GO 2581
  CASE:2 GO 2581
GO 2542

:2581	// STANDING?(5)
IF_1ST mRFLeg_2 = 0
IF_AND mRFLeg_3 = 3
IF_AND mLFLeg_2 = 0
IF_AND mLFLeg_3 = 3
IF_AND mRRLeg_1 = 0
IF_AND mRRLeg_2 = 0
IF_AND mLRLeg_1 = 0
IF_AND mLRLeg_2 = 0 2583
GO 2542

:2582	// needstep
RET 1

:2583	// kick_ok
RET 2



////////////////////////////////////////////////////////////////////
//
//  Do we need to turn to the ball?
//
:G_SOCCER_PAN2BALL?
WAIT 1
IF_1ST miss_count >= 2 2591
IF_1ST Head_Pan > 39 2593
IF_1ST Head_Pan < -39 2593
IF_1ST Head_Pan > 34 2590
IF_1ST Head_Pan < -34 2590
IF_1ST Head_Pan = 34 2589
IF_1ST Head_Pan = -34 2589
IF_1ST Head_Pan = 33 2588
IF_1ST Head_Pan <> -33 2592

:2588	// PAN33
WAIT 1
IF Head_Tilt > -66 2593
RET 1	// noturn

:2589	// PAN34
WAIT 1
IF Head_Tilt > -71 2593
RET 1	// noturn

:2590	// PAN35
WAIT 1
IF Head_Tilt > -75 2593
RET 1	// noturn

:2591	// MISS_PAN?
WAIT 1
IF Head_Pan > 10 2593
IF Head_Pan < -10 2593

:2592	// noturn
RET 1

:2593	// turn
RET 2


////////////////////////////////////////////////////////////////////
//
//  Search for the ball (forward, move back, turn to sides, etc...)
//
//++CALL G_SOCCER_SEARCH4BALL // Search for Ball
:G_SOCCER_SEARCH4BALL
SET searchmode 1
SET searchmove 0	// Set if move while searching
CALL G_SOCCER_LOOK4BALL
  CASE:GO_IDLE GO 2606

:SSB_LOOP	// NEED2REST?
if (F_NEED2REST()) then
  RET 1 // rest
endif

SWITCH F_SEE_BALL()
  CASE:GO_IGNORE RET 1  // rest
  CASE:GO_SEEBALL RET 2	// ball

:2600	// NOBALL
SET kick_tilt 999	// Clear kick track
SET kick_pan 999
CALL G_RANDOM3
  CASE:1 PLAY ACTION+ ummm
  CASE:2 PLAY ACTION OHWELL
  CASE:3 PLAY ACTION SAD8
WAIT
RET 3	// noball

:2606	// MOOD?
IF_1ST mood_mad > 0 2600
IF_1ST mood_happy > 3 2611

:2607	// RANDOM
RND rndnum 0 100
IF_1ST ballhint > 0 2609
IF_1ST rndnum < 33 2600		// Don't bother...
IF_1ST rndnum < 66 2611		// Turn left/right...
IF_1ST lastmove >= 3 2607	// Move back (if last

:2609	// MOVE_BACK
PLAY ACTION WALK 180 200
WAIT
SET lastmove 3		// back
SET kick_tilt 999	// Force kick success
SET searchmode 0
SET searchmove 1	// Moved.
CALL G_SOCCER_LOOK4BALL
  CASE:GO_SEEBALL GO SSB_LOOP

:2611	// HINT?
RND sign 0 1
MUL sign 2
SUB sign 1

SWITCH ballhint
  CASE:1 SET sign 1	// turn left first
  CASE:2 SET sign -1	// turn right first

SET ballhint 0
RND turndelta 90 150
MUL turndelta sign
SET pan turndelta
SET d 0
SET pan2 0
SET searchmode 1
SET kick_tilt 999	// Force kick success
SET searchmove 1
CALL G_SOCCER_SEARCHTURN
  CASE:GO_SEEBALL GO SSB_LOOP

if (mood_happy<5) && (F_RND100()<50) 2600

SET pan 270
MUL pan sign
SUB pan turndelta
CALL G_SOCCER_SEARCHTURN
  CASE:GO_SEEBALL GO SSB_LOOP
CALL G_SOCCER_SEARCHTURN
  CASE:GO_SEEBALL GO SSB_LOOP
GO 2600



////////////////////////////////////////////////////////////////////
//
//  Turn while also looking for ball...
//
//  Inputs:
//    pan (first turn)
//    d (walk distance)
//    pan2 (second turn)
//
//  Returns:
//    GO_IDLE - Didn't find ball
//    GO_SEEBALL - Found the ball
//
:G_SOCCER_SEARCHTURN
  // Start first turn...
  if (F_RND100()<33) then
    PLAY ACTION MOVE.TURN.FAST pan
  else
    PLAY ACTION TURN pan
  endif
  // Wait while turning...
  while (Wait>0) && (Pink_Ball==0)
    WAIT 1
  wend
  if (Wait>0) && (Pink_Ball>0) then
    CALL G_SOCCER_STOP_TRACK
    RET GO_SEEBALL
  endif

  // Need to walk?
  if (d>0) then
    if (F_RND100()<33) then
      PLAY ACTION MOVE.MOVE.FAST 0 d
    else
      PLAY ACTION WALK 0 d
    endif
    // Wait while walking...
    while (Wait>0) && (Pink_Ball==0)
      WAIT 1
    wend
    if ((Wait>0) && (Pink_Ball>0)) || (Distance<200) then
      CALL G_SOCCER_STOP_TRACK
      RET GO_SEEBALL
    endif
  endif

  // Need second turn?
  if (pan2!=0) then
    if (F_RND100()<33) then
      PLAY ACTION MOVE.TURN.FAST pan2
    else
      PLAY ACTION TURN pan2
    endif
    // Wait while turning...
    while (Wait>0) && (Pink_Ball==0)
      WAIT 1
    wend
    if (Wait>0) && (Pink_Ball>0) then
      CALL G_SOCCER_STOP_TRACK
      RET GO_SEEBALL
    endif
  endif

  GO G_SOCCER_LOOK4BALL



////////////////////////////////////////////////////////////////////
//
//  Start tracking ball, if not already...
//
:G_SOCCER_START_TRACK

:2648	// STALL
WAIT 100
WAIT 1
IF_1ST Wait = 0 2651	// Resume tracking.
IF_1ST Wait > 0
IF_AND Pink_Ball > 0 2652	// Tracking ok.  Move.
WAIT 1000
GO 2648

:2651	// TRACK_BALL
PLAY ACTION TRACK_HEAD PINK_BALL
WAIT 500

:2652	// RETURN
RET 1



////////////////////////////////////////////////////////////////////
//
//  Stop tracking the ball...
//
:G_SOCCER_STOP_TRACK
WAIT 1
IF Wait < 1 THEN
  WAIT 100
  RET 1
ENDIF

WAIT 500
IF Wait > 0 THEN
  STOP
  CALL G_WAITZERO
ENDIF
RET 1


////////////////////////////////////////////////////////////////////
//
// SOCCER TRACK_BALL
//
:G_SOCCER_TRACK_BALL
SET last_walkmode -1	// 0=norm 1=stalk 2=turn
SET walking WALKING_SOCCER
ADD soccer 1
VSAVE soccer

:STB_START_TRACKING
if (F_NEED2REST()) then
  RET:GO_RESTPOS
endif

CALL G_SOCCER_KICK_MOOD
if mood_mad>6 then
  RET:GO_RESTPOS
endif

CALL G_SOCCER_ATTENTION_HANDLER
  CASE:GO_DOWNPOS RET GO_DOWNPOS
  CASE:GO_RESTPOS RET GO_RESTPOS
  CASE:GO_SITPOS RET GO_SITPOS
  CASE:GO_STOP RET GO_STANDPOS
  CASE:GO_STANDPOS RET GO_S_SEARCH

CALL G_SOCCER_TURN2BALL
  CASE:1 RET GO_RESTPOS	
  CASE:2 RET GO_DOWNPOS	
  CASE:3 RET GO_S_NOBALL
  CASE:5 RET GO_SITPOS
  CASE:6 RET GO_STANDPOS
  CASE:7 RET GO_S_SEARCH

CALL G_SOCCER_ATTENTION_HANDLER
  CASE:GO_DOWNPOS RET GO_DOWNPOS
  CASE:GO_RESTPOS RET GO_RESTPOS
  CASE:GO_SITPOS RET GO_SITPOS
  CASE:GO_STOP RET GO_STANDPOS
  CASE:GO_STANDPOS RET GO_S_SEARCH

CALL G_SOCCER_MOVE2BALL
  CASE:1 RET GO_RESTPOS
  CASE:2 RET GO_DOWNPOS
  CASE:3 RET GO_S_NOBALL
  CASE:4 GO 2674 // cliff
  CASE:5 GO 2672 // nearball
  CASE:7 RET GO_SITPOS
  CASE:8 RET GO_S_SEARCH
  CASE:9 RET GO_STANDPOS

// ballabove
WAIT 500
CALL G_SOCCER_PAN2BALL?
  CASE:1 RET GO_S_BALLABOVE
GO STB_START_TRACKING

:2672	// SETTLE
WAIT 500
CALL G_SOCCER_PAN2BALL?
  CASE:1 RET GO_S_BALLCLOSE
GO STB_START_TRACKING

:2674	// STOP_TRACK
CALL G_SOCCER_STOP_TRACK
CALL G_WALK_FOUND_CLIFF
  CASE:1 RET GO_S_NOBALL
  CASE:2 RET GO_S_NOBALL
  CASE:3 RET GO_RESTPOS
  CASE:4 GO STB_START_TRACKING
  CASE:6 RET GO_SITPOS
  CASE:7 RET GO_S_SEARCH
RET 1



////////////////////////////////////////////////////////////////////
//
//  Turn to ball & leave head pointing at it...
//
:G_SOCCER_TURN2BALL
WAIT 1
if (Pink_Ball==0) then
  RET 3 // noball
endif

CALL G_SOCCER_PAN2BALL?
  CASE:1 RET 4 // ball

lastmove := Head_Pan<0
CALL G_SOCCER_START_TRACK

WAIT 1
SET pan Head_Pan
SET init_turnwait Wait
SET last_walkmode 2	// Last move was turn
PLAY ACTION TURN pan

repeat
  CALL G_SOCCER_ATTENTION_HANDLER
    CASE:GO_DOWNPOS RET 2  // down
    CASE:GO_RESTPOS RET 1  // rest
    CASE:GO_SEEBALL RET 4  // ball
    CASE:GO_SITPOS RET 5   // sit
    CASE:GO_STOP RET 6	   // stop
    CASE:GO_STANDPOS RET 7 // stand
  WAIT 1
until (Wait==0) || ((Pink_Ball>0) && (Wait<=init_turnwait)) || (F_ABS(Head_Pan)<10) 

PLAY ACTION TURN 0
SET last_walkmode -1

WAIT 1
IF Pink_Ball > 0 then
  RET 4 // ball
endif
RET 3 // noball



////////////////////////////////////////////////////////////////////
//
//  Determine if we are close enough to ball for a kick...
//
:G_SOCCER_CLOSE_ENOUGH?
WAIT 1
IF Pink_Ball == 0 THEN
  RET:GO_S_NOBALL // noball
ENDIF

IF (Head_Tilt>-45) && (Pink_Ball_Dist<PINK_BALL_NEAR) THEN
  PRINT "close enough: Pink Near dist=%d tilt=%d pan=%d" Pink_Ball_Dist Head_Tilt Head_Pan
  RET:GO_S_BALLCLOSE
ENDIF

IF (Head_Pan>39) || (Head_Pan<-39) || (Head_Tilt>-60) THEN
  RET:GO_S_TRACK
ENDIf

IF ((Head_Pan>34) || (Head_Pan<-34)) && (Head_Tilt>-70) THEN
  RET:GO_S_TRACK
ENDIF

IF ((Head_Pan==34) || (Head_Pan==-34)) && (Head_Tilt>-71) THEN
  RET:GO_S_TRACK
ENDIF

IF ((Head_Pan==33) || (Head_Pan==-33)) && (Head_Tilt>-66) THEN
  RET:GO_S_TRACK
ENDIF

RET:GO_S_BALLCLOSE



////////////////////////////////////////////////////////////////////
//
//  Pick a soccer skit based on the ball's position.  The 'ballhint'
//  variable gives a heads-up to the soccer search routine (after all,
//  if you kick left, one might assume the ball would go that way)...
//
:G_SOCCER_CHECK_SWING
SET swing_kick 0
SET kickcount 0

// Belly flop kick forward (zone 1)...
IF (pan>=-30) && (pan<-18) && (tilt>=-70) && (tilt<-60) THEN
  PRINT BELLYFWD
  SET swing_kick 6
  swing_kick := kickcheck[kickcount++] := 6
ENDIF

// Belly flop kick forward (zone 2)...
IF (pan<=30) && (pan>18) && (tilt>=-70) && (tilt<-60) THEN
  PRINT BELLYFWD
  swing_kick := kickcheck[kickcount++] := 6
ENDIF

// Belly flop kick to right (zone 1)...
IF (pan<-34) && (tilt<-70) THEN
  PRINT BELLYR
  swing_kick := kickcheck[kickcount++] := 7
ENDIF

// Belly flop kick to right (zone 2)...
IF (pan<-18) && (tilt>=-70) && (tilt<-60) THEN
  PRINT BELLYR
  swing_kick := kickcheck[kickcount++] := 7
ENDIF

// Belly flop kick to left (zone 1)...
IF (pan>34) && (tilt<-70) THEN
  PRINT BELLYL
  swing_kick := kickcheck[kickcount++] := 8
ENDIF

// Belly flop kick to left (zone 2)...
IF (pan>18) && (tilt>=-70) && (tilt<-60) THEN
  PRINT BELLYL
  swing_kick := kickcheck[kickcount++] := 8
ENDIF

// Side kick to right...
IF (pan<-25) && (tilt<-70) THEN
  PRINT SIDER
  swing_kick := kickcheck[kickcount++] := 9
ENDIF

// Side kick to left...
IF (pan>25) && (tilt<-70) THEN
  PRINT SIDEL
  swing_kick := kickcheck[kickcount++] := 10
ENDIF

// Big kick to right...
IF (pan<-18) && (tilt<-70) THEN
  PRINT SWINGR
  swing_kick := kickcheck[kickcount++] := 11
ENDIF

// Big kick to left...
IF (pan>18) && (tilt<-70) THEN
  PRINT SWINGL
  swing_kick := kickcheck[kickcount++] := 12
ENDIF

// Header to the right...
IF (pan<-5) && (pan>=-18) && (tilt<-65) THEN
  PRINT HEAD_R
  swing_kick := kickcheck[kickcount++] := 13
ENDIF

// Header to the left...
IF (pan>5) && (pan<=18) && (tilt<-65) THEN
  PRINT HEAD_L
  swing_kick := kickcheck[kickcount++] := 14
ENDIF

// Ball in front, but too close for straight header...
IF (pan>=-5) && (pan<=5) && (tilt<-73) THEN 
  PRINT HEAD_L
  swing_kick := kickcheck[kickcount++] := 14
ENDIF

// Header straight...
IF (pan>=-5) && (pan<=5) && (tilt>=-73) THEN
  PRINT HEADFWD
  swing_kick := kickcheck[kickcount++] := 15
ENDIF

// Header straight (ball likely held off-ground in front of us)...
IF (tilt>-45) && (Pink_Ball_Dist<PINK_BALL_NEAR) THEN
  PRINT "check swing: Pink Near dist=%d tilt=%d pan=%d" Pink_Ball_Dist tilt pan
  swing_kick := kickcheck[kickcount++] := 15
ENDIF

// If there is only one possible kick that works, use it...
IF kickcount == 1 THEN
  RET:GO_S_KICKIT
ENDIF

// If there are multiple kicks available, pick one at random...
IF kickcount > 0 THEN
  RND num 0 (kickcount-1)
  swing_kick := kickcheck[num]
  RET:GO_S_KICKIT
ENDIF

// Not in range of swing kick...
RET:GO_S_TRACK



////////////////////////////////////////////////////////////////////
//
//  Do a soccer skit based on the ball's position.  The 'ballhint'
//  variable gives a heads-up to the soccer search routine (after all,
//  if you kick left, one might assume the ball would go that way)...
//
:G_SOCCER_PLAY_SWING
SET init_wait 0

PRINT:"swing_kick = %d":swing_kick

SWITCH swing_kick 
  CASE 6 : PLAY ACTION+ kick_bellyflop_fwd
  CASE 7 : PLAY ACTION+ kick_bellyflop_right
  CASE 8 : PLAY ACTION+ kick_bellyflop_left
  CASE 9  : PLAY ACTION+ aibostand_sidekick_right
  CASE 10 : PLAY ACTION+ aibostand_sidekick_left
  CASE 11 : PLAY ACTION+ aibostand_bigkick_right
  CASE 12 : PLAY ACTION+ aibostand_bigkick_left
  CASE 13 : PLAY ACTION CONTACT.FRONT.HEADR
  CASE 14 : PLAY ACTION CONTACT.FRONT.HEADL
  CASE 15 : PLAY ACTION CONTACT.FRONT.HEAD
  CASE:ELSE RET:GO_S_TRACK

SET last_kick swing_kick

SWITCH swing_kick 
  CASE 7 : SET ballhint 2 // right
  CASE 8 : SET ballhint 1 // left 
  CASE 9  : SET ballhint 2 // right
  CASE 10 : SET ballhint 1 // left
  CASE 11 : SET ballhint 2 // right
  CASE 12 : SET ballhint 1 // left
  CASE 13 : SET ballhint 2 // right
  CASE 14 : SET ballhint 1 // left

RET:GO_S_KICKED



////////////////////////////////////////////////////////////////////
//
//  If ball properly positioned, touch it carefully, then 
//  setup to whallop it...
//
:G_SOCCER_TOUCH_BALL

// Ball missing?
WAIT 1
IF Pink_Ball = 0 THEN
  RET:GO_S_NOBALL 
ENDIF

// Touch ball?
IF (HEAD_TILT()<=-69) && (HEAD_TILT()>=-73) THEN
  IF (Head_Pan>=9) && (Head_Pan<=17) THEN 	// to the left?
    PLAY ACTION+ aibostand_touchball_left
    GO STB_LOOKATBALL
  ENDIF

  IF (Head_Pan<=-9) && (Head_Pan>=-17) THEN 	// to the right?
    PLAY ACTION+ aibostand_touchball_right
    GO STB_LOOKATBALL
  ENDIF
ENDIF

RET:GO_S_KICKIT	

// Look back at ball & decide if close enough to kick...
:STB_LOOKATBALL	
WAIT
PLAY ACTION MOVE.HEAD.FAST pan tilt
WAIT
PLAY ACTION TRACK_HEAD PINK_BALL
WAIT 1000
CALL G_SOCCER_STOP_TRACK
GO G_SOCCER_CLOSE_ENOUGH?



////////////////////////////////////////////////////////////////////
//
//  Initialize the kick behavior tracking information...
//
:G_SOCCER_INIT_KICK
WAIT 1
SET pan Head_Pan
SET tilt HEAD_TILT()
SET rndbase 1800
SET rndcount 2

// If need to initialize kick behavior, skew init so that kicks
// are initially favored 5 to 1 (instead of 1 to 1)...
if (behavior[rndbase]!=rndcount) then
  CALL G_BEHAVIOR_INIT
  behavior[++rndend] := rndbase
  behavior[++rndend] := rndbase
  behavior[++rndend] := rndbase
  behavior[++rndend] := rndbase
  behavior[rndbase+1] := rndend
endif
RET 1



////////////////////////////////////////////////////////////////////
//
//  Save soccer skill to memstick...
//
:G_SAVE_SOCCER
IF soccer < 1 THEN
  SET soccer 1
ENDIF
IF soccer > 100 THEN
  SET soccer 100
ENDIF
VSAVE soccer
RET 1



////////////////////////////////////////////////////////////////////
//
//  TURN_AWAY
//
:G_TURN_AWAY
WAIT 1

SET dir -1
IF Head_Pan > 10 THEN	// Go left if looking left...
  SET dir 1
ENDIF

IF Head_Pan >= -10 THEN	// If looking straight, go left or right...
  CALL G_RANDOM2
    CASE:1 SET dir 1
    CASE:2 SET dir -1
ENDIF

CALL G_SOCCER_STOP_TRACK

// Start turn...
RND p 150 180
MUL p dir

WAIT 1
SET init_wait Wait
PLAY ACTION TURN p
PLAY ACTION MOVE_HEAD 0 0
CALL G_WAIT_AWARE
RET 1



////////////////////////////////////////////////////////////////////
//
//  Do soccer kick.  These kicks allow the head to track the
//  ball during (looks more natural)...
//
:G_SKB_AIBOKICK
// Kick left?
if (pan>=0) && (pan<=20) then
  PRINT KICKFWDL

  SWITCH:0
  CSET:pan <= 5:1
  CSET:pan <= 10:2
  CSET:pan < 15:3
  CSET:pan < 20:4
  CASE:1 PLAY ACTION kick_center_left
  CASE:2 PLAY ACTION kick_front_left
  CASE:3 PLAY ACTION kick_front2_left
  CASE:4 PLAY ACTION kick_front3_left

  SET ballhint 1	// 1=left, 2=right
  SET last_kick 3
  RET:1
endif

// Kick right?
if (pan>=-20) && (pan<=0) then
  PRINT KICKFWDR

  SWITCH:0
  CSET:pan >= -5:1
  CSET:pan >= -10:2
  CSET:pan > -15:3
  CSET:pan > -20:4
  CASE:1 PLAY ACTION kick_center_right
  CASE:2 PLAY ACTION kick_front_right
  CASE:3 PLAY ACTION kick_front2_right
  CASE:4 PLAY ACTION kick_front3_right

  SET ballhint 2	// 1=left, 2=right
  SET last_kick 4
  RET:1
endif

// Kick to side & hope for the best...
if (pan>10) then
  PRINT KICKL
  PLAY ACTION kick_front4_left
  SET ballhint 1	// 1=left, 2=right
  SET last_kick 3
  RET:1
endif

PRINT KICKR
PLAY ACTION kick_front4_right
SET ballhint 2	// 1=left, 2=right
SET last_kick 4
RET:1



////////////////////////////////////////////////////////////////////
//
//  Process any voice commands, praise, etc...  If some action
//  was performed, try and reaquire the ball in the last place
//  it was known.
//
:G_SOCCER_ATTENTION_HANDLER
  LOCAL lastx -999
  LOCAL lasty -999

  if (F_SEETOWER_STANDPOS()==GO_IGNORE) then
    WAIT:2000
    if (Wait==0) then
      PLAY ACTION TRACK_HEAD PINK_BALL
      WAIT 2000
      PLAY ACTION MOVE.HEAD.FAST Head_Pan Head_Tilt
    endif
    if (F_SEETOWER_STANDPOS()==GO_IGNORE) then
      CALL G_TURN_AWAY
      RET:GO_STOP
    endif
  endif

  // If hungry, time to find that charger...
  if (Batt_Rest<BATTLEVEL_SELFCHARGE) then
    CALL G_SELFDOCK
    CALL G_TURN_AWAY
    RET:GO_STOP
  endif

  if (Pink_Ball>0) then
    lastx := Head_Pan
    lasty := Head_Tilt
  endif

  CALL G_WALK_ATTENTION_HANDLER
  if (Context != GO_STANDPOS) then
    RET:Context
  endif

  if (Pink_Ball>0) then
    RET:GO_SEEBALL
  endif

  if (lastx>-999) || (lasty>-999) then
    SET init_wait Wait
    PLAY ACTION MOVE.HEAD.FAST lastx lasty
    CALL G_WAIT
    WAIT:200
    if (Pink_Ball>0) then
      RET:GO_SEEBALL
    endif
  endif
  RET:GO_STANDPOS


