
////////////////////////////////////////////////////////////////////
//                                                                //
//  DogsLife Soccer Module for ERS-310                            //
//  Copyright (C) 2001-2003 by DogsBody & Ratchet Software        //
//  All Rights Reserved                                           //
//                                                                //
//  This is free software and MAY NOT be sold under any           //
//  circumstances, seperately or bundled.                         //
//                                                                //
////////////////////////////////////////////////////////////////////


#define GO_S_NOBALL 2000
#define GO_S_TRACK 2001
#define GO_S_BALLCLOSE 2002
#define GO_S_TOUCHIT 2003
#define GO_S_KICKIT 2004
#define GO_S_KICKED 2005
#define GO_S_SEARCH 2006
#define GO_S_BALLABOVE 2007

#define HEAD_TILT() F_HEAD_TILT()
#define HEAD_WALKPOS() (Head_Tilt<-10)


////////////////////////////////////////////////////////////////////
//
//  Chase and kick ball until bored or we lose it...
//
:G_SOCCER
CALL G_CHECK_SITONLY
  CASE:GO_DOWNPOS RET:GO_DOWNPOS
  CASE:GO_SITPOS RET:GO_SITPOS

CALL G_SOCCER_POSTURE

SET scale 10		// Distance scaling factor
PLAY ACTION TRACK_HEAD PINK_BALL
WAIT 500

SET lastmove -1		// 0=Left, 1=Right, 2=Fwd, 3=Back
SET kick_tilt 999	// Headtilt before last kick
SET kick_pan 999	// Headpan before last kick
SET miss_count 0	// # of consequtive misses

RND TIMER_TIRED 5 10
ADD TIMER_TIRED endure

IF Pink_Ball <= 0 THEN
  RET:GO_WALK
ENDIF

SET pan Head_Pan
SET tilt HEAD_TILT()
CALL G_STOP_HEAD

// Call YART "see-the-ball" override...
CALL G_YART_Soccer_SeeBall
if (Context != GO_AHEAD) then
  if (!POSE_STANDING()) then
    PLAY ACTION STAND
    CALL G_WAIT
  endif
else
  SET init_wait Wait
  SWITCH:behavior[BEHAVIOR_SEEBALL_MODE]
    CASE:0 PLAY ACTION TUNE_SEEBALL
    CASE:1 PLAY ACTION dog_1bark_anypos
  CALL G_WAIT
endif

CALL G_SOCCER_POSTURE

WAIT 1
IF (Head_Pan <= 10) && (Head_Pan >= -10) && (Pink_Ball > 0) THEN
  STOP
  PLAY ACTION+ happy_eyes
  WAIT
  PLAY ACTION+ pounce
  WAIT
ENDIF

:2305	// SEE_BALL?(2)
WAIT 1
if Pink_Ball > 0 then
  CALL G_SOCCER_ATTENTION_HANDLER
    CASE:GO_DOWNPOS GO SOCCER_MUSTLAYDOWN
    CASE:GO_SITPOS GO SOCCER_MUSTSITDOWN
    CASE:GO_RESTPOS GO 2307
    CASE:GO_SEEBALL GO 2311
    CASE:GO_IDLE GO 2311
    CASE:GO_STOP RET:GO_STANDPOS
endif

:2306	// SEARCH4BALL
CALL G_CHECK_SITONLY
  CASE:GO_DOWNPOS RET:GO_DOWNPOS
  CASE:GO_SITPOS RET:GO_SITPOS

CALL G_SOCCER_SEARCH4BALL
  CASE:2 GO 2305
  CASE:3 GO SOCCER_LOSTBALL

:2307	// TURN_AWAY
CALL G_TURN_AWAY
CALL G_INC_ENDURE
RET:GO_RESTPOS

:2311	// START_TRACK
PLAY ACTION TRACK_HEAD PINK_BALL
WAIT 1000
SET scale 10	// Distance scaling factor
SET ballhint 0	// 1=left, 2=right

:2312	// SEE_BALL?(3)
WAIT 1
IF_1ST Pink_Ball <= 0 2306
CALL G_SOCCER_TRACK_BALL
  CASE:GO_DOWNPOS GO SOCCER_MUSTLAYDOWN
  CASE:GO_SITPOS GO SOCCER_MUSTSITDOWN
  CASE:GO_RESTPOS GO 2307
  CASE:GO_S_NOBALL GO 2318
  CASE:GO_S_BALLCLOSE GO 2315	// near to ball
  CASE:GO_S_SEARCH GO 2306
  CASE:GO_STANDPOS RET:GO_STANDPOS

:2314	// BALLABOVE
CALL G_SOCCER_BALLABOVE
  CASE:1 GO 2307
  CASE:2 RET:GO_WALK
GO 2312

:2315	// NEARBALL
WAIT 1
SET pan Head_Pan	// Save head position
SET tilt HEAD_TILT()	// prior to delay...
CALL G_SOCCER_KICK_BALL
  CASE:2 GO 2307
  CASE:3 GO 2306
  CASE:4 GO 2314
  CASE:GO_DOWNPOS  RET:GO_DOWNPOS
  CASE:GO_SITPOS   RET:GO_SITPOS
  CASE:GO_STANDPOS RET:GO_STANDPOS
  CASE:GO_WALK     RET:GO_WALK
if (F_NEED2REST()) 2307
GO 2305

:2318	// MOVEBACK
WAIT 1
SET init_wait Wait
PLAY ACTION+ mad_eyes
WAIT 200
PLAY ACTION WALK 180 200
SET lastmove 3	// lastmove=back
CALL G_WAIT_AWARE
if (F_NEED2REST()) 2307
GO 2305

:SOCCER_MUSTLAYDOWN
  CALL G_DEC_ENDURE
  RET:GO_DOWNPOS

:SOCCER_MUSTSITDOWN
  CALL G_DEC_ENDURE
  RET:GO_SITPOS

:SOCCER_LOSTBALL
  CALL G_YART_Soccer_LoseBall
  if (Context != GO_AHEAD) then
    RET:Context
  endif
  RET:GO_WALK




////////////////////////////////////////////////////////////////////
//
//  Someone is holding the ball above our head...
//
:G_SOCCER_BALLABOVE
PRINT "ZZZ ball above.  pan=%d  tilt=%d" Head_Pan HEAD_TILT()
if (F_NEED2REST()) then
  RET 1 // rest
endif
SET above_angle 0
SET last_teasedact -1
SET last_teasedact2 -1
SET actcount 0
RND tease 100 300	// 10-30 second timeout

:2329	// START_TRACK
CALL G_SOCCER_START_TRACK

:2330
WAIT 1
IF (Pink_Ball>0) THEN
  IF HEAD_TILT()>=above_angle 2333
  RET 3 // ball
ENDIF
RET 2 // noball

:2333	// START_TAIL
PLAY ACTION+ happy_eyes
CALL G_START_TAILWAG_NORMAL
RND impat 20 50	// 2-5 secs

:2334	// WAIT4BALL
CALL G_CHECK_SITONLY
  CASE:GO_DOWNPOS RET:2
  CASE:GO_SITPOS RET:2

WAIT 100
SUB tease 1
SUB impat 1
WAIT 1

IF (HEAD_TILT()>=above_angle) && Pink_Ball && tease 2342
IF HEAD_TILT() < above_angle 2341
IF Pink_Ball = 0 2341
IF tease > 0 2341

WAIT 1
SET init_wait Wait
PLAY ACTION MOVE_HEAD 0 0
CALL G_WAIT_AWARE
tailwag := 0

:2338	// TURN_AWAY
WAIT 1
SET init_wait Wait
RND angle 100 180	// Pick random turn.
RND temp 0 1		// Make random pos/neg.
MUL temp 2
MUL temp angle
SUB temp angle

IF Head_Pan > 0 THEN
  RND pan -20 0
ELSE
  RND pan 0 20
ENDIF

SET tilt HEAD_TILT()
PLAY ACTION MOVE_HEAD pan tilt
PLAY ACTION TURN 180
CALL G_INC_MAD_MOOD
CALL G_WAIT_AWARE
RET 2	// noball

:2341	// STOP_TAIL
WAIT 500
SET init_wait 1
GO 2330

:2342	// IMPATIENT?
IF_1ST impat > 0 2334
WAIT 1
SET pan Head_Pan
SET tilt HEAD_TILT()
SET above_angle 0	// Reset above angle...
CALL G_SOCCER_STOP_TRACK

:2345	// PICK_ACT
RND temp 0 25
IF_1ST temp = last_teasedact 2345
IF_1ST temp = last_teasedact2 2345
IF_1ST temp <= 8 2370
IF_1ST temp <= 21 2353
IF_1ST actcount < 2 2345
IF_1ST temp = 22 2352
IF_1ST temp = 23 2351
IF_1ST temp = 24 2350
CALL G_TANTRUM
SET mood_mad MOOD_MAX
SET mood_happy 0
GO 2338

:2350	// resign
PLAY ACTION RESIGNATION
WAIT
GO 2338

:2351	// so_sad
CALL G_INC_SAD_MOOD
PLAY ACTION NOD_STAND
WAIT
GO 2338

:2352	// frust
PLAY ACTION FRUSTRATED
WAIT
GO 2338

:2353	// SELECT_SITACT
SWITCH temp
  CASE:9 PLAY ACTION BEG_BALL
  CASE:10 PLAY ACTION NOBI4
  CASE:11 PLAY ACTION SIT
  CASE:12 PLAY ACTION CUTE_BANZAI1
  CASE:13 PLAY ACTION COMEON
  CASE:14 PLAY ACTION IMPATIENT_SIT1
  CASE:15 PLAY ACTION IMPATIENT_SIT2
  CASE:16 PLAY ACTION LOOKAROUND_SIT3
  CASE:17 PLAY ACTION SIGH
  CASE:18 PLAY ACTION YOUSILLY1
  CASE:19 PLAY ACTION YOUSILLY2
  CASE:20 PLAY ACTION YOUSILLY3
  CASE:ELSE PLAY ACTION YOUSILLY4
WAIT
SET last_teasedact2 last_teasedact
SET last_teasedact temp
SET above_angle -25	// Head level at -25 now
ADD actcount 1

:2356	// DEC_HAPPY_MOOD
CALL G_DEC_HAPPY_MOOD
PLAY ACTION MOVE_HEAD pan tilt
WAIT
GO 2329

:2370	// SELECT_STAND
SWITCH temp
  CASE:0 PLAY ACTION CUTE_SMILE1
  CASE:1 PLAY ACTION+ beg_leftpaw
  CASE:2 PLAY ACTION+ beg_rightpaw
  CASE:3 PLAY ACTION CUTE_BARK2
  CASE:4 PLAY ACTION LETSPLAY1
  CASE:5 PLAY ACTION LETSPLAY2
  CASE:6 PLAY ACTION LEANRIGHT
  CASE:7 PLAY ACTION WANTBALL
  CASE:ELSE PLAY ACTION TUNE_JAWS
WAIT
SET last_teasedact2 last_teasedact
SET last_teasedact temp
ADD actcount 1
GO 2356

:2383	// ball
RET 3



////////////////////////////////////////////////////////////////////
//
//  Estimate Distance to the Ball...
//
:G_SOCCER_DIST2BALL
IF Pink_Ball==0 THEN
  RET 1 // noball
ENDIF

SET tilt HEAD_TILT()
IF tilt>20 THEN
  SET d 0
  RET 3 // ballabove
ENDIF

// If head not in walk posture, then ball not as 
// close as might otherwise believe.
if (HEAD_WALKPOS()) then
  if (tilt<=-64) && (Head_Pan<35) && (Head_Pan>-35) then
    SET d 0
    RET 4 // nearball
  endif
else
  if (tilt<=-75) && (Head_Pan<35) && (Head_Pan>-35) then
    SET d 0
    RET 4 // nearball
  endif
endif

CSET:tilt > 0:1
CSET:tilt > -20:2
CSET:tilt > -30:3
CSET:tilt > -40:4
CSET:tilt > -70:5
CASE:1:SET d 250
CASE:2:SET d 200
CASE:3:SET d 150
CASE:4:SET d 100
CASE:5:SET d 50
RET 2 // balldist


////////////////////////////////////////////////////////////////////
//
//  Try to infer where ball might have gone, based on last 
//  head track position...
//
:G_SOCCER_INFER_BALL
SET panr pan
SET panl pan
SET tiltd tilt
SET tiltu tilt
SUB panr 5
ADD panl 5
SUB tiltd 5
ADD tiltu 5
SET pan2 0

// Maybe to the right?  
WAIT 1
IF Head_Pan < panr THEN
  IF HEAD_TILT() > tilt THEN // Right-forward
    SET d 300
  ELSE
    SET d 0
  ENDIF
  GO G_SOCCER_SEARCHTURN
ENDIF

// Maybe to the right?
IF Head_Pan > panl THEN
  IF HEAD_TILT() > tilt THEN // Left-forward
    SET d 300
  ELSE
    SET d 0
  ENDIF
  GO G_SOCCER_SEARCHTURN
ENDIF

// Maybe forward?
IF HEAD_TILT() > tiltu THEN
  SET d 300
  GO G_SOCCER_SEARCHTURN
ENDIF

IF HEAD_TILT() >= tiltd THEN
  RET:GO_IDLE
ENDIF

PLAY ACTION WALK 180 150
RET:GO_IDLE




////////////////////////////////////////////////////////////////////
//
//  Kick the ball...
//
:G_SOCCER_KICK_BALL
WAIT 1

CALL G_SOCCER_POSTURE

// If no ball, try to infer where it went...
IF Pink_Ball == 0 THEN
  CALL G_SOCCER_INFER_BALL
    CASE:GO_SEEBALL RET:1
  RET 3
ENDIF

PRINT "ZZZ CALLING G_SOCCER_DIST2BALL"
CALL G_SOCCER_DIST2BALL
  CASE:1 RET 3	// noball
  CASE:2 RET 1	// track
  CASE:3 RET 4	// ballabove
WAIT 1

// If not standing straight already, see if too close to ball.  Backup slightly if so...
if (Posture1 != POSTURE_STAND) then
  WAIT 1
  while (Pink_Ball>0) && (HEAD_TILT()<-85) && (Wait!=0) 
    SET init_wait Wait
    PLAY ACTION WALK 180 10	// Take a step backwards
    CALL G_WAIT_AWARE
    WAIT 500
  wend

  if Pink_Ball==0 then
    RET 3 // noball
  endif
ENDIF

// Stop tracking the ball...
PRINT "ZZZ STOP TRACKING"
CALL G_SOCCER_STOP_TRACK

// Call customization routine...
CALL G_CUSTOM_SOCCER_KICK
  CASE:GO_DOWNPOS  RET:GO_DOWNPOS
  CASE:GO_SITPOS   RET:GO_SITPOS
  CASE:GO_STANDPOS RET:GO_STANDPOS
  CASE:GO_WALK     RET:GO_WALK

// Still close enough to kick?
CALL G_SOCCER_CLOSE_ENOUGH?
  CASE:GO_S_NOBALL RET 3	// noball
  CASE:GO_S_TRACK GO SKB_NOKICK

// Close enough...
CALL G_SOCCER_INIT_KICK

// 80% of time do a normal kick...
IF F_RND100() < 80 THEN
  // If mad, only aibo kicks are performed.  Good mood needed to do something fancy.
  // This intentionally creates situations where Aibo misses & makes himself angrier.
  // Otherwise, 4/5ths of time do aibo kick (if ball in range)...
  if (!F_BEHAVIOR_RND()) then
    RET 2 // no kick options available?
  endif

  WAIT 1
  IF (Pink_Ball==0) SKB_SURPRISE	// Hey?!?

  PRINT:"ZZZ check_aibo_kick.  pan=%d(-30 to 30?)  tilt=%d(<=-68?)":pan:tilt
  if (mood_mad>1) then
    CALL G_SKB_AIBOKICK
    GO SKB_RESUMETRACK
  endif

  if (rndnum==rndbase) then
    if (tilt<=-68) && (pan>=-30) && (pan<=30) && ((pan>=12) || (pan<=-12)) then
      CALL G_SKB_AIBOKICK
      GO SKB_RESUMETRACK
    endif
    if (tilt<=-75) && (pan>=-30) && (pan<=30) && ((pan>=5) || (pan<=-5)) then
      CALL G_SKB_AIBOKICK
      GO SKB_RESUMETRACK
    endif
  endif
ELSE
  // See if ball close enough to touch...
  CALL G_SOCCER_TOUCH_BALL
    CASE:GO_S_NOBALL GO SKB_SURPRISE
    CASE:GO_S_TRACK GO SKB_NOKICK
ENDIF

// Swing kick.  See if should touch it first...
CALL G_SOCCER_CHECK_SWING
  CASE:GO_S_TRACK GO SKB_NOKICK

CALL G_SOCCER_PLAY_SWING
  CASE:GO_S_KICKED GO SKB_WAIT4KICK

:SKB_NOKICK
SET pan 999
SET tilt 999

:SKB_RESUMETRACK
SET init_wait 1
PLAY ACTION TRACK_HEAD PINK_BALL
SUB TIMER_TIRED 3 // accelerate getting tired (since tired timer doesn't work here...)

:SKB_WAIT4KICK	
CALL G_WAIT_AWARE
SET kick_pan pan
SET kick_tilt tilt
CALL G_SOCCER_POSTURE
RET 1	// track


// Kick ball from walking pose, but need small step to get 
// into a stable stance to avoid a face-plant...
:SKB_SMALLSTEP
WAIT 1
SET init_wait Wait
PLAY ACTION WALK 0 10
CALL G_WAIT_AWARE

// Kick ball from walking pose...
:SKB_WALKPOSE_KICK
WAIT 1
IF Head_Pan > 0 THEN // kick left
  PRINT KICKL
  SET pan Head_Pan
  SET tilt HEAD_TILT()
  PLAY ACTION kick_front_left
  SET last_kick 1
ELSE
  PRINT KICKR
  SET pan Head_Pan
  SET tilt HEAD_TILT()
  PLAY ACTION kick_front_right
  SET last_kick 2
ENDIF
GO SKB_RESUMETRACK

:SKB_SURPRISE
CALL G_SURPRISE
RET 3	// noball



////////////////////////////////////////////////////////////////////
//
//  Update mood after kicking (or missing ball).  See if it 
//  moved and update...
//
:G_SOCCER_KICK_MOOD

// If no kick has occured, exit now...
IF (kick_tilt>=999) && (kick_pan>=999) THEN
  RET 2
ENDIF

WAIT 1
SET pan Head_Pan	// Remember where head currently pointed.
SET tilt HEAD_TILT()
SUB kick_pan pan	// Compute movement.
SUB kick_tilt tilt

// If ball moved more than 15 degrees, get happy...
if (kick_pan>15) || (kick_pan<-15) || (kick_tilt>15) || (kick_tilt<-15) then
  // Yea!  Kicked the ball!!!
  PRINT KICKED_BALL
  SET miss_count 0
  ADD soccer 2
  CALL G_INC_HAPPY_MOOD
  CALL G_DEC_MAD_MOOD

  // Occasionally do a happy dance...
  if (F_RND100()>=75) && (mood_happy>=4) && (mood_mad<=0) then
    CALL G_YART_Soccer_Happy
    if (Context == GO_AHEAD) CALL G_HAPPYDANCE
    GO SKM_LOOK2BALL
  endif

  CALL G_YART_Soccer_GoodKick
  if (Context == GO_AHEAD) then
    WAIT 1
    SET init_wait Wait
    PLAY ACTION+ happy_eyes
    CALL G_WAIT_AWARE
  endif
  GO SKM_DONE
endif

// Otherwise, not happy...
PRINT "MISSED_BALL"
ADD miss_count 1
SUB soccer 1
CALL G_INC_MAD_MOOD
CALL G_DEC_HAPPY_MOOD

// If getting mad, show our frustration...
if (F_RND100()<50) && (mood_mad>=4) && POSE_STANDING() then
  CALL G_YART_Soccer_Frustrated
  if (Context==GO_AHEAD) then
    WAIT 1
    SET init_wait Wait
    PLAY ACTION FRUSTRATED
    CALL G_WAIT_AWARE
  endif
  GO SKM_LOOK2BALL
endif

CALL G_YART_Soccer_MissedKick
if (Context==GO_AHEAD) then
  // Flash mad eye's...
  WAIT 1
  SET init_wait Wait
  PLAY ACTION+ mad_eyes
  CALL G_WAIT_AWARE
endif

:SKM_DONE
SET kick_pan 999
SET kick_tilt 999
CALL G_SAVE_SOCCER
RET 1	// done


// Look at ball & resume soccer play...
:SKM_LOOK2BALL	
WAIT 1
SET init_wait Wait
PLAY ACTION MOVE.HEAD.FAST pan tilt
CALL G_WAIT_AWARE
CALL G_SOCCER_START_TRACK
GO SKM_DONE




////////////////////////////////////////////////////////////////////
//
//  Look for the ball...
//  Return:
//    GO_IDLE - Didn't find ball
//    GO_SEEBALL - Found the ball
//
:G_SOCCER_LOOK4BALL
  LOCAL slb_temp 0
  CALL G_SOCCER_STOP_TRACK

  WAIT 1
  SET init_wait Wait

  // Center up head position before starting ball search...
  PLAY ACTION MOVE_HEAD 0 -60
  WHILE (Wait>0) && (Wait>init_wait) && (Pink_Ball==0) && (slb_temp<600)
    ADD slb_temp 1
    WAIT 100
  WEND

  IF Pink_Ball > 0 THEN
    RET GO_SEEBALL
  ENDIF

  IF searchmode == 0 THEN // search low
    PLAY ACTION SEARCH.HEAD.LOWCENT PINK_BALL
  ELSE
    IF F_RND100() < 33 THEN // search fast
      PLAY ACTION SEARCH.HEAD.FASTCENT PINK_BALL
    ELSE
      PLAY ACTION SEARCH.HEAD.NORMALCENT PINK_BALL
    ENDIF
  ENDIF

  // Wait for search to complete...
  SET slb_temp 0
  WHILE (Wait>0) && (Wait>init_wait) && (Pink_Ball==0) && (slb_temp<600)
    ADD slb_temp 1
    WAIT 100
  WEND

  IF Pink_Ball > 0 THEN
    RET GO_SEEBALL
  ENDIF
  RET GO_IDLE



////////////////////////////////////////////////////////////////////
//
//  Move to ball, keeping an eye out for obstructions & cliff's...
//
:G_SOCCER_MOVE2BALL
PRINT "MOVE2BALL"

CALL G_SOCCER_POSTURE
CALL G_SOCCER_DIST2BALL
  CASE:1 GO 2520 // noball
  CASE:3 RET 6	 // ballabove
  CASE:4 RET 5	 // nearball

WAIT 1
IF Wait == 0 THEN			// Resume tracking.
  PLAY ACTION TRACK_HEAD PINK_BALL
  WAIT 500
  GO G_SOCCER_MOVE2BALL
ENDIF

// If tracking not good, loop...
IF (Wait < 1) || (Pink_Ball==0) THEN
  WAIT 250
  GO G_SOCCER_MOVE2BALL
ENDIF

SET dd d
RND temp 0 1				// Randomly decide to
MUL temp Head_Pan			// walk at an angle
SET lastmove 2				// towards ball...

PRINT "ZZZ move2ball.  angle=%d dist=%d" temp d

// If havent decided a walk mode yet, 20% of time stalk...
if (last_walkmode<0) then
  last_walkmode := F_RND100()>80
endif

// Need to relock head tracking after starting walk?
relock_track := !HEAD_WALKPOS()
if (relock_track) then
  pan := Head_Pan
  tilt := HEAD_TILT()
endif

// If not too close, and stalk walked before, do it again...
if ((last_walkmode==1) && (d>=200)) then
  PLAY ACTION BALLSTALK temp d
else
  SET last_walkmode 0
  PLAY ACTION WALK temp d
endif

if (relock_track) then
  PLAY ACTION MOVE.HEAD.FAST pan tilt
  WAIT:1000
  PLAY ACTION TRACK_HEAD PINK_BALL
  WAIT:500
endif

:2502	// HEAD_POSITION
CALL G_SOCCER_ATTENTION_HANDLER
  CASE:GO_DOWNPOS RET 2	 // down
  CASE:GO_RESTPOS RET 1	 // rest
  CASE:GO_SITPOS RET 7	 // sit
  CASE:GO_STOP RET 8	 // stand
  CASE:GO_STANDPOS RET 8 // stand
WAIT 1

IF Pink_Ball == 0 THEN
  WAIT 1
  SET init_wait Wait
  PLAY ACTION WALK 0 0
  CALL G_WAIT_AWARE
  WAIT 200
  RET 3	// noball
ENDIF

SET tilt HEAD_TILT()
SET pan Head_Pan
IF tilt >= 20 THEN
  RET 6 // ballabove
ENDIF

if (F_SOCCER_NEAR2BALL()) then
  SET init_wait Wait
  PLAY ACTION WALK 0 0
  CALL G_WAIT_AWARE

  CALL G_SOCCER_PAN2BALL?
    CASE:1 GO G_SOCCER_MOVE2BALL
  RET 5	// nearball
endif

if Wait<=1 then
  CALL G_SOCCER_PAN2BALL?
    CASE:1 GO G_SOCCER_MOVE2BALL
  RET 5	// nearball
endif

// If looking straight & distance is too far, might be a cliff!
IF (tilt<-30) && (Head_Pan<30) && (Head_Pan>-30) && (Distance>CLIFFDIST) THEN
  WAIT 1
  SET init_wait Wait
  PLAY ACTION+ sad_eyes
  PLAY ACTION WALK 0 0
  CALL G_WAIT_AWARE

  // Once standing still, if still see cliff, exit...
  IF (HEAD_TILT()<-30) && (Head_Pan<30) && (Head_Pan>-30) && (Distance>CLIFFDIST) THEN
    RET 4
  ENDIF
  GO G_SOCCER_MOVE2BALL
ENDIF
GO 2502

:2520	// debug2
WAIT 200
RET 3	// noball



////////////////////////////////////////////////////////////////////
//
//  SOCCER NEAR2BALL?  TRUE = close enough or need to turn
//
:F_SOCCER_NEAR2BALL

PRINT "ZZZ Near2Ball?  pan=%d  tilt=%d" pan tilt
WAIT 1
if (Pink_Ball_Dist<PINK_BALL_NEAR) then
  RETURN TRUE
endif

if last_walkmode==1 then
  if (tilt<=-50) && (pan>-20) && (pan<20) then
    RETURN TRUE
  endif
  RETURN (tilt<=-40) && ((pan>=20) || (pan<=-20))
endif

if (d>100) && (tilt<-50) then
  RETURN TRUE
endif

// Close enough while walking normally?
if (mood_mad<2) && (tilt<=-64) && (pan>-35) && (pan<35) then
  RETURN TRUE
endif

// Not near ball...
RETURN (tilt<=-50) && ((pan>35) || (pan<-35))



////////////////////////////////////////////////////////////////////
//
//  Do we need to turn to the ball?
//
:G_SOCCER_PAN2BALL?
IF (Head_Pan<-35) || (Head_Pan>35) THEN
  RET 2 // turn
ENDIF
RET 1 // noturn



////////////////////////////////////////////////////////////////////
//
//  Search for the ball (forward, move back, turn to sides, etc...)
//
//++CALL G_SOCCER_SEARCH4BALL // Search for Ball
:G_SOCCER_SEARCH4BALL
SET searchmode 1
SET searchmove 0	// Set if move while searching
CALL G_SOCCER_LOOK4BALL
  CASE:GO_IDLE GO 2606

:SSB_LOOP	// NEED2REST?
if (F_NEED2REST()) then
  RET 1 // rest
endif

SWITCH F_SEE_BALL()
  CASE:GO_IGNORE RET 1  // rest
  CASE:GO_SEEBALL RET 2	// ball

:2600	// NOBALL
SET kick_tilt 999	// Clear kick track
SET kick_pan 999
CALL G_RANDOM3
  CASE:1 PLAY ACTION+ ummm
  CASE:2 PLAY ACTION OHWELL
  CASE:3 PLAY ACTION SAD8
WAIT
RET 3	// noball

:2606	// Backup & look again...
PLAY ACTION WALK 180 200
WAIT
SET lastmove 3	// back
SET kick_tilt 999	// Force kick success
SET searchmode 0
SET searchmove 1	// Moved.
CALL G_SOCCER_LOOK4BALL
  CASE:GO_SEEBALL GO SSB_LOOP

if (mood_mad>1) 2600
if (mood_happy>3) || (ballhint>0) 2611
if (F_RND100()<33) 2600	// Don't bother...

:2611	// HINT?
RND sign 0 1
MUL sign 2
SUB sign 1

SWITCH ballhint
  CASE:1 SET sign 1	// turn left first

SET ballhint 0
RND turndelta 90 150
MUL turndelta sign
SET pan turndelta
SET d 0
SET pan2 0
SET searchmode 1
SET kick_tilt 999	// Force kick success
SET searchmove 1
CALL G_SOCCER_SEARCHTURN
  CASE:GO_SEEBALL GO SSB_LOOP

if (mood_happy<5) && (F_RND100()<50) 2600

SET pan 270
MUL pan sign
SUB pan turndelta
CALL G_SOCCER_SEARCHTURN
  CASE:GO_SEEBALL GO SSB_LOOP
CALL G_SOCCER_SEARCHTURN
  CASE:GO_SEEBALL GO SSB_LOOP
GO 2600



////////////////////////////////////////////////////////////////////
//
//  Turn while also looking for ball...
//
//  Inputs:
//    pan (first turn)
//    d (walk distance)
//    pan2 (second turn)
//
//  Returns:
//    GO_IDLE - Didn't find ball
//    GO_SEEBALL - Found the ball
//
:G_SOCCER_SEARCHTURN
  // Start first turn...
  if (F_RND100()<33) then
    PLAY ACTION MOVE.TURN.FAST pan
  else
    PLAY ACTION TURN pan
  endif
  // Wait while turning...
  while (Wait>0) && (Pink_Ball==0)
    WAIT 1
  wend
  if (Wait>0) && (Pink_Ball>0) then
    CALL G_SOCCER_STOP_TRACK
    RET GO_SEEBALL
  endif

  // Need to walk?
  if (d>0) then
    if (F_RND100()<33) then
      PLAY ACTION MOVE.MOVE.FAST 0 d
    else
      PLAY ACTION WALK 0 d
    endif
    // Wait while walking...
    while (Wait>0) && (Pink_Ball==0)
      WAIT 1
    wend
    if ((Wait>0) && (Pink_Ball>0)) || (Distance<200) then
      CALL G_SOCCER_STOP_TRACK
      RET GO_SEEBALL
    endif
  endif

  // Need second turn?
  if (pan2!=0) then
    if (F_RND100()<33) then
      PLAY ACTION MOVE.TURN.FAST pan2
    else
      PLAY ACTION TURN pan2
    endif
    // Wait while turning...
    while (Wait>0) && (Pink_Ball==0)
      WAIT 1
    wend
    if (Wait>0) && (Pink_Ball>0) then
      CALL G_SOCCER_STOP_TRACK
      RET GO_SEEBALL
    endif
  endif

  GO G_SOCCER_LOOK4BALL



////////////////////////////////////////////////////////////////////
//
//  Start tracking ball, if not already...
//
:G_SOCCER_START_TRACK

:2648	// STALL
WAIT 100
WAIT 1
IF_1ST Wait = 0 2651	// Resume tracking.
IF_1ST Wait > 0
IF_AND Pink_Ball > 0 2652	// Tracking ok.  Move.
WAIT 1000
GO 2648

:2651	// TRACK_BALL
PLAY ACTION TRACK_HEAD PINK_BALL
WAIT 500

:2652	// RETURN
RET 1



////////////////////////////////////////////////////////////////////
//
//  Stop tracking the ball...
//
:G_SOCCER_STOP_TRACK
WAIT 1
IF_1ST Wait > 0 2656
WAIT 100
RET 1

:2656	// WAIT
WAIT 500
WAIT 1
IF_1ST Wait <= 0 2660
STOP	// Stop Tracking
CALL G_WAITZERO

:2660	// RETURN
RET 1


////////////////////////////////////////////////////////////////////
//
// SOCCER TRACK_BALL
//
:G_SOCCER_TRACK_BALL
SET last_walkmode -1	// 0=norm 1=stalk 2=turn
SET walking WALKING_SOCCER
ADD soccer 1
VSAVE soccer

CALL G_SOCCER_POSTURE

:STB_START_TRACKING
if (F_NEED2REST()) then
  RET:GO_RESTPOS
endif

CALL G_SOCCER_KICK_MOOD
if mood_mad>6 then
  RET:GO_RESTPOS
endif

CALL G_SOCCER_ATTENTION_HANDLER
  CASE:GO_DOWNPOS RET GO_DOWNPOS
  CASE:GO_RESTPOS RET GO_RESTPOS
  CASE:GO_SITPOS RET GO_SITPOS
  CASE:GO_STOP RET GO_S_NOBALL
  CASE:GO_STANDPOS RET GO_S_SEARCH

CALL G_SOCCER_TURN2BALL
  CASE:1 RET GO_RESTPOS	
  CASE:2 RET GO_DOWNPOS	
  CASE:3 RET GO_S_NOBALL
  CASE:5 RET GO_SITPOS
  CASE:6 RET GO_STANDPOS
  CASE:7 RET GO_S_SEARCH

CALL G_SOCCER_ATTENTION_HANDLER
  CASE:GO_DOWNPOS RET GO_DOWNPOS
  CASE:GO_RESTPOS RET GO_RESTPOS
  CASE:GO_SITPOS RET GO_SITPOS
  CASE:GO_STOP RET GO_STANDPOS
  CASE:GO_STANDPOS RET GO_S_SEARCH

CALL G_SOCCER_MOVE2BALL
  CASE:1 RET GO_RESTPOS
  CASE:2 RET GO_DOWNPOS
  CASE:3 RET GO_S_NOBALL
  CASE:4 GO 2674
  CASE:5 GO 2672
  CASE:7 RET GO_SITPOS
  CASE:8 RET GO_S_SEARCH

WAIT 500
CALL G_SOCCER_PAN2BALL?
  CASE:1 RET GO_S_BALLABOVE
GO STB_START_TRACKING

:2672	// SETTLE
WAIT 500
CALL G_SOCCER_PAN2BALL?
  CASE:1 RET GO_S_BALLCLOSE
GO STB_START_TRACKING

:2674	// STOP_TRACK
CALL G_SOCCER_STOP_TRACK
CALL G_WALK_FOUND_CLIFF
  CASE:1 RET GO_S_NOBALL
  CASE:2 RET GO_S_NOBALL
  CASE:3 RET GO_RESTPOS
  CASE:4 GO STB_START_TRACKING
  CASE:6 RET GO_SITPOS
  CASE:7 RET GO_S_SEARCH
RET 1


////////////////////////////////////////////////////////////////////
//
//  Turn to ball & leave head pointing at it...
//
:G_SOCCER_TURN2BALL
WAIT 1
if (Pink_Ball==0) then
  RET 3 // noball
endif

CALL G_SOCCER_PAN2BALL?
  CASE:1 RET 4 // ball

lastmove := Head_Pan<0
CALL G_SOCCER_POSTURE
CALL G_SOCCER_START_TRACK

WAIT 1
SET pan Head_Pan
SET init_turnwait Wait
SET last_walkmode 2	// Last move was turn
PLAY ACTION TURN pan

repeat
  CALL G_SOCCER_ATTENTION_HANDLER
    CASE:GO_DOWNPOS RET 2  // down
    CASE:GO_RESTPOS RET 1  // rest
    CASE:GO_SEEBALL RET 4  // ball
    CASE:GO_SITPOS RET 5   // sit
    CASE:GO_STOP RET 6	   // stop
    CASE:GO_STANDPOS RET 7 // stand
  WAIT 1
until (Wait==0) || ((Pink_Ball>0) && (Wait<=init_turnwait)) || (F_ABS(Head_Pan)<10) 

PLAY ACTION TURN 0
SET last_walkmode -1

WAIT 1
IF Pink_Ball > 0 then
  RET 4 // ball
endif
RET 3	// noball



////////////////////////////////////////////////////////////////////
//
//  Determine if we are close enough to ball for a kick...
//
:G_SOCCER_CLOSE_ENOUGH?
WAIT 1
IF Pink_Ball == 0 THEN
  RET:GO_S_NOBALL // noball
ENDIF

IF (Pink_Ball_Dist < PINK_BALL_NEAR) THEN
  RET:GO_S_BALLCLOSE
ENDIF

PRINT:"ZZZ close_enough?  pan=%d  tilt2=%d":Head_Pan:HEAD_TILT()
IF (HEAD_TILT()<=-64) && (Head_Pan>-35) && (Head_Pan<35) THEN
  RET:GO_S_BALLCLOSE
ENDIF
RET GO_S_TRACK



////////////////////////////////////////////////////////////////////
//
//  Pick a soccer skit based on the ball's position.  The 'ballhint'
//  variable gives a heads-up to the soccer search routine (after all,
//  if you kick left, one might assume the ball would go that way)...
//
:G_SOCCER_CHECK_SWING

PRINT:"ZZZ check_swing.  pan=%d  tilt=%d":pan:tilt

SET swing_kick 0
SET kickcount 0

// Belly flop kick forward (zone 1)...
IF (pan>=-30) && (pan<=-15) && (tilt<=-64) THEN
  PRINT BELLYFWD
  swing_kick := kickcheck[kickcount++] := 6
ENDIF

// Belly flop kick forward (zone 2)...
IF (pan<=30) && (pan>=15) && (tilt<=-64) THEN
  PRINT BELLYFWD
  swing_kick := kickcheck[kickcount++] := 6
ENDIF

// Belly flop kick to right (zone 1)...
IF (pan<-34) && (tilt<-64) THEN
  PRINT BELLYR
  swing_kick := kickcheck[kickcount++] := 7
ENDIF

// Belly flop kick to right (zone 2)...
IF (pan<-18) && (tilt<-64) THEN
  PRINT BELLYR
  swing_kick := kickcheck[kickcount++] := 7
ENDIF

// Belly flop kick to left (zone 1)...
IF (pan>34) && (tilt<-64) THEN
  PRINT BELLYL
  swing_kick := kickcheck[kickcount++] := 8
ENDIF

// Belly flop kick to left (zone 2)...
IF (pan>18) && (tilt<-64) THEN
  PRINT BELLYL
  swing_kick := kickcheck[kickcount++] := 8
ENDIF

// Side kick to right...
IF (pan<-25) && (tilt<=-64) THEN
  PRINT SIDER
  swing_kick := kickcheck[kickcount++] := 9
ENDIF

// Side kick to left...
IF (pan>25) && (tilt<=-64) THEN
  PRINT SIDEL
  swing_kick := kickcheck[kickcount++] := 10
ENDIF

// Big kick to right...
IF (pan<-18) && (tilt<=-64) THEN
  PRINT SWINGR
  swing_kick := kickcheck[kickcount++] := 11
ENDIF

// Big kick to left...
IF (pan>18) && (tilt<=-64) THEN
  PRINT SWINGL
  swing_kick := kickcheck[kickcount++] := 12
ENDIF

// Header to the right...
IF (pan<-5) && (pan>=-18) && (tilt<-64) THEN
  PRINT HEAD_R
  swing_kick := kickcheck[kickcount++] := 13
ENDIF

// Header to the left...
IF (pan>5) && (pan<=18) && (tilt<-64) THEN
  PRINT HEAD_L
  swing_kick := kickcheck[kickcount++] := 14
ENDIF

// Header straight...
IF (pan>=-5) && (pan<=5) && (tilt<-60) THEN
  PRINT HEADFWD
  swing_kick := kickcheck[kickcount++] := 15
ENDIF

// If there is only one possible kick that works, use it...
IF kickcount == 1 THEN
  RET:GO_S_KICKIT
ENDIF

// If there are multiple kicks available, pick one at random...
IF kickcount > 0 THEN
  RND num 0 (kickcount-1)
  swing_kick := kickcheck[num]
  RET:GO_S_KICKIT
ENDIF

// Not in range of swing kick...
PRINT "ZZZ Can't do swing kick"
RET:GO_S_TRACK



////////////////////////////////////////////////////////////////////
//
//  Do a soccer skit based on the ball's position.  The 'ballhint'
//  variable gives a heads-up to the soccer search routine (after all,
//  if you kick left, one might assume the ball would go that way)...
//
:G_SOCCER_PLAY_SWING
SET init_wait 0

PRINT:"swing_kick = %d":swing_kick

SWITCH swing_kick 
  CASE 6 : PLAY ACTION+ kick_bellyflop_fwd
  CASE 7 : PLAY ACTION+ kick_bellyflop_right
  CASE 8 : PLAY ACTION+ kick_bellyflop_left
  CASE 9  : PLAY ACTION+ aibostand_sidekick_right
  CASE 10 : PLAY ACTION+ aibostand_sidekick_left
  CASE 11 : PLAY ACTION+ aibostand_bigkick_right
  CASE 12 : PLAY ACTION+ aibostand_bigkick_left
  CASE 13 : PLAY ACTION CONTACT.FRONT.HEADR
  CASE 14 : PLAY ACTION CONTACT.FRONT.HEADL
  CASE 15 : PLAY ACTION CONTACT.FRONT.HEAD
  CASE:ELSE RET:GO_S_TRACK

SET last_kick swing_kick

SWITCH swing_kick 
  CASE 7 : SET ballhint 2 // right
  CASE 8 : SET ballhint 1 // left 
  CASE 9  : SET ballhint 2 // right
  CASE 10 : SET ballhint 1 // left
  CASE 11 : SET ballhint 2 // right
  CASE 12 : SET ballhint 1 // left
  CASE 13 : SET ballhint 2 // right
  CASE 14 : SET ballhint 1 // left

RET:GO_S_KICKED



////////////////////////////////////////////////////////////////////
//
//  If ball properly positioned, touch it carefully, then 
//  setup to whallop it...
//
:G_SOCCER_TOUCH_BALL

// Ball missing?
WAIT 1
IF Pink_Ball = 0 THEN
  RET:GO_S_NOBALL 
ENDIF

// Touch ball?
tilt := HEAD_TILT()
IF (tilt<-60) && (tilt>-70) then
  // to the left?
  IF (Head_Pan>=15) && (Head_Pan<=30) THEN	// to the left?
    PLAY ACTION+ aibostand_touchball_left
    GO STB_LOOKATBALL
  ENDIF
  // to the right?
  IF (Head_Pan<=-15) && (Head_Pan>=-30) THEN	// to the right?
    PLAY ACTION+ aibostand_touchball_right
    GO STB_LOOKATBALL
  ENDIF
ENDIF
RET:GO_S_KICKIT	

// Look back at ball & decide if close enough to kick...
:STB_LOOKATBALL	
WAIT
CALL G_SOCCER_POSTURE
PLAY ACTION MOVE.HEAD.FAST pan tilt
WAIT
PLAY ACTION TRACK_HEAD PINK_BALL
WAIT 1000
CALL G_SOCCER_STOP_TRACK
GO G_SOCCER_CLOSE_ENOUGH?



////////////////////////////////////////////////////////////////////
//
//  Initialize the kick behavior tracking information...
//
:G_SOCCER_INIT_KICK
WAIT 1
SET pan Head_Pan
SET tilt HEAD_TILT()
SET rndbase 1800
SET rndcount 2

// If need to initialize kick behavior, skew init so that kicks
// are initially favored 5 to 1 (instead of 1 to 1)...
if (behavior[rndbase]!=rndcount) then
  CALL G_BEHAVIOR_INIT
  behavior[++rndend] := rndbase
  behavior[++rndend] := rndbase
  behavior[++rndend] := rndbase
  behavior[++rndend] := rndbase
  behavior[rndbase+1] := rndend
endif
RET 1



////////////////////////////////////////////////////////////////////
//
//  Save soccer skill to memstick...
//
:G_SAVE_SOCCER
IF soccer < 1 THEN
  SET soccer 1
ENDIF
IF soccer > 100 THEN
  SET soccer 100
ENDIF
VSAVE soccer
RET 1



////////////////////////////////////////////////////////////////////
//
//  Check soccer posture (for 310 since the STAND & WALK postures
//  affect head position and screw up distance detection).
//
:G_SOCCER_POSTURE
  if (!HEAD_WALKPOS()) then
    SET sp_t HEAD_TILT()
    SET sp_p Head_Pan
    SET sp_iw Wait

    if (Posture1==POSTURE_WALK) then
      PLAY ACTION MOVE.HEAD.FAST sp_p -70
      WHILE Wait > sp_iw
        WAIT 100
      WEND
      if (HEAD_WALKPOS()) then
        PLAY ACTION MOVE.HEAD.FAST sp_p sp_t
        WHILE Wait > sp_iw
          WAIT 100
        WEND
        RET:1
      endif

      PLAY:ACTION:stand_straight
      WHILE Wait > sp_iw
        WAIT 100
      WEND
    endif

    PRINT:"ZZZ Soccer Posture. init_wait=%d  pan=%d  tilt=%d":sp_iw:sp_p:sp_t
    PLAY:ACTION:CHGPOS.WALK.NORMAL
    WHILE Wait > sp_iw
      WAIT 100
    WEND
    PLAY ACTION MOVE.HEAD.FAST sp_p sp_t
    WHILE Wait > sp_iw
      WAIT 100
    WEND
  endif
  RET 1



////////////////////////////////////////////////////////////////////
//
//  TURN_AWAY
//
:G_TURN_AWAY
WAIT 1

SET dir -1
IF Head_Pan > 10 THEN	// Go left if looking left...
  SET dir 1
ENDIF

IF Head_Pan >= -10 THEN	// If looking straight, go left or right...
  CALL G_RANDOM2
    CASE:1 SET dir 1
    CASE:2 SET dir -1
ENDIF

CALL G_SOCCER_STOP_TRACK

// Start turn...
RND p 150 180
MUL p dir

WAIT 1
SET init_wait Wait
PLAY ACTION TURN p
PLAY ACTION MOVE_HEAD 0 0
CALL G_WAIT_AWARE
RET 1




////////////////////////////////////////////////////////////////////
//
//  Do soccer kick.  On 210/220 the head tracks during these.
//  However, on 310 the head doesn't track, because the head servos 
//  switch from walk to standing pose.  Doesn't seem to be a way
//  of changing 310 from walk to stand pose without the head moving.
//
//  ARGH!  Thanks Sony...
//
:G_SKB_AIBOKICK
PRINT:"ZZZ aibo_kick.  pan=%d  tilt=%d":pan:tilt

// Kick left?
if (pan>=0) && (pan<=20) then
  PRINT KICKFWDL1
  CALL G_RANDOM2
    CASE:1 PLAY ACTION kick_center_left
    CASE:2 PLAY ACTION kick_front_left
  SET ballhint 1 // hint=left
  SET last_kick 3
  RET:1
endif

if (pan>20) then
  PRINT KICKFWDL2
  CALL G_RANDOM3
    CASE:1 PLAY ACTION kick_front2_left
    CASE:2 PLAY ACTION kick_front3_left
    CASE:3 PLAY ACTION kick_front4_left
  SET ballhint 1 // hint=left
  SET last_kick 3
  RET:1
endif

// Kick right...
if (pan>=-20) && (pan<=0) then
  PRINT KICKFWDR1
  CALL G_RANDOM2
    CASE:0 PLAY ACTION kick_center_right
    CASE:1 PLAY ACTION kick_front_right
else // pan<-20
  PRINT KICKFWDR2
  CALL G_RANDOM3
    CASE:1 PLAY ACTION kick_front2_right
    CASE:2 PLAY ACTION kick_front3_right
    CASE:3 PLAY ACTION kick_front4_right
endif
SET ballhint 2	// hint=right
SET last_kick 4
RET:1



////////////////////////////////////////////////////////////////////
//
//  Process any voice commands, praise, etc...  If some action
//  was performed, try and reaquire the ball in the last place
//  it was known.
//
:G_SOCCER_ATTENTION_HANDLER
  LOCAL lastpose -999
  LOCAL lastx -999
  LOCAL lasty -999

  if (Pink_Ball>0) then
    lastpose := Posture1
    lastx := Head_Pan
    lasty := HEAD_TILT()
  endif

  CALL G_WALK_ATTENTION_HANDLER
  if (Context != GO_STANDPOS) then
    RET:Context
  endif

  if (Pink_Ball>0) then
    RET:GO_SEEBALL
  endif

  if (lastx>-999) || (lasty>-999) then
    if (lastpose == POSTURE_WALK) CALL G_SOCCER_POSTURE
    SET init_wait Wait
    PLAY ACTION MOVE.HEAD.FAST lastx lasty
    CALL G_WAIT
    WAIT:200
    if (Pink_Ball>0) then
      RET:GO_SEEBALL
    endif
  endif
  RET:GO_STANDPOS



////////////////////////////////////////////////////////////////////
//
//  Average out the head tilt over multiple samples, since it 
//  tends to be noisy.  Especially on the 310, because of the
//  dependence on "Pink_Ball_V" which makes coarse increments.
//
:F_HEAD_TILT
  LOCAL htilt 0
  LOCAL hfor
  for hfor 1 5
    WAIT:64
    ADD:htilt:Head_Tilt_2
    ADD:htilt:Head_Tilt_2
    ADD:htilt:Pink_Ball_V
  next
  DIV htilt 5
  return htilt


