
////////////////////////////////////////////////////////////////////
//                                                                //
//  DogsLife Stand Position Behavior Module                       //
//  Copyright (C) 2001-2002 by DogsBody & Ratchet Software        //
//  All Rights Reserved                                           //
//                                                                //
//  This is free software and MAY NOT be sold under any           //
//  circumstances, seperately or bundled.                         //
//                                                                //
////////////////////////////////////////////////////////////////////


//
// Behavior when standing still...
//
:G_STANDPOS
CALL G_CHECK_SITONLY
  CASE:GO_DOWNPOS RET:GO_DOWNPOS
  CASE:GO_SITPOS RET:GO_SITPOS

CALL G_INIT_STANDPOS

:STAND_LOOP	// INIT_TIMERS
SET Clock 0
RND TIMER_BORED 3 10		// 3 to 10 seconds
RND TIMER_LOOKAROUND 0 2	// 0 to 2 seconds
RND TIMER_REST 5 10		// 5 to 10 seconds
SET tailwag 0

if (mood_happy>3) CALL G_START_TAILWAG_SLOW

:2845	// NEED2REST?
if (F_NEED2REST()) then
  CALL G_STOP_TAILWAG
  RET:GO_RESTPOS
endif

if (mood_tired >= MOOD_MAX) then
  // If tired & standing, sitdown...
  IF Posture1 == POSTURE_STAND THEN
    RND rndnum 0 100
    SET init_wait Wait
    IF rndnum < 50 THEN
      PLAY ACTION SIT
    ELSE
      PLAY ACTION+ sit_quick
    ENDIF
    CALL G_WAIT
  ENDIF
  CALL G_STOP_TAILWAG
  RET:GO_RESTPOS
endif

CALL G_CHECK_SITONLY
  CASE:GO_DOWNPOS RET:GO_DOWNPOS
  CASE:GO_SITPOS RET:GO_SITPOS

CALL G_REST_TIMER
WAIT 50

// Is the ball visible?
if (F_SEE_BALL()==GO_SEEBALL) STAND_SEEBALL

:STAND_CHECKATTENTION	// ATTENTION?
CALL G_ATTENTION_HANDLER
  CASE:GO_IDLE     GO 2868	
  CASE:GO_PRAISE   GO 2867
  CASE:GO_PETTED   GO 2866
  CASE:GO_SCOLD    GO 2863
  CASE:GO_STANDPOS GO 2854
  CASE:GO_RESTPOS  RET:GO_RESTPOS
  CASE:GO_DOWNPOS  RET:GO_DOWNPOS
  CASE:GO_SITPOS   RET:GO_SITPOS
  CASE:GO_WALK     RET:GO_WALK

// Call YART voice command customization routine...
:STAND_PROCESSVOICE
CALL G_YART_VoiceCmd
  CASE:GO_RESTPOS  RET:GO_RESTPOS
  CASE:GO_DOWNPOS  RET:GO_DOWNPOS
  CASE:GO_SITPOS   RET:GO_SITPOS
  CASE:GO_WALK     RET:GO_WALK
  CASE:GO_STANDPOS GO 2854

// Call voice command customization routine...
CALL G_CUSTOM_STAND_VOICECMD
  CASE:GO_DOWNPOS RET:GO_DOWNPOS
  CASE:GO_SITPOS RET:GO_SITPOS
  CASE:GO_STANDPOS RET:GO_STANDPOS
  CASE:GO_SEEBALL RET:GO_SEEBALL
  CASE:GO_IGNORE GO 2854

// If not overridden, do normal voice command processing...
CALL G_STAND_VOICE_HANDLER
  CASE:1 GO STAND_LOOP
  CASE:3 RET:GO_WALK
  CASE:4 RET:GO_DOWNPOS
  CASE:5 RET:GO_SITPOS
  CASE:6 RET:GO_SEEBALL
  CASE:7 RET:GO_RESTPOS

:2854	// TIMER1?
CALL G_BORED_TIMER
  CASE:1 GO 2845

// Go process pending voice command...
if (AP_Voice_Cmd!=0) && (AP_Voice_Level>=MIN_VOICE_LEVEL) STAND_CHECKATTENTION

//
// 20% remain standing (bored)
// 50% of time start walking.  
// 20% lay down
// 10% sit down
//
RND rndnum 0 100
IF rndnum >= 20 THEN
  IF rndnum < 70 THEN
    RET:GO_WALK
  ENDIF
  IF rndnum < 90 THEN
    RET:GO_DOWNPOS
  ENDIF
  RET:GO_SITPOS
ENDIF

// Process YART standing position bored handler...
CALL G_YART_Bored_Stand
  CASE:GO_RESTPOS  RET:GO_RESTPOS
  CASE:GO_DOWNPOS  RET:GO_DOWNPOS
  CASE:GO_SITPOS   RET:GO_SITPOS
  CASE:GO_WALK     RET:GO_WALK
  CASE:GO_STANDPOS GO 2854

WAIT 1
CALL G_BEHAVIOR_BORED
ADD change_thres 2
GO STAND_LOOP

:2863	// SCOLD
CALL G_SCOLD_REST

:2864	// RESET_BORED
RND bored_count 5 10
CALL G_CLEAR_SENSORS
ADD change_thres 2
GO STAND_LOOP

:2866	// STAND_PETTED
CALL G_STAND_PETTED
GO 2864

:2867	// PRAISE
CALL G_PRAISE_REST
GO 2864

:2868	// TAIL_TWEAKED?
CALL G_TAIL_TWEAKED
  CASE:2 GO 2867
  CASE:3 GO 2863
  CASE:4 GO STAND_PROCESSVOICE
CALL G_LOOK_TIMER
GO 2854


:STAND_SEEBALL
  CALL G_STOP_TAILWAG
  RET:GO_SEEBALL



////////////////////////////////////////////////////////////////////
// INIT_STANDPOS
:G_INIT_STANDPOS
RND bored_count 3 10	// # of cycles before bored
SET back_count 0	// # b2b back pets
SET tilt 0
SET pan 0
WAIT 1

// Get into stand position if necessary...
IF Posture1 != POSTURE_STAND THEN
  SET init_wait Wait
  PLAY ACTION stand_straight
  CALL G_WAIT
ENDIF

CALL G_CLEAR_SENSORS
RET 1


////////////////////////////////////////////////////////////////////
// STAND_BARK
:G_STAND_BARK
CALL G_VOICE_HIT
RND rndnum 1 5
SWITCH rndnum
  CASE:1 PLAY ACTION BARK
  CASE:2 PLAY ACTION BARK2
  CASE:3 PLAY ACTION dog_1bark_stand
  CASE:4 PLAY ACTION dog_2barks_stand
  CASE:5 PLAY ACTION dog_3barks_stand
GO G_WAITZERO


////////////////////////////////////////////////////////////////////
// STAND_DANCE
:G_STAND_DANCE
SET rndbase 1600
SET rndcount 6
if (F_BEHAVIOR_RNDN()) then
  SWITCH rndnum
    CASE:1600 PLAY ACTION DANCE_STAND3
    CASE:1601 PLAY ACTION DANCE_STAND4
    CASE:1602 PLAY ACTION DANCE_STAND5
    CASE:1603 PLAY ACTION DANCE_STAND6
    CASE:1604 PLAY ACTION pinkpanther
    CASE:1605 GO G_STAND_TWISTNSHOUT
  SET last_danceact rndnum
  WAIT
endif
RET 1

:G_STAND_TWISTNSHOUT
SET:NoFallDown:1
PLAY ACTION twistnshout
WAIT
SET:NoFallDown:0
SET last_danceact rndnum
RET 1


////////////////////////////////////////////////////////////////////
// STAND_GREET
:G_STAND_GREET
WAIT 1
SET init_wait Wait
CALL G_RANDOM4
  CASE:1 PLAY ACTION WAVE_LEFT_STAND1
  CASE:2 PLAY ACTION WAVE_LEFT_STAND2
  CASE:3 PLAY ACTION WAVE_RIGHT_STAND1
  CASE:4 PLAY ACTION WAVE_RIGHT_STAND2
GO G_WAIT


////////////////////////////////////////////////////////////////////
// STAND_HELLO
:G_STAND_HELLO
WAIT 1
SET init_wait Wait
CALL G_RANDOM4
  CASE:1 PLAY ACTION HELLO_STAND1
  CASE:2 PLAY ACTION HELLO_STAND2
  CASE:3 PLAY ACTION HELLO_STAND3
  CASE:4 PLAY ACTION HELLO_STAND4
GO G_WAIT


////////////////////////////////////////////////////////////////////
// STAND_HUH  (Say what?)
:G_STAND_HUH
CALL G_VOICE_HIT
CALL G_RANDOM3
  CASE:1 PLAY ACTION SAYWHAT_LEFT
  CASE:2 PLAY ACTION SAYWHAT_RIGHT
  CASE:3 PLAY ACTION LEANRIGHT
GO G_WAITZERO


////////////////////////////////////////////////////////////////////
// STAND_PETTED
:G_STAND_PETTED

WAIT 1
SET init_wait Wait
CALL G_RANDOM3
  CASE:1 PLAY ACTION TUNE_PETTED1
  CASE:2 PLAY ACTION TUNE_PETTED2
  CASE:3 GO 2761

CALL G_WAIT
if (F_RND100()>((mood_happy>4)?66:33)) 2768

:2761	// LOTS_BACK_PET?
WAIT 1
SET init_wait Wait
if (back_count>4) then
  RND rndnum 0 3
  SWITCH rndnum
    CASE:0 PLAY ACTION+ petting_kick_stand_left
    CASE:1 PLAY ACTION+ petting_kick_stand_right
    CASE:2 PLAY ACTION+ petting_kick_stand_left2
    CASE:3 PLAY ACTION+ petting_kick_stand_right2
  SET last_petsong 999
  CALL G_WAIT
  SET Back_ON 0
else
  repeat
    RND rndnum 0 5
  until (rndnum!=last_petsong)
  SWITCH rndnum
    CASE:0 PLAY ACTION BEEN_PETTED18
    CASE:1 PLAY ACTION BEEN_PETTED19
    CASE:2 PLAY ACTION BEEN_PETTED20
    CASE:3 PLAY ACTION BEEN_PETTED21
    CASE:4 PLAY ACTION BEEN_PETTED22
    CASE:5 PLAY ACTION BEEN_PETTED23
  SET last_petsong rndnum
  CALL G_WAIT
endif

:2768	// INC_HAPPY_MOOD
CALL G_INC_HAPPY_MOOD
CALL G_DEC_MAD_MOOD
CALL G_DEC_SAD_MOOD
RET 1



////////////////////////////////////////////////////////////////////
// STAND_POSE
:G_STAND_POSE
WAIT 1
SET rndbase 1650
SET rndcount 5
SET lastact1 last_poseact
SET lastact2 last_poseact
SET init_wait Wait
if (F_BEHAVIOR_RNDN()) then
  SWITCH rndnum
    CASE:1650 PLAY ACTION POSE_MADONNA
    CASE:1651 PLAY ACTION POSE_WAVERIGHT
    CASE:1652 PLAY ACTION SMALL_BOW
    CASE:1653 PLAY ACTION SURPRISE_STAND
    CASE:1654 GO G_STAND_HEADSTAND
  CALL G_WAIT
endif
RET 1


:G_STAND_HEADSTAND
SET:NoFallDown:1
PLAY ACTION headstand_stand
CALL G_WAIT
SET:NoFallDown:0
RET 1


////////////////////////////////////////////////////////////////////
// STAND_VOICE_HANDLER  (Voice processing when standing still.)
:G_STAND_VOICE_HANDLER
CALL G_STOP_HEAD
WAIT 1
SWITCH VoiceCmd
  CASE:HEARD_RHYTHM GO 2816
  CASE:VOICE_WALK GO 2833		// Walk
  CASE:VOICE_FINDBALL GO 2831		// Find Ball
  CASE:VOICE_KICKBALL GO 2831		// Kick Ball
  CASE:VOICE2_PINKBALL GO 2831		// Pink Ball
  CASE:VOICE2_RIGHTKICK GO 2831		// Right Kick - ZZZ - Should add right kick code
  CASE:VOICE2_LEFTKICK GO 2831		// Left Kick - ZZZ - Should add left kick code
  CASE:VOICE2_RIGHTTOUCH GO 2831	// Right Touch - ZZZ - Should add right touch code
  CASE:VOICE2_LEFTTOUCH GO 2831		// Left Touch - ZZZ - Should add left touch code
  CASE:VOICE_LETSDANCE GO 2829		// Dance
  CASE:VOICE2_SHOWTIME GO 2829		// Show Time
  CASE:VOICE2_SHOWOFF GO 2829		// Show Off
  CASE:VOICE_GETUP GO 2828		// Get Up
  CASE:VOICE_STOP GO 2828		// Stop
  CASE:VOICE_STANDUP GO 2828		// Stand Up
  CASE:VOICE_GOODMORNING GO 2825	// Good Morning
  CASE:VOICE_GOODNIGHT GO 2827		// Good Night
  CASE:VOICE_GOODBYE GO 2827		// Goodbye
  CASE:VOICE2_SEEYOU GO 2827		// See You
  CASE:VOICE_AIBO GO 2825		// AIBO
  CASE:VOICE2_HEYAIBO GO 2825		// Hey AIBO
  CASE:VOICE_HELLO GO 2825		// Hello
  CASE:VOICE2_THANKS GO 2825		// Thanks
  CASE:VOICE2_HAPPYDAY GO 2825		// Happy Day
  CASE:VOICE_SAYHELLO GO 2825		// Say Hello
  CASE:VOICE_AREYOUOK GO 2824		// Are you ok?
  CASE:VOICE2_HOWAREYOU GO 2824		// How are you?
  CASE:VOICE_GOFORWARD GO 2823		// Go Forward
  CASE:VOICE2_GOAHEAD GO 2823		// Go Ahead
  CASE:VOICE_TURNLEFT GO 2822		// Go Left
  CASE:VOICE_GOBACK GO 2821		// Go Back
  CASE:VOICE_TURNRIGHT GO 2820		// Go Right
  CASE:VOICE_POSE GO 2819		// Pose
  CASE:VOICE2_CLOWNAROUND GO 2819	// Clown around
  CASE:VOICE_ROAR GO 2818		// Roar
  CASE:VOICE_MEOW GO 2818		// Meow
  CASE:VOICE2_SINGSONG GO 2818		// Sing Song
  CASE:VOICE_AREYOUTIRED GO 2817	// Tired?
  CASE:VOICE_AREYOUHUNGRY GO 2815	// Hungry?
  CASE:VOICE_SHAKEPAW GO 2814		// Shake Paw
  CASE:VOICE_SHAKE GO 2812		// Shake
  CASE:VOICE_OTHERPAW GO 2806		// Other Paw
  CASE:VOICE_KARATECHOP GO 2811		// Karate Chop
  CASE:VOICE2_BANZAI GO 2811		// Banzai
  CASE:VOICE_LETSPLAY GO 2808		// Let's Play
  CASE:VOICE_SITDOWN GO 2809		// Sit
  CASE:VOICE_LAYDOWN GO 2800		// Lie Down / Play Dead
  CASE:VOICE_ROAR GO 2800		// Roar / Roll Over
  CASE:VOICE_WHATSYOURNAME GO 2834	// What's your name?
  CASE:VOICE2_WHATSOWNERNAME GO 2835	// What's owners name?
  CASE:VOICE_NAMEREG GO 2836		// Name Registration
  CASE:VOICE2_OWNERREG GO 2837		// Owner Registration
#if ERS210 || ERS220
  CASE:VOICE2_ACTION1 GO 2838		// Self Dock ("Action 1")
#endif
RET 2	// none

:2800	// LAY_DOWN
CALL G_VOICE_HIT
CALL G_RANDOM2
  CASE:1 GO 2805
IF_1ST mood_happy < 3 2805
PLAY ACTION RESIGNATION
WAIT
CALL G_DEC_HAPPY_MOOD
RET 4	// down

:2805	// SLEEPPOS
PLAY ACTION LIE
WAIT
RET 4	// down

:2806	// OTHERPAW_CMD
CALL G_VOICE_HIT
CALL G_SIT_OTHERHAND
RET 5	// sit

:2808	// Game Time
CALL G_Select_Game
RET 5	// sit

:2809	// SIT_DOWN
CALL G_VOICE_HIT
RND rndnum 0 100
IF rndnum < 50 THEN
  PLAY ACTION SIT
ELSE
  PLAY ACTION+ sit_quick
ENDIF
WAIT
RET 5	// sit

:2811	// KARATE_CHOP
CALL G_KARATE_CHOP
RET 5	// sit

:2812	// SHAKEPAW_CMD
CALL G_VOICE_HIT
CALL G_SIT_SHAKEHANDS
RET 5	// sit

:2814	// SHUDDER
CALL G_SHUDDER
  CASE:1 RET 1	// done
GO 2812

:2815	// HUNGRY?
CALL G_QUERY_HUNGRY
  CASE:1 RET 1	// done
RET 5	// sit

:2816	// STAND_RHYTHM
CALL G_STAND_RHYTHM
RET 1	// done

:2817	// TIRED?
CALL G_QUERY_TIRED
RET 1	// done

:2818	// BARK
CALL G_STAND_BARK
RET 1	// done

:2819	// POSE
CALL G_STAND_POSE
RET 1	// done

:2820	// RIGHT
CALL G_GO_RIGHT
RET 1	// done

:2821	// BACK
CALL G_GO_BACK
RET 1	// done

:2822	// LEFT
CALL G_GO_LEFT
RET 1	// done

:2823	// FWD
CALL G_GO_FORWARD
RET 1	// done

:2824	// OK?
CALL G_QUERY_MOOD
RET 1	// done

:2825	// HELLO?
CALL G_RANDOM1/3
  CASE:1 GO 2827
CALL G_STAND_HELLO
RET 1	// done

:2827	// GREET
CALL G_STAND_GREET
RET 1	// done

:2828	// HUH?
CALL G_STAND_HUH
RET 1	// done

:2829	// LETS_DANCE
CALL G_VOICE_HIT
CALL G_STAND_DANCE
RET 1	// done

:2831	// FIND_BALL
CALL G_VOICE_HIT
CALL G_SOCCER_SEARCH4BALL
  CASE:1 RET 7	// rest
  CASE:2 RET 6	// ball
RET 1	// done

:2833	// WALK_REQUEST
CALL G_WALK_REQUEST
  CASE:1 RET 3	// walk
RET 1

:2834   // What's your name?
CALL G_PLAYBACK_AIBONAME
RET 1	// done

:2835   // What's owner name?
CALL G_PLAYBACK_OWNERNAME
RET 1	// done

:2836	// Name Registration
CALL G_NAME_REGISTRATION
RET 5	// sit

:2837	// Owner Registration
CALL G_OWNER_REGISTRATION
if (POSE_SIT()) then 
  RET 5	// sit
endif
RET 4	// down

#if ERS210 || ERS220
:2838   // Self Dock
CALL G_SELFDOCK
RET 1	// done
#endif




////////////////////////////////////////////////////////////////////
// STAND_RHYTHM
:G_STAND_RHYTHM
SET rndbase 1950
SET rndcount 6
CALL G_BEHAVIOR_RNDNM
  CASE:3 RET 1	// no valid number available

:4097	// SELECT_POS
SWITCH rndnum
  CASE:1950 PLAY ACTION+ dancestep_aibostand1
  CASE:1951 PLAY ACTION+ dancestep_aibostand2
  CASE:1952 PLAY ACTION+ dancestep_aibostand3
  CASE:1953 PLAY ACTION+ dancestep_aibostand4
  CASE:1954 PLAY ACTION+ dancestep_stand1
  CASE:1955 PLAY ACTION+ dancestep_stand2
WAIT
RET 1


