
////////////////////////////////////////////////////////////////////
//                                                                //
//  DogsLife Startup & Initialization Module                      //
//  Copyright (C) 2001-2002 by DogsBody & Ratchet Software        //
//  All Rights Reserved                                           //
//                                                                //
//  This is free software and MAY NOT be sold under any           //
//  circumstances, seperately or bundled.                         //
//                                                                //
////////////////////////////////////////////////////////////////////


//
// Startup Processing...
//
:G_STARTUP
WAIT 1
SET temp Status
PRINT:"Status=%d",temp
WAIT
CLR SENSORS

SET Seed Sec
SET dogslife REQ_RCODE_VERSION
SET sitonly 0				// Used to keep DogsLife sitting/sleeping (no walking)

// Array reference variables...
SET behavior 1	
SET kickhist 2
SET kickcheck 3
SET colorarray 4
SET trackarray 5
SET syn_voice 6
SET voicehist 7

WAIT 1
IF AP_Version >= dogslife THEN
  SET rcodeplus 1
  SET AP_Voice_Cmd 0
ELSE
  SET rcodeplus 0
ENDIF

// If RCode 1.2 vocabulary, offset the base value...
SET base_voice_cmd 0
VLOAD AP_Vocab
IF (AP_Vocab==0) || (AP_Vocab==2) THEN
  SET base_voice_cmd 0x400
ENDIF

// Make sure we are good with battery & temp...
CALL G_NEED2REST
  CASE:1 GO STARTUP_INITMOOD

// Cold boot?
IF_1ST temp = 0 STARTUP_INITMOOD

// Recover boot...
RND rndnum 0 100

// AIBO restarts after the first act, so track the restarts 
// with "shudder" variable...
IF shudder == 0 THEN
  SET shudder 1	
  IF rndnum < 50 THEN
    PLAY ACTION ATCLIFF	
  ELSE
    PLAY ACTION SHUDDER	
  ENDIF
  WAIT		
ENDIF

SET shudder 0

// Aperios sometimes goes a little "funny" after a recovery.
// This stuff seems to help a little (not always though)...
PLAY ACTION WALK 0 0
WAIT
SET d Distance
WAIT 1000
SET dd Distance

// Test the behavior arrays to make sure they wen't wiped...
AP_SET 123 behavior 3999
AP_SET 456 behavior 3998
AP_GET temp behavior 3999


// If fail test, go reinitialzie arrays...
IF (temp != 123) STARTUP_LOADVARS

CALL G_YART_Startup_Recovery
  CASE:GO_RESTPOS RET:GO_RESTPOS
  CASE:GO_SITPOS RET:GO_SITPOS
  CASE:GO_DOWNPOS RET:GO_DOWNPOS
  CASE:GO_WALK RET:GO_WALK

RET:GO_STANDPOS


:STARTUP_INITMOOD
SET mood_happy 0
SET mood_mad 0
SET mood_sad 0
SET mood_curious 0
SET mood_bored 0
SET mood_tired 0	// 0=rested  10=tired

SET last_happydance -1
SET last_happydance2 -1
SET last_walkact -1
SET last_danceact -1
SET last_happyact -1
SET last_boredact -1
SET last_calmact -1
SET last_poseact -1
SET last_praiseact -1
SET last_praiseact2 -1
SET last_scoldact -1
SET last_scoldact2 -1
SET last_shakehand 0
SET last_kick -1

SET TIMER_BORED MAXINT
SET TIMER_LOOKAROUND MAXINT
SET TIMER_REST MAXINT
SET TIMER_EXPECT MAXINT
SET TIMER_CLEARLEDS MAXINT
SET TIMER_310ROLL MAXINT
SET TIMER_GAME GAME_TIMER_INTERVAL
SET TIMER_GOFORIT MAXINT
SET TIMER_MOOD MAXINT
SET TIMER_TIRED MAXINT
SET TIMER_HELLO 0
SET TIMER_VOICE VOICE_TIMER_INTERVAL

#ifdef RCODE250
SET Warn 0
#if ERS210 | ERS220
SET Eye_L1 0		// Bottom
SET Eye_L2 0		// Center
SET Eye_L3 0		// Top
SET Eye_R1 0
SET Eye_R2 0
SET Eye_R3 0
#endif
#if ERS220
SET Back_1 0		// tailfan, third from left
SET Back_2 0		// tailfan, second from left 
SET Back_3 0		// tailfan, left most
SET Back_4 0		// tailfan, third from right
SET Back_5 0		// tailfan, second from right
SET Back_6 0		// tailfan, right most
SET Back_7 0		// tail, red
SET Back_8 0		// tail, left blue
SET Back_9 0		// tail, right blue
#endif
#if ERS310
SET Horn_O 0
SET Horn_G 0
SET Horn_B 0
#endif
#endif

:STARTUP_LOADVARS
SET AP_Voice_Cmd 0
SET VoiceCmd 0
VLOAD boygirl
VLOAD endure
VLOAD soccer

IF soccer < 1 THEN
  SET soccer 30
ENDIF

IF endure < 1 THEN
  SET endure 20
ENDIF

IF rcodeplus > 0 THEN
  AP_DIM behavior 4000 1	// Autosave/Autoload behavior array (configurations, learned behavior, etc...)
  AP_DIM kickhist 1000
  AP_DIM kickcheck 100
  AP_DIM colorarray 3168	// AiboPet image processing routines 
  AP_DIM trackarray 256		// Color tracking array (used in self docking)
  AP_DIM syn_voice 1000		// Synthetic voice playback array
  AP_DIM voicehist 100
ENDIF


//
// Sanity check camera settings...
//
if (behavior[BEHAVIOR_CAMERA_BALANCE]==0) then
  behavior[BEHAVIOR_CAMERA_BALANCE] := 3
endif

if (behavior[BEHAVIOR_CAMERA_GAIN]==0) then
  behavior[BEHAVIOR_CAMERA_GAIN] := 2
endif

if (behavior[BEHAVIOR_CAMERA_SHUTTER]==0) then
  behavior[BEHAVIOR_CAMERA_SHUTTER] := 2
endif


//
// User specified camera settings?
//
if (behavior[BEHAVIOR_CAMERA_MODE]>0) then
  AP_DEVCTL 1 behavior[BEHAVIOR_CAMERA_BALANCE]
  AP_DEVCTL 2 behavior[BEHAVIOR_CAMERA_GAIN]
  AP_DEVCTL 3 behavior[BEHAVIOR_CAMERA_SHUTTER]
  WAIT:500
endif


//
// Initialize voice dictionary history log...
//
for i 0 MAX_VOICEHIST-1
  voicehist[i] := -999
next


//
// Benchmark CPU & enable face recognition on SuperCore's...
// See how many loops performed in 1 second...
//
supercore := FALSE
count := 0
Clock := 0
while (Clock<1)
wend
while (Clock<30)
  ++count
wend
if (count>4000) then
  supercore := TRUE
endif

// If supercore, turn on face recognition...
if (supercore) then
  AP_DEVCTL 6 1
endif


//
// One more check on battery/temp status.  If good, go into
// sleep position.  If not, the rest mode...
//
CALL G_NEED2REST
  CASE:1 RET:GO_RESTPOS

CALL G_YART_Startup_Once
  CASE:GO_RESTPOS RET:GO_RESTPOS
  CASE:GO_STANDPOS RET:GO_STANDPOS
  CASE:GO_SITPOS RET:GO_SITPOS
  CASE:GO_WALK RET:GO_WALK

RET:GO_DOWNPOS





