
////////////////////////////////////////////////////////////////////
//                                                                //
//  DogsLife Charger Station Behavior Module                      //
//  Copyright (C) 2001-2002 by DogsBody & Ratchet Software        //
//  All Rights Reserved                                           //
//                                                                //
//  This is free software and MAY NOT be sold under any           //
//  circumstances, seperately or bundled.                         //
//                                                                //
////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////
// STATION_BORED
:G_STATION_BORED
CALL G_RANDOM4
  CASE:1 GO 2907
  CASE:2 GO 2906
  CASE:3 GO 2905
CALL G_STATION_PICKMEUP
WAIT
RET 1

:2905	// BORED3
PLAY ACTION STATION_BORED3
WAIT
RET 1

:2906	// BORED2
PLAY ACTION STATION_BORED2
WAIT
RET 1

:2907	// BORED1
PLAY ACTION STATION_BORED1
WAIT
RET 1

////////////////////////////////////////////////////////////////////
// STATION_CALM
:G_STATION_CALM
CALL G_RANDOM6
  CASE:1 PLAY ACTION STATION_EXERCISE
  CASE:2 PLAY ACTION STATION_LOOK1
  CASE:3 PLAY ACTION STATION_LOOK2
  CASE:4 PLAY ACTION STATION_LOOK3
  CASE:5 PLAY ACTION STATION_LOOK4
  CASE:6 PLAY ACTION STATION_SNEEZE
WAIT
RET 1

////////////////////////////////////////////////////////////////////
// STATION_HUH?
:G_STATION_HUH?
CALL G_VOICE_HIT
CALL G_RANDOM4
  CASE:1 PLAY ACTION STATION_HUH1
  CASE:2 PLAY ACTION STATION_HUH2
  CASE:3 PLAY ACTION STATION_NO1
  CASE:4 PLAY ACTION STATION_NO2
WAIT
RET 1

////////////////////////////////////////////////////////////////////
// STATION_PICKMEUP
:G_STATION_PICKMEUP
CALL G_RANDOM6
  CASE:1 PLAY ACTION STATION_PICKMEUP1
  CASE:2 PLAY ACTION STATION_PICKMEUP2
  CASE:3 PLAY ACTION STATION_PICKMEUP3
  CASE:4 PLAY ACTION STATION_PICKMEUP4
  CASE:5 PLAY ACTION STATION_PICKMEUP5
  CASE:6 PLAY ACTION STATION_PICKMEUP6
WAIT
RET 1

////////////////////////////////////////////////////////////////////
// STATION_SHUTDOWN
:G_STATION_SHUTDOWN
WAIT 1
SET init_wait Wait
WAIT 1
IF_1ST Posture1 = POSTURE_CHARGE1 2959	// Charger
CALL G_RANDOM6
  CASE:1 PLAY ACTION SLEEPY1
  CASE:2 PLAY ACTION SLEEPY2
  CASE:3 PLAY ACTION SLEEPY3
  CASE:4 PLAY ACTION SLEEPY4
  CASE:5 PLAY ACTION SLEEPY5
  CASE:6 PLAY ACTION SLEEPY6

:2943	// WAIT
CALL G_WAIT_AWARE
WAIT 1
IF_1ST Pink_Ball = 0 2946	// Nope
PLAY ACTION TRACK_HEAD PINK_BALL
RET 2	// ball

:2946	// VOICECMD?
CALL G_VOICECMD
if Context==GO_VOICE then
  if (VoiceCmd==VOICE_AIBO) || (VoiceCmd==VOICE2_HEYAIBO) || (VoiceCmd==VOICE_LETSPLAY) || (VoiceCmd==VOICE_GETUP) then
    CALL G_TWITCH_EARS
    RET 1 // voice
  endif
endif

:2949	// RANDOM1/3
CALL G_RANDOM1/3
  CASE:1 GO 2953

:2950	// HEAD_DOWN
RND pan -25 25
PLAY ACTION MOVE.HEAD.NORMAL pan -90
CALL G_WAIT
WAIT 2000
HALT
EXIT

:2953	// SNORE
PLAY ACTION STATION_SNORE
GO 2950

:2959	// RANDOM4
CALL G_RANDOM4
  CASE:1 PLAY ACTION STATION_SLEEPY1
  CASE:2 PLAY ACTION STATION_SLEEPY2
  CASE:3 PLAY ACTION STATION_SLEEPY3
  CASE:4 PLAY ACTION STATION_SLEEPY4
GO 2943

////////////////////////////////////////////////////////////////////
// STATION_TALKING
:G_STATION_TALKING
CALL G_RANDOM6
  CASE:1 PLAY ACTION STATION_TALKING1
  CASE:2 PLAY ACTION STATION_TALKING2
  CASE:3 PLAY ACTION STATION_TALKING3
  CASE:4 PLAY ACTION STATION_TALKING4
  CASE:5 PLAY ACTION STATION_TALKING5
  CASE:6 PLAY ACTION STATION_TALKING6
WAIT
RET 1

////////////////////////////////////////////////////////////////////
// STATION_VOICE_HANDLER
:G_STATION_VOICE_HANDLER
WAIT 1
SWITCH VoiceCmd
  CASE:VOICE_FINDBALL GO 2992		// Find Ball
  CASE:VOICE_KICKBALL GO 2992		// Kick Ball
  CASE:VOICE2_PINKBALL GO 2992		// Pink Ball
  CASE:VOICE2_RIGHTKICK GO 2992		// Right Kick - ZZZ - Should add right kick code
  CASE:VOICE2_LEFTKICK GO 2992		// Left Kick - ZZZ - Should add left kick code
  CASE:VOICE2_RIGHTTOUCH GO 2992	// Right Touch - ZZZ - Should add right touch code
  CASE:VOICE2_LEFTTOUCH GO 2992		// Left Touch - ZZZ - Should add left touch code
  CASE:VOICE_AIBO GO 2990		// AIBO
  CASE:VOICE2_HEYAIBO GO 2990		// Hey AIBO
  CASE:VOICE_HELLO GO 2990		// Hello
  CASE:VOICE_SAYHELLO GO 2990		// Say Hello
  CASE:VOICE2_THANKS GO 2990		// Thanks
  CASE:VOICE2_HAPPYDAY GO 2990		// Happy Day
  CASE:VOICE_AREYOUHUNGRY GO 2989	// Hungry?
  CASE:VOICE_AREYOUOK GO 2988		// Are you ok?
  CASE:VOICE2_HOWAREYOU GO 2988		// How are you?
  CASE:VOICE_AREYOUTIRED GO 2986	// Tired?
  CASE:VOICE_GOODMORNING GO 2990	// Good Morning
  CASE:VOICE_GOODNIGHT GO 2987		// Good Night
  CASE:VOICE_GOODBYE GO 2987		// Goodbye
  CASE:VOICE2_SEEYOU GO 2987		// See You
  CASE:VOICE_ROAR GO 2985		// Roar
  CASE:VOICE_MEOW GO 2985		// Meow
  CASE:VOICE2_SINGSONG GO 2985		// Sing Song
  CASE:VOICE_GOFORWARD GO 2983		// Forward
  CASE:VOICE2_GOAHEAD GO 2983		// Go Ahead
  CASE:VOICE_TURNLEFT GO 2984		// Left
  CASE:VOICE_TURNRIGHT GO 2981		// Right
  CASE:VOICE_WHATSYOURNAME GO 2993	// What's your name?
  CASE:VOICE2_WHATSOWNERNAME GO 2994	// What's owners name?
  CASE:VOICE_NAMEREG GO 2995		// Name Registration
  CASE:VOICE2_OWNERREG GO 2996		// Owner Registration
WAIT 1

if VoiceCmd >0 then
  CALL G_STATION_HUH?
endif
RET 1	// none

:2981	// LOOK_RIGHT
WAIT 1
SET init_wait Wait
PLAY ACTION MOVE_HEAD -90 0

:2982	// WAIT(2)
CALL G_WAIT_AWARE
RET 2	// done

:2983	// LOOK_FORWARD
WAIT 1
SET init_wait Wait
PLAY ACTION MOVE_HEAD 0 0
GO 2982

:2984	// LOOK_LEFT
WAIT 1
SET init_wait Wait
PLAY ACTION MOVE_HEAD 90 0
GO 2982

:2985	// SING
WAIT 1
SET init_wait Wait
PLAY ACTION STATION_SING
GO 2982

:2986	// TIRED?
CALL G_QUERY_TIRED
RET 2	// done

:2987	// SHUTDOWN
CALL G_STATION_SHUTDOWN
  CASE:1 RET 2	// done
RET 2	// done

:2988	// ARE_YOU_OK?
CALL G_QUERY_MOOD
RET 2	// done

:2989	// HUNGRY?
CALL G_QUERY_HUNGRY
  CASE:1 RET 2	// done
RET 2	// done

:2990	// HELLO
WAIT 1
SET init_wait Wait
PLAY ACTION STATION_WINK
CALL G_WAIT_AWARE
RET 2	// done

:2992	// FIND_BALL
CALL G_VOICE_HIT
CALL G_SOCCER_LOOK4BALL
  CASE:2 RET 2	// done
CALL G_RANDOM2
  CASE:1 PLAY ACTION+ ummm
  CASE:2 PLAY ACTION OHWELL
WAIT
RET 2	// done

:2993   // What's your name?
CALL G_PLAYBACK_AIBONAME
RET 2	// done

:2994   // What's owner name?
CALL G_PLAYBACK_OWNERNAME
RET 2	// done

:2995	// Name Registration
CALL G_NAME_REGISTRATION
RET 2	// done

:2996	// Owner Registration
CALL G_OWNER_REGISTRATION
RET 2	// done




////////////////////////////////////////////////////////////////////
// STATIONPOS  (Behavior when on charging station)
:G_STATIONPOS
RND bored_count 3 10	// # of cycles before bored
SET nosecount 0
CALL G_CLEAR_SENSORS

:3002	// INIT_TIMERS
SET Clock 0
RND TIMER_BORED 3 10		// 3 to 10 seconds
RND TIMER_LOOKAROUND 0 2	// 0 to 2 seconds
RND TIMER_REST 5 10		// 5 to 10 seconds
SET tailwag 0			// Set if tail wagging
SET tracking 0			// Set if watching ball

if (mood_happy>3) CALL G_START_TAILWAG_SLOW

:3004	// NEED2REST?
WAIT 1
IF_1ST Batt_Rest >= 20
IF_AND BODYTEMP() <= 45
IF_AND Batt_Temp <= 45 3006	// Nope

:3005	// STOP_HEADTAIL1
CALL G_STOP_HEADTAIL
RET 1	// rest

:3006	// ON_CHARGER?
WAIT 1
SWITCH Posture1
  CASE:POSTURE_PICKUP GO 3007	// Picked up?
  CASE:POSTURE_CHARGE1 GO 3007	// On charger? 
  CASE:POSTURE_CHARGE2 GO 3007	// On charger? 
GO 3005

:3007	// REST_TIMER
CALL G_REST_TIMER
WAIT 1
if (tracking==0) || (Pink_Ball>0) then
  PLAY ACTION TRACK_HEAD PINK_BALL
  SET tracking 1
else
  SET tracking 0
endif

:3010	// ATTENTION?
CALL G_SLEEP_ATTENTION
  CASE:GO_IDLE     GO 3031
  CASE:GO_PRAISE   GO 3030
  CASE:GO_PETTED   GO 3029
  CASE:GO_SCOLD    GO 3026
  CASE:GO_RESTPOS  GO 3031
  CASE:GO_SITPOS   GO 3031
  CASE:GO_STANDPOS GO 3031
  CASE:GO_WALK     GO 3031
  CASE:GO_DOWNPOS  GO 3031

CALL G_STATION_VOICE_HANDLER
  CASE:1 GO 3013
  CASE:2 GO 3012

:3012	// loop
ADD change_thres 2
GO 3002

:3013	// NOSE_SENSE?
CALL G_SLEEP_NOSE_SENSE
CALL G_TIMER1
  CASE:1 GO 3004
CALL G_STOP_HEADTAIL

RND TIMER_BORED 3 10
SUB bored_count 1

IF_1ST rcodeplus = 0 3018
IF_1ST AP_Voice_Cmd = 0 3018
IF_1ST AP_Voice_Level >= MIN_VOICE_LEVEL 3010

:3018	// WHAT_TO_DO?
RND rndnum 0 100
IF_1ST rndnum >= 90 3020	// 50% chance
IF_1ST rndnum > 33
IF_AND bored_count < 3 3022
IF_1ST rndnum > 66
IF_AND bored_count >= 3
IF_AND mood_happy > 5 3021

:3020	// STATION_CALM
CALL G_STATION_CALM
ADD change_thres 2
GO 3002

:3021	// STATION_TALK
CALL G_STATION_TALKING
ADD change_thres 2
GO 3002

:3022	// STATION_BORED
CALL G_STATION_BORED
WAIT 1

IF Fav_Color <> 0 3012	// Nope

CALL G_DEC_HAPPY_MOOD
CALL G_BEHAVIOR_BORED
ADD change_thres 2
GO 3002

:3026	// SCOLD
CALL G_SCOLD_REST

:3027	// RESET_BORED
RND bored_count 5 10
CALL G_CLEAR_SENSORS
ADD change_thres 2
GO 3002

:3029	// SLEEP_PETTED
CALL G_SLEEP_PETTED
GO 3027

:3030	// PRAISE
CALL G_PRAISE_REST
GO 3027

:3031	// LOOK_TIMER
CALL G_LOOK_TIMER
GO 3013


