
////////////////////////////////////////////////////////////////////
//                                                                //
//  DogsLife Table Leg Search Module                              //
//  Copyright (C) 2001-2002 by DogsBody & Ratchet Software        //
//  All Rights Reserved                                           //
//                                                                //
//  This is free software and MAY NOT be sold under any           //
//  circumstances, seperately or bundled.                         //
//                                                                //
////////////////////////////////////////////////////////////////////


#undef DEBUG_TABLE
#define GO_WFT_SEETABLE 1000
#define GO_WFT_FIREAWAY 1001


//
// Scan looking for something akin to a table leg.  An AIBO has "needs"...
// Look one way, then the other, then back again.
//
// Return values:
//   GO_RESTPOS		Did something that transitioned into rest position
//   GO_DOWNPOS		Did something that transitioned into down position
//   GO_SITPOS		Did something that transitioned into sit position
//   GO_STANDPOS	Did something that transitioned into stand position
//   GO_SEEBALL		See the ball!!!
//   GO_TURN		Turn to direction in variable "pan" (distance in variable "dd")
//   GO_TURNSCAN	Caller must look for a direction to turn.
//
:G_WALK_FINDTABLE
  LOCAL temp 0
#ifdef DEBUG_TABLE
  PRINT "WALK_FINDTABLE"
#endif

  CALL G_NEED2REST
    CASE:1 RET:GO_RESTPOS

  SET pan 0
  SET dd 0

  RND rndnum 0 100
  IF rndnum < 50 WFT_LOOKRIGHT

:WFT_LOOKLEFT
  SET panadjust -5
  ADD temp 1
  IF temp > 2 WFT_LOOKAHEAD
  WAIT 1
  SET wft_initwait Wait
  PLAY:ACTION:MOVE.HEAD.SLOW:75:0	// Move head left
  CALL G_WFT_SCAN
    CASE:GO_IDLE:GO:WFT_LOOKRIGHT
    CASE:GO_WFT_SEETABLE:GO:WFT_SEE_TABLE
  RET:Context

:WFT_LOOKRIGHT
  SET panadjust 5
  ADD temp 1
  IF temp > 2 WFT_LOOKAHEAD
  WAIT 1
  SET wft_initwait Wait
  PLAY:ACTION:MOVE.HEAD.SLOW:-75:0	// Move head right
  CALL G_WFT_SCAN
    CASE:GO_IDLE:GO:WFT_LOOKLEFT
    CASE:GO_WFT_SEETABLE:GO:WFT_SEE_TABLE
  RET:Context

:WFT_LOOKAHEAD
  WAIT 1
  SET wft_initwait Wait
  PLAY:ACTION:MOVE.HEAD.SLOW:0:0	// Move head straight ahead
  CALL G_WFT_SCAN
    CASE:GO_IDLE:GO:WFT_NO_TABLE
    CASE:GO_WFT_SEETABLE:GO:WFT_SEE_TABLE
  RET:Context

:WFT_NO_TABLE
  STOP
  WAIT
  PLAY ACTION MOVE_HEAD 0 0
//  CALL G_STOP_TAILWAG
  WAIT

  RND rndnum 0 100
  IF rndnum > 75 THEN
    PLAY ACTION+ antsy
    WAIT
  ELSE
    IF rndnum > 50 THEN
      PLAY ACTION BOTH_EAR_TWITCH2
      WAIT
    ENDIF
  ENDIF

#ifdef DEBUG_TABLE
  PRINT:"GO_TURN pan=%d dd=%d result=%d":pan:dd:GO_TURN
#endif
  CALL G_DEC_HAPPY_MOOD
  RET:GO_TURN

:WFT_SEE_TABLE
  // Move closer to table...
  CALL G_WFT_MOVECLOSER
  if (Context != GO_WFT_FIREAWAY) then
    RET:Context
  endif

  // Process YART "see table" override...
  CALL G_YART_Walking_SeeTable
  if (Context != GO_AHEAD) then
    RET:Context
  endif

  // Ready to fire!  heh heh...  Oh, but -how- 
  // should we fire?  Decisions, decisions...
  CALL G_INC_HAPPY_MOOD
  SET temp 5

:WFT_PICKACT
  if (--temp>0) then
    SET rndbase 1750
    SET rndcount 11
    SET lastact1 -1
    SET lastact2 -1
    if (F_BEHAVIOR_RNDN()) WFT_FIRE
  endif

  CALL G_DEC_HAPPY_MOOD
  CALL G_INC_SAD_MOOD
  PLAY ACTION+ sad_eyes		// No options available.  Aeeiii!!!!
  WAIT
  RET:GO_TURNSCAN

:WFT_FIRE
  // Ensure only appropriate actions for girl/boy bot's are used...
  if ((BOYBOT) && (rndnum==1752)) || ((GIRLBOT) && (rndnum>1752)) then
    GO WFT_PICKACT
  endif

  // Sniff left?
  IF (rndnum==1750) THEN
    SUB table_pan 45
    PLAY ACTION TURN table_pan
    WAIT
    PLAY ACTION STAND			// Stand up straight
    WAIT
    PLAY ACTION+ sniff_left		// Check for other Aibo's... 
  ENDIF

  // Sniff right?
  IF (rndnum==1751) THEN
    ADD table_pan 45
    PLAY ACTION TURN table_pan
    WAIT
    PLAY ACTION STAND			// Stand up straight
    WAIT
    PLAY ACTION+ sniff_right		// Check for other Aibo's...
  ENDIF

  // Squat piddle (girl-bot's only)...
  if (rndnum==1752) then
    if (rndnum%1) then
      ADD table_pan 200
    else
      SUB table_pan 200
    endif
    PLAY ACTION TURN table_pan		// Get in position
    WAIT
    PLAY ACTION+ piddle_girl		// Let'r rip...
  endif
  
  // Piddle left...
  IF rndnum == 1753 THEN
    SUB table_pan 120
    PLAY ACTION TURN table_pan		// Get in position
    WAIT
    PLAY ACTION+ piddle_left		// Let'r rip...
  ENDIF

  // Piddle right...
  IF rndnum == 1754 THEN
    ADD table_pan 120
    PLAY ACTION TURN table_pan		// Get in position
    WAIT
    PLAY ACTION+ piddle_right		// Let'r rip...
  ENDIF

  // Piddle left (version 2)...
  IF rndnum == 1755 THEN
    SUB table_pan 120
    PLAY ACTION TURN table_pan		// Get in position
    WAIT
    PLAY ACTION+ piddle2_left		// Let'r rip...
  ENDIF

  // Piddle right (version 2)...
  IF rndnum == 1756 THEN
    ADD table_pan 120
    PLAY ACTION TURN table_pan		// Get in position
    WAIT
    PLAY ACTION+ piddle2_right		// Let'r rip...
  ENDIF

  // Piddle left (version 3) -- Sniff then piddle...
  IF rndnum == 1757 THEN
    SUB table_pan 45
    PLAY ACTION TURN table_pan
    WAIT
    PLAY ACTION STAND			// Stand up straight
    WAIT
    PLAY ACTION+ sniff_left		// Check for other Aibo's... 
    WAIT
    PLAY ACTION TURN -90		// Get in position
    WAIT
    PLAY ACTION+ piddle3_left		// Let them know we were here...
  ENDIF

  // Piddle right (version 3) -- Sniff then piddle...
  IF rndnum == 1758 THEN
    ADD table_pan 45
    PLAY ACTION TURN table_pan
    WAIT
    PLAY ACTION STAND			// Stand up straight
    WAIT
    PLAY ACTION+ sniff_right		// Check for other Aibo's...
    WAIT
    PLAY ACTION TURN 90			// Get in position
    WAIT
    PLAY ACTION+ piddle3_right		// Let them know we were here...
  ENDIF

  // Piddle left (version 4) -- hard start...
  IF rndnum == 1759 THEN
    SUB table_pan 120
    PLAY ACTION TURN table_pan		// Get in position
    WAIT
    PLAY ACTION+ piddle4_left		// Let'r rip...
  ENDIF

  // Piddle right (version 4) -- hard start...
  IF rndnum == 1760 THEN
    ADD table_pan 120
    PLAY ACTION TURN table_pan		// Get in position
    WAIT
    PLAY ACTION+ piddle4_right		// Let'r rip...
  ENDIF

  WAIT
  RET:GO_TURNSCAN
// END G_WALK_FINDTABLE



////////////////////////////////////////////////////////////////////////////////
//
// Scan looking for something akin to a table leg.  An AIBO has "needs"...
// Return values:
//   GO_IDLE		Nothing of interest happened or was found.
//   GO_RESTPOS		Did something that transitioned into rest position
//   GO_DOWNPOS		Did something that transitioned into down position
//   GO_SITPOS		Did something that transitioned into sit position
//   GO_STANDPOS	Did something that transitioned into stand position
//   GO_SEEBALL		See the ball!!!
//   GO_WFT_SEETABLE	See a table!!!   Position in variable "table_pan" 
//
:G_WFT_SCAN
#ifdef DEBUG_TABLE
  PRINT "WFT_SCAN"
#endif

  SET lastpan -1
  SET lastdist -1
  SET rise_edge_pan -1
  SET rise_edge_dist -1
  SET fall_edge_pan -1
  SET fall_edge_dist -1
  SET mapmode 0
  SET Clock 0

  SET Distance 0
  WHILE Wait > wft_initwait
    WAIT 1
    SET d Distance
    SET p Head_Pan

    IF Clock > 16 THEN
      CALL G_WALK_ATTENTION_HANDLER
        CASE:GO_DOWNPOS RET GO_DOWNPOS
        CASE:GO_RESTPOS RET GO_RESTPOS
        CASE:GO_SEEBALL RET GO_SEEBALL
        CASE:GO_SITPOS RET GO_SITPOS
        CASE:GO_STOP RET GO_STANDPOS
        CASE:GO_STANDPOS RET GO_STANDPOS
      SET Clock 0
    ENDIF

    IF Pink_Ball > 0 THEN
      RET:GO_SEEBALL
    ENDIF

    IF d > 0 THEN
#ifdef DEBUG_TABLE
      PRINT:"d=%d pan=%d dd=%d":d:pan:dd
#endif

      CALL G_WALK_UPDATE_BEST_DISTANCE
      SET Distance 0

      IF lastdist > 0 THEN
        SET temp (lastdist-d)

        IF (mapmode == 0) && (temp>50) && (d<400) THEN
 	  SET rise_edge_dist d
	  SET rise_edge_pan (p+lastpan)/2
	  SET mapmode 1
        ENDIF

        IF mapmode == 1 THEN
	  SET pandelta (p-rise_edge_pan)
	  IF (pandelta<=30) && (pandelta>=-30) && (temp<-50) THEN
	    SET mapmode 2
 	    SET fall_edge_dist d
	    SET fall_edge_pan (p+lastpan)/2 
	    SET table_pan fall_edge_pan-(pandelta/2)+panadjust
	    RET:GO_WFT_SEETABLE
  	  ENDIF
        ENDIF
      ENDIF
      SET lastdist d
      SET lastpan p
    ENDIF
    WAIT 1
  WEND
  RET:GO_IDLE
// END G_WFT_SCAN




////////////////////////////////////////////////////////////////////////////////
//
// Move closer to table...
// Return Values:
//   GO_DOWNPOS		Did something that transitioned into down position
//   GO_SITPOS		Did something that transitioned into sit position
//   GO_STANDPOS	Did something that transitioned into stand position
//   GO_SEEBALL		See the ball!!!
//   GO_WFT_FIREAWAY	All lined up.  Ready to fire!
//
:G_WFT_MOVECLOSER
  STOP
  WAIT
  PLAY ACTION MOVE.HEAD.FAST table_pan 0	// Look at table
//  CALL G_STOP_TAILWAG
  WAIT

  // Pause for effect...
  WAIT 500

  SET dist Distance
  IF fall_edge_dist < d THEN
    SET dist fall_edge_dist
  ENDIF

  IF rise_edge_dist < d THEN
    SET dist rise_edge_dist
  ENDIF

  IF dist < 150 THEN
    RET:GO_WFT_FIREAWAY
  ENDIF

  // Need to turn?
  IF table_pan > 25 WFT_TURN2TABLE
  IF table_pan < -25 WFT_TURN2TABLE

  // Nope... Just get closer to table...
  SUB dist 100
  PLAY ACTION WALK 0 dist	// Get closer
  SET TIMER_BORED 10		// Give 10sec for move
  SET mindist 200		// Don't get too close
  CALL G_WFT_WALKFWD
    CASE:GO_IDLE RET:GO_WFT_FIREAWAY
  RET:Context

:WFT_TURN2TABLE
  SET map_state 0
  SET fall_edge_pan 0
  SET rise_edge_pan 0
  SET fall_edge_dist 0
  SET rise_edge_dist 0
  SET init_lookwait 0

  PLAY ACTION TURN table_pan

  // table_pan 41 to 90?
  IF table_pan > 40 THEN	
    PLAY ACTION MOVE_HEAD 90 0
    GO WFT_INITMAP_RIGHT
  ENDIF

  // table_pan 1 to 40?
  IF table_pan > 0 THEN	
    PLAY ACTION MOVE_HEAD 45 0
    GO WFT_INITMAP_RIGHT
  ENDIF

  // table_pan -39 to 0?
  IF table_pan > -40 THEN	
    PLAY ACTION MOVE_HEAD -45 0
    GO WFT_INITMAP_LEFT
  ENDIF

  // table_pan -90 to -40
  PLAY ACTION MOVE_HEAD -90 0

:WFT_INITMAP_LEFT
  WAIT
  SET wft_initwait 0
  PLAY ACTION MOVE.HEAD.SLOW 45 0
  CALL G_WFT_SCAN
    CASE:GO_WFT_SEETABLE GO G_WFT_MOVECLOSER
    CASE:GO_IDLE GO WFT_LOSTTABLE
  RET:Context

:WFT_INITMAP_RIGHT
  WAIT
  SET wft_initwait 0
  PLAY ACTION MOVE.HEAD.SLOW -45 0
  CALL G_WFT_SCAN
    CASE:GO_WFT_SEETABLE GO G_WFT_MOVECLOSER
    CASE:GO_IDLE GO WFT_LOSTTABLE
  RET:Context

// Lost sight of the table.  Fire anyway...
:WFT_LOSTTABLE
  SET table_pan 0
  RET:GO_WFT_FIREAWAY

// END G_WFT_MOVECLOSER




////////////////////////////////////////////////////////////////////
//
//  Walk until WAIT or distance criteria are met...
//
:G_WFT_WALKFWD
SET Clock 0

:3593	// ALL_CLEAR?
WAIT 1
IF Pink_Ball > 0 THEN
  CALL G_STOP_WALK
  RET:GO_SEEBALL
ENDIF

IF Wait > 0 THEN
  IF Distance > mindist THEN
    CALL G_NEED2REST
      CASE:1 GO 3597
    CALL G_TIMER1
      CASE:1 GO 3593
  ENDIF
ENDIF

CALL G_STOP_WALK
RET:GO_IDLE

:3597	// stop(2)
CALL G_STOP_WALK
RET:GO_RESTPOS



////////////////////////////////////////////////////////////////////
// STOP_WALK  (Issue stop walk command, if we are walking.)
:G_STOP_WALK
WAIT 1
IF_1ST Wait <= 0 3043
PLAY ACTION WALK 0 1
WAIT

:3043	// RETURN
RET 1


