
////////////////////////////////////////////////////////////////////
//                                                                //
//  DogsLife Timers Module                                        //
//  Copyright (C) 2001-2003 by DogsBody & Ratchet Software        //
//  All Rights Reserved                                           //
//                                                                //
//  This is free software and MAY NOT be sold under any           //
//  circumstances, seperately or bundled.                         //
//                                                                //
////////////////////////////////////////////////////////////////////



//
// Decrement timer counts once per second.  Uses system clock tick
// variables which increments every 32ms.  32ms*32 = ~1 second.
//
// If timer count negative, then its already expired.
// If timer count is MAXINT, then its disabled.
// 
:G_TIMERS
  WAIT:1
  if (Clock<32) then
    if (Clock>=0) then
      RET 1
    endif
  endif

  Clock := 0
  if (TIMER_BORED+1)>0 then	// Decrement if timer count between 0 and 32766
    --TIMER_BORED
  endif
  if (TIMER_LOOKAROUND+1)>0 then
    --TIMER_LOOKAROUND
  endif
  if (TIMER_REST+1)>0 then
    --TIMER_REST
  endif
  if (TIMER_EXPECT+1)>0 then
    --TIMER_EXPECT
  endif
  if (TIMER_CLEARLEDS+1)>0 then
    --TIMER_CLEARLEDS
  endif
  if (TIMER_GAME+1)>0 then
    --TIMER_GAME
  endif
  if (TIMER_GOFORIT+1)>0 then
    --TIMER_GOFORIT
  endif
  if (TIMER_MOOD+1)>0 then
    --TIMER_MOOD
  endif
  if (TIMER_TIRED+1)>0 then
    --TIMER_TIRED
  endif
  if (TIMER_HELLO+1)>0 then
    --TIMER_HELLO
  endif
  if (TIMER_VOICE+1)>0 then
    --TIMER_VOICE
  endif

#ifdef ERS310
  if (TIMER_310ROLL+1)>0 then
    --TIMER_310ROLL
  endif
#endif

  if (TIMER_GAME_ELAPSED()) then
    if (behavior[BEHAVIOR_ELEPHANT_MODE]) then
      TIMER_GAME := MAXINT
    else
      TIMER_GAME := GAME_TIMER_INTERVAL	
      --behavior[BEHAVIOR_SKILL_TICTACTOE]
      if (behavior[BEHAVIOR_SKILL_TICTACTOE]<MIN_TTT_SKILL) then
        behavior[BEHAVIOR_SKILL_TICTACTOE] := MIN_TTT_SKILL
      endif
    endif
  endif

  if (TIMER_VOICE_ELAPSED()) then
    TIMER_VOICE := VOICE_TIMER_INTERVAL
    AP_BMOVE voicehist 0 1 MAX_VOICEHIST-1
    voicehist[0] := -999
  endif

  if (TIMER_CLEARLEDS_ELAPSED()) then
    TIMER_CLEARLEDS := MAXINT
#ifdef ERS210
    Eye_L1 := Eye_R1 := Eye_L2 := Eye_R2 := Eye_L3 := Eye_R3 := 0
#endif
#ifdef ERS220
    Eye_L1 := Eye_R1 := Eye_L2 := Eye_R2 := Eye_L3 := Eye_R3 := 0
    Spot := Back_1 := Back_2 := Back_3 := Back_4 := Back_5 := Back_6 := Back_7 := Back_8 := Back_9 := 0
#endif
#ifdef ERS310
    Horn_G := Horn_B := Horn_O := 0
#endif
  endif

  RET 1


////////////////////////////////////////////////////////////////////
// TIMER1 - Used to time getting bored...
:G_TIMER1
  CALL G_TIMERS
  IF maxtime1 < 0 THEN
    RET 2 // timeout
  ENDIF
  RET 1


////////////////////////////////////////////////////////////////////
// TIMER2 - Used to time looking around...
:G_TIMER2
  CALL G_TIMERS
  IF maxtime2 < 0 THEN
    RET 2 // timeout
  ENDIF
  RET 1


////////////////////////////////////////////////////////////////////
// TIMER3 - Used to time getting tired...
:G_TIMER3
  CALL G_TIMERS
  IF maxtime3 < 0 THEN
    RET 2 // timeout
  ENDIF
  RET 1


////////////////////////////////////////////////////////////////////
// TIMER4 - Used to time getting sad...
:G_TIMER4
  CALL G_TIMERS
  IF maxtime4 < 0 THEN
    RET 2 // timeout
  ENDIF
  RET 1



////////////////////////////////////////////////////////////////////
// 
//  Timer used to detect getting bored.  Auto reset the count
//  an update the bored count...
//
:G_BORED_TIMER
  CALL G_TIMERS
  if (TIMER_BORED_ELAPSED()) THEN
    CALL G_STOP_TAILWAG
    RND TIMER_BORED 3 10
    SUB bored_count 1
    RET 2
  ENDIF

  // If TIMER_EXPECT was set, AIBO expected something to happen within
  // a limited amount of time.  If timer expires, it didn't happen... :-(
  if (TIMER_EXPECT_ELAPSED()) then // sad?
    TIMER_EXPECT := MAXINT
    CALL G_INC_SAD_MOOD
  ENDIF

  // Slowly get better on own if mad or sad...
  if (mood_sad>0) || (mood_mad>0) then
    if (TIMER_MOOD>1000) then
      CALL G_INIT_MOOD_TIMER
    endif
    if (TIMER_MOOD_ELAPSED()) then
      CALL G_INIT_MOOD_TIMER
      CALL G_DEC_SAD_MOOD
      CALL G_DEC_MAD_MOOD
    endif
  endif
  RET 1


////////////////////////////////////////////////////////////////////
// Set the mood timer, used to slowly improve mood if nothing
// stimulating is happening...
:G_INIT_MOOD_TIMER
  RND TIMER_MOOD 30 60
  RET:1


////////////////////////////////////////////////////////////////////
// LOOK_TIMER  (Look around randomly)
:G_LOOK_TIMER
  CALL G_TIMER2
    CASE:1 RET 1
  WAIT 1
  RND tilt -40 10
  RND pan -60 60
  SET look_wait Wait

  #ifdef ERS310
  CALL G_RANDOM2
    CASE:1 PLAY ACTION MOVE.HEAD.NORMAL pan tilt 10
    CASE:2 PLAY ACTION MOVE.HEAD.SLOW pan tilt 10

  #else
  CALL G_RANDOM3
    CASE:1 PLAY ACTION MOVE.HEAD.FAST pan tilt
    CASE:2 PLAY ACTION MOVE.HEAD.NORMAL pan tilt
    CASE:3 PLAY ACTION MOVE.HEAD.SLOW pan tilt
  #endif
  RND TIMER_LOOKAROUND 1 3
  RET 1


////////////////////////////////////////////////////////////////////
// REST_TIMER
:G_REST_TIMER
  CALL G_TIMER3
    CASE:1:RET 1

  // timeout...
  RND TIMER_REST 8 15
  CALL G_DEC_TIRED_MOOD
  RET 1


////////////////////////////////////////////////////////////////////
// TIMER_TIRED
:G_TIMER_TIRED
  CALL G_NEED2REST
    CASE:1 RET 1	// tired

  // If something time consuming was happening, 
  // compensate in tired timer...
  WHILE Clock > 100 
    SUB TIMER_TIRED 1
    SUB Clock 100
  WEND

  // Timer tick?
  CALL G_TIMERS

  // If tired timer not expired, return...
  IF TIMER_TIRED >= 0 THEN
    RET 2 // play
  ENDIF

  RND TIMER_TIRED 5 10
  ADD TIMER_TIRED endure

  ADD mood_tired 1
  IF mood_tired > MOOD_MAX THEN
    SET mood_tired MOOD_MAX
  ENDIF

  IF mood_tired > 9 THEN
    RET 1 // tired
  ENDIF
  RET 2	// play



