
////////////////////////////////////////////////////////////////////
//                                                                //
//  DogsLife Walk-Around Behavior Module                          //
//  Copyright (C) 2001-2002 by DogsBody & Ratchet Software        //
//  All Rights Reserved                                           //
//                                                                //
//  This is free software and MAY NOT be sold under any           //
//  circumstances, seperately or bundled.                         //
//                                                                //
////////////////////////////////////////////////////////////////////


//
//  Main walking loop...
//
:G_WALK_ABOUT
CALL G_CHECK_SITONLY
  CASE:GO_DOWNPOS RET:GO_DOWNPOS
  CASE:GO_SITPOS RET:GO_SITPOS

CALL G_NEED2REST
  CASE:1 RET:GO_RESTPOS

CALL G_WAITZERO
PLAY ACTION STAND
CALL G_WAITZERO

if (F_RND100()<5) then		// Go "meep-meep" occasionally...
  PLAY ACTION roadrunner
  CALL G_WAITZERO
endif

CLR SENSORS
SET ex_pan_r 999		// Disable turn exclude
SET ex_pan_l 999
RND TIMER_TIRED 5 10
ADD TIMER_TIRED endure

WAIT 1
IF Back_LONG>0 THEN		// Stop if back 3sec
  RET:GO_RESTPOS
ENDIF

// Stop walking if see ball...
if (F_SEE_BALL()==GO_SEEBALL) then
  RET:GO_SEEBALL
endif

:WA_WALKLOOP
CALL G_WALK_LOOK_AROUND
  CASE:1 GO 3635
  CASE:2 RET:GO_SEEBALL
  CASE:3 GO 3634
  CASE:4 GO 3633
  CASE:5 RET:GO_STANDPOS
  CASE:6 GO WA_TURN
  CASE:7 GO WA_WALKING

:WA_FOUNDCLIFF
CALL G_WALK_FOUND_CLIFF
  CASE:GO_TURN GO WA_WALKLOOP
  CASE:GO_SEEBALL RET:GO_SEEBALL
  CASE:GO_RESTPOS GO 3635
  CASE:GO_DOWNPOS GO 3634
  CASE:GO_SITPOS GO 3633
  CASE:GO_STANDPOS RET:GO_STANDPOS

:WA_WALKING
CALL G_WALK_WALKING
  CASE:1 GO WA_OBSTACLE
  CASE:2 GO 3635
  CASE:3 RET GO_SEEBALL
  CASE:4 GO 3634
  CASE:5 GO 3633
  CASE:6 RET GO_STANDPOS
GO WA_FOUNDCLIFF

:WA_TURN
CALL G_WALK_TURN?
  CASE:1 GO 3635
  CASE:3 GO 3634
  CASE:4 GO 3633
  CASE:5 RET GO_STANDPOS
  CASE:6 GO WA_WALKING
  CASE:7 GO WA_FOUNDCLIFF

// Call obstacle customization routine...
:WA_OBSTACLE
CALL G_CUSTOM_WALK_OBSTACLE
  CASE:GO_DOWNPOS RET:GO_DOWNPOS
  CASE:GO_SITPOS RET:GO_SITPOS
  CASE:GO_STANDPOS RET:GO_STANDPOS
  CASE:GO_SEEBALL RET:GO_SEEBALL
GO WA_WALKLOOP

:3633	// DEC_ENDURE
CALL G_DEC_ENDURE
RET:GO_SITPOS

:3634	// DEC_ENDURE
CALL G_DEC_ENDURE
RET:GO_DOWNPOS

:3635	// INC_ENDURE
CALL G_INC_ENDURE
RET:GO_RESTPOS



////////////////////////////////////////////////////////////////////
//
//  Wait while in walking mode...
//
:G_WAIT_WALK
while Wait>init_walkwait 
  CALL G_WALK_ATTENTION_HANDLER
    CASE:GO_DOWNPOS RET 2  // down
    CASE:GO_RESTPOS RET 3  // rest
    CASE:GO_SEEBALL RET 4  // ball
    CASE:GO_SITPOS RET 5   // sit
    CASE:GO_STOP RET 7	   // stop
    CASE:GO_STANDPOS RET 6 // stand
  WAIT 100
wend
RET 1



////////////////////////////////////////////////////////////////////
//
//  Process voice commands while walking...
//
:G_WALK_ATTENTION_HANDLER
CALL G_TIMER_TIRED
  CASE:1 RET GO_RESTPOS

CALL G_CHECK_SITONLY
  CASE:GO_DOWNPOS  RET GO_DOWNPOS
  CASE:GO_SITPOS   RET GO_SITPOS

CALL G_ATTENTION_HANDLER
  CASE:GO_PRAISE   GO 3254
  CASE:GO_PETTED   GO 3254
  CASE:GO_SCOLD    GO 3253
  CASE:GO_RESTPOS  RET GO_RESTPOS
  CASE:GO_DOWNPOS  RET GO_DOWNPOS
  CASE:GO_SITPOS   RET GO_SITPOS
  CASE:GO_STANDPOS RET GO_STANDPOS
  CASE:GO_WALK     RET GO_IDLE
  CASE:GO_IDLE     RET GO_IDLE

:WAH_PROCESSVOICE

// Process YART voice command customization routine...
CALL G_YART_VoiceCmd
  CASE:GO_RESTPOS  RET GO_RESTPOS
  CASE:GO_DOWNPOS  RET GO_DOWNPOS
  CASE:GO_SITPOS   RET GO_SITPOS
  CASE:GO_STANDPOS RET GO_STANDPOS
  CASE:GO_WALK     RET GO_IDLE

// Call voice command customization routine...
CALL G_CUSTOM_WALK_VOICECMD
  CASE:GO_DOWNPOS RET:GO_DOWNPOS
  CASE:GO_SITPOS RET:GO_SITPOS
  CASE:GO_STANDPOS RET:GO_STANDPOS
  CASE:GO_SEEBALL RET:GO_SEEBALL
  CASE:GO_IGNORE RET:GO_IDLE

//
// If not overridden, do normal voice command processing....
//

// Only proceed if valid voice command.  Don't want to stop what
// we are doing because of a bogus voice command...
SWITCH VoiceCmd
  CASE:VOICE_GOODMORNING  GO 3210	// Good Morning
  CASE:VOICE_GOODNIGHT 	  GO 3210	// Good Night
  CASE:VOICE_GOODBYE 	  GO 3210	// Goodbye
  CASE:VOICE_AIBO 	  GO 3210	// AIBO
  CASE:VOICE_HELLO 	  GO 3210	// Hello
  CASE:VOICE_SAYHELLO 	  GO 3210	// Say Hello
  CASE:VOICE_FINDBALL 	  GO 3210	// Find Ball
  CASE:VOICE_KICKBALL 	  GO 3210	// Kick Ball
  CASE:VOICE_LETSDANCE 	  GO 3210	// Dance
  CASE:VOICE_GETUP 	  GO 3210	// Get Up
  CASE:VOICE_STANDUP 	  GO 3210	// Stand Up
  CASE:VOICE_AREYOUOK 	  GO 3210	// Are you ok?
  CASE:VOICE_GOFORWARD 	  GO 3210	// Go Forward
  CASE:VOICE_GOBACK 	  GO 3210	// Go Back
  CASE:VOICE_TURNLEFT 	  GO 3210	// Go Left
  CASE:VOICE_TURNRIGHT 	  GO 3210	// Go Right
  CASE:VOICE_POSE 	  GO 3210	// Pose
  CASE:VOICE_ROAR 	  GO 3210	// Roar
  CASE:VOICE_MEOW 	  GO 3210	// Meow
  CASE:VOICE_AREYOUTIRED  GO 3210	// Tired?
  CASE:VOICE_AREYOUHUNGRY GO 3210	// Hungry?
  CASE:VOICE_STOP 	  GO 3210	// Stop
  CASE:VOICE_SITDOWN 	  GO 3210	// Sit
  CASE:VOICE_SHAKEPAW 	  GO 3210	// Shake
  CASE:VOICE_SHAKE 	  GO 3210	// Shake
  CASE:VOICE_OTHERPAW 	  GO 3210	// Other Paw
  CASE:VOICE_KARATECHOP   GO 3210	// Karate Chop
  CASE:VOICE_LETSPLAY 	  GO 3210	// Let's Play
  CASE:VOICE_LAYDOWN 	  GO 3210	// Lie Down / Play Dead
  CASE:VOICE_NAMEREG 	  GO 3210	// Name Registration
  CASE:VOICE_WHATSYOURNAME GO 3210	// What's your name?
  CASE:VOICE2_THANKS 	  GO 3210	// Thanks
  CASE:VOICE2_HAPPYDAY	  GO 3210	// Happy Day
  CASE:VOICE2_HEYAIBO 	  GO 3210	// Hey AIBO
  CASE:VOICE2_SEEYOU 	  GO 3210	// See You
  CASE:VOICE2_HOWAREYOU	  GO 3210	// How Are You?
  CASE:VOICE2_SINGSONG	  GO 3210	// Sing Song
  CASE:VOICE2_CLOWNAROUND GO 3210	// Clown Around
  CASE:VOICE2_HAPPYDAY	  GO 3210	// Happy Day
  CASE:VOICE2_GOAHEAD	  GO 3210	// Go Ahead
  CASE:VOICE2_BANZAI	  GO 3210	// Banzai
  CASE:VOICE2_SHOWTIME 	  GO 3210	// Show Time
  CASE:VOICE2_SHOWOFF	  GO 3210	// Show Off
  CASE:VOICE2_PINKBALL    GO 3210	// Pink Ball
  CASE:VOICE2_RIGHTKICK   GO 3210	// Right Kick - ZZZ - Should add right kick code
  CASE:VOICE2_LEFTKICK    GO 3210	// Left Kick - ZZZ - Should add left kick code
  CASE:VOICE2_RIGHTTOUCH  GO 3210	// Right Touch - ZZZ - Should add right touch code
  CASE:VOICE2_LEFTTOUCH   GO 3210	// Left Touch - ZZZ - Should add left touch code
  CASE:VOICE2_OWNERREG    GO 3210	// Owner Registration
  CASE:VOICE2_WHATSOWNERNAME GO 3210	// What's owners name?
#if ERS210 || ERS220
  CASE:VOICE2_ACTION1 	  GO 3210	// Self Dock ("Action 1")
#endif
RET GO_IDLE

:3210	// BUSY?
IF Wait > 0 THEN
  IF walking == WALKING_IDLE THEN // stop head & tail
    SET dd d
    SET pan Head_Pan
    PLAY ACTION MOVE.HEAD.FAST pan 0
    PLAY ACTION PALONE.AUTO.TAILSTOP
  ENDIF

  IF walking == WALKING_ACTIVE THEN // stop walking
    PLAY ACTION MOVE.MOVE.FAST 0 0
  ENDIF

  IF walking == WALKING_SOCCER THEN // stop everything
    STOP
    WAIT
  ENDIF

  CALL G_WAITZERO
ENDIF

SWITCH VoiceCmd
  CASE:VOICE_FINDBALL 	  GO 3248	// Find Ball
  CASE:VOICE_KICKBALL 	  GO 3248	// Kick Ball
  CASE:VOICE2_PINKBALL    GO 3248	// Pink Ball
  CASE:VOICE2_RIGHTKICK   GO 3248	// Right Kick - ZZZ - Should add right kick code
  CASE:VOICE2_LEFTKICK    GO 3248	// Left Kick - ZZZ - Should add left kick code
  CASE:VOICE2_RIGHTTOUCH  GO 3248	// Right Touch - ZZZ - Should add right touch code
  CASE:VOICE2_LEFTTOUCH   GO 3248	// Left Touch - ZZZ - Should add left touch code
  CASE:VOICE_LETSDANCE 	  GO 3246	// Dance
  CASE:VOICE2_SHOWTIME 	  GO 3246	// Show Time
  CASE:VOICE2_SHOWOFF	  GO 3246	// Show Off
  CASE:VOICE_GETUP 	  GO 3245	// Get Up
  CASE:VOICE_STANDUP 	  GO 3245	// Stand Up
  CASE:VOICE_GOODMORNING  GO 3242	// Good Morning
  CASE:VOICE_AIBO 	  GO 3242	// AIBO
  CASE:VOICE_HELLO 	  GO 3242	// Hello
  CASE:VOICE_SAYHELLO 	  GO 3242	// Say Hello
  CASE:VOICE2_THANKS 	  GO 3242	// Thanks
  CASE:VOICE2_HAPPYDAY	  GO 3242	// Happy Day
  CASE:VOICE2_HEYAIBO 	  GO 3242	// Hey AIBO
  CASE:VOICE_GOODNIGHT 	  GO 3244	// Good Night
  CASE:VOICE_GOODBYE 	  GO 3244	// Goodbye
  CASE:VOICE2_SEEYOU 	  GO 3244	// See You
  CASE:VOICE_AREYOUOK 	  GO 3241	// Are you ok?
  CASE:VOICE2_HOWAREYOU	  GO 3241	// How Are You?
  CASE:VOICE_GOFORWARD 	  GO 3240	// Go Forward
  CASE:VOICE2_GOAHEAD	  GO 3240	// Go Ahead
  CASE:VOICE_GOBACK 	  GO 3238	// Go Back
  CASE:VOICE_TURNLEFT 	  GO 3239	// Go Left
  CASE:VOICE_TURNRIGHT 	  GO 3237	// Go Right
  CASE:VOICE_POSE 	  GO 3236	// Pose
  CASE:VOICE2_CLOWNAROUND GO 3236	// Clown Around
  CASE:VOICE_ROAR 	  GO 3235	// Roar
  CASE:VOICE_MEOW 	  GO 3235	// Meow
  CASE:VOICE2_SINGSONG	  GO 3235	// Sing Song
  CASE:VOICE_AREYOUTIRED  GO 3234	// Tired?
  CASE:VOICE_AREYOUHUNGRY GO 3232	// Hungry?
  CASE:VOICE_STOP 	  GO 3231	// Stop
  CASE:VOICE_SITDOWN 	  GO 3229	// Sit
  CASE:VOICE_SHAKEPAW 	  GO 3227	// Shake
  CASE:VOICE_SHAKE 	  GO 3227	// Shake
  CASE:VOICE_OTHERPAW 	  GO 3224	// Other Paw
  CASE:VOICE_KARATECHOP   GO 3226	// Karate Chop
  CASE:VOICE2_BANZAI	  GO 3226	// Banzai
  CASE:VOICE_LETSPLAY 	  GO 3223	// Let's Play
  CASE:VOICE_LAYDOWN 	  GO 3217	// Lie Down / Play Dead
  CASE:VOICE_WHATSYOURNAME GO 3255	// What's your name?
  CASE:VOICE2_WHATSOWNERNAME GO 3256	// What's owners name?
  CASE:VOICE_NAMEREG      GO 3257	// Name Registration
  CASE:VOICE2_OWNERREG    GO 3258	// Owner Registration
#if ERS210 || ERS220
  CASE:VOICE2_ACTION1 	  GO 3259	// Self Dock ("Action 1")
#endif
RET GO_IDLE

:3217	// LAY_DOWN
CALL G_VOICE_HIT
CALL G_RANDOM2
  CASE:1 GO 3222
IF_1ST mood_sad > 2 3222
IF_1ST mood_happy < 3 3222
PLAY ACTION RESIGNATION
WAIT
CALL G_DEC_HAPPY_MOOD
RET GO_DOWNPOS

:3222	// SLEEPPOS
PLAY ACTION LIE
WAIT
RET GO_DOWNPOS

:3223	// Game Time
CALL G_Select_Game
RET GO_SITPOS

:3224	// OTHERPAW_CMD
CALL G_VOICE_HIT
CALL G_SIT_OTHERHAND
RET GO_SITPOS

:3226	// KARATE_CHOP
CALL G_KARATE_CHOP
RET GO_SITPOS

:3227	// SHAKEPAW_CMD
CALL G_VOICE_HIT
CALL G_SIT_SHAKEHANDS
RET GO_SITPOS

:3229	// SIT_DOWN
CALL G_VOICE_HIT
RND rndnum 0 100
IF rndnum < 50 THEN
  PLAY ACTION SIT
ELSE
  PLAY ACTION+ sit_quick
ENDIF
WAIT
RET GO_SITPOS

:3231	// STOP
CALL G_VOICE_HIT
RET GO_STOP

:3232	// HUNGRY?
CALL G_QUERY_HUNGRY
  CASE:2 RET GO_SITPOS
RET GO_STANDPOS

:3234	// TIRED?
CALL G_QUERY_TIRED
RET GO_STANDPOS

:3235	// BARK
CALL G_STAND_BARK
RET GO_STANDPOS

:3236	// POSE
CALL G_STAND_POSE
RET GO_STANDPOS

:3237	// RIGHT
CALL G_GO_RIGHT
RET GO_STANDPOS

:3238	// BACK
CALL G_GO_BACK
RET GO_STANDPOS

:3239	// LEFT
CALL G_GO_LEFT
RET GO_STANDPOS

:3240	// FWD
CALL G_GO_FORWARD
RET GO_STANDPOS

:3241	// OK?
CALL G_QUERY_MOOD
RET GO_STANDPOS

:3242	// HELLO?
CALL G_RANDOM1/3
  CASE:1 GO 3244
CALL G_STAND_HELLO
RET GO_STANDPOS

:3244	// GREET
CALL G_STAND_GREET
RET GO_STANDPOS

:3245	// HUH?
CALL G_STAND_HUH
RET GO_STANDPOS

:3246	// LETS_DANCE
CALL G_VOICE_HIT
CALL G_STAND_DANCE
RET GO_STANDPOS

:3248	// FIND_BALL
CALL G_VOICE_HIT
if (walking!=WALKING_SOCCER) then
  CALL G_SOCCER_SEARCH4BALL
    CASE:1 RET GO_RESTPOS
    CASE:2 RET GO_SEEBALL
endif
RET GO_STANDPOS

:3253	// SCOLD
CALL G_SCOLD
RET GO_IDLE

:3254	// PRAISE
CALL G_PRAISE
RET GO_IDLE

:3255   // What's your name?
CALL G_PLAYBACK_AIBONAME
RET GO_STANDPOS

:3256   // What's owner name?
CALL G_PLAYBACK_OWNERNAME
RET GO_STANDPOS

:3257	// Name Registration
CALL G_NAME_REGISTRATION
RET GO_SITPOS

:3258	// Owner Registration
CALL G_OWNER_REGISTRATION
if (POSE_SIT()) then 
  RET GO_SITPOS
endif
RET GO_DOWNPOS

#if ERS210 || ERS220
:3259
CALL G_SELFDOCK
RET GO_STANDPOS
#endif



////////////////////////////////////////////////////////////////////
//
//  Check distance (called before initiating walk).  Looks forward,
//  turning if necessary, then looks down again turning if necessary.
//  This avoids tables with low shelfs.  If turned while looking down,
//  repeat the cycle...
//
:G_WALK_CHECK_DIST
SET turn_timeout 12
SET init_walkwait 0

:3264	// LOOK_UP
PLAY ACTION MOVE_HEAD 0 0
WAIT

:WCD_LOOP
// Stop walking if see ball...
if (F_SEE_BALL()==GO_SEEBALL) then
  RET 3 // ball
endif

if (turn_timeout<=0) WCD_GIVEUP

CALL G_WALK_ATTENTION_HANDLER
  CASE:GO_DOWNPOS RET 4	 // down
  CASE:GO_RESTPOS RET 7	 // rest
  CASE:GO_SEEBALL RET 3	 // ball
  CASE:GO_SITPOS RET 5	 // sit
  CASE:GO_STOP RET 6	 // stand
  CASE:GO_STANDPOS RET 6 // stand

// Try turning away from obstacle...
WAIT 1
IF Distance < TURNTOOCLOSE THEN
  SUB turn_timeout 1
  PLAY ACTION TURN pan
  SET walking WALKING_ACTIVE
  CALL G_WAIT_WALK
    CASE:1 GO WCD_LOOP
    CASE:2 RET 4	// down
    CASE:3 RET 7	// rest
    CASE:4 RET 3	// ball
    CASE:5 RET 5	// sit
    CASE:6 RET 6	// stand
  RET 6	// stand
ENDIF

CALL G_WAITZERO

// For the 310, this moves the head into a lower position & prevents the
// tilt2 joint from auto-zeroing once walking starts...
#ifdef ERS310
IF Posture1 != POSTURE_WALK THEN
  PLAY:ACTION:CHGPOS.WALK.NORMAL
  CALL G_WAITZERO
ENDIF
#endif

PLAY ACTION MOVE_HEAD 0 WALKHEADTILT

DO
  WAIT 1
  IF Distance < TOOCLOSEDIST THEN
    CALL G_WAITZERO
    GO WCD_ATTENTION
  ENDIF
LOOP:WHILE:Wait>0

// Time to settle...
WAIT 500

// One last check...
SET d Distance
IF d > TURNCLIFFDIST THEN 	// Cliff! Aeeiii!
  RET 1 // cliff
ENDIF
IF d >= TOOCLOSEDIST THEN	// Ah... just right...
  RET 2	// walk
ENDIF

:WCD_ATTENTION	
CALL G_WALK_ATTENTION_HANDLER
  CASE:GO_DOWNPOS RET 4	 // down
  CASE:GO_RESTPOS RET 7	 // rest
  CASE:GO_SEEBALL RET 3	 // ball
  CASE:GO_SITPOS RET 5	 // sit
  CASE:GO_STOP RET 6	 // stand
  CASE:GO_STANDPOS RET 6 // stand

if (turn_timeout<=0) WCD_GIVEUP
SUB turn_timeout 1
PLAY ACTION TURN pan

SET walking WALKING_ACTIVE
CALL G_WAIT_WALK
  CASE:2 RET 4	// down
  CASE:3 RET 7	// rest
  CASE:4 RET 3	// ball
  CASE:5 RET 5	// sit
  CASE:6 RET 6	// stand
  CASE:7 RET 6	// stand

WAIT 1
if (Distance < TOOCLOSEDIST) WCD_ATTENTION

if (Distance < TURNCLIFFDIST) then
  PLAY ACTION MOVE_HEAD 0 0
  CALL G_WAITZERO
  GO WCD_LOOP
endif
RET 1	// cliff


:WCD_GIVEUP
CALL G_RANDOM2
  CASE:1 PLAY ACTION+ ummm
  CASE:2 PLAY ACTION OHWELL
CALL G_WAITZERO

if (F_RND100()<50) then
  RET 4 // down
endif
RET 5	// sit


////////////////////////////////////////////////////////////////////
//
//  Found a cliff or something black, or hit an uneven surface...
//  Double check distance (look up & down).  If it looks ok, 
//  try walking a bit further.  If another blip on the distance
//  sensor occurs, give up and turn away.
//
:G_WALK_FOUND_CLIFF
SET RFLeg_ON 0
SET LFLeg_ON 0
SET RRLeg_ON 0
SET LRLeg_ON 0
PLAY ACTION MOVE.MOVE.NORMAL 0 0		// Stop walking midstep
PLAY ACTION PALONE.AUTO.TAILSTOP		// Stop tail also.
PLAY ACTION MOVE.HEAD.NORMAL 0 WALKHEADTILT	// Look forward.
WAIT

CALL G_BEING_HELD
  CASE:2 RET GO_RESTPOS
WAIT 1

IF Distance < PARANOIDTOOCLOSE THEN	// Something in front?
  RET GO_TURN
ENDIF

IF Distance >= PARANOIDCLIFFDIST THEN 	// If still see a cliff again, give up...
  GO WFC_CLIFFACT
ENDIF

WAIT 1
SET ex_pan_r Head_Pan
SET ex_pan_l ex_pan_r
SUB ex_pan_r 15
ADD ex_pan_l 15
SET map_state 0
SET map_d Distance
SET fall_edge_tilt 0
SET rise_edge_tilt 0
SET fall_edge_dist 0
SET rise_edge_dist 0
SET walkcount 0
PLAY ACTION MOVE.HEAD.SLOW 0 0

:3300	// UPDATEMAP
CALL G_WALK_UPDATE_CLIFF_MAP
WAIT 1
IF_1ST map_state = 2 3315		// Something in way.
IF_1ST Wait > 0 3300			// Still looking.
IF_1ST map_state <> 0 WFC_CLIFFACT	// Nothing in way.
PLAY ACTION MOVE.HEAD.SLOW 0 -50

:3303	// UPDATEMAP(2)
CALL G_WALK_UPDATE_CLIFF_MAP
WAIT 1
IF_1ST map_state = 2 3315		// Something in way.
IF_1ST Wait > 0 3303			// Still looking.
IF_1ST map_state <> 0 WFC_CLIFFACT	// Nothing in way.

// For the 310, this moves the head into a lower position & prevents the
// tilt2 joint from auto-zeroing once walking starts...
#ifdef ERS310
IF Posture1 != POSTURE_WALK THEN
  PLAY:ACTION:CHGPOS.WALK.NORMAL
  WAIT
ENDIF
#endif

PLAY ACTION MOVE_HEAD 0 WALKHEADTILT
WAIT

// Setting time...
WAIT 500

IF Distance < PARANOIDTOOCLOSE THEN	// Something in front?
  RET GO_TURN
ENDIF

// If see cliff again, or we've tried this walking thing 3 times, give up...
IF (Distance>=PARANOIDCLIFFDIST) || (walkcount>=3) THEN
  GO WFC_CLIFFACT
ENDIF

// Not at cliff yet.  Try walking some more...
IF mood_tired > 8 THEN
  PLAY ACTION MOVE.MOVE.SLOW 0 300
ELSE
  PLAY ACTION WALK 0 300
ENDIF

ADD walkcount 1
SET pan -45

DO
  WAIT 1
  SET d Distance

  IF d < PARANOIDTOOCLOSE THEN	 	// Something in front?
    PLAY ACTION MOVE.MOVE.NORMAL 0 0
    WAIT
    RET GO_TURN
  ENDIF

  IF d >= PARANOIDCLIFFDIST THEN 	// If see a cliff again, give up...
    PLAY ACTION MOVE.MOVE.NORMAL 0 0
    WAIT
    GO WFC_CLIFFACT
  ENDIF
LOOP WHILE Wait>0
GO 3298


:3315	// STOP_HEAD
PLAY ACTION MOVE_HEAD 0 0
WAIT

:WFC_CLIFFACT	// CLIFFACT
CALL G_YART_Walking_SeeCliff
  CASE:GO_RESTPOS  RET:GO_RESTPOS
  CASE:GO_DOWNPOS  RET:GO_DOWNPOS
  CASE:GO_SITPOS   RET:GO_SITPOS
  CASE:GO_STANDPOS RET:GO_STANDPOS
  CASE:GO_WALK     RET:GO_WALK

CALL G_CLIFFACT

:3298	// CHECK_DIST
CALL G_WALK_CHECK_DIST
  CASE:1 GO G_WALK_FOUND_CLIFF
  CASE:2 RET GO_WALK
  CASE:3 RET GO_SEEBALL
  CASE:4 RET GO_DOWNPOS
  CASE:5 RET GO_SITPOS
  CASE:6 RET GO_STANDPOS
RET GO_RESTPOS


////////////////////////////////////////////////////////////////////
//
//  Plenty of room, so turn and go (instead of waiting for 
//  scan to finish)...
//
:G_WALK_GONOW

// Stop tailwag if required...
WAIT 1
IF (tailwag>0) && (Wait>0) THEN
  PLAY ACTION PALONE.AUTO.TAILSTOP
ENDIF
SET tailwag 0

// If not sad, show happy eyes...
IF mood_sad < 2 THEN
  PLAY ACTION+ happy_eyes
  WAIT
ENDIF

// Get happier.  Wide open spaces do that to an Aibo...
CALL G_INC_HAPPY_MOOD
CALL G_DEC_SAD_MOOD

CALL G_WALK_ATTENTION_HANDLER
  CASE:GO_DOWNPOS RET 8	 // down
  CASE:GO_RESTPOS RET 5	 // rest
  CASE:GO_SEEBALL RET 4	 // ball
  CASE:GO_SITPOS RET 7	 // sit
  CASE:GO_STOP RET 6	 // stand
  CASE:GO_STANDPOS RET 6 // stand

// Turn right?
IF pan < -10 THEN
  ADD pan -TURNADJUST
  SET init_walkwait 0
  PLAY ACTION TURN pan
  PLAY ACTION MOVE_HEAD 0 0
  SET pan -45
ELSE
  // Turn left?
  IF pan > 10 THEN
    ADD pan TURNADJUST
    SET init_walkwait 0
    PLAY ACTION TURN pan
    PLAY ACTION MOVE_HEAD 0 0
    SET pan 45
  ELSE
    // Randomly go left or right...
    RND pan 0 1
    MUL pan 90
    SUB pan 45
    SET init_walkwait 0
    PLAY ACTION MOVE_HEAD 0 0
    WAIT
  ENDIF
ENDIF

CALL G_WAIT_WALK
  CASE:2 RET 8	// down
  CASE:3 RET 5	// rest
  CASE:4 RET 4	// ball
  CASE:5 RET 7	// sit
  CASE:6 RET 6	// stand
  CASE:7 RET 6	// stand
WAIT 1

// Stop if see ball...
if (F_SEE_BALL()==GO_SEEBALL) then
  RET:4
endif

// Distance -should- be ok now.  Do final distance & sensor check, 
// then get walking now...
if (Distance>=TURNTOOCLOSE) then
  CALL G_WALK_CHECK_DIST
    CASE:1 RET 2	// cliff
    CASE:2 RET 3	// walk
    CASE:3 RET 4	// ball
    CASE:4 RET 8	// down
    CASE:5 RET 7	// sit
    CASE:6 RET 6	// stand
  RET 5	// rest
endif

// If area not open, occasionally get mad about it...
if (F_RND100()<20) then
  PLAY ACTION+ mad_eyes
  WAIT
  CALL G_DEC_HAPPY_MOOD	// Get unhappy faster than mad...
  CALL G_DEC_HAPPY_MOOD
  CALL G_INC_MAD_MOOD
endif

// Clear flags & resume looking again...
:3335
SET left_done 0
SET right_done 0
SET gonow 0
RET 1	// look


////////////////////////////////////////////////////////////////////
//
//  Look for a good place to turn to...
//
:G_WALK_LOOK_AROUND
WAIT 1
IF Wait > 0 THEN
  //PLAY ACTION PALONE.AUTO.TAILSTOP
  //PLAY ACTION WALK 0 0
  STOP
  WAIT
ENDIF

CLR SENSORS
WAIT
SET left_done 0
SET right_done 0
RND dirsel 0 100
SET walking WALKING_IDLE

:3354	// setup_exclude
SET tailwag 0
SET gonow 1	// Enable 'go-now' turns

IF (mood_happy>1) && (mood_sad<1) THEN
  IF mood_happy>(MOOD_MAX/2) THEN
    CALL G_START_TAILWAG_FAST
  ELSE
    CALL G_START_TAILWAG_NORMAL
  ENDIF
ENDIF

:3357	
IF_1ST dirsel < 43 3371
IF_1ST dirsel < 86 3364

CALL G_WALK_FINDTABLE
  CASE:GO_SEEBALL GO 3363	// ball
  CASE:GO_RESTPOS GO 3362	// rest
  CASE:GO_STANDPOS RET 5	// stand
  CASE:GO_SITPOS RET 4		// sit
  CASE:GO_DOWNPOS RET 3		// down
  CASE:GO_TURN GO 3360		// turn

// scan
SET left_done 0
SET right_done 0
SET ex_pan_r 999		// Disable exclude.
SET ex_pan_l 999
RND dirsel 0 79			// Exclude look_for_table
GO 3354

:3360	// GO_STRAIGHT?
IF (pan>=-10) && (pan<=10) THEN
  RET 7
ENDIF

CALL G_TIMER_TIRED
  CASE:1 RET 1	// rest
RET 6	// turn

:3362	// STOP_TAILWAG2
CALL G_STOP_TAILWAG
RET 1	// rest

:3363	// STOP_TAILWAG
CALL G_STOP_TAILWAG
RET 2	// ball

:3364	// search_right
SET right_done 1
SET sofs 0
SET eofs -90
CALL G_WALK_SCAN
  CASE:1 GO 3374
  CASE:2 GO 3363
  CASE:4 GO 3362
  CASE:5 RET 5	// stand
  CASE:6 RET 4	// sit
  CASE:7 RET 3	// down
SET right_dd dd
SET right_pan pan

:3367	// BOTH_DONE?
IF_1ST left_done = 0 3371
IF_1ST right_done <= 0 3364
IF_1ST left_dd > right_dd 3370
SET dd right_dd
SET pan right_pan
PLAY ACTION PALONE.AUTO.TAILSTOP
PLAY ACTION MOVE.HEAD.FAST 0 0	// Center Head
WAIT
GO 3360

:3370	// pick_left
SET dd left_dd
SET pan left_pan
PLAY ACTION PALONE.AUTO.TAILSTOP
PLAY ACTION MOVE.HEAD.FAST 0 0	// Center Head
WAIT
GO 3360

:3371	// search_left
SET left_done 1
SET sofs 0
SET eofs 90
CALL G_WALK_SCAN
  CASE:1 GO 3374
  CASE:2 GO 3363
  CASE:4 GO 3362
  CASE:5 RET 5	// stand
  CASE:6 RET 4	// sit
  CASE:7 RET 3	// down
SET left_dd dd
SET left_pan pan
GO 3367

:3374	// got_good_spot
CALL G_WALK_GONOW
  CASE:1 GO 3357
  CASE:2 RET 8	// cliff
  CASE:3 RET 7	// walk
  CASE:4 GO 3363
  CASE:5 RET 1	// rest
  CASE:6 RET 5	// stand
  CASE:7 RET 4	// sit
RET 3	// down



////////////////////////////////////////////////////////////////////
//
//  Scan range looking for best open space...
//
:G_WALK_SCAN
SET dd 0
SET pan 0
WAIT 1
SET init_lookwait Wait
PLAY ACTION MOVE.HEAD.FAST eofs 0
SET walking WALKING_IDLE

:3485	// NEED2REST?
CALL G_NEED2REST
  CASE:1 RET 4	// rest

CALL G_WALK_ATTENTION_HANDLER
  CASE:GO_DOWNPOS RET 7	 // down
  CASE:GO_RESTPOS RET 4	 // rest
  CASE:GO_SEEBALL RET 2	 // ball
  CASE:GO_SITPOS RET 6	 // sit
  CASE:GO_STOP RET 5	 // stand
  CASE:GO_STANDPOS RET 5 // stand

// Stop if see ball...
if (F_SEE_BALL()==GO_SEEBALL) then
  RET:2
endif

WAIT 1
IF Wait <= init_lookwait THEN	// Wait until finish the movement
  RET 3 // done
ENDIF

SET d Distance	// For compare distance
SET p Head_Pan	// For search direction

// If 'gonow' enabled & see spot with enough room, go for it...
IF gonow && (d>=TURNTOOCLOSE) THEN
  SET dd d
  SET pan p
  PLAY ACTION MOVE.HEAD.FAST pan 0
  PLAY ACTION PALONE.AUTO.TAILSTOP
  WAIT
  RET 1 // go_now
ENDIF

CALL G_WALK_UPDATE_BEST_DISTANCE
GO 3485



////////////////////////////////////////////////////////////////////
//
//  Turn to a new direction...
//
:G_WALK_TURN?
CALL G_NEED2REST
  CASE:1 RET 1	// rest
WAIT
SET init_walkwait 0
IF_1ST dd < TOOCLOSEDIST 3513
IF_1ST pan < -15 3511
IF_1ST pan > 15 3512
CALL G_RANDOM6
  CASE:1 RET 6	// walk
  CASE:2 GO 3512
  CASE:3 GO 3511
  CASE:4 GO 3510
  CASE:5 GO 3509
SET pan 45
PLAY ACTION TURN 90

:3507	// WAIT
CALL G_WAIT_WALK
  CASE:2 RET 3	// down
  CASE:3 RET 1	// rest
  CASE:4 RET 2	// ball
  CASE:5 RET 4	// sit
  CASE:6 RET 5	// stand
  CASE:7 RET 5	// stand
CALL G_WALK_CHECK_DIST
  CASE:1 RET 7	// cliff
  CASE:2 RET 6	// walk
  CASE:3 RET 2	// ball
  CASE:4 RET 3	// down
  CASE:5 RET 4	// sit
  CASE:6 RET 5	// stand
RET 1	// rest

:3509	// RIGHT_90
SET pan -45
PLAY ACTION TURN -90
GO 3507

:3510	// TURN_AROUND
SET pan 45
PLAY ACTION TURN 180
GO 3507

:3511	// RIGHT_45
SET pan -45
PLAY ACTION TURN pan
GO 3507

:3512	// LEFT_45
SET pan 45
PLAY ACTION TURN pan
GO 3507

:3513	// MOVE_BACK
PLAY ACTION+ ummm
WAIT
PLAY ACTION WALK 180 300
WAIT
SET ex_pan_r -20
SET ex_pan_l 20
CALL G_WALK_LOOK_AROUND
  CASE:1 RET 1	// rest
  CASE:2 RET 2	// ball
  CASE:3 RET 3	// down
  CASE:4 RET 4	// sit
  CASE:5 RET 5	// stand
  CASE:7 RET 6	// walk
  CASE:8 RET 7	// cliff
IF_1ST pan < -15 3511
IF_1ST pan > 15 3512
SET pan 45
PLAY ACTION TURN 180
GO 3507



////////////////////////////////////////////////////////////////////
//
//  Examine distance and track head-horz pan angle of best distance...
//
:G_WALK_UPDATE_BEST_DISTANCE
IF d < dd 3526
IF_1ST p > ex_pan_r 
IF_AND p < ex_pan_l 3526
SET dd d
SET pan p
:3526
RET 1


////////////////////////////////////////////////////////////////////
//
//  Map space in front to look for cliff's, or narrow obstacles...
//
:G_WALK_UPDATE_CLIFF_MAP
WAIT 1
SET d Distance
SET t Head_Tilt
SET delta map_d
SUB delta d
SWITCH map_state
  CASE:0 GO 3536
  CASE:1 GO 3534
  CASE:3 GO 3532

:3531	// UPDATE_MAP_D
SET map_d d
RET 1

:3532	// RISING_EDGE?
IF_1ST delta <= 50 3531
SET map_state 2
SET rise_edge_tilt t
SET rise_edge_dist d
SET map_d d
RET 1

:3534	// FALLING_EDGE?
IF_1ST delta >= -50 3531
SET map_state 2
SET fall_edge_tilt t
SET fall_edge_dist d
SET map_d d
RET 1

:3536	// SEE_EDGE?
IF_1ST delta > 50
IF_AND map_d < 400 3538
IF_1ST delta < -50
IF_AND map_d < 400 3537
SET map_d d
RET 1

:3537	// set_fall_edge
SET map_state 3
SET fall_edge_tilt t
SET fall_edge_dist d
SET map_d d
RET 1

:3538	// set_rise_edge
SET map_state 1
SET rise_edge_tilt t
SET rise_edge_dist d
SET map_d d
RET 1


////////////////////////////////////////////////////////////////////
//
//  Perform an action during walking...
//
:G_WALK_WALKACT
RND rndnum 0 100
IF rndnum > 33 THEN
  RET GO_IDLE
ENDIF

// Process YART walking act override...
if (mood_happy>=2) && (mood_sad<=2) && (mood_mad<=1) then
  CALL G_YART_Walking_Happy
  if (Context != GO_AHEAD) then
    RET:Context
  endif
endif

SET rndbase 1700
SET rndcount 18

if (F_BEHAVIOR_RNDN()) then
  // If itchy skit, so now without further ado...
  IF rndnum < 1705 THEN
    PLAY ACTION STOP_WALK
    WAIT
    SWITCH rndnum
      CASE:1700 GO WALKACT_SCRATCH_LEFT
      CASE:1701 GO WALKACT_SCRATCH_LEFT
      CASE:1702 GO WALKACT_SCRATCH_RIGHT
      CASE:1703 GO WALKACT_SCRATCH_RIGHT
      CASE:1704 PLAY ACTION+ sticky_floor
    CALL G_WAITZERO
    RET GO_IDLE
  ENDIF

  // If not happy enough, restrict ourself to scratching...
  IF (mood_happy<2) || (mood_sad>2) || (mood_mad>1) THEN
    RET GO_IDLE
  ENDIF

  PLAY ACTION STOP_WALK
  CALL G_WAITZERO

  // Walking acts which indicate a happy frame of mind...
  SWITCH rndnum
    CASE:1705 PLAY ACTION CUTE_SMILE1
    CASE:1706 PLAY ACTION CUTE_SWING1
    CASE:1707 PLAY ACTION CUTE_SWING2
    CASE:1708 PLAY ACTION DANCE_STAND4
    CASE:1709 PLAY ACTION DANCE_STAND5
    CASE:1710 PLAY ACTION DANCE_STAND6
    CASE:1711 PLAY ACTION digging
    CASE:1712 PLAY ACTION digging2
    CASE:1713 PLAY ACTION digging3
    CASE:1714 PLAY ACTION digging4
    CASE:1715 PLAY ACTION digging5
    CASE:1716 PLAY ACTION digging6
    CASE:1717 PLAY ACTION motorcycle
  CALL G_WAITZERO
endif
RET GO_IDLE


//
// Scratch right side...
//
:WALKACT_SCRATCH_RIGHT
SWITCH rndnum
  CASE:1702 PLAY ACTION+ scratch_rear_right
  CASE:1703 PLAY ACTION+ scratch_rear_ear_right
CALL G_WAITZERO

CALL G_RANDOM1/3
  CASE:2 RET 1
CALL G_RANDOM3
  CASE:1 PLAY ACTION RIGHT_EAR_TWITCH1
  CASE:2 PLAY ACTION RIGHT_EAR_TWITCH2
  CASE:3 PLAY ACTION RIGHT_EAR_TWITCH3
GO G_WAITZERO


//
// Scratch left side...
//
:WALKACT_SCRATCH_LEFT
SWITCH rndnum
  CASE:1700 PLAY ACTION+ scratch_rear_left
  CASE:1701 PLAY ACTION+ scratch_rear_ear_left
CALL G_WAITZERO

CALL G_RANDOM1/3
  CASE:2 RET 1
CALL G_RANDOM3
  CASE:1 PLAY ACTION LEFT_EAR_TWITCH1
  CASE:2 PLAY ACTION LEFT_EAR_TWITCH2
  CASE:3 PLAY ACTION LEFT_EAR_TWITCH3
GO G_WAITZERO



////////////////////////////////////////////////////////////////////
//
//  Walk about until run into something, see a cliff, see a ball, anything...)
//
:G_WALK_WALKING
CALL G_NEED2REST
  CASE:1 RET 2	// rest

:WW_STARTWALK	
CALL G_WALK_ATTENTION_HANDLER
  CASE:GO_DOWNPOS RET 4	 // down
  CASE:GO_RESTPOS RET 2	 // rest
  CASE:GO_SEEBALL RET 3	 // ball
  CASE:GO_SITPOS RET 5	 // sit
  CASE:GO_STOP RET 6	 // stand
  CASE:GO_STANDPOS RET 6 // stand

// For the 310, this moves the head into a lower position & prevents the
// tilt2 joint from auto-zeroing once walking starts...
#ifdef ERS310
IF Posture1 != POSTURE_WALK THEN
  PLAY:ACTION:CHGPOS.WALK.NORMAL
  CALL G_WAITZERO
ENDIF
#endif

PLAY ACTION MOVE_HEAD 0 WALKHEADTILT
CALL G_WAITZERO
WAIT 500		// Time to take distance measurements

SET ex_pan_r 999	// Disable PAN exclusion
SET ex_pan_l 999

CALL G_WALK_ATTENTION_HANDLER
  CASE:GO_DOWNPOS RET 4	 // down
  CASE:GO_RESTPOS RET 2	 // rest
  CASE:GO_SEEBALL RET 3	 // ball
  CASE:GO_SITPOS RET 5	 // sit
  CASE:GO_STOP RET 6	 // stand
  CASE:GO_STANDPOS RET 6 // stand

IF Back_ON > 0 THEN
  RET 2 // rest
ENDIF

// Stop if see ball...
if (F_SEE_BALL()==GO_SEEBALL) then
  RET:3
endif

SET d Distance	// Get initial distance
IF d < TOOCLOSEDIST THEN
  CALL G_WALK_TOO_CLOSE
    CASE:GO_DOWNPOS RET 4   // down
    CASE:GO_RESTPOS RET 2   // rest
    CASE:GO_SITPOS RET 5    // sit
    CASE:GO_STOP RET 6	    // stand
    CASE:GO_STANDPOS RET 6  // stand
  RET 1	// turn
ENDIF

IF d >= CLIFFDIST THEN			// At a cliff?
#ifdef RCODE250
  STOP
#endif
  RET 7 // cliff
ENDIF

IF mood_tired > 8 THEN
  PLAY ACTION MOVE.MOVE.SLOW 0 -1	// Walk forever.
ELSE
  PLAY ACTION WALK 0 -1			// Walk forever.
ENDIF

SET RFLeg_ON 0
SET LFLeg_ON 0
SET RRLeg_ON 0
SET LRLeg_ON 0
SET walking WALKING_ACTIVE

RND pan 0 1				// Set 'pan' randomly
MUL pan 50				// to +25 or -25
SUB pan 25
SET look_state 0			// 0=down 1-2=sides

SET Clock 0
RND TIMER_BORED 5 20			// Time before stopping
RND TIMER_LOOKAROUND 0 2		// Look around time

// Loop executed while walking.
:WW_WALKLOOP
//PRINT ". %d %d,%d":Wait:Head_Tilt:Head_Tilt_2 
WAIT 1

// Stop if see ball...
if (F_SEE_BALL()==GO_SEEBALL) WW_STOPWALK

IF Distance < TOOCLOSEDIST THEN
  CALL G_WALK_TOO_CLOSE
    CASE:GO_DOWNPOS RET 4   // down
    CASE:GO_RESTPOS RET 2   // rest
    CASE:GO_SITPOS RET 5    // sit
    CASE:GO_STOP RET 6	    // stand
    CASE:GO_STANDPOS RET 6  // stand
  RET 1	// turn
ENDIF

// See cliff?  If looking to side, distance more than 700 is scary.
// If look almost straight, distance more than 725 is scary.
IF Distance > CLIFFDIST THEN
  IF (Head_Pan>=-15) && (Head_Pan<=15) THEN // looking ahead...
    RET 7
  ENDIF
  IF Distance > CLIFFDISTSIDE THEN // looking to side...
    RET 7
  ENDIF
ENDIF

// If no voice command & no timer tick, loop...
IF (AP_Voice_Cmd==0) && (Clock<32) THEN
  GO WW_WALKLOOP
ENDIF

// Get here on voice command or timer tick...
CALL G_WALK_TIMER
  CASE:1 GO WW_WALKLOOP
  CASE:2 RET 4	// down
  CASE:3 RET 3	// ball
  CASE:4 GO WW_STOPWALK
  CASE:5 RET 1	// turn
  CASE:6 RET 5	// sit
  CASE:7 RET 6	// stand

// 90% of the time, resume walking.  Otherwise stand...
RND rndnum 0 100
IF rndnum >= 10 WW_STARTWALK
RET 6

:WW_STOPWALK
PLAY ACTION WALK 0 0
CALL G_WAITZERO

// See ball?
if (F_SEE_BALL()==GO_SEEBALL) then
  RET:3 // ball
endif

RET 2 // rest



////////////////////////////////////////////////////////////////////
// CLIFFACT  (Perform act when encounter a cliff)
:G_CLIFFACT
CALL G_RANDOM3
  CASE:1 PLAY ACTION+ testfloor
  CASE:2 PLAY ACTION ATCLIFF
  CASE:3 PLAY ACTION SHUDDER
CALL G_WAITZERO

CALL G_RANDOM4
  CASE:1 GO 1108
  CASE:2 GO 1107
  CASE:3 GO 1106

PLAY ACTION TURN -180
CALL G_WAITZERO

SET pan -45
SET lastmove 1
RET 1

:1106	// TURN_AROUND_L
PLAY ACTION TURN 180
CALL G_WAITZERO

SET pan 45
SET lastmove 0
RET 1

:1107	// LEFT_120
PLAY ACTION TURN 120
CALL G_WAITZERO

SET pan 45
SET lastmove 0
RET 1

:1108	// RIGHT_120
PLAY ACTION TURN -120
CALL G_WAITZERO

SET pan -45
SET lastmove 1
RET 1


////////////////////////////////////////////////////////////////////
//
// WALK_TIMER.  Called when 'Clock' greater than 32.   Clock is reset
// to zero by G_TIMER_TIRED (called within G_WALK_ATTENTION_HANDLER)
//
:G_WALK_TIMER
IF_1ST Posture1 == POSTURE_PICKUP 3738	// Picked up?
IF_1ST Posture1 == POSTURE_CHARGE1 3738	// On charger?
IF_1ST Posture1 == POSTURE_CHARGE2 3738	// On charger? 
IF_1ST Back_LONG > 0 3738	// Stop if back touched

IF_1ST Batt_Rest < BATTLEVEL_SHUTDOWN 3738
IF_1ST BODYTEMP() > 45 3738
IF_1ST Batt_Temp > 45 3738

CALL G_WALK_ATTENTION_HANDLER
  CASE:GO_DOWNPOS RET 2	 // down
  CASE:GO_RESTPOS RET 4	 // rest
  CASE:GO_SEEBALL RET 3	 // ball
  CASE:GO_SITPOS RET 6	 // sit
  CASE:GO_STOP RET 7	 // stop
  CASE:GO_STANDPOS RET 8 // stand

IF TIMER_BORED <= 0 THEN
  CALL G_WALK_WALKACT
    CASE:GO_DOWNPOS RET 2  // down
    CASE:GO_RESTPOS RET 4  // rest
    CASE:GO_SITPOS RET 6   // sit
    CASE:GO_STANDPOS RET 8 // stand
  RET 5	// turn
ENDIF

IF TIMER_LOOKAROUND <= 0 THEN
  IF look_state < 2 THEN
    MUL pan -1
    ADD look_state 1
    SET TIMER_LOOKAROUND 2
    PLAY ACTION MOVE_HEAD pan WALKHEADTILT
  ELSE
    SET look_state 0
    RND TIMER_LOOKAROUND 2 3
    PLAY ACTION MOVE_HEAD 0 WALKHEADTILT
  ENDIF
  // Clear foot sensors (used to detect if lifted off floor by owner)...
  SET RFLeg_ON 0
  SET LFLeg_ON 0
  SET RRLeg_ON 0
  SET LRLeg_ON 0
ENDIF
RET 1	// none

:3738	// rest
RET 4



////////////////////////////////////////////////////////////////////
// WALK TOO_CLOSE
:G_WALK_TOO_CLOSE
#ifdef RCODE250
STOP
#endif

WAIT 1
SET ex_pan_r Head_Pan	// Set exclude angle
SET ex_pan_l ex_pan_r
SUB ex_pan_r 15
ADD ex_pan_l 15
RND rndnum 0 100

if (Head_Pan>5) then
  SET ex_pan_r 15
endif

if (Head_Pan<-5) then
  SET ex_pan_l 15
endif

if (rndnum<80) then
  RET GO_TURN
endif

if (Head_Pan>5) then
  CALL G_YART_Walking_ObstacleLeft
  if (Context != GO_AHEAD) then
    RET:Context
  endif
  CALL G_RANDOM3
    CASE:1 PLAY ACTION+ sniff_left
    CASE:2 PLAY ACTION+ sniff2_left
    CASE:3 PLAY ACTION+ sniff3_left
  CALL G_WAITZERO
  RET GO_TURN
endif

if (Head_Pan<-5) then
  CALL G_YART_Walking_ObstacleRight
  if (Context != GO_AHEAD) then
    RET:Context
  endif
  CALL G_RANDOM3
    CASE:1 PLAY ACTION+ sniff_right
    CASE:2 PLAY ACTION+ sniff2_right
    CASE:3 PLAY ACTION+ sniff3_right
  CALL G_WAITZERO
  RET GO_TURN
endif

CALL G_YART_Walking_ObstacleFront
if (Context != GO_AHEAD) then
  RET:Context
endif

PLAY ACTION sniff_ahead
CALL G_WAITZERO
RET GO_TURN



////////////////////////////////////////////////////////////////////
// BEING_HELD  (Check if being held by owner)
:G_BEING_HELD
SET last_heldact -1
SET last_heldact2 -1

//
// Check if any foot in contact with floor.  Return if so...
//
WAIT 1
IF_1ST RFLeg_ON > 0 1096
IF_1ST LFLeg_ON > 0 1096
IF_1ST RRLeg_ON > 0 1096
IF_1ST LRLeg_ON > 0 1096
SET RFLeg_ON 0
SET LFLeg_ON 0
SET RRLeg_ON 0
SET LRLeg_ON 0

WAIT 1000
IF_1ST RFLeg_ON > 0 1096
IF_1ST LFLeg_ON > 0 1096
IF_1ST RRLeg_ON > 0 1096
IF_1ST LRLeg_ON > 0 1096

//
// Whoa!  What happened to the floor?
//
CALL G_RANDOM3
  CASE:1 PLAY ACTION SURPRISE1
  CASE:2 PLAY ACTION SURPRISE2
  CASE:3 PLAY ACTION SURPRISE3
CALL G_WAITZERO

PLAY ACTION MOVE.HEAD.FAST 40 WALKHEADTILT
CALL G_WAITZERO
WAIT 500

PLAY ACTION MOVE.HEAD.FAST -40 WALKHEADTILT
CALL G_WAITZERO
WAIT 500

PLAY ACTION MOVE.HEAD.FAST 0 -90
CALL G_WAITZERO
WAIT 500

IF_1ST Distance < TOOCLOSEDIST 1096
PLAY ACTION BELLYPOS
CALL G_WAITZERO

:BH_INITTIMER	
RND timer 5 30	// 1/2 to 3 secs

:1048	// NEED2REST?
CALL G_NEED2REST
  CASE:1 RET 2	// rest

CALL G_SLEEP_ATTENTION
  CASE:GO_IDLE     GO 1051
  CASE:GO_PRAISE   GO 1093
  CASE:GO_PETTED   GO 1092
  CASE:GO_SCOLD    GO 1089
  CASE:GO_RESTPOS  GO 1051
  CASE:GO_DOWNPOS  GO 1051
  CASE:GO_SITPOS   GO 1051
  CASE:GO_WALK     GO 1051
  CASE:GO_STANDPOS GO 1051

CALL G_STATION_VOICE_HANDLER
  CASE:2 GO BH_INITTIMER

:1051	// WAITING
SUB timer 1
WAIT 100
IF_1ST timer >= 1 1048
RND rndnum 0 100

// Occasionally check to see if on floor, if so, exit...
IF rndnum < 20 THEN
  PLAY ACTION MOVE.HEAD.FAST 0 -90
  CALL G_WAITZERO
  IF Distance < TOOCLOSEDIST THEN
    RET 1
  ENDIF
ENDIF

// Randomly look around, move head using random speed...
IF rndnum < 80 THEN
  RND tilt -40 10
  RND pan -60 60
  CALL G_RANDOM3
    CASE:1 PLAY ACTION MOVE.HEAD.FAST pan tilt
    CASE:2 PLAY ACTION MOVE.HEAD.NORMAL pan tilt
    CASE:3 PLAY ACTION MOVE.HEAD.SLOW pan tilt
  CALL G_WAITZERO
  WAIT 500
  IF_1ST Distance >= TOOCLOSEDIST BH_INITTIMER
  PLAY ACTION MOVE.HEAD.FAST 0 -90
  CALL G_WAITZERO
  SET tilt Head_Tilt
  SET pan Head_Pan
  IF_1ST Distance < TOOCLOSEDIST 1096
  PLAY ACTION MOVE.HEAD.FAST pan tilt
  CALL G_WAITZERO
  GO BH_INITTIMER
ENDIF


:1055	// RNDNUM_BELLY
RND rndnum 0 17
IF_1ST rndnum = last_heldact 1055
IF_1ST rndnum = last_heldact2 1055
SWITCH rndnum
  CASE:0    PLAY ACTION DANCE_BELLY1
  CASE:1    PLAY ACTION DANCE_BELLY2
  CASE:2    PLAY ACTION DANCE_BELLY3
  CASE:3    PLAY ACTION DANCE_BELLY4
  CASE:4    PLAY ACTION DANCE_BELLY5
  CASE:5    PLAY ACTION DANCE_BELLY6
  CASE:6    PLAY ACTION THINKING_BELLY
  CASE:7    PLAY ACTION HOWL_BELLY1
  CASE:8    PLAY ACTION HOWL_BELLY2
  CASE:9    PLAY ACTION CONFUSED1
  CASE:10   PLAY ACTION CONFUSED2
  CASE:11   PLAY ACTION OHWELL
  CASE:12   PLAY ACTION BOTH_EAR_TWITCH4
  CASE:13   PLAY ACTION BOTH_EAR_TWITCH5
  CASE:14   PLAY ACTION WAVE_LEFT_BELLY1
  CASE:15   PLAY ACTION WAVE_LEFT_BELLY2
  CASE:16   PLAY ACTION WAVE_RIGHT_BELLY1
  CASE:ELSE PLAY ACTION WAVE_RIGHT_BELLY2
SET last_heldact2 last_heldact
SET last_heldact rndnum
CALL G_WAITZERO
GO BH_INITTIMER

:1089	// SCOLD
CALL G_SCOLD_REST
RND bored_count 5 10
CALL G_CLEAR_SENSORS
GO 1048

:1092	// SLEEP_PETTED
CALL G_SLEEP_PETTED
RND bored_count 5 10
CALL G_CLEAR_SENSORS
GO 1048

:1093	// PRAISE
CALL G_PRAISE_REST
RND bored_count 5 10
CALL G_CLEAR_SENSORS
GO 1048

:1096	// RETURN
RET 1


