
//////////////////////////////////////////
//                                      //
//  DogsLife YART Customization Module  //
//                                      //
//////////////////////////////////////////

#define YART_BEHAVIOR_PROBABILITY 66	// 66% of time a YART behavior override given a shot...


//
// Called when a customized yart extension is used.  Stops anything 
// which might cause a hang if user inserts WAIT command...
//
:G_GOTYART
  if (Posture1==POSTURE_WALK) then		// Stop walking
    PLAY ACTION STOP_WALK
  endif
  PLAY ACTION MOVE.HEAD.FAST Head_Pan Head_Tilt	// Stop ball tracking.
  CALL G_STOP_TAILWAG				// Stop tail wagging
  CALL G_WAITZERO
  init_wait := Wait				// Setup Wait timeout variable
  result := GO_YART
  RET:1



//
// Cleanup processing.  If user caused posture change, 
// DogsLife needs to know about that...
//
:G_YART_VOICEDONE
  if (result==GO_YART) then
    SET VoiceCmd 0
  endif

:G_YART_DONE
  if (result==GO_YART) then
    CALL G_WAIT
    SWITCH:Posture1
      CASE:POSTURE_PICKUP SET result GO_RESTPOS
      CASE:POSTURE_STAND SET result GO_STANDPOS
      CASE:POSTURE_SIT SET result GO_SITPOS
      CASE:POSTURE_SLEEP SET result GO_DOWNPOS
      CASE:POSTURE_WALK SET result GO_WALK

    // If sit-only mode, and user has made AIBO stand up, make AIBO sit back down...
    if (sitonly>0) && POSE_STANDING() then
      init_wait := Wait
      PLAY ACTION SIT
      CALL G_WAIT
      result := GO_SITPOS
    endif
  endif
  RET:result



//
// Initialization...
//
:G_YART_Startup_Once
  yart_last_favcolor := 0
  yart_last_unfavcolor := 0

  result := GO_AHEAD
  //{ "Main/Startup (once)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE

:G_YART_Startup_Recovery
  result := GO_AHEAD
  //{ "Main/Recovery (after fall-over)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE



//
// Common AIBO Sensors...
//
:G_YART_Sensors
  result := GO_AHEAD
  if (Head_Hit) then
    //{ "Sensor/Head Hit" PRE
    //[PRE]: CALL G_GOTYART
    //}
    if (result==GO_YART) then
      Head_Hit := 0
    endif
  endif

  if (Head_Pat) then
    //{ "Sensor/Head Pat" PRE
    //[PRE]: CALL G_GOTYART
    //}
    if (result==GO_YART) then
      Head_Pat := 0
    endif
  endif

  if (Head_LONG) then
    //{ "Sensor/Head Long Press" PRE
    //[PRE]: CALL G_GOTYART
    //}
    if (result==GO_YART) then
      Head_LONG := 0
    endif
  endif

  if (Head_ON) then
    //{ "Sensor/Head Pressed" PRE
    //[PRE]: CALL G_GOTYART
    //}
    if (result==GO_YART) then
      Head_ON := 0
    endif
  endif

  if (Head_OFF) then
    //{ "Sensor/Head Released" PRE
    //[PRE]: CALL G_GOTYART
    //}
    if (result==GO_YART) then
      Head_OFF := 0
    endif
  endif

  if (POSE_SLEEP()) then
    if (RFLeg_ON) then
      //{ "Sensor/RF Paw (sleep position)" PRE
      //[PRE]: CALL G_GOTYART
      //}
      if (result==GO_YART) then
        RFLeg_ON := 0
      endif
    endif
    if (LFLeg_ON) then
      //{ "Sensor/LF Paw (sleep position)" PRE
      //[PRE]: CALL G_GOTYART
      //}
      if (result==GO_YART) then
        LFLeg_ON := 0
      endif
    endif
  endif


  //
  // ERS-210/220 Specific Customizations...
  //
#if ERS210 | ERS220
  if (Back_ON) then
    //{ "Sensor/Back Pressed" PRE
    //[PRE]: CALL G_GOTYART
    //}
    if (result==GO_YART) then
      Back_ON := 0
    endif
  endif

  if (Back_LONG) then
    //{ "Sensor/Back Long Press" PRE
    //[PRE]: CALL G_GOTYART
    //}
    if (result==GO_YART) then
      Back_LONG := 0
    endif
  endif

  if (Jaw_ON) then
    //{ "Sensor/Jaw Pressed" PRE
    //[PRE]: CALL G_GOTYART
    //}
    if (result==GO_YART) then
      Jaw_ON := 0
    endif
  endif

  if (Jaw_LONG) then
    //{ "Sensor/Jaw Long Press" PRE
    //[PRE]: CALL G_GOTYART
    //}
    if (result==GO_YART) then
      Jaw_LONG := 0
    endif
  endif
#endif

  
  //
  // ERS-220 Specific Customizations...
  //
#if ERS220
  if (RTail_ON) then
    //{ "Sensor/Right Tail Button Pressed" PRE
    //[PRE]: CALL G_GOTYART
    //}
    if (result==GO_YART) then
      RTail_ON := 0
    endif
  endif

  if (CTail_ON) then
    //{ "Sensor/Center Tail Button Pressed" PRE
    //[PRE]: CALL G_GOTYART
    //}
    if (result==GO_YART) then
      CTail_ON := 0
    endif
  endif

  if (LTail_ON) then
    //{ "Sensor/Left Tail Button Pressed" PRE
    //[PRE]: CALL G_GOTYART
    //}
    if (result==GO_YART) then
      LTail_ON := 0
    endif
  endif
#endif


#if ERS310
  //
  // ERS-310 Specific Customizations...
  //
  if (Tail_U_ON) then
    //{ "Sensor/Tail Pushed Up" PRE
    //[PRE]: CALL G_GOTYART
    //}
    if (result==GO_YART) then
      Tail_U_ON := 0
    endif
  endif

  if (Tail_D_ON) then
    //{ "Sensor/Tail Pushed Down" PRE
    //[PRE]: CALL G_GOTYART
    //}
    if (result==GO_YART) then
      Tail_D_ON := 0
    endif
  endif

  if (Tail_R_ON) then
    //{ "Sensor/Tail Pushed Right" PRE
    //[PRE]: CALL G_GOTYART
    //}
    if (result==GO_YART) then
      Tail_R_ON := 0
    endif
  endif

  if (Tail_L_ON) then
    //{ "Sensor/Tail Pushed Left" PRE
    //[PRE]: CALL G_GOTYART
    //}
    if (result==GO_YART) then
      Tail_L_ON := 0
    endif
  endif

  if (Tail_RollR) then
    //{ "Sensor/Tail Rolled Right" PRE
    //[PRE]: CALL G_GOTYART
    //}
    if (result==GO_YART) then
      Tail_RollR := 0
    endif
  endif

  if (Tail_RollL) then
    //{ "Sensor/Tail Rolled Left" PRE
    //[PRE]: CALL G_GOTYART
    //}
    if (result==GO_YART) then
      Tail_RollL := 0
    endif
  endif

  if (Tail_Roll3) then
    //{ "Sensor/Tail Rolled Three Times" PRE
    //[PRE]: CALL G_GOTYART
    //}
    if (result==GO_YART) then
      Tail_Roll3 := 0
    endif
  endif
#endif

  GO G_YART_DONE



//
// Stand Position Behaviors...  These add onto DogsLife builtin behavior.
// ie: User sees both DogsLife + their customizations performed.
//
// DogsLife passes parameter in rndnum of which action should be performed.  
// If not overridden by YART, DogsLife randomly picks numbers until either it 
// uses a DogsLife skit, or one of these...
//
:G_YART_Bored_Stand
  result := GO_AHEAD
  RND rndnum 0 (500/YART_BEHAVIOR_PROBABILITY)
  switch (rndnum)
    case 0 : GO YI_StandRandom1
    case 1 : GO YI_StandRandom2
    case 2 : GO YI_StandRandom3
    case 3 : GO YI_StandRandom4
    case 4 : GO YI_StandRandom5
  RET:result

 :YI_StandRandom1
  //{ "Stand Position/Bored Random#1" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE

 :YI_StandRandom2
  //{ "Stand Position/Bored Random#2" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE

 :YI_StandRandom3
  //{ "Stand Position/Bored Random#3" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE

 :YI_StandRandom4
  //{ "Stand Position/Bored Random#4" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE

 :YI_StandRandom5
  //{ "Stand Position/Bored Random#5" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE




//
// Sit Position Behaviors...  These add onto DogsLife builtin behavior.
// ie: User sees both DogsLife + their customizations performed.
//
// DogsLife passes parameter in rndnum of which action should be performed.  
// If not overridden by YART, DogsLife randomly picks numbers until either it 
// uses a DogsLife skit, or one of these...
//
:G_YART_Calm_Sit
  result := GO_AHEAD
  RND rndnum 0 (500/YART_BEHAVIOR_PROBABILITY)
  switch (rndnum)
    case 0 : GO YC_SitRandom1
    case 1 : GO YC_SitRandom2
    case 2 : GO YC_SitRandom3
    case 3 : GO YC_SitRandom4
    case 4 : GO YC_SitRandom5
  RET:result

 :YC_SitRandom1
  //{ "Sit Position/Calm Random#1" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE

 :YC_SitRandom2
  //{ "Sit Position/Calm Random#2" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE

 :YC_SitRandom3
  //{ "Sit Position/Calm Random#3" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE

 :YC_SitRandom4
  //{ "Sit Position/Calm Random#4" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE

 :YC_SitRandom5
  //{ "Sit Position/Calm Random#5" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE


:G_YART_Bored_Sit
  result := GO_AHEAD
  RND rndnum 0 (500/YART_BEHAVIOR_PROBABILITY)
  switch (rndnum)
    case 0 : GO YB_SitRandom1
    case 1 : GO YB_SitRandom2
    case 2 : GO YB_SitRandom3
    case 3 : GO YB_SitRandom4
    case 4 : GO YB_SitRandom5
  RET:result

 :YB_SitRandom1
  //{ "Sit Position/Bored Random#1" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE

 :YB_SitRandom2
  //{ "Sit Position/Bored Random#2" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE

 :YB_SitRandom3
  //{ "Sit Position/Bored Random#3" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE

 :YB_SitRandom4
  //{ "Sit Position/Bored Random#4" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE

 :YB_SitRandom5
  //{ "Sit Position/Bored Random#5" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE


:G_YART_Happy_Sit
  result := GO_AHEAD
  RND rndnum 0 (500/YART_BEHAVIOR_PROBABILITY)
  switch (rndnum)
    case 0 : GO YH_SitRandom1
    case 1 : GO YH_SitRandom2
    case 2 : GO YH_SitRandom3
    case 3 : GO YH_SitRandom4
    case 4 : GO YH_SitRandom5
  RET:result

 :YH_SitRandom1
  //{ "Sit Position/Happy Random#1" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE

 :YH_SitRandom2
  //{ "Sit Position/Happy Random#2" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE

 :YH_SitRandom3
  //{ "Sit Position/Happy Random#3" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE

 :YH_SitRandom4
  //{ "Sit Position/Happy Random#4" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE

 :YH_SitRandom5
  //{ "Sit Position/Happy Random#5" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE



//
// Sleep Position Behaviors...  These add onto DogsLife builtin behavior.
// ie: User sees both DogsLife + their customizations performed.
//
// DogsLife passes parameter in rndnum of which action should be performed.  
// If not overridden by YART, DogsLife randomly picks numbers until either it 
// uses a DogsLife skit, or one of these...
//
:G_YART_Calm_Sleep
  result := GO_AHEAD
  RND rndnum 0 (500/YART_BEHAVIOR_PROBABILITY)
  switch (rndnum)
    case 0 : GO YC_SleepRandom1
    case 1 : GO YC_SleepRandom2
    case 2 : GO YC_SleepRandom3
    case 3 : GO YC_SleepRandom4
    case 4 : GO YC_SleepRandom5
  RET:result

 :YC_SleepRandom1
  //{ "Sleep Position/Calm Random#1" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE

 :YC_SleepRandom2
  //{ "Sleep Position/Calm Random#2" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE

 :YC_SleepRandom3
  //{ "Sleep Position/Calm Random#3" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE

 :YC_SleepRandom4
  //{ "Sleep Position/Calm Random#4" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE

 :YC_SleepRandom5
  //{ "Sleep Position/Calm Random#5" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE


:G_YART_Bored_Sleep
  result := GO_AHEAD
  RND rndnum 0 (500/YART_BEHAVIOR_PROBABILITY)
  switch (rndnum)
    case 0 : GO YB_SleepRandom1
    case 1 : GO YB_SleepRandom2
    case 2 : GO YB_SleepRandom3
    case 3 : GO YB_SleepRandom4
    case 4 : GO YB_SleepRandom5
  RET:result

 :YB_SleepRandom1
  //{ "Sleep Position/Bored Random#1" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE

 :YB_SleepRandom2
  //{ "Sleep Position/Bored Random#2" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE

 :YB_SleepRandom3
  //{ "Sleep Position/Bored Random#3" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE

 :YB_SleepRandom4
  //{ "Sleep Position/Bored Random#4" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE

 :YB_SleepRandom5
  //{ "Sleep Position/Bored Random#5" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE


:G_YART_Happy_Sleep
  result := GO_AHEAD
  RND rndnum 0 (500/YART_BEHAVIOR_PROBABILITY)
  switch (rndnum)
    case 0 : GO YH_SleepRandom1
    case 1 : GO YH_SleepRandom2
    case 2 : GO YH_SleepRandom3
    case 3 : GO YH_SleepRandom4
    case 4 : GO YH_SleepRandom5
  RET:result

 :YH_SleepRandom1
  //{ "Sleep Position/Happy Random#1" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE

 :YH_SleepRandom2
  //{ "Sleep Position/Happy Random#2" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE

 :YH_SleepRandom3
  //{ "Sleep Position/Happy Random#3" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE

 :YH_SleepRandom4
  //{ "Sleep Position/Happy Random#4" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE

 :YH_SleepRandom5
  //{ "Sleep Position/Happy Random#5" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE


//
// Voice Commands...
//
:G_YART_VoiceCmd_Attention
  result := GO_AHEAD
  switch (VoiceCmd)
    case:VOICE_AIBO		GO YVC_AIBO
    case:VOICE2_GOODAIBO	GO YVC_GoodAIBO
    case:VOICE_DONTDOTHAT	GO YVC_DontDoThat
    case:VOICE2_DONTDOTHAT	GO YVC_DontDoThat
    case:VOICE_GOODBOT		GO YVC_GoodBOT
    case:VOICE2_GOODBOY		GO YVC_GoodBoy
    case:VOICE2_GOODGIRL	GO YVC_GoodGirl
    case:VOICE_BADBOT		GO YVC_BadBOT
    case:VOICE2_BADBOY		GO YVC_BadBoy
    case:VOICE2_BADGIRL		GO YVC_BadGirl
    case:VOICE_GOFORIT		GO YVC1_GoForIt
    case:VOICE_ILIKEYOU		GO YVC1_ILikeYou
    case:VOICE2_THATSRIGHT	GO YVC2_ThatsRight
  RET:result

/*
:G_YART_VoiceCmd_Game
  result := GO_AHEAD
  switch VoiceCmd
    case:VOICE2_GOODAIBO	GO YVC_GoodAIBO
    case:VOICE_DONTDOTHAT	GO YVC_DontDoThat
    case:VOICE2_DONTDOTHAT	GO YVC_DontDoThat
    case:VOICE_STOP		GO YVC_Stop
    case:VOICE2_STOP		GO YVC_Stop
    case:VOICE_WALK		GO YVC_WalkAround
    case:VOICE_LAYDOWN		GO YVC_LayDown
    case:VOICE_LETSDANCE	GO YVC_LetsDance
    case:VOICE_GOODNIGHT	GO YVC_GoodNight
    case:VOICE_GOODMORNING	GO YVC_GoodMorning
    case:VOICE_AREYOUTIRED	GO YVC_AreYouTired
    case:VOICE_GOODBOT		GO YVC_GoodBOT
    case:VOICE2_GOODBOY		GO YVC_GoodBoy
    case:VOICE2_GOODGIRL	GO YVC_GoodGirl
    case:VOICE_BADBOT		GO YVC_BadBOT
    case:VOICE2_BADBOY		GO YVC_BadBoy
    case:VOICE2_BADGIRL		GO YVC_BadGirl
    case:VOICE_GOODBYE		GO YVC1_GoodBye
    case:VOICE_GOFORIT		GO YVC1_GoForIt
    case:VOICE_ROAR		GO YVC1_Roar
    case:VOICE_MEOW 		GO YVC1_Meow
    case:VOICE_AREYOUOK 	GO YVC1_AreYouOK
    case:VOICE_KICKBALL		GO YVC1_KickBall
    case:VOICE_FINDBALL		GO YVC1_FindBall
    case:VOICE2_THATSRIGHT	GO YVC2_ThatsRight
    case:VOICE2_SHOWTIME	GO YVC2_ShowTime
    case:VOICE2_YOUWON		GO YVC2_YouWon
    case:VOICE2_YOULOST		GO YVC2_YouLost
  RET:result
*/

:G_YART_VoiceCmd
  result := GO_AHEAD
  switch VoiceCmd
    case:VOICE_AIBO		GO YVC_AIBO		// Voice Commands common to Life 1 & 2
    case:VOICE2_AIBO		GO YVC_AIBO
    case:VOICE_HELLO		GO YVC_Hello
    case:VOICE2_HELLO		GO YVC_Hello
    case:VOICE_SAYHELLO		GO YVC_SayHello
    case:VOICE2_SAYHELLO	GO YVC_SayHello
    case:VOICE_GOODMORNING	GO YVC_GoodMorning
    case:VOICE2_MORNING		GO YVC_GoodMorning
    case:VOICE_GOODNIGHT	GO YVC_GoodNight
    case:VOICE2_GOODNIGHT	GO YVC_GoodNight
    case:VOICE_KARATECHOP	GO YVC_KarateChop
    case:VOICE2_KARATECHOP	GO YVC_KarateChop
    case:VOICE_AREYOUTIRED	GO YVC_AreYouTired
    case:VOICE2_AREYOUTIRED	GO YVC_AreYouTired
    case:VOICE_AREYOUHUNGRY	GO YVC_AreYouHungry
    case:VOICE2_AREYOUHUNGRY	GO YVC_AreYouHungry
    case:VOICE_LETSPLAY		GO YVC_LetsPlay
    case:VOICE2_LETSPLAY	GO YVC_LetsPlay
    case:VOICE_SHAKEPAW		GO YVC_ShakePaw
    case:VOICE_SHAKE		GO YVC_ShakePaw
    case:VOICE2_SHAKEPAW	GO YVC_ShakePaw
    case:VOICE_POSE		GO YVC_Pose
    case:VOICE2_POSE		GO YVC_Pose
    case:VOICE_WALK		GO YVC_WalkAround
    case:VOICE2_WALK		GO YVC_WalkAround
    case:VOICE_TURNLEFT		GO YVC_TurnLeft
    case:VOICE2_TURNLEFT	GO YVC_TurnLeft
    case:VOICE_TURNRIGHT	GO YVC_TurnRight
    case:VOICE2_TURNRIGHT	GO YVC_TurnRight
    case:VOICE_GOFORWARD	GO YVC_GoForward
    case:VOICE2_GOFORWARD	GO YVC_GoForward
    case:VOICE_GOBACK		GO YVC_GoBackward
    case:VOICE2_GOBACKWARD	GO YVC_GoBackward
    case:VOICE_STANDUP		GO YVC_StandUp
    case:VOICE2_STANDUP		GO YVC_StandUp
    case:VOICE_LAYDOWN		GO YVC_LayDown
    case:VOICE2_LAYDOWN		GO YVC_LayDown
    case:VOICE_SITDOWN		GO YVC_SitDown
    case:VOICE2_SITDOWN		GO YVC_SitDown
    case:VOICE_LETSDANCE	GO YVC_LetsDance
    case:VOICE2_DANCE		GO YVC_LetsDance
    case:VOICE_BEQUIET		GO YVC_BeQuiet
    case:VOICE2_BEQUIET		GO YVC_BeQuiet
    case:VOICE_TAKEAPICTURE	GO YVC_TakeAPicture
    case:VOICE2_TAKEAPICTURE 	GO YVC_TakeAPicture
    case:VOICE_NAMEREG 		GO YVC_NameRegistration
    case:VOICE2_NAMEREG 	GO YVC_NameRegistration
    case:VOICE_WHATSYOURNAME 	GO YVC_WhatsYourName
    case:VOICE2_WHATSYOURNAME 	GO YVC_WhatsYourName
    case:VOICE_IAMHERE 		GO YVC_ImHere
    case:VOICE2_IAMHERE 	GO YVC_ImHere
    case:VOICE_FINDBALL 	GO YVC1_FindBall	// Life 1 Specific Voice Commands
    case:VOICE_KICKBALL 	GO YVC1_KickBall
    case:VOICE_AREYOUOK 	GO YVC1_AreYouOK
    case:VOICE_GOODBYE 		GO YVC1_GoodBye
    case:VOICE_OTHERPAW 	GO YVC1_OtherPaw
    case:VOICE_ROAR	 	GO YVC1_Roar
    case:VOICE_MEOW 		GO YVC1_Meow
    case:VOICE_GETUP 		GO YVC1_GetUp
    case:VOICE2_SHOWTIME 	GO YVC2_ShowTime	// Life 2 Specific Voice Commands
    case:VOICE2_HEYAIBO		GO YVC2_HeyAIBO
    case:VOICE2_THANKS 		GO YVC2_Thanks
    case:VOICE2_SEEYOU 		GO YVC2_SeeYou
    case:VOICE2_HOWAREYOU 	GO YVC2_HowAreYou
    case:VOICE2_CHEERUP 	GO YVC2_CheerUp
    case:VOICE2_READYSETGO	GO YVC2_ReadySetGo
    case:VOICE2_SINGSONG 	GO YVC2_SingSong
    case:VOICE2_CLOWNAROUND 	GO YVC2_ClownAround
    case:VOICE2_HAPPYDAY 	GO YVC2_HappyDay
    case:VOICE2_GOAHEAD 	GO YVC2_GoAhead
    case:VOICE2_PINKBALL 	GO YVC2_PinkBall
    case:VOICE2_RIGHTKICK 	GO YVC2_RightKick
    case:VOICE2_LEFTKICK 	GO YVC2_LeftKick
    case:VOICE2_RIGHTTOUCH 	GO YVC2_RightTouch
    case:VOICE2_LEFTTOUCH 	GO YVC2_LeftTouch
    case:VOICE2_BANZAI 		GO YVC2_Banzai
    case:VOICE2_SHOWOFF 	GO YVC2_ShowOff
    case:VOICE2_YOUWON 		GO YVC2_YouWon
    case:VOICE2_YOULOST 	GO YVC2_YouLost
    case:VOICE2_ACTION1 	GO YVC2_Action1
    case:VOICE2_ACTION2 	GO YVC2_Action2
    case:VOICE2_ACTION3 	GO YVC2_Action3
    case:VOICE2_ACTION4 	GO YVC2_Action4
    case:VOICE2_ACTION5 	GO YVC2_Action5
    case:VOICE2_LETSTALK 	GO YVC2_LetsTalk
    case:VOICE2_SORRY 		GO YVC2_Sorry
    case:VOICE2_SAYMESSAGE 	GO YVC2_SayMessage
    case:VOICE2_LETSBESECRET 	GO YVC2_LetsBeSecret
    case:VOICE2_OPENSESAME 	GO YVC2_OpenSesame
    case:VOICE2_FASTER 		GO YVC2_Faster
    case:VOICE2_SLOWDOWN 	GO YVC2_SlowDown
    case:VOICE2_WHATSOWNERNAME	GO YVC2_WhatsOwnersName
    case:VOICE2_OWNERREG	GO YVC2_OwnerRegistration
    case:VOICE2_FUNCTIONCHECK	GO YVC2_FunctionCheck
  RET:result



//
// Voice Commands common to Life 1 & Life 2...
//
 :YVC_AIBO
  //{ "AIBO voice command/AIBO or <dog's name>" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC_OwnerName
  //{ "AIBO voice command/<owner's name>" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC_WhatsYourName
  //{ "AIBO voice command/What's your name?" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC_SayHello
  //{ "AIBO voice command/Say hello" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC_ShakePaw
  //{ "AIBO voice command/Shake paw" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC_GoodMorning
  //{ "AIBO voice command/Morning" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC_Hello
  //{ "AIBO voice command/Hello" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC_GoodNight
  //{ "AIBO voice command/Good night" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC_ThatsWrong
  //{ "AIBO voice command/That's wrong" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC_GoodAIBO
  //{ "AIBO voice command/Good AIBO" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC_DontDoThat
  //{ "AIBO voice command/Don't Do that" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC_LetsPlay
  //{ "AIBO voice command/Let's play!" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC_StandUp
  //{ "AIBO voice command/Stand up" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC_LayDown
  //{ "AIBO voice command/Lie down" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC_SitDown
  //{ "AIBO voice command/Sit down" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC_TurnRight
  //{ "AIBO voice command/Turn right" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC_TurnLeft
  //{ "AIBO voice command/Turn left" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC_GoForward
  //{ "AIBO voice command/Go forward" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC_GoBackward
  //{ "AIBO voice command/Go backward" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC_Stop
  //{ "AIBO voice command/Stop" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC2_SingSong
  //{ "AIBO voice command/Sing a song" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC_LetsDance
  //{ "AIBO voice command/Dance, Let's Dance" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC_Pose
  //{ "AIBO voice command/Pose for me" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC_TakeAPicture
  //{ "AIBO voice command/Take a picture" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC_KarateChop
  //{ "AIBO voice command/Karate chop" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC_WalkAround
  //{ "AIBO voice command/Walk around" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC_AreYouTired
  //{ "AIBO voice command/Are you tired?" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC_AreYouHungry
  //{ "AIBO voice command/Are you hungry?" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC_NameRegistration
  //{ "AIBO voice command/Name registration" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC_BeQuiet
  //{ "AIBO voice command/Be quiet" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC_GoodBOT
  if (VoiceDictID>=149) && (VoiceDictID<=150) YVC_GoodBoy
  if (VoiceDictID>=151) && (VoiceDictID<=154) YVC_GoodGirl
  GO G_YART_VOICEDONE

 :YVC_GoodBoy
  //{ "AIBO voice command/Good boy" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC_GoodGirl
  //{ "AIBO voice command/Good girl" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC_BadBOT
  if (VoiceDictID>=160) && (VoiceDictID<=161) YVC_BadBoy
  if (VoiceDictID>=162) && (VoiceDictID<=165) YVC_BadGirl
  GO G_YART_VOICEDONE

 :YVC_BadBoy
  //{ "AIBO voice command/Bad boy" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC_BadGirl
  //{ "AIBO voice command/Bad girl" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC_ImHere
  //{ "AIBO voice command/I'm here" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE



//
// Life 1 Specific Voice Commands...
//
 :YVC1_GetUp
  //{ "AIBO voice command/Get Up (life1)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC1_GoForIt
  //{ "AIBO voice command/Go For It (life1)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC1_ILikeYou
  //{ "AIBO voice command/I Like You (life1)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC1_OtherPaw
  //{ "AIBO voice command/Other Paw (life1)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC1_GoodBye
  //{ "AIBO voice command/Goodbye (life1)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC1_KickBall
  //{ "AIBO voice command/Kick Ball (life1)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC1_FindBall
  //{ "AIBO voice command/Find Ball (life1)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC1_AreYouOK
  //{ "AIBO voice command/Are you OK? (life1)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC1_Roar
  //{ "AIBO voice command/Roar, Roll Over (life1)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC1_Meow
  //{ "AIBO voice command/Meow (life1)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE



//
// Life 2 Specific Voice Commands...
//
 :YVC2_SeeYou
  //{ "AIBO voice command/See you (life2)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC2_HowAreYou
  //{ "AIBO voice command/How are you? (life2)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC2_HeyAIBO
  //{ "AIBO voice command/Hey AIBO (life2)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC2_Thanks
  //{ "AIBO voice command/Thanks (life2)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC2_Sorry
  //{ "AIBO voice command/Sorry (life2)" PRE
  //[PRE]: CALL G_GOTYART
  //}


 :YVC2_CheerUp
  //{ "AIBO voice command/Cheer up (life2)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC2_Banzai
  //{ "AIBO voice command/Banzai (life2)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC2_ThatsRight
  //{ "AIBO voice command/That's right (life2)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC2_ShowTime
  //{ "AIBO voice command/Show time (life2)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC2_ShowOff
  //{ "AIBO voice command/Show off (life2)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC2_ClownAround
  //{ "AIBO voice command/Clown around (life2)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC2_SayMessage
  //{ "AIBO voice command/Say message (life2)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC2_LetsBeSecret
  //{ "AIBO voice command/Let's be secret (life2)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC2_OpenSesame
  //{ "AIBO voice command/Open sesame (life2)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC2_HappyDay
  //{ "AIBO voice command/Happy day (life2)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC2_Faster
  //{ "AIBO voice command/Faster (life2)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC2_SlowDown
  //{ "AIBO voice command/Slow down (life2)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC2_GoAhead
  //{ "AIBO voice command/Go ahead (life2)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC2_PinkBall
  //{ "AIBO voice command/Pink ball (life2)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC2_RightKick
  //{ "AIBO voice command/Right leg kick (life2)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC2_RightTouch
  //{ "AIBO voice command/Right leg touch (life2)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC2_LeftKick
  //{ "AIBO voice command/Left leg kick (life2)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC2_LeftTouch
  //{ "AIBO voice command/Left leg touch (life2)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC2_ReadySetGo
  //{ "AIBO voice command/Ready set go (life2)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC2_YouWon
  //{ "AIBO voice command/You won (life2)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC2_YouLost
  //{ "AIBO voice command/You lost (life2)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC2_Action1
  //{ "AIBO voice command/Action one (life2)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC2_Action2
  //{ "AIBO voice command/Action two (life2)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC2_Action3
  //{ "AIBO voice command/Action three (life2)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC2_Action4
  //{ "AIBO voice command/Action four (life2)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC2_Action5
  //{ "AIBO voice command/Action five (life2)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC2_LetsTalk
  //{ "AIBO voice command/Let's talk (life2)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC2_WhatsOwnersName
  //{ "AIBO voice command/What's your owner's name (life2)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC2_OwnerRegistration
  //{ "AIBO voice command/Owner registration (life2)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE

 :YVC2_FunctionCheck
  //{ "AIBO voice command/Function check (life2)" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_VOICEDONE



//
// Sounds...
//
:G_YART_HearSound
  result := GO_AHEAD
  if (AP_Loud>0) then
    //{ "AIBO hears/Loud Sound" PRE
    //[PRE]: CALL G_GOTYART
    //}
    if (result==GO_YART) then
      AP_Loud := 0
    endif
  endif

  if (AP_AiboSound>0) then
    //{ "AIBO hears/Another AIBO" PRE
    //[PRE]: CALL G_GOTYART
    //}
    if (result==GO_YART) then
      AP_AiboSound := 0
    endif
  endif

  if (AP_Rhythm>0) then
    //{ "AIBO hears/Music & Rhythm" PRE
    //[PRE]: CALL G_GOTYART
    //}
    if (result==GO_YART) then
      AP_Rhythm := 0
    endif
  endif

  if (AP_Noise>0) then
    //{ "AIBO hears/Noise" PRE
    //[PRE]: CALL G_GOTYART
    //}
    if (result==GO_YART) then
      AP_Noise := 0
    endif
  endif
  GO G_YART_DONE



//
// Vision...
//
:G_YART_Vision
  result := GO_AHEAD
  yart_last_favcolor := yart_new_favcolor
  yart_last_unfavcolor := yart_new_unfavcolor
  yart_new_favcolor := Fav_Color
  yart_new_unfavcolor := Unfav_Color

  if (yart_new_favcolor && !yart_last_favcolor) then
    //{ "AIBO sees/Favorite Color (seen)" PRE
    //[PRE]: CALL G_GOTYART
    //}
  endif

  if (!yart_new_favcolor && yart_last_favcolor) then
    //{ "AIBO sees/Favorite Color (lost)" PRE
    //[PRE]: CALL G_GOTYART
    //}
  endif

  if (yart_new_unfavcolor && !yart_last_unfavcolor) then
    //{ "AIBO sees/Unliked Color (seen)" PRE
    //[PRE]: CALL G_GOTYART
    //}
  endif

  if (!yart_new_unfavcolor && yart_last_unfavcolor) then
    //{ "AIBO sees/Unliked Color (lost)" PRE
    //[PRE]: CALL G_GOTYART
    //}
  endif

  if (AP_FaceDetect>0) then
    if (AP_FaceDetect>3) then
      //{ "AIBO sees/Human Face (up close)" PRE
      //[PRE]: CALL G_GOTYART
      //}
    else
      //{ "AIBO sees/Human Face (far away)" PRE
      //[PRE]: CALL G_GOTYART
      //}
    endif
    if (result==GO_YART) then
      AP_FaceDetect := 0
    endif
  endif

  if (AP_FaceDetect<0) then
    //{ "AIBO sees/Human Face (lost)" PRE
    //[PRE]: CALL G_GOTYART
    //}
    if (result==GO_YART) then
      AP_FaceDetect := 0
    endif
  endif
  GO G_YART_DONE



//
// Walking...
//
:G_YART_Walking_ObstacleFront
  result := GO_AHEAD
  RND rndnum 0 (500/YART_BEHAVIOR_PROBABILITY)
  if (rndnum<5) then
    //{ "Walking/Obstacle in front" PRE
    //[PRE]: CALL G_GOTYART
    //}
  endif
  GO G_YART_DONE

:G_YART_Walking_ObstacleLeft
  result := GO_AHEAD
  RND rndnum 0 (500/YART_BEHAVIOR_PROBABILITY)
  if (rndnum<5) then
    //{ "Walking/Obstacle to left" PRE
    //[PRE]: CALL G_GOTYART
    //}
  endif
  GO G_YART_DONE

:G_YART_Walking_ObstacleRight
  result := GO_AHEAD
  RND rndnum 0 (500/YART_BEHAVIOR_PROBABILITY)
  if (rndnum<5) then
    //{ "Walking/Obstacle to right" PRE
    //[PRE]: CALL G_GOTYART
    //}
  endif
  GO G_YART_DONE

:G_YART_Walking_SeeCliff
  result := GO_AHEAD
  RND rndnum 0 (500/YART_BEHAVIOR_PROBABILITY)
  if (rndnum<5) then
    //{ "Walking/See Cliff (drop off)" PRE
    //[PRE]: CALL G_GOTYART
    //}
  endif
  GO G_YART_DONE

:G_YART_Walking_SeeTable
  result := GO_AHEAD
  RND rndnum 0 (500/YART_BEHAVIOR_PROBABILITY)
  if (rndnum<5) then
    //{ "Walking/See Table Leg" PRE
    //[PRE]: CALL G_GOTYART
    //}
  endif
  GO G_YART_DONE

:G_YART_Walking_Happy
  result := GO_AHEAD
  RND rndnum 0 (500/YART_BEHAVIOR_PROBABILITY)
  switch (rndnum)
    case 0 : GO YH_WalkRandom1
    case 1 : GO YH_WalkRandom2
    case 2 : GO YH_WalkRandom3
    case 3 : GO YH_WalkRandom4
    case 4 : GO YH_WalkRandom5
  RET:result
 :YH_WalkRandom1
  //{ "Walking/Happy Random#1" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE
 :YH_WalkRandom2
  //{ "Walking/Happy Random#2" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE
 :YH_WalkRandom3
  //{ "Walking/Happy Random#3" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE
 :YH_WalkRandom4
  //{ "Walking/Happy Random#4" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE
 :YH_WalkRandom5
  //{ "Walking/Happy Random#5" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE



//
// Soccer...
//
:G_YART_Soccer_SeeBall
  result := GO_AHEAD
  //{ "Soccer/See ball" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE

:G_YART_Soccer_LoseBall
  result := GO_AHEAD
  RND rndnum 0 (500/YART_BEHAVIOR_PROBABILITY)
  if (rndnum<5) then
    //{ "Soccer/Lose ball" PRE
    //[PRE]: CALL G_GOTYART
    //}
  endif
  GO G_YART_DONE

:G_YART_Soccer_GoodKick
  result := GO_AHEAD
  RND rndnum 0 (500/YART_BEHAVIOR_PROBABILITY)
  if (rndnum<5) then
    //{ "Soccer/Successful Kick" PRE
    //[PRE]: CALL G_GOTYART
    //}
  endif
  GO G_YART_DONE

:G_YART_Soccer_MissedKick
  result := GO_AHEAD
  RND rndnum 0 (500/YART_BEHAVIOR_PROBABILITY)
  if (rndnum<5) then
    //{ "Soccer/Missed Kick" PRE
    //[PRE]: CALL G_GOTYART
    //}
  endif
  GO G_YART_DONE

:G_YART_Soccer_Happy
  result := GO_AHEAD
  RND rndnum 0 (500/YART_BEHAVIOR_PROBABILITY)
  switch (rndnum)
    case 0 : GO YH_SoccerRandom1
    case 1 : GO YH_SoccerRandom2
    case 2 : GO YH_SoccerRandom3
    case 3 : GO YH_SoccerRandom4
    case 4 : GO YH_SoccerRandom5
  RET:result
 :YH_SoccerRandom1
  //{ "Soccer/Happy Random#1" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE
 :YH_SoccerRandom2
  //{ "Soccer/Happy Random#2" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE
 :YH_SoccerRandom3
  //{ "Soccer/Happy Random#3" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE
 :YH_SoccerRandom4
  //{ "Soccer/Happy Random#4" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE
 :YH_SoccerRandom5
  //{ "Soccer/Happy Random#5" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE

:G_YART_Soccer_Frustrated
  result := GO_AHEAD
  RND rndnum 0 (500/YART_BEHAVIOR_PROBABILITY)
  switch (rndnum)
    case 0 : GO YF_SoccerRandom1
    case 1 : GO YF_SoccerRandom2
    case 2 : GO YF_SoccerRandom3
    case 3 : GO YF_SoccerRandom4
    case 4 : GO YF_SoccerRandom5
  RET:result
 :YF_SoccerRandom1
  //{ "Soccer/Frustrated Random#1" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE
 :YF_SoccerRandom2
  //{ "Soccer/Frustrated Random#2" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE
 :YF_SoccerRandom3
  //{ "Soccer/Frustrated Random#3" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE
 :YF_SoccerRandom4
  //{ "Soccer/Frustrated Random#4" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE
 :YF_SoccerRandom5
  //{ "Soccer/Frustrated Random#5" PRE
  //[PRE]: CALL G_GOTYART
  //}
  GO G_YART_DONE



