// [ERS-11x]
// Yart11x AIBO - 11x
// Base personality .04


////////////////////////////////////
// multi-build version - Features selected:
//  BASE - basic empty personality
//  ONE - one mood
//    (four performance styles)
////////////////////////////////////
//REVIEW: things to fix/improve
// make the posture logic more automatic (improve logic)
// mini-ball tracking
////////////////////////////////////

:Init

 GLOBAL doPrint 1
 VLOAD doPrint

  IF doPrint <> 0 THEN
    PRINT "Base Personality - RCODE 11x - YART Version 1.04 (one mood)"
  ENDIF

  SET Power ON // power up
  SET COLOR PINK // I like pink

  // clear globals and sensors
  GLOBAL pressOld 0 // head pressure
  GLOBAL pinkOld 0 // pink level 0, 1 (some pink), 2, 3 (lots)
  GLOBAL pinkNew
  GLOBAL nearOld 0 // nearness 0 (far), 1, 2, 3 (up close)

  GLOBAL mood 1
  GLOBAL beaten 0   // beaten level: negative for hit, positive for pat
  GLOBAL walking 0
  GLOBAL lastMood mood

  GLOBAL statusOld 0
  GLOBAL statusNew -1

  GLOBAL nearNew
  GLOBAL pressNew 0 // updated/polled several times per loop
  GLOBAL t // general purpose

  //{ "Main/Startup(once)"
    PLAY ESC SITDOWN
    WAIT
  //}

///// MAIN LOOP /////
:Main
  SET Clock 0
    // use Clock (32 ms ticks) for idle timeout

:MainDidNothing
  IF mood <> lastMood THEN
    IF doPrint <> 0 THEN
      PRINT "new mood %d" mood
    ENDIF
    LET lastMood mood
  ENDIF

  IF walking <> 0 THEN
    // Walking mode - limited logic
    CALL MainWalking

    IF walking == 0 THEN
      IF doPrint <> 0 THEN
        PRINT "Walking - stopped!"
      ENDIF
    ENDIF
    GO Main
  ENDIF

  // Not walking - full logic

  ////////////////////////////////
  // check head

  LET t Touch_head_press // last average pressure
  IF t > pressNew THEN
    LET pressNew t
  ENDIF
     
  IF pressNew <> pressOld THEN
    IF doPrint <> 0 THEN
      PRINT "Sensor: head pressure %d -> %d (now %d)" pressOld pressNew Touch_head_press
    ENDIF
    LET pressOld pressNew // actually the hardest most recent hit
    LET pressNew 0

    IF pressOld > 150 THEN
      IF doPrint <> 0 THEN
        PRINT "Sensor: head HIT"
      ENDIF
      CALL HeadHit_Handler
      IF beaten < 0 THEN
        ADD beaten -1
      ELSE
        LET beaten -1
      ENDIF
      IF beaten <= -3 THEN
        CALL HeadHitALot_Handler
        LET beaten 0
      ENDIF

      // SET Touch_head_press 0 // REVIEW ??
      GO Main
    ENDIF

    IF pressOld > 30 THEN
      IF doPrint <> 0 THEN
        PRINT "Sensor: head PAT"
      ENDIF
      CALL HeadPat_Handler

      IF beaten > 0 THEN
        ADD beaten 1
      ELSE
        LET beaten 1
      ENDIF
      IF beaten >= 3 THEN
        CALL HeadPatALot_Handler
        LET beaten 0
      ENDIF

      // SET Touch_head_press 0 // REVIEW ??
      GO Main
    ENDIF
  ENDIF

  //////////////////////////////////////////////////
  // Sound controller / remote

  IF Melody_id > 0 THEN
    PUSH Melody_id
    CALL Melody_Handler:1
    SET Melody_id 0
    GO Main
  ENDIF

  //////////////////////
  // repeat head test
  LET t Touch_head_press
  IF t > pressNew THEN
    LET pressNew t
  ENDIF
     
  //////////////////////////////////////////////////
  // Status bits (for vibration check - only if not moving)

  LET statusNew Status
  IF statusNew <> statusOld THEN
    LOCAL did
    CALL CheckStatus
    POP did
    IF did <> 0 THEN
      GO Main
    ENDIF
  ENDIF

  //////////////////////
  // repeat head test
  LET t Touch_head_press
  IF t > pressNew THEN
    LET pressNew t
  ENDIF

  ////////////////////////////////
  // pink - using level detection and upper water mark

  LET pinkNew 0
  IF Cdt_npixel > 500 THEN
    LET pinkNew 1
  ENDIF
  IF Cdt_npixel > 1500 THEN
    LET pinkNew 2
  ENDIF
  IF Cdt_npixel > 4000 THEN
    LET pinkNew 3
  ENDIF

  IF pinkNew > pinkOld THEN
    // seeing more pink
    IF doPrint <> 0 THEN
      PRINT "PinkBall %d (was %d)" pinkNew pinkOld
    ENDIF
    IF pinkNew == 1 THEN
      //{ "AIBO sees/Pink Ball (far/faint)"
      //}
    ENDIF
    IF pinkNew == 2 THEN
      //{ "AIBO sees/Pink Ball (medium)"
        PLAY SOUND joy6_ppb
      //}
    ENDIF
    IF pinkNew == 3 THEN
      //{ "AIBO sees/Pink Ball (near)"
      //}
    ENDIF
    LET pinkOld = pinkNew // new (higher) level
    GO Main
  ENDIF

  IF pinkNew == 0 THEN
    IF pinkOld <> 0 THEN
    IF doPrint <> 0 THEN
      PRINT "PinkBall LOST (was %d)" pinkOld
    ENDIF
    IF pinkOld == 1 THEN
      //{ "AIBO sees/Pink Ball LOST (was far/faint)"
      //}
    ENDIF
    IF pinkOld == 2 THEN
      //{ "AIBO sees/Pink Ball LOST (was medium)"
        PLAY SOUND joy6_ppb
      //}
    ENDIF
    IF pinkOld == 3 THEN
      //{ "AIBO sees/Pink Ball LOST (was near)"
        PLAY SOUND joy7_dda
      //}
    ENDIF
    LET pinkOld 0 // back to zero only when no more pink
    GO Main
    ENDIF
  ENDIF

  //////////////////////////////////////////////////
  // other colors
    // -- perhaps later...

  //////////////////////
  // repeat head test
  LET t Touch_head_press
  IF t > pressNew THEN
    LET pressNew t
  ENDIF

  //////////////////////////////////////////////////
  // Distance => nearness
    // similar upper water mark logic (ie. closer distance)

  LET nearNew 0 // far
  IF Distance < 1000 THEN
    LET nearNew 1
  ENDIF
  IF Distance < 500 THEN
    LET nearNew 2
  ENDIF
  IF Distance < 200 THEN
    LET nearNew 3
  ENDIF

  IF nearNew > nearOld THEN
    // something nearer
    IF doPrint <> 0 THEN
      PRINT "Obstacle %d (was %d)" nearNew nearOld
    ENDIF
    IF nearNew == 1 THEN
      //{ "AIBO sees/Obstacle (far)"
      //}
    ENDIF
    IF nearNew == 2 THEN
      //{ "AIBO sees/Obstacle (medium)"
      //}
    ENDIF
    IF nearNew == 3 THEN
      //{ "AIBO sees/Obstacle (near)"
        PLAY LIGHT joy2_eye
      //}
    ENDIF
    LET nearOld = nearNew // new (higher) level
    GO Main
  ENDIF

  IF nearOld <> 0 THEN
    IF nearNew == 0 THEN
    IF doPrint <> 0 THEN
      PRINT "Obstacle LOST (was %d)" nearOld
    ENDIF
    IF nearOld == 1 THEN
      //{ "AIBO sees/Obstacle LOST (was far)"
      //}
    ENDIF
    IF nearOld == 2 THEN
      //{ "AIBO sees/Obstacle LOST (was medium)"
      //}
    ENDIF
    IF nearOld == 3 THEN
      //{ "AIBO sees/Obstacle LOST (was near)"
      //}
    ENDIF
    LET nearOld 0 // back to zero only when no more near
    GO Main
    ENDIF
  ENDIF

  //////////////////////
  // repeat head test
  LET t Touch_head_press
  IF t > pressNew THEN
    LET pressNew t
  ENDIF

  //////////////////////////////////////////////////
  // Random timeout

  IF Clock > 320 THEN
    // 10 seconds with nothing happening
    CALL DoSomethingRandom
    GO Main
  ENDIF

  GO MainDidNothing

EXIT

////////////////////////////////////////////////////
// Walking mode - very limited set of commands

:MainWalking
  IF Touch_head_press > 300 THEN
    IF doPrint <> 0 THEN
      PRINT "Walking Sensor: head hit hard"
    ENDIF
    //{ "Walking Mode/Head Hit"
      CALL StopWalking
    //}
    RETURN
  ENDIF

  IF Touch_head_press > 30 THEN
    IF doPrint <> 0 THEN
      PRINT "Walking Sensor: head hit soft"
    ENDIF
    //{ "Walking Mode/Pat Hit"
    //}
    RETURN
  ENDIF

  IF Distance < 200 THEN
    IF doPrint <> 0 THEN
      PRINT "Walking : Distance hit something"
    ENDIF
    //{ "Walking Mode/Obstacle (near)"
      CALL StopWalking
    //}
    RETURN
  ENDIF

  // otherwise just handle Game mode remote control
  IF Melody_id > 0 THEN
    PUSH Melody_id
    CALL Melody_Handler_Walking:1
    SET Melody_id 0
    RETURN
  ENDIF

  IF doPrint <> 0 THEN
    PRINT "walking..."
  ENDIF
  
RETURN

///////////////////////////////////////////////////////////////////////////
// Head Sensors

:HeadHit_Handler
  LOCAL randVal
  RND randVal 1 4

  IF randVal == 1 THEN
    //{ "Sensor-HeadHit/Random#1"
      PLAY ESC 4SAD3B_SIT
      WAIT
    //}
  ENDIF

  IF randVal == 2 THEN
    //{ "Sensor-HeadHit/Random#2"
      PLAY ESC 4SAD3A_SIT
      WAIT
    //}
  ENDIF

  IF randVal == 3 THEN
    //{ "Sensor-HeadHit/Random#3"
      PLAY ESC 4SUP3A_SIT
      WAIT
    //}
  ENDIF

  IF randVal == 4 THEN
    //{ "Sensor-HeadHit/Random#4"
      PLAY ESC 4FER3Y_SIT
      WAIT
    //}
  ENDIF
RETURN


:HeadHitALot_Handler
  //{ "Sensor-HeadHit/Excessive"
    // Stop beating me!
    PLAY ESC 4PUNCH_SIT3
    WAIT
  //}
RETURN

//////////////////////////////



:HeadPat_Handler
  LOCAL randVal
  RND randVal 1 4

  IF randVal == 1 THEN
    //{ "Sensor-HeadPat/Random#1"
      PLAY ESC 4JOY5A_SIT
      WAIT
    //}
  ENDIF

  IF randVal == 2 THEN
    //{ "Sensor-HeadPat/Random#2"
      PLAY ESC 4JOY5Y_SIT
      WAIT
    //}
  ENDIF

  IF randVal == 3 THEN
    //{ "Sensor-HeadPat/Random#3"
      PLAY ESC 7JOY1A_SIT
      WAIT
    //}
  ENDIF

  IF randVal == 4 THEN
    //{ "Sensor-HeadPat/Random#4"
      PLAY ESC 7JOY2C_SIT
      WAIT
    //}
  ENDIF
RETURN


:HeadPatALot_Handler
  //{ "Sensor-HeadPat/Excessive"
    // Stop smothering me!
    PLAY ESC 4LV_ME_ALONEA
    WAIT
  //}
RETURN

///////////////////////////////////////////////////////////////////////////
// Status/Vibration sensor

:CheckStatus // status change
  LOCAL tmp statusOld
  XOR tmp -1 // bitwise not, don't use NOT
  LOCAL statOn statusNew
  AND statOn tmp // statOn = statusNew & ~statusOld
  LOCAL statOff statusNew
  XOR statOff -1
  AND statOff statusOld // statOff = ~statusNew & statusOld

// PRINT "stat o=$%x n=$%x on=$%x, off=$%x" statusOld statusNew statOn statOff
  LET statusOld statusNew // for next time

  IF statOn & 1 THEN
    IF doPrint <> 0 THEN
      PRINT "Sensor: vibration start"
    ENDIF
    //{ "Sensor Other/Vibration Start"
      PLAY SOUND fer1_xxt
      WAIT
    //}
    RETURN:1
  ENDIF

  IF statOff & 1 THEN
    IF doPrint <> 0 THEN
      PRINT "Sensor: vibration stop"
    ENDIF
    //{ "Sensor Other/Vibration Stop"
    //}
    RETURN:1
  ENDIF
RETURN:0

///////////////////////////////////////////////////////////////////////////
// Sound Controller (Remote) Handler routines

:Melody_Handler
  ARG id

  IF doPrint <> 0 THEN
    PRINT "Melody: %d" id
    PRINT "  levels = %d,%d,%d" Tone1_level Tone2_level Tone3_level
    PRINT "  directions = %d,%d,%d" Tone1_dir Tone2_dir Tone3_dir
  ENDIF

  // NOTE: remove or adjust the following code if you want to control
  //  two different AIBOs at the same time (with two different remotes)
  IF id > 304 THEN
    SUB id 304    // move channel B to channel A
  ENDIF

  IF id == 1 THEN
    //{ "Remote/GOAUTO(00)"
    //}
  ENDIF
  IF id == 9 THEN
    //{ "Remote/GOGAME(01)"
      CALL BigPing
      PLAY ESC STANDUP
      WAIT
    //}
  ENDIF
  IF id == 17 THEN
    //{ "Remote/GOACTION(02)"
    //}
  ENDIF
  IF id == 25 THEN
    //{ "Remote/GOSTAT(03)"
      CALL NotImplementedPing
    //}
  ENDIF
  IF id == 33 THEN
    //{ "Remote/SLEEP(89)"
      CALL BigPing
      PLAY ESC LIEDOWN5
      WAIT
    //}
  ENDIF
  IF id == 41 THEN
    //{ "Remote/SLEEP8(88)"
      CALL BigPing
      PLAY ESC LIEDOWN5
      WAIT
    //}
  ENDIF


  // Style=Mood

  IF id == 193 THEN
    //{ "Remote/MSTYLE1(31)"
      CALL BigPing
      CALL SmallPing
      LET mood 1
      PLAY ESC P1P1
      WAIT
    //}
  ENDIF
  IF id == 200 THEN
    //{ "Remote/MSTYLE2(32)"
      CALL BigPing
      CALL SmallPing
      CALL SmallPing
      LET mood 2
      PLAY ESC P2P1
      WAIT
    //}
  ENDIF
  IF id == 207 THEN
    //{ "Remote/MSTYLE3(33)"
      CALL BigPing
      CALL SmallPing
      CALL SmallPing
      CALL SmallPing
      LET mood 3
      PLAY ESC P3P1
      WAIT
    //}
  ENDIF
  IF id == 214 THEN
    //{ "Remote/MSTYLE4(34)"
      CALL BigPing
      CALL SmallPing
      CALL SmallPing
      CALL SmallPing
      CALL SmallPing
      LET mood 4
      PLAY ESC P4P1
      WAIT
    //}
  ENDIF

  // Mood specific performances
  IF id == 235 THEN
    IF mood == 1 THEN
      //{ "Remote/Mood1/MOTION1(41)"
        CALL SmallPing
        PLAY ESC P1P1
        WAIT
      //}
    ENDIF
    IF mood == 2 THEN
      //{ "Remote/Mood2/MOTION1(41)"
        CALL SmallPing
        PLAY ESC P2P1
        WAIT
    //}
    ENDIF
    IF mood == 3 THEN
      //{ "Remote/Mood3/MOTION1(41)"
        CALL SmallPing
        PLAY ESC P3P1
        WAIT
      //}
    ENDIF
    IF mood == 4 THEN
      //{ "Remote/Mood4/MOTION1(41)"
        CALL SmallPing
        PLAY ESC P4P1
        WAIT
      //}
    ENDIF
  ENDIF

  IF id == 240 THEN
    IF mood == 1 THEN
      //{ "Remote/Mood1/MOTION2(42)"
        CALL SmallPing
        PLAY ESC P1P2
        WAIT
      //}
    ENDIF
    IF mood == 2 THEN
      //{ "Remote/Mood2/MOTION2(42)"
        CALL SmallPing
        PLAY ESC P2P2
        WAIT
      //}
    ENDIF
    IF mood == 3 THEN
      //{ "Remote/Mood3/MOTION2(42)"
        CALL SmallPing
        PLAY ESC P3P2
        WAIT
      //}
    ENDIF
    IF mood == 4 THEN
      //{ "Remote/Mood4/MOTION2(42)"
        CALL SmallPing
        PLAY ESC P4P2
        WAIT
      //}
    ENDIF
  ENDIF

  IF id == 245 THEN
    IF mood == 1 THEN
      //{ "Remote/Mood1/MOTION3(43)"
        CALL SmallPing
        PLAY ESC P1P3
        WAIT
      //}
    ENDIF
    IF mood == 2 THEN
      //{ "Remote/Mood2/MOTION3(43)"
        CALL SmallPing
        PLAY ESC P2P3
        WAIT
      //}
    ENDIF
    IF mood == 3 THEN
      //{ "Remote/Mood3/MOTION3(43)"
        CALL SmallPing
        PLAY ESC P3P3
        WAIT
      //}
    ENDIF
    IF mood == 4 THEN
      //{ "Remote/Mood4/MOTION3(43)"
        CALL SmallPing
        PLAY ESC P4P3
        WAIT
      //}
    ENDIF
  ENDIF

  IF id == 250 THEN
    IF mood == 1 THEN
      //{ "Remote/Mood1/MOTION4(44)"
        CALL SmallPing
        PLAY ESC P1P4
        WAIT
      //}
    ENDIF
    IF mood == 2 THEN
      //{ "Remote/Mood2/MOTION4(44)"
        CALL SmallPing
        PLAY ESC P2P4
        WAIT
      //}
    ENDIF
    IF mood == 3 THEN
      //{ "Remote/Mood3/MOTION4(44)"
        CALL SmallPing
        PLAY ESC P3P4
        WAIT
      //}
    ENDIF
    IF mood == 4 THEN
      //{ "Remote/Mood4/MOTION4(44)"
        CALL SmallPing
        PLAY ESC P4P4
        WAIT
      //}
    ENDIF
  
  ENDIF

  IF id == 255 THEN
    IF mood == 1 THEN
      //{ "Remote/Mood1/MOTION5(45)"
        CALL SmallPing
        PLAY ESC P1P5
        WAIT
      //}
    ENDIF
    IF mood == 2 THEN
      //{ "Remote/Mood2/MOTION5(45)"
        CALL SmallPing
        PLAY ESC P2P5
        WAIT
      //}
    ENDIF
    IF mood == 3 THEN
      //{ "Remote/Mood3/MOTION5(45)"
        CALL SmallPing
        PLAY ESC P3P5
        WAIT
      //}
    ENDIF
    IF mood == 4 THEN
      //{ "Remote/Mood4/MOTION5(45)"
        CALL SmallPing
        PLAY ESC P4P5
        WAIT
      //}
    ENDIF
  ENDIF

  /////////////////////////////////////////
  IF id == 265 THEN
    //{ "Remote/VOLUP*(86)"
      CALL SmallPing
    //}
  ENDIF
  IF id == 270 THEN
    //{ "Remote/VOLDOWN*(84)"
      CALL SmallPing
    //}
  ENDIF
  IF id == 275 THEN
    //{ "Remote/TYPEA(81)"
      CALL SmallPing
    //}
  ENDIF
  IF id == 280 THEN
    //{ "Remote/TYPEB(82)"
      CALL SmallPing
    //}
  ENDIF

  PUSH id
  CALL Melody_Handler_Walking:1

RETURN

////////////////////////////////////
// sub-set of remote commands while walking
//  set 'walking' global appropriately to change walking state

:Melody_Handler_Walking
  ARG id

  IF id == 49 THEN
    //{ "RemoteWalking/FORWARD(52)"
      CALL SmallPing
      MOVE:LEGS:WALK:DEFAULT:FORWARD:0
      CALL StartWalkingDelay
    //}
  ENDIF
  IF id == 56 THEN
    //{ "RemoteWalking/BACKWARD(58)"
      CALL SmallPing
      MOVE:LEGS:WALK:DEFAULT:BACKWARD:0
      CALL StartWalkingDelay
    //}
  ENDIF
  IF id == 63 THEN
    //{ "RemoteWalking/TURNR(56)"
      CALL SmallPing
      MOVE:LEGS:STEP:RIGHT_TURN:0:0
      CALL StartWalkingDelay
    //}
  ENDIF
  IF id == 70 THEN
    //{ "RemoteWalking/TURNL(54)"
      CALL SmallPing
      MOVE:LEGS:STEP:LEFT_TURN:0:0
    //}
  ENDIF
  IF id == 77 THEN
    //{ "RemoteWalking/KICKR(53)"
      CALL SmallPing
      MOVE:LEGS:KICK:RIGHT_KICK:0
      CALL StartWalkingDelay
    //}
  ENDIF
  IF id == 84 THEN
    //{ "RemoteWalking/KICKL(51)"
      CALL SmallPing
      MOVE:LEGS:KICK:LEFT_KICK:0
      CALL StartWalkingDelay
    //}
  ENDIF
  IF id == 91 THEN
    //{ "RemoteWalking/WIN(5#)"
      CALL SmallPing
      CALL StopWalking
      PLAY ESC G_W1
      WAIT
    //}
  ENDIF
  IF id == 98 THEN
    //{ "RemoteWalking/LOSE(5*)"
      CALL SmallPing
      CALL StopWalking
      PLAY ESC G_L3
      WAIT
    //}
  ENDIF
  IF id == 105 THEN
    //{ "RemoteWalking/PICKUP(57)"
      CALL NotImplementedPing
    //}
  ENDIF
  IF id == 112 THEN
    //{ "RemoteWalking/RELEASE(59)"
      CALL NotImplementedPing
    //}
  ENDIF
  IF id == 119 THEN
    //{ "RemoteWalking/STOP(55)"
      CALL SmallPing
      CALL StopWalking
    //}
  ENDIF
  IF id == 126 THEN
    //{ "RemoteWalking/ASSIST(50)"
      CALL NotImplementedPing
    //}
  ENDIF
  IF id == 163 THEN
    //{ "RemoteWalking/STANDUP(11)"
      CALL SmallPing
      CALL StopWalking
      PLAY ESC STANDUP
      WAIT
    //}
  ENDIF
  IF id == 168 THEN
    //{ "RemoteWalking/SIT(12)"
      CALL SmallPing
      CALL StopWalking
      PLAY ESC SITDOWN
      WAIT
    //}
  ENDIF
  IF id == 178 THEN
    //{ "RemoteWalking/LIEDOWN(13)"
      CALL SmallPing
      CALL StopWalking
      PLAY ESC LIEDOWN
      WAIT
    //}
  ENDIF

RETURN

///////////////////////////////////////////////////////////////////////////
// Random skits after 10 seconds of idleness

:DoSomethingRandom
  LOCAL randVal
  RND randVal 1 10  // 1 to 10

  IF doPrint <> 0 THEN
    PRINT "Random (idle) event randVal=%d (mood ignored)" randVal
  ENDIF

  IF randVal == 1 THEN
    //{ "Idle/Random#1"
      PLAY ESC P1I1
      WAIT
    //}
  ENDIF

  IF randVal == 2 THEN
    //{ "Idle/Random#2"
      PLAY ESC P1I2
      WAIT
    //}
  ENDIF

  IF randVal == 3 THEN
    //{ "Idle/Random#3"
      PLAY ESC P1I3
      WAIT
    //}
  ENDIF

  IF randVal == 4 THEN
    //{ "Idle/Random#4"
      PLAY ESC P1I4
      WAIT
    //}
  ENDIF

  IF randVal == 5 THEN
    //{ "Idle/Random#5"
      PLAY ESC P1I5
      WAIT
    //}
  ENDIF

  IF randVal == 6 THEN
    //{ "Idle/Random#6"
      PLAY ESC P1I6
      WAIT
    //}
  ENDIF

  IF randVal == 7 THEN
    //{ "Idle/Random#7"
      PLAY ESC P1I7
      WAIT
    //}
  ENDIF

  IF randVal == 8 THEN
    //{ "Idle/Random#8"
      PLAY ESC P1I8
      WAIT
    //}
  ENDIF

  IF randVal == 9 THEN
    //{ "Idle/Random#9"
      PLAY ESC P1I9
      WAIT
    //}
  ENDIF

  IF randVal == 10 THEN
    //{ "Idle/Random#10"
      PLAY ESC P1P1
      WAIT
    //}
  ENDIF
RETURN


///////////////////////////////////////////////////////////////////////////
// Subroutines - confirmation of sound controller commands

:NotImplementedPing
    // play a ping for not yet implemented
    PLAY SOUND sup5_ppy
    WAIT
RETURN

:BigPing
    // play a big ping to ack the sound controller
    PLAY SOUND thnk1aax
    WAIT
RETURN

:SmallPing
    // play a short ping to ack the sound controller
    PLAY SOUND trk2_xxx
    WAIT
RETURN


///////////////////////////////
// Subroutines - Walking helpers

:StartWalkingDelay
  IF doPrint <> 0 THEN
    PRINT "StartWalkingDelay"
  ENDIF
  WAIT 4000 // wait before walking actually starts
    // if too soon, distance sensor may stop walking
  LET walking 1
  IF doPrint <> 0 THEN
    PRINT "StartWalkingDelay done"
  ENDIF
RETURN

:StopWalking
  IF doPrint <> 0 THEN
    PRINT "StopWalking"
  ENDIF
  QUIT:LEGS // a little dangerous
  PLAY ESC STANDUP // restore standup posture
  WAIT
  LET walking 0
  IF doPrint <> 0 THEN
    PRINT "StopWalking done"
  ENDIF
RETURN

///////////////////////////////////////////////////////////////////////////
// Extra YART statements
//++CALL StartWalkingDelay
//++CALL StopWalking
//++CALL SmallPing
//++CALL NotImplementedPing
//++CALL BigPing
///////////////////////////////////////////////////////////////////////////
